/*
 * Decompiled with CFR 0.152.
 */
package jline;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.StringTokenizer;
import jline.Terminal;

public final class UnixTerminal
extends Terminal {
    private String ttyConfig;
    private String ttyProps;
    private long ttyPropsLastFetched;
    private boolean backspaceDeleteSwitched = false;
    private String encoding = System.getProperty("input.encoding", "UTF-8");
    private ReplayPrefixOneCharInputStream replayStream = new ReplayPrefixOneCharInputStream(this.encoding);
    private InputStreamReader replayReader;

    public UnixTerminal() {
        try {
            this.replayReader = new InputStreamReader((InputStream)this.replayStream, this.encoding);
            return;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public final void initializeTerminal() throws IOException, InterruptedException {
        this.ttyConfig = UnixTerminal.stty("-g");
        if (this.ttyConfig.length() == 0 || this.ttyConfig.indexOf("=") == -1 && this.ttyConfig.indexOf(":") == -1) {
            throw new IOException("Unrecognized stty code: " + this.ttyConfig);
        }
        UnixTerminal unixTerminal = this;
        String[] stringArray = unixTerminal.ttyConfig.split(":|=");
        unixTerminal.backspaceDeleteSwitched = stringArray.length >= 7 && "7f".equals(stringArray[6]);
        UnixTerminal.stty("-icanon min 1");
        UnixTerminal.stty("-echo");
        try {
            Runtime.getRuntime().addShutdownHook(new Thread(){

                public final void start() {
                    try {
                        UnixTerminal.this.restoreTerminal();
                        return;
                    }
                    catch (Exception e) {
                        UnixTerminal.access$000(UnixTerminal.this, e);
                        return;
                    }
                }
            });
            return;
        }
        catch (AbstractMethodError abstractMethodError) {
            return;
        }
    }

    public final void restoreTerminal() throws Exception {
        if (this.ttyConfig != null) {
            UnixTerminal.stty(this.ttyConfig);
            this.ttyConfig = null;
        }
        UnixTerminal.resetTerminal();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final int readVirtualKey(InputStream in) throws IOException {
        int c = this.readCharacter(in);
        if (this.backspaceDeleteSwitched) {
            if (c == 127) {
                return 8;
            }
            if (c == 8) {
                return 127;
            }
        }
        if (c == 27 && in.available() > 0) {
            while (c == 27) {
                c = this.readCharacter(in);
            }
            if (c == 91 || c == 79) {
                c = this.readCharacter(in);
                if (c == 65) {
                    return 16;
                }
                if (c == 66) {
                    return 14;
                }
                if (c == 68) {
                    return 2;
                }
                if (c == 67) {
                    return 6;
                }
                if (c == 72) {
                    return 1;
                }
                if (c == 70) {
                    return 5;
                }
                if (c == 51) {
                    this.readCharacter(in);
                    return 127;
                }
            }
        }
        if (c <= 128) return c;
        InputStream inputStream = in;
        int n = c;
        ReplayPrefixOneCharInputStream replayPrefixOneCharInputStream = this.replayStream;
        this.replayStream.byteRead = 0;
        replayPrefixOneCharInputStream.firstByte = (byte)n;
        replayPrefixOneCharInputStream.wrappedStream = inputStream;
        replayPrefixOneCharInputStream.byteLength = 1;
        if (replayPrefixOneCharInputStream.encoding.equalsIgnoreCase("UTF-8")) {
            ReplayPrefixOneCharInputStream replayPrefixOneCharInputStream2 = replayPrefixOneCharInputStream;
            if ((replayPrefixOneCharInputStream2.firstByte & 0xFFFFFFE0) == -64) {
                replayPrefixOneCharInputStream2.byteLength = 2;
                return this.replayReader.read();
            } else if ((replayPrefixOneCharInputStream2.firstByte & 0xFFFFFFF0) == -32) {
                replayPrefixOneCharInputStream2.byteLength = 3;
                return this.replayReader.read();
            } else {
                if ((replayPrefixOneCharInputStream2.firstByte & 0xFFFFFFF8) != -16) throw new IOException("invalid UTF-8 first byte: " + replayPrefixOneCharInputStream2.firstByte);
                replayPrefixOneCharInputStream2.byteLength = 4;
            }
            return this.replayReader.read();
        } else if (replayPrefixOneCharInputStream.encoding.equalsIgnoreCase("UTF-16")) {
            replayPrefixOneCharInputStream.byteLength = 2;
            return this.replayReader.read();
        } else {
            if (!replayPrefixOneCharInputStream.encoding.equalsIgnoreCase("UTF-32")) return this.replayReader.read();
            replayPrefixOneCharInputStream.byteLength = 4;
        }
        return this.replayReader.read();
    }

    public final boolean isSupported() {
        return true;
    }

    public final boolean getEcho() {
        return false;
    }

    public final int getTerminalWidth() {
        int val = -1;
        try {
            val = this.getTerminalProperty("columns");
        }
        catch (Exception exception) {}
        if (val == -1) {
            val = 80;
        }
        return val;
    }

    public final int getTerminalHeight() {
        int val = -1;
        try {
            val = this.getTerminalProperty("rows");
        }
        catch (Exception exception) {}
        if (val == -1) {
            val = 24;
        }
        return val;
    }

    private int getTerminalProperty(String prop) throws IOException, InterruptedException {
        if (this.ttyProps == null || System.currentTimeMillis() - this.ttyPropsLastFetched > 1000L) {
            this.ttyProps = UnixTerminal.stty("-a");
            this.ttyPropsLastFetched = System.currentTimeMillis();
        }
        StringTokenizer tok = new StringTokenizer(this.ttyProps, ";\n");
        while (tok.hasMoreTokens()) {
            String str = tok.nextToken().trim();
            if (str.startsWith(prop)) {
                int index = str.lastIndexOf(" ");
                return Integer.parseInt(str.substring(index).trim());
            }
            if (!str.endsWith(prop)) continue;
            int index = str.indexOf(" ");
            return Integer.parseInt(str.substring(0, index).trim());
        }
        return -1;
    }

    private static String stty(String args) throws IOException, InterruptedException {
        String string = "stty " + args + " < /dev/tty";
        return UnixTerminal.exec(new String[]{"sh", "-c", string}).trim();
    }

    private static String exec(String[] cmd) throws IOException, InterruptedException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        Process p = Runtime.getRuntime().exec(cmd);
        InputStream in = null;
        InputStream err = null;
        OutputStream out = null;
        try {
            int c;
            in = p.getInputStream();
            while ((c = in.read()) != -1) {
                bout.write(c);
            }
            err = p.getErrorStream();
            while ((c = err.read()) != -1) {
                bout.write(c);
            }
            out = p.getOutputStream();
            p.waitFor();
        }
        catch (Throwable throwable) {
            try {
                in.close();
            }
            catch (Exception exception) {}
            try {
                err.close();
            }
            catch (Exception exception) {}
            try {
                out.close();
            }
            catch (Exception exception) {}
            throw throwable;
        }
        try {
            in.close();
        }
        catch (Exception exception) {}
        try {
            err.close();
        }
        catch (Exception exception) {}
        try {
            out.close();
        }
        catch (Exception exception) {}
        String result = new String(bout.toByteArray());
        return result;
    }

    static /* synthetic */ void access$000(UnixTerminal x0, Throwable x1) {
    }

    static {
        System.getProperty("jline.sttyCommand", "stty");
    }

    static final class ReplayPrefixOneCharInputStream
    extends InputStream {
        byte firstByte;
        int byteLength;
        InputStream wrappedStream;
        int byteRead;
        final String encoding;

        public ReplayPrefixOneCharInputStream(String encoding) {
            this.encoding = encoding;
        }

        public final int read() throws IOException {
            if (this.available() == 0) {
                return -1;
            }
            ++this.byteRead;
            if (this.byteRead == 1) {
                return this.firstByte;
            }
            return this.wrappedStream.read();
        }

        public final int available() {
            return this.byteLength - this.byteRead;
        }
    }
}

