/*
 * Decompiled with CFR 0.152.
 */
package org.python.core.stringlib;

import org.python.core.stringlib.InternalFormatSpec;

public class InternalFormatSpecParser {
    private String spec;
    private int index;

    public InternalFormatSpecParser(String spec) {
        this.spec = spec;
        this.index = 0;
    }

    private static boolean isAlign(char c) {
        switch (c) {
            case '<': 
            case '=': 
            case '>': 
            case '^': {
                return true;
            }
        }
        return false;
    }

    public InternalFormatSpec parse() {
        InternalFormatSpec result = new InternalFormatSpec();
        if (this.spec.length() > 0 && InternalFormatSpecParser.isAlign(this.spec.charAt(0))) {
            result.align = this.spec.charAt(this.index);
            ++this.index;
        } else if (this.spec.length() >= 2 && InternalFormatSpecParser.isAlign(this.spec.charAt(1))) {
            result.fill_char = this.spec.charAt(0);
            result.align = this.spec.charAt(1);
            this.index += 2;
        }
        if (this.isAt("+- ")) {
            result.sign = this.spec.charAt(this.index);
            ++this.index;
        }
        if (this.isAt("#")) {
            result.alternate = true;
            ++this.index;
        }
        if (result.fill_char == '\u0000' && this.isAt("0")) {
            result.fill_char = (char)48;
            if (result.align == '\u0000') {
                result.align = (char)61;
            }
            ++this.index;
        }
        result.width = this.getInteger();
        if (this.isAt(",")) {
            result.thousands_separators = true;
            ++this.index;
        }
        if (this.isAt(".")) {
            ++this.index;
            result.precision = this.getInteger();
            if (result.precision == -1) {
                throw new IllegalArgumentException("Format specifier missing precision");
            }
        }
        if (this.index < this.spec.length()) {
            result.type = this.spec.charAt(this.index);
            if (this.index + 1 != this.spec.length()) {
                throw new IllegalArgumentException("Invalid conversion specification");
            }
        }
        if (result.thousands_separators && "defgEG%F\u0000".indexOf(result.type) == -1) {
            throw new IllegalArgumentException("Cannot specify ',' with '" + result.type + "'.");
        }
        return result;
    }

    private int getInteger() {
        int value = 0;
        boolean empty = true;
        while (this.index < this.spec.length() && this.spec.charAt(this.index) >= '0' && this.spec.charAt(this.index) <= '9') {
            value = value * 10 + this.spec.charAt(this.index) - 48;
            ++this.index;
            empty = false;
        }
        if (empty) {
            return -1;
        }
        return value;
    }

    private boolean isAt(String chars) {
        return this.index < this.spec.length() && chars.indexOf(this.spec.charAt(this.index)) >= 0;
    }
}

