/*
 * Decompiled with CFR 0.152.
 */
package org.python.google.common.collect;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.RandomAccess;
import javax.annotation.Nullable;
import org.python.google.common.base.CharMatcher;
import org.python.google.common.collect.AbstractIndexedListIterator;
import org.python.google.common.collect.Collections2;
import org.python.google.common.collect.EmptyImmutableList;
import org.python.google.common.collect.ImmutableCollection;
import org.python.google.common.collect.Iterators;
import org.python.google.common.collect.ObjectArrays;
import org.python.google.common.collect.RegularImmutableList;
import org.python.google.common.collect.SingletonImmutableList;
import org.python.google.common.collect.UnmodifiableIterator;
import org.python.google.common.collect.UnmodifiableListIterator;

public abstract class ImmutableList<E>
extends ImmutableCollection<E>
implements List<E>,
RandomAccess {
    public static <E> ImmutableList<E> of() {
        return EmptyImmutableList.INSTANCE;
    }

    public static <E> ImmutableList<E> of(E element) {
        return new SingletonImmutableList<E>(element);
    }

    public static <E> ImmutableList<E> copyOf(Iterable<? extends E> elements) {
        ImmutableList immutableList;
        block6: {
            block2: {
                ImmutableList<Object> immutableList2;
                block5: {
                    Collection<? extends E> collection;
                    block3: {
                        ImmutableList immutableList3;
                        block4: {
                            CharMatcher.LookupTable.checkNotNull(elements);
                            if (!(elements instanceof Collection)) break block2;
                            collection = Collections2.cast(elements);
                            if (!(collection instanceof ImmutableCollection)) break block3;
                            immutableList3 = ((ImmutableCollection)collection).asList();
                            if (!immutableList3.isPartialView()) break block4;
                            immutableList2 = ImmutableList.copyFromCollection(immutableList3);
                            break block5;
                        }
                        immutableList = immutableList3;
                        break block6;
                    }
                    immutableList2 = ImmutableList.copyFromCollection(collection);
                }
                return immutableList2;
            }
            Iterator<E> iterator = elements.iterator();
            if (!iterator.hasNext()) {
                return EmptyImmutableList.INSTANCE;
            }
            E e = iterator.next();
            if (!iterator.hasNext()) {
                return ImmutableList.of(e);
            }
            immutableList = ((Builder)((Builder)new Builder().add((Object)e)).addAll(iterator)).build();
        }
        return immutableList;
    }

    static <E> ImmutableList<E> asImmutableList(Object[] elements) {
        switch (elements.length) {
            case 0: {
                return EmptyImmutableList.INSTANCE;
            }
            case 1: {
                SingletonImmutableList<Object> list = new SingletonImmutableList<Object>(elements[0]);
                return list;
            }
        }
        Object[] objectArray = elements;
        for (int i = 0; i < objectArray.length; ++i) {
            ObjectArrays.checkElementNotNull(objectArray[i], i);
        }
        return new RegularImmutableList(objectArray);
    }

    private static <E> ImmutableList<E> copyFromCollection(Collection<? extends E> collection) {
        return ImmutableList.asImmutableList(collection.toArray());
    }

    ImmutableList() {
    }

    @Override
    public UnmodifiableIterator<E> iterator() {
        return this.listIterator();
    }

    @Override
    public UnmodifiableListIterator<E> listIterator() {
        return this.listIterator(0);
    }

    @Override
    public UnmodifiableListIterator<E> listIterator(int index) {
        return new AbstractIndexedListIterator<E>(this, this.size(), index){
            private /* synthetic */ ImmutableList this$0;
            {
                this.this$0 = immutableList;
                super(x0, x1);
            }

            @Override
            protected final E get(int index) {
                return this.this$0.get(index);
            }
        };
    }

    @Override
    public int indexOf(@Nullable Object object) {
        if (object != null) {
            Object object2 = object;
            ImmutableList immutableList = this;
            ListIterator listIterator = immutableList.listIterator();
            while (listIterator.hasNext()) {
                if (!CharMatcher.LookupTable.equal(object2, listIterator.next())) continue;
                return listIterator.previousIndex();
            }
        }
        return -1;
    }

    @Override
    public int lastIndexOf(@Nullable Object object) {
        if (object != null) {
            Object object2 = object;
            ImmutableList immutableList = this;
            ListIterator listIterator = immutableList.listIterator(immutableList.size());
            while (listIterator.hasPrevious()) {
                if (!CharMatcher.LookupTable.equal(object2, listIterator.previous())) continue;
                return listIterator.nextIndex();
            }
        }
        return -1;
    }

    @Override
    public boolean contains(@Nullable Object object) {
        return this.indexOf(object) >= 0;
    }

    @Override
    public ImmutableList<E> subList(int fromIndex, int toIndex) {
        CharMatcher.LookupTable.checkPositionIndexes(fromIndex, toIndex, this.size());
        int length = toIndex - fromIndex;
        switch (length) {
            case 0: {
                return EmptyImmutableList.INSTANCE;
            }
            case 1: {
                return ImmutableList.of(this.get(fromIndex));
            }
        }
        return this.subListUnchecked(fromIndex, toIndex);
    }

    ImmutableList<E> subListUnchecked(int fromIndex, int toIndex) {
        return new SubList(this, fromIndex, toIndex - fromIndex);
    }

    @Override
    public final boolean addAll(int index, Collection<? extends E> newElements) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final E set(int index, E element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final void add(int index, E element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final E remove(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final ImmutableList<E> asList() {
        return this;
    }

    @Override
    public boolean equals(Object obj) {
        Object object = obj;
        ImmutableList immutableList = this;
        if (object == CharMatcher.LookupTable.checkNotNull(immutableList)) {
            return true;
        }
        if (object instanceof List) {
            List list = (List)object;
            if (immutableList.size() == list.size() && Iterators.elementsEqual(immutableList.iterator(), list.iterator())) {
                return true;
            }
        }
        return false;
    }

    @Override
    public int hashCode() {
        ImmutableList immutableList = this;
        int n = 1;
        for (Object e : immutableList) {
            n = n * 31 + (e == null ? 0 : e.hashCode());
        }
        return n;
    }

    public static final class Builder<E>
    extends ImmutableCollection.Builder<E> {
        private Object[] contents = new Object[4];
        private int size = 0;

        public Builder() {
            this(4);
        }

        private Builder(int capacity) {
        }

        @Override
        public final Builder<E> add(E element) {
            CharMatcher.LookupTable.checkNotNull(element);
            boolean bl = true;
            Builder builder = this;
            int n = builder.size + 1;
            if (builder.contents.length < n) {
                Object[] objectArray = builder.contents;
                int n2 = n;
                int n3 = builder.contents.length;
                if (n2 < 0) {
                    throw new AssertionError((Object)"cannot store more than MAX_VALUE elements");
                }
                int n4 = n3 + (n3 >> 1) + 1;
                if (n4 < n2) {
                    n4 = Integer.highestOneBit(n2 - 1) << 1;
                }
                if (n4 < 0) {
                    n4 = Integer.MAX_VALUE;
                }
                builder.contents = ObjectArrays.arraysCopyOf(objectArray, n4);
            }
            this.contents[this.size++] = element;
            return this;
        }

        @Override
        public final Builder<E> addAll(Iterator<? extends E> elements) {
            super.addAll(elements);
            return this;
        }

        public final ImmutableList<E> build() {
            switch (this.size) {
                case 0: {
                    return ImmutableList.of();
                }
                case 1: {
                    Object singleElement = this.contents[0];
                    return ImmutableList.of(singleElement);
                }
            }
            if (this.size == this.contents.length) {
                return new RegularImmutableList(this.contents);
            }
            return new RegularImmutableList(ObjectArrays.arraysCopyOf(this.contents, this.size));
        }
    }

    final class SubList
    extends ImmutableList<E> {
        private transient int offset;
        private transient int length;
        private /* synthetic */ ImmutableList this$0;

        SubList(ImmutableList immutableList, int offset, int length) {
            this.this$0 = immutableList;
            this.offset = offset;
            this.length = length;
        }

        @Override
        public final int size() {
            return this.length;
        }

        @Override
        public final E get(int index) {
            CharMatcher.LookupTable.checkElementIndex(index, this.length);
            return this.this$0.get(index + this.offset);
        }

        @Override
        public final ImmutableList<E> subList(int fromIndex, int toIndex) {
            CharMatcher.LookupTable.checkPositionIndexes(fromIndex, toIndex, this.length);
            return this.this$0.subList(fromIndex + this.offset, toIndex + this.offset);
        }

        @Override
        final boolean isPartialView() {
            return true;
        }
    }
}

