/*
 * Decompiled with CFR 0.152.
 */
package org.python.indexer.ast;

import java.io.File;
import org.python.indexer.Indexer;
import org.python.indexer.NBinding;
import org.python.indexer.Scope;
import org.python.indexer.Util;
import org.python.indexer.ast.NName;
import org.python.indexer.ast.NNode;
import org.python.indexer.ast.NNodeVisitor;
import org.python.indexer.types.NModuleType;
import org.python.indexer.types.NType;
import org.python.indexer.types.NUnknownType;

public final class NQname
extends NNode {
    private NQname next;
    private NName name;

    public NQname(NQname next, NName name) {
        this(null, name, 0, 1);
    }

    public NQname(NQname next, NName name, int start, int end) {
        super(start, end);
        if (name == null) {
            throw new IllegalArgumentException("null name");
        }
        this.name = name;
        this.next = next;
        this.addChildren(name, next);
    }

    public final NName getName() {
        return this.name;
    }

    private NQname getPrevious() {
        NNode parent = this.getParent();
        if (parent instanceof NQname) {
            return (NQname)parent;
        }
        return null;
    }

    public final NQname getNext() {
        return this.next;
    }

    public final NQname getBottom() {
        while (this_.next != null) {
            NQname this_ = this_.next;
        }
        return this_;
    }

    public final boolean isTop() {
        return this.getPrevious() == null;
    }

    private boolean isBottom() {
        return this.next == null;
    }

    public final String toQname() {
        if (this.isBottom()) {
            return this.name.id;
        }
        return this.name.id + "." + this.next.toQname();
    }

    private String thisQname() {
        NQname n = this.getTop();
        StringBuilder sb = new StringBuilder();
        sb.append(n.name.id);
        while (n != this) {
            sb.append(".");
            n = n.next;
            sb.append(n.name.id);
        }
        return sb.toString();
    }

    private NQname getTop() {
        while (!this_.isTop()) {
            NQname this_ = this_.getPrevious();
        }
        return this_;
    }

    @Override
    public final NType resolve(Scope s) throws Exception {
        Object object;
        String string;
        NModuleType nModuleType;
        NModuleType nModuleType2;
        this.setType(this.name.setType(new NUnknownType()));
        NQname nQname = this;
        if (nQname.isTop() && nQname.isBottom()) {
            NModuleType mt = Indexer.idx.loadModule(this.name.id);
            if (mt != null) {
                return this.setType(this.name.setType(mt));
            }
        } else {
            NModuleType mt = Indexer.idx.getBuiltinModule(this.thisQname());
            if (mt != null) {
                this.setType(this.name.setType(mt));
                NQname.resolveExpr(this.next, s);
                return mt;
            }
        }
        Scope scope = s;
        nQname = this;
        Object object2 = scope;
        NQname nQname2 = nQname;
        if (!nQname.isTop()) {
            NType nType = nQname2.getPrevious().getType();
            nModuleType2 = (NModuleType)nType;
        } else {
            NModuleType nModuleType3;
            Scope scope2 = ((Scope)object2).getSymtabOfType(Scope.Type.MODULE);
            if (scope2 != null && (nModuleType3 = Indexer.idx.loadModule(scope2.getPath())) != null) {
                nModuleType2 = nModuleType3;
            } else {
                String string2 = new File(nQname2.getFile()).getParent();
                if (string2 == null) {
                    Indexer.idx.warn("Unable to find parent dir for " + nQname2.getFile());
                    nModuleType2 = null;
                } else {
                    nModuleType2 = nModuleType = Indexer.idx.loadModule(string2);
                }
            }
        }
        if (nModuleType2 == null) {
            nQname.reportUnresolvedModule();
            return nQname.getType();
        }
        String string3 = nModuleType.getTable().getPath();
        nQname2 = nQname;
        if (".".equals(nQname2.name.id)) {
            string = Util.getQnameParent(string3);
        } else if (!nQname.isTop()) {
            string = string3 + "." + nQname.name.id;
        } else {
            nQname2 = nQname;
            object2 = nQname2.getFile();
            object = (object2 == null ? false : new File((String)object2).getName().equals("__init__.py")) ? string3 : Util.getQnameParent(string3);
            string = (String)object + "." + nQname.name.id;
            if (Indexer.idx.loadModule(string) == null) {
                string = nQname.name.id;
            }
        }
        object = Indexer.idx.loadModule(string);
        if (object == null) {
            nQname.reportUnresolvedModule();
            return nQname.getType();
        }
        nQname.setType(nQname.name.setType((NType)object));
        if (!nQname.isTop() && ((NModuleType)object).getFile() != null) {
            Scope scope3 = nQname.getPrevious().getTable();
            NBinding nBinding = Indexer.idx.moduleTable.lookup(((NModuleType)object).getFile());
            scope3.put(nQname.name.id, nBinding);
        }
        NQname.resolveExpr(nQname.next, scope);
        return nQname.getType();
    }

    private void reportUnresolvedModule() {
        this.addError("module not found: " + this.name.id);
        Indexer.idx.recordUnresolvedModule(this.thisQname(), this.getFile());
    }

    public final String toString() {
        return "<QName:" + this.name + ":" + this.next + ">";
    }

    @Override
    public final void visit(NNodeVisitor v) {
        if (v.visit(this)) {
            NQname.visitNode(this.next, v);
            NQname.visitNode(this.name, v);
        }
    }
}

