/*
 * Decompiled with CFR 0.152.
 */
package org.python.modules.itertools;

import org.python.core.Py;
import org.python.core.PyIterator;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.python.core.PyTuple;
import org.python.core.PyType;
import org.python.expose.ExposedNew;
import org.python.expose.ExposedType;
import org.python.modules.itertools.itertools;
import org.python.modules.itertools.product$PyExposer;

@ExposedType(name="itertools.product", base=PyObject.class)
public class product
extends PyObject {
    public static final PyType TYPE;
    private PyIterator iter;
    public static PyString __doc__;

    public product() {
    }

    public product(PyType subType) {
        super(subType);
    }

    public product(PyTuple[] tuples, int repeat2) {
        this.product___init__(tuples, repeat2);
    }

    @ExposedNew
    final void product___init__(PyObject[] args, String[] kws) {
        int num_iterables;
        int repeat2;
        if (kws.length == 1 && kws[0] == "repeat") {
            repeat2 = args[args.length - 1].asInt();
            if (repeat2 < 0) {
                throw Py.ValueError("repeat argument cannot be negative");
            }
            num_iterables = args.length - 1;
        } else {
            repeat2 = 1;
            num_iterables = args.length;
        }
        PyTuple[] tuples = new PyTuple[num_iterables];
        for (int i = 0; i < num_iterables; ++i) {
            tuples[i] = PyTuple.fromIterable(args[i]);
        }
        this.product___init__(tuples, repeat2);
    }

    private void product___init__(PyTuple[] tuples, int repeat2) {
        int num_pools = tuples.length * repeat2;
        PyTuple[] pools = new PyTuple[num_pools];
        for (int r = 0; r < repeat2; ++r) {
            System.arraycopy(tuples, 0, pools, r * tuples.length, tuples.length);
        }
        int[] indices = new int[num_pools];
        this.iter = new itertools.ItertoolsIterator(this, pools, num_pools, indices){
            private boolean firstthru = true;
            private /* synthetic */ PyTuple[] val$pools;
            private /* synthetic */ int val$num_pools;
            private /* synthetic */ int[] val$indices;
            private /* synthetic */ product this$0;
            {
                this.val$pools = pyTupleArray;
                this.val$num_pools = n;
                this.val$indices = nArray;
            }

            @Override
            public PyObject __iternext__() {
                if (this.firstthru) {
                    PyTuple[] arr$ = this.val$pools;
                    int len$ = this.val$pools.length;
                    for (int i$ = 0; i$ < len$; ++i$) {
                        PyTuple pool = arr$[i$];
                        if (pool.__len__() != 0) continue;
                        return null;
                    }
                    this.firstthru = false;
                    return this.makeTuple();
                }
                for (int i = this.val$num_pools - 1; i >= 0; --i) {
                    int n = i;
                    this.val$indices[n] = this.val$indices[n] + 1;
                    if (this.val$indices[i] != this.val$pools[i].__len__()) {
                        return this.makeTuple();
                    }
                    this.val$indices[i] = 0;
                }
                return null;
            }

            private PyTuple makeTuple() {
                PyObject[] items = new PyObject[this.val$num_pools];
                for (int i = 0; i < this.val$num_pools; ++i) {
                    items[i] = this.val$pools[i].__getitem__(this.val$indices[i]);
                }
                return new PyTuple(items);
            }
        };
    }

    @Override
    public PyObject __iter__() {
        return this.iter;
    }

    public PyObject next() {
        return this.iter.next();
    }

    static {
        PyType.addBuilder(product.class, new product$PyExposer());
        TYPE = PyType.fromClass(product.class);
        __doc__ = new PyString("product(*iterables) --> product object\n\nCartesian product of input iterables.  Equivalent to nested for-loops.\n\nFor example, product(A, B) returns the same as:  ((x,y) for x in A for y in B).\nThe leftmost iterators are in the outermost for-loop, so the output tuples\ncycle in a manner similar to an odometer (with the rightmost element changing\non every iteration).\n\nTo compute the product of an iterable with itself, specify the number\nof repetitions with the optional repeat keyword argument. For example,\nproduct(A, repeat=4) means the same as product(A, A, A, A).\n\nproduct('ab', range(3)) --> ('a',0) ('a',1) ('a',2) ('b',0) ('b',1) ('b',2)\nproduct((0,1), (0,1), (0,1)) --> (0,0,0) (0,0,1) (0,1,0) (0,1,1) (1,0,0) ...");
    }
}

