/*
 * Decompiled with CFR 0.152.
 */
package com.python.pydev.analysis;

import com.python.pydev.analysis.AbstractAnalysisPreferences;
import com.python.pydev.analysis.AnalysisPlugin;
import com.python.pydev.analysis.PyAnalysisScopedPreferences;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.python.pydev.core.preferences.PydevPrefs;
import org.python.pydev.shared_core.SharedCorePlugin;
import org.python.pydev.shared_core.preferences.IScopedPreferences;
import org.python.pydev.shared_core.process.ProcessUtils;
import org.python.pydev.shared_core.string.FastStringBuffer;
import org.python.pydev.shared_core.string.StringUtils;

public class AnalysisPreferences
extends AbstractAnalysisPreferences {
    private final IAdaptable projectAdaptable;
    static final Object[][] completeSeverityMap = new Object[][]{{1, "SEVERITY_UNUSED_IMPORT", 1}, {2, "SEVERITY_UNUSED_VARIABLE", 1}, {3, "SEVERITY_UNDEFINED_VARIABLE", 2}, {4, "SEVERITY_DUPLICATED_SIGNATURE", 2}, {5, "SEVERITY_REIMPORT", 1}, {6, "SEVERITY_UNRESOLVED_IMPORT", 2}, {7, "SEVERITY_NO_SELF", 2}, {8, "SEVERITY_UNUSED_WILD_IMPORT", 1}, {9, "SEVERITY_UNDEFINED_IMPORT_VARIABLE", 2}, {10, "SEVERITY_UNUSED_PARAMETER", 0}, {11, "SEVERITY_NO_EFFECT_STMT", 1}, {12, "SEVERITY_INDENTATION_PROBLEM", 1}, {14, "SEVERITY_ASSIGNMENT_TO_BUILT_IN_SYMBOL", 1}, {15, "SEVERITY_PEP8", -1}, {16, "SEVERITY_ARGUMENTS_MISMATCH", -1}, {17, "SEVERITY_FSTRING_ERROR", 2}, {18, "SEVERITY_INVALID_ENCODING", 2}};
    private HashMap<Integer, Integer> severityTypeMapCache;
    private final Object lock = new Object();
    public static boolean TESTS_DO_AUTO_IMPORT = true;
    public static boolean TESTS_DO_AUTO_IMPORT_ON_ORGANIZE_IMPORTS = true;
    public static boolean TESTS_DO_IGNORE_IMPORT_STARTING_WITH_UNDER = false;

    public AnalysisPreferences(IAdaptable projectAdaptable) {
        this.projectAdaptable = projectAdaptable;
    }

    public IAdaptable getProjectAdaptable() {
        return this.projectAdaptable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<Integer, Integer> getSeverityTypeMap() {
        if (this.severityTypeMapCache == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.severityTypeMapCache == null) {
                    HashMap<Integer, Integer> temp = new HashMap<Integer, Integer>();
                    IEclipsePreferences analysisEclipsePreferences = PydevPrefs.getAnalysisEclipsePreferences();
                    IEclipsePreferences defaultAnalysisEclipsePreferences = PydevPrefs.getDefaultAnalysisEclipsePreferences();
                    IScopedPreferences iScopedPreferences = PyAnalysisScopedPreferences.get();
                    int i = 0;
                    while (i < completeSeverityMap.length) {
                        Object[] s = completeSeverityMap[i];
                        int v = iScopedPreferences.getInt(analysisEclipsePreferences, defaultAnalysisEclipsePreferences, (String)s[1], this.projectAdaptable);
                        temp.put((Integer)s[0], v);
                        ++i;
                    }
                    temp.put(16, -1);
                    this.severityTypeMapCache = temp;
                }
            }
        }
        return this.severityTypeMapCache;
    }

    public int getSeverityForType(int type) {
        Map<Integer, Integer> severityTypeMap = this.getSeverityTypeMap();
        Integer sev = severityTypeMap.get(type);
        if (sev == null) {
            throw new RuntimeException("Unable to get severity for: " + type);
        }
        return sev;
    }

    public boolean makeCodeAnalysis() {
        AnalysisPlugin plugin = AnalysisPlugin.getDefault();
        if (plugin == null) {
            return false;
        }
        return PyAnalysisScopedPreferences.getBoolean("DO_CODE_ANALYSIS", this.projectAdaptable);
    }

    public Set<String> getNamesIgnoredByUnusedVariable() {
        return this.getSetOfNames("NAMES_TO_IGNORE_UNUSED_VARIABLE");
    }

    public Set<String> getTokensAlwaysInGlobals() {
        return this.getSetOfNames("NAMES_TO_CONSIDER_GLOBALS");
    }

    private Set<String> getSetOfNames(String preferencesName) {
        HashSet<String> names = new HashSet<String>();
        String string = PyAnalysisScopedPreferences.getString(preferencesName, this.projectAdaptable);
        if (string != null) {
            String[] strings = string.split(",");
            int i = 0;
            while (i < strings.length) {
                names.add(strings[i].trim());
                ++i;
            }
        }
        return names;
    }

    public Set<String> getModuleNamePatternsToBeIgnored() {
        Set<String> setOfNames = this.getSetOfNames("NAMES_TO_IGNORE_UNUSED_IMPORT");
        HashSet<String> ret = new HashSet<String>();
        for (String string : setOfNames) {
            ret.add(string.replaceAll("\\*", ".*"));
        }
        return ret;
    }

    public static String[] getPep8CommandLine(IAdaptable projectAdaptable) {
        return ProcessUtils.parseArguments((String)AnalysisPreferences.getPep8CommandLineAsStr(projectAdaptable));
    }

    public static String getPep8CommandLineAsStr(IAdaptable projectAdaptable) {
        return PyAnalysisScopedPreferences.getString("PEP8_IGNORE_WARNINGS", projectAdaptable);
    }

    public static boolean useConsole(IAdaptable projectAdaptable) {
        return false;
    }

    public static boolean useSystemInterpreter(IAdaptable projectAdaptable) {
        return PyAnalysisScopedPreferences.getBoolean("PEP8_USE_SYSTEM", projectAdaptable);
    }

    public static boolean doAutoImport(IAdaptable projectAdaptable) {
        if (SharedCorePlugin.inTestMode()) {
            return TESTS_DO_AUTO_IMPORT;
        }
        return PyAnalysisScopedPreferences.getBoolean("DO_AUTO_IMPORT", projectAdaptable);
    }

    public static boolean doAutoImportOnOrganizeImports(IAdaptable projectAdaptable) {
        if (SharedCorePlugin.inTestMode()) {
            return TESTS_DO_AUTO_IMPORT_ON_ORGANIZE_IMPORTS;
        }
        return PyAnalysisScopedPreferences.getBoolean("DO_AUTO_IMPORT_ON_ORGANIZE_IMPORTS", projectAdaptable);
    }

    public static boolean doIgnoreImportsStartingWithUnder(IAdaptable projectAdaptable) {
        if (SharedCorePlugin.inTestMode()) {
            return TESTS_DO_IGNORE_IMPORT_STARTING_WITH_UNDER;
        }
        return PyAnalysisScopedPreferences.getBoolean("DO_IGNORE_FIELDS_WITH_UNDER", projectAdaptable);
    }

    public static String removeImportsStartingWithUnderIfNeeded(String declPackageWithoutInit, FastStringBuffer buf, boolean doIgnoreImportsStartingWithUnder) {
        block5: {
            if (!doIgnoreImportsStartingWithUnder) break block5;
            List splitted = StringUtils.dotSplit((String)declPackageWithoutInit);
            boolean foundStartingWithoutUnder = false;
            buf.clear();
            int len = splitted.size();
            int i = len - 1;
            while (i >= 0) {
                block7: {
                    String s;
                    block6: {
                        s = (String)splitted.get(i);
                        if (foundStartingWithoutUnder) break block6;
                        if (s.charAt(0) == '_') break block7;
                        foundStartingWithoutUnder = true;
                    }
                    buf.insert(0, s);
                    if (i != 0) {
                        buf.insert(0, '.');
                    }
                }
                --i;
            }
            declPackageWithoutInit = buf.toString();
        }
        return declPackageWithoutInit;
    }
}

