/*
 * Decompiled with CFR 0.152.
 */
package com.python.pydev.analysis.additionalinfo;

import com.python.pydev.analysis.additionalinfo.AbstractAdditionalTokensInfo;
import com.python.pydev.analysis.additionalinfo.IOUtils;
import com.python.pydev.analysis.additionalinfo.IReferenceSearches;
import com.python.pydev.analysis.additionalinfo.ReferenceSearchesLucene;
import com.python.pydev.analysis.additionalinfo.TreeIO;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import org.eclipse.core.runtime.IProgressMonitor;
import org.python.pydev.ast.codecompletion.revisited.PyPublicTreeMap;
import org.python.pydev.ast.codecompletion.revisited.PythonPathHelper;
import org.python.pydev.ast.codecompletion.revisited.modules.IAbstractJavaClassModule;
import org.python.pydev.ast.interpreter_managers.InterpreterInfo;
import org.python.pydev.core.BaseModuleRequest;
import org.python.pydev.core.FastBufferedReader;
import org.python.pydev.core.IGrammarVersionProvider;
import org.python.pydev.core.IInfo;
import org.python.pydev.core.IModule;
import org.python.pydev.core.IModuleRequestState;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.IToken;
import org.python.pydev.core.IterTokenEntry;
import org.python.pydev.core.MisconfigurationException;
import org.python.pydev.core.ModulesKey;
import org.python.pydev.core.ObjectsInternPool;
import org.python.pydev.core.TokensList;
import org.python.pydev.core.cache.CompleteIndexKey;
import org.python.pydev.core.cache.DiskCache;
import org.python.pydev.core.log.Log;
import org.python.pydev.core.logging.DebugSettings;
import org.python.pydev.parser.jython.SimpleNode;
import org.python.pydev.parser.jython.ast.Name;
import org.python.pydev.parser.jython.ast.exprType;
import org.python.pydev.parser.jython.ast.factory.AdapterPrefs;
import org.python.pydev.parser.jython.ast.factory.PyAstFactory;
import org.python.pydev.shared_core.callbacks.CallbackWithListeners;
import org.python.pydev.shared_core.io.FileUtils;
import org.python.pydev.shared_core.log.ToLogFile;
import org.python.pydev.shared_core.string.FastStringBuffer;
import org.python.pydev.shared_core.string.StringUtils;
import org.python.pydev.shared_core.structure.Tuple;
import org.python.pydev.shared_core.structure.Tuple3;

public abstract class AbstractAdditionalDependencyInfo
extends AbstractAdditionalTokensInfo {
    public static boolean TESTING = false;
    public static final boolean DEBUG = false;
    public DiskCache completeIndex;
    private volatile IReferenceSearches referenceSearches;
    private final Object referenceSearchesLock = new Object();
    public static final CallbackWithListeners modulesAddedAndRemoved = new CallbackWithListeners(1);
    public final Object updateKeysLock = new Object();
    private CountDownLatch waitForIntegrity = null;
    private static final Object waitForIntegrityLock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IReferenceSearches getReferenceSearches() {
        if (this.referenceSearches == null) {
            Object object = this.referenceSearchesLock;
            synchronized (object) {
                if (this.referenceSearches == null) {
                    this.referenceSearches = new ReferenceSearchesLucene(this);
                }
            }
        }
        return this.referenceSearches;
    }

    public void dispose() {
        this.referenceSearches = null;
    }

    public AbstractAdditionalDependencyInfo() throws MisconfigurationException {
        this.init();
    }

    public AbstractAdditionalDependencyInfo(boolean callInit) throws MisconfigurationException {
        if (callInit) {
            this.init();
        }
    }

    protected void init() throws MisconfigurationException {
        File persistingFolder = this.getCompleteIndexPersistingFolder();
        this.completeIndex = new DiskCache(persistingFolder, ".v2_indexcache");
    }

    protected File getCompleteIndexPersistingFolder() throws MisconfigurationException {
        File persistingFolder = this.getPersistingFolder();
        if ((persistingFolder = new File(persistingFolder, "v2_indexcache")).exists() && !persistingFolder.isDirectory()) {
            persistingFolder.delete();
        }
        if (!persistingFolder.exists()) {
            persistingFolder.mkdirs();
        }
        return persistingFolder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearAllInfo() {
        Object object = this.lock;
        synchronized (object) {
            super.clearAllInfo();
            try {
                this.completeIndex.clear();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
    }

    public void updateKeysIfNeededAndSave(PyPublicTreeMap<ModulesKey, ModulesKey> keysFound, InterpreterInfo info, IProgressMonitor monitor) {
        Map keys = this.completeIndex.keys();
        ArrayList<ModulesKey> newKeys = new ArrayList<ModulesKey>();
        ArrayList<ModulesKey> removedKeys = new ArrayList<ModulesKey>();
        CompleteIndexKey tempKey = new CompleteIndexKey(null);
        boolean isJython = info != null ? info.getInterpreterType() == 1 : true;
        for (ModulesKey next : keysFound.values()) {
            if (next.file != null) {
                long lastModified = FileUtils.lastModified((File)next.file);
                if (lastModified == 0L) continue;
                tempKey.key = next;
                CompleteIndexKey completeIndexKey = (CompleteIndexKey)keys.get(tempKey);
                if (completeIndexKey == null) {
                    newKeys.add(next);
                    continue;
                }
                if (completeIndexKey.lastModified == lastModified) continue;
                newKeys.add(next);
                continue;
            }
            tempKey.key = next;
            CompleteIndexKey completeIndexKey = (CompleteIndexKey)keys.get(tempKey);
            if (completeIndexKey != null) continue;
            newKeys.add(next);
        }
        for (CompleteIndexKey next : keys.values()) {
            if (keysFound.containsKey((Object)next.key)) continue;
            removedKeys.add(next.key);
        }
        boolean hasNew = newKeys.size() != 0;
        boolean hasRemoved = removedKeys.size() != 0;
        modulesAddedAndRemoved.call((Object)new Tuple(newKeys, removedKeys));
        HashSet<File> ignoreFiles = new HashSet<File>();
        if (hasRemoved) {
            for (ModulesKey removedKey : removedKeys) {
                this.removeInfoFromModule(removedKey.name, false);
            }
        }
        if (hasNew) {
            FastStringBuffer buffer = new FastStringBuffer();
            int currI = 0;
            int total = newKeys.size();
            BaseModuleRequest moduleRequest = new BaseModuleRequest(true);
            for (ModulesKey newKey : newKeys) {
                ++currI;
                if (monitor.isCanceled()) {
                    return;
                }
                if (PythonPathHelper.canAddAstInfoForSourceModule((ModulesKey)newKey)) {
                    buffer.clear().append("Indexing ").append(currI).append(" of ").append(total).append(" (source module): ").append(newKey.name).append("  (").append(currI).append(" of ").append(total).append(")");
                    try {
                        this.addAstInfo(newKey, false);
                    }
                    catch (Exception e) {
                        Log.log((Throwable)e);
                    }
                    continue;
                }
                if (info == null || isJython && ignoreFiles.contains(newKey.file)) continue;
                buffer.clear().append("Indexing ").append(currI).append(" of ").append(total).append(" (builtin module): ").append(newKey.name);
                monitor.setTaskName(buffer.toString());
                IModule builtinModule = info.getModulesManager().getModule(newKey.name, info.getModulesManager().getNature(), true, (IModuleRequestState)moduleRequest);
                if (builtinModule == null) continue;
                if (builtinModule instanceof IAbstractJavaClassModule) {
                    if (newKey.file != null) {
                        ignoreFiles.add(newKey.file);
                        continue;
                    }
                    Log.log((String)("Not expecting null file for java class module: " + newKey));
                    continue;
                }
                boolean removeFirst = keys.containsKey(new CompleteIndexKey(newKey));
                this.addAstForCompiledModule(builtinModule, info, newKey, removeFirst);
            }
        }
        if (hasNew || hasRemoved) {
            if (DebugSettings.DEBUG_INTERPRETER_AUTO_UPDATE) {
                ToLogFile.toLogFile((Object)this, (String)StringUtils.format((String)"Additional info modules. Added: %s Removed: %s", (Object[])new Object[]{newKeys, removedKeys}));
            }
            this.save();
        }
    }

    private void addAstForCompiledModule(IModule module, InterpreterInfo info, ModulesKey newKey, boolean removeFirst) {
        TokensList globalTokens = module.getGlobalTokens();
        PyAstFactory astFactory = new PyAstFactory(new AdapterPrefs("\n", (IGrammarVersionProvider)info.getModulesManager().getNature()));
        ArrayList<Object> body = new ArrayList<Object>(globalTokens.size());
        for (IterTokenEntry entry : globalTokens) {
            IToken token = entry.getToken();
            switch (token.getType()) {
                case 1: {
                    body.add(astFactory.createClassDef(token.getRepresentation()));
                    break;
                }
                case 2: {
                    body.add(astFactory.createFunctionDef(token.getRepresentation()));
                    break;
                }
                default: {
                    Name attr = astFactory.createName(token.getRepresentation());
                    body.add(astFactory.createAssign(new exprType[]{attr, attr}));
                }
            }
        }
        if (removeFirst) {
            this.removeInfoFromModule(newKey.name, false);
        }
        this.addAstInfo((SimpleNode)astFactory.createModule(body), newKey, false);
    }

    protected abstract String getUIRepresentation();

    protected abstract Set<String> getPythonPathFolders();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<IInfo> addAstInfo(SimpleNode node, ModulesKey key, boolean generateDelta) {
        List<IInfo> addAstInfo = new ArrayList<IInfo>();
        if (node == null || key == null || key.name == null) {
            return addAstInfo;
        }
        try {
            Object object = this.lock;
            synchronized (object) {
                addAstInfo = super.addAstInfo(node, key, generateDelta);
                CompleteIndexKey completeIndexKey = new CompleteIndexKey(key);
                if (key.file != null) {
                    completeIndexKey.lastModified = FileUtils.lastModified((File)key.file);
                }
                this.completeIndex.add(completeIndexKey);
            }
        }
        catch (Exception e) {
            Log.log((Throwable)e);
        }
        return addAstInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void addModulesKeyForFolderToIndex(ModulesKey key, boolean generateDelta) {
        Object object = this.lock;
        synchronized (object) {
            CompleteIndexKey completeIndexKey = new CompleteIndexKey(key);
            if (key.file != null) {
                completeIndexKey.lastModified = FileUtils.lastModified((File)key.file);
            }
            this.completeIndex.add(completeIndexKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeInfoFromModule(String moduleName, boolean generateDelta) {
        Object object = this.lock;
        synchronized (object) {
            if (moduleName == null) {
                throw new AssertionError((Object)"The module name may not be null.");
            }
            this.completeIndex.remove(new CompleteIndexKey(moduleName));
            super.removeInfoFromModule(moduleName, generateDelta);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void saveTo(OutputStreamWriter writer, FastStringBuffer tempBuf, File pathToSave) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.completeIndex.writeTo(tempBuf);
            writer.write(tempBuf.getInternalCharsArray(), 0, tempBuf.length());
            tempBuf.clear();
            super.saveTo(writer, tempBuf, pathToSave);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void restoreSavedInfo(Object o) throws MisconfigurationException {
        Object object = this.lock;
        synchronized (object) {
            Tuple readFromFile = (Tuple)o;
            if (!(readFromFile.o1 instanceof Tuple3)) {
                throw new RuntimeException("Type Error: the info must be regenerated (changed across versions).");
            }
            this.completeIndex = (DiskCache)readFromFile.o2;
            if (this.completeIndex == null) {
                throw new RuntimeException("Type Error (index == null): the info must be regenerated (changed across versions).");
            }
            String shouldBeOn = FileUtils.getFileAbsolutePath((File)this.getCompleteIndexPersistingFolder());
            if (!this.completeIndex.getFolderToPersist().equals(shouldBeOn)) {
                this.completeIndex.setFolderToPersist(shouldBeOn);
            }
            super.restoreSavedInfo(readFromFile.o1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean load() {
        RuntimeException errorFound = null;
        Object object = this.lock;
        synchronized (object) {
            File file;
            try {
                file = this.getPersistingLocation();
            }
            catch (MisconfigurationException e) {
                Log.log((String)"Unable to restore previous info... (persisting location not available).", (Throwable)e);
                return false;
            }
            if (file.exists() && file.isFile()) {
                try {
                    return this.loadContentsFromFile(file, this.getNature()) != null;
                }
                catch (Throwable e) {
                    errorFound = new RuntimeException("Unable to read: " + file, e);
                }
            }
        }
        try {
            String msg = "Info: Rebuilding internal caches: " + this.getPersistingLocation();
            if (errorFound == null) {
                msg = String.valueOf(msg) + " (Expected error to be provided and got no error!)";
                Log.log((int)4, (String)msg, (Throwable)errorFound);
            } else {
                Log.log((int)1, (String)msg, (Throwable)errorFound);
            }
        }
        catch (Exception e1) {
            Log.log((String)"Rebuilding internal caches (error getting persisting location).");
        }
        return false;
    }

    private Object loadContentsFromFile(File file, IPythonNature nature) throws FileNotFoundException, IOException, MisconfigurationException {
        FileInputStream fileInputStream = new FileInputStream(file);
        String expected = "-- VERSION_5";
        InputStreamReader reader = new InputStreamReader(fileInputStream);
        FastBufferedReader bufferedReader = new FastBufferedReader((Reader)reader);
        FastStringBuffer string = bufferedReader.readLine();
        ObjectsInternPool.ObjectsPoolMap objectsPoolMap = new ObjectsInternPool.ObjectsPoolMap();
        if (string != null && string.startsWith("-- VERSION_")) {
            Tuple tupWithResults = new Tuple((Object)new Tuple3(null, null, null), null);
            Tuple3 superTupWithResults = (Tuple3)tupWithResults.o1;
            if (string.toString().equals(expected)) {
                try {
                    try {
                        FastStringBuffer line;
                        Map<Integer, String> dictionary = null;
                        FastStringBuffer tempBuf = new FastStringBuffer(1024);
                        while ((line = bufferedReader.readLine()) != null) {
                            if (!line.startsWith("-- ")) continue;
                            if (line.startsWith("-- START TREE 1")) {
                                superTupWithResults.o1 = TreeIO.loadTreeFrom(bufferedReader, dictionary, tempBuf.clear(), objectsPoolMap, nature);
                                continue;
                            }
                            if (line.startsWith("-- START TREE 2")) {
                                superTupWithResults.o2 = TreeIO.loadTreeFrom(bufferedReader, dictionary, tempBuf.clear(), objectsPoolMap, nature);
                                continue;
                            }
                            if (line.startsWith("-- START DICTIONARY")) {
                                dictionary = TreeIO.loadDictFrom(bufferedReader, tempBuf.clear(), objectsPoolMap);
                                continue;
                            }
                            if (line.startsWith("-- START DISKCACHE")) {
                                if (!line.startsWith("-- START DISKCACHE_3")) {
                                    throw new RuntimeException("Disk cache version changed");
                                }
                                tupWithResults.o2 = DiskCache.loadFrom((FastBufferedReader)bufferedReader, (ObjectsInternPool.ObjectsPoolMap)objectsPoolMap);
                                continue;
                            }
                            if (line.startsWith("-- VERSION_")) {
                                if (line.endsWith(String.valueOf(5))) continue;
                                throw new RuntimeException("Expected the version to be: 5 Found: " + line);
                            }
                            if (line.startsWith("-- END TREE")) continue;
                            throw new RuntimeException("Unexpected line: " + line);
                        }
                    }
                    finally {
                        bufferedReader.close();
                    }
                }
                finally {
                    reader.close();
                }
                this.restoreSavedInfo(tupWithResults);
                Tuple tuple = tupWithResults;
                return tuple;
            }
            throw new RuntimeException("Version does not match. Found: " + string + ". Expected: " + expected);
        }
        fileInputStream.close();
        Object tupWithResults = IOUtils.readFromFile(file);
        this.restoreSavedInfo(tupWithResults);
        this.save();
        Object object = tupWithResults;
        return object;
        finally {
            try {
                fileInputStream.close();
            }
            catch (Exception exception) {}
        }
    }

    protected void addInfoToModuleOnRestoreInsertCommand(Tuple<ModulesKey, List<IInfo>> data) {
        CompleteIndexKey key = new CompleteIndexKey((ModulesKey)data.o1);
        if (((ModulesKey)data.o1).file != null) {
            key.lastModified = FileUtils.lastModified((File)((ModulesKey)data.o1).file);
        }
        this.completeIndex.add(key);
        for (IInfo info : (List)data.o2) {
            if (info.getPath() == null || info.getPath().length() == 0) {
                this.add(info, 1);
                continue;
            }
            this.add(info, 2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setWaitForIntegrityCheck(boolean waitFor) {
        Object object = waitForIntegrityLock;
        synchronized (object) {
            if (waitFor) {
                if (this.waitForIntegrity == null) {
                    this.waitForIntegrity = new CountDownLatch(1);
                }
            } else if (this.waitForIntegrity != null) {
                this.waitForIntegrity.countDown();
                this.waitForIntegrity = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForIntegrityCheck() {
        CountDownLatch waitFor = null;
        Object object = waitForIntegrityLock;
        synchronized (object) {
            if (this.waitForIntegrity != null) {
                waitFor = this.waitForIntegrity;
            }
        }
        if (waitFor != null) {
            try {
                waitFor.await();
            }
            catch (InterruptedException e) {
                Log.log((Throwable)e);
            }
        }
    }

    static interface IBufferFiller {
        public void fillBuffer(FastStringBuffer var1);
    }
}

