/*
 * Decompiled with CFR 0.152.
 */
package com.python.pydev.analysis.additionalinfo;

import com.python.pydev.analysis.additionalinfo.AttrInfo;
import com.python.pydev.analysis.additionalinfo.ClassInfo;
import com.python.pydev.analysis.additionalinfo.FuncInfo;
import com.python.pydev.analysis.additionalinfo.TreeIO;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import org.eclipse.jface.text.IDocument;
import org.python.pydev.ast.codecompletion.revisited.PyPublicTreeMap;
import org.python.pydev.core.FileUtilsFileBuffer;
import org.python.pydev.core.IInfo;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.MisconfigurationException;
import org.python.pydev.core.ModulesKey;
import org.python.pydev.core.ModulesKeyForFolder;
import org.python.pydev.core.ModulesKeyForZip;
import org.python.pydev.core.ObjectsInternPool;
import org.python.pydev.core.log.Log;
import org.python.pydev.core.logging.DebugSettings;
import org.python.pydev.parser.fastparser.FastDefinitionsParser;
import org.python.pydev.parser.jython.SimpleNode;
import org.python.pydev.parser.jython.ast.ClassDef;
import org.python.pydev.parser.jython.ast.FunctionDef;
import org.python.pydev.parser.jython.ast.NameTok;
import org.python.pydev.parser.jython.ast.VisitorIF;
import org.python.pydev.parser.visitors.NodeUtils;
import org.python.pydev.parser.visitors.scope.ASTEntry;
import org.python.pydev.parser.visitors.scope.DefinitionsASTIteratorVisitor;
import org.python.pydev.shared_core.log.ToLogFile;
import org.python.pydev.shared_core.string.FastStringBuffer;
import org.python.pydev.shared_core.string.FullRepIterable;
import org.python.pydev.shared_core.string.StringUtils;
import org.python.pydev.shared_core.structure.FastStack;
import org.python.pydev.shared_core.structure.Tuple;
import org.python.pydev.shared_core.structure.Tuple3;

public abstract class AbstractAdditionalTokensInfo {
    public static final int NUMBER_OF_INITIALS_TO_INDEX = 3;
    private static final boolean DEBUG_ADDITIONAL_INFO = false;
    public static final int TOP_LEVEL = 1;
    public static final int INNER = 2;
    protected SortedMap<String, Set<IInfo>> topLevelInitialsToInfo = new PyPublicTreeMap();
    protected SortedMap<String, Set<IInfo>> innerInitialsToInfo = new PyPublicTreeMap();
    protected Object lock = new Object();
    private final Filter equalsFilter = new Filter(){

        @Override
        public boolean doCompare(String qualifier, IInfo info) {
            return info.getName().equals(qualifier);
        }

        @Override
        public boolean doCompare(String qualifier, String infoName) {
            return infoName.equals(qualifier);
        }
    };
    private final Filter startingWithFilter = new Filter(){

        @Override
        public boolean doCompare(String lowerCaseQual, IInfo info) {
            return this.doCompare(lowerCaseQual, info.getName());
        }

        @Override
        public boolean doCompare(String qualifier, String infoName) {
            return infoName.toLowerCase().startsWith(qualifier);
        }
    };
    protected static final int version = 5;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearAllInfo() {
        Object object = this.lock;
        synchronized (object) {
            if (this.topLevelInitialsToInfo != null) {
                this.topLevelInitialsToInfo.clear();
            }
            if (this.innerInitialsToInfo != null) {
                this.innerInitialsToInfo.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void add(IInfo info, int doOn) {
        Object object = this.lock;
        synchronized (object) {
            SortedMap<String, Set<IInfo>> initialsToInfo;
            String name = info.getName();
            String initials = this.getInitials(name);
            if (doOn == 1) {
                if (info.getPath() != null && info.getPath().length() > 0) {
                    throw new RuntimeException("Error: the info being added is added as an 'top level' info, but has path. Info:" + info);
                }
                initialsToInfo = this.topLevelInitialsToInfo;
            } else if (doOn == 2) {
                if (info.getPath() == null || info.getPath().length() == 0) {
                    throw new RuntimeException("Error: the info being added is added as an 'inner' info, but does not have a path. Info: " + info);
                }
                initialsToInfo = this.innerInitialsToInfo;
            } else {
                throw new RuntimeException("List to add is invalid: " + doOn);
            }
            Set<IInfo> listForInitials = this.getAndCreateListForInitials(initials, initialsToInfo);
            listForInitials.add(info);
        }
    }

    protected String getInitials(String name) {
        if (name.length() < 3) {
            return name;
        }
        return name.substring(0, 3).toLowerCase();
    }

    protected Set<IInfo> getAndCreateListForInitials(String initials, SortedMap<String, Set<IInfo>> initialsToInfo) {
        HashSet lInfo = (HashSet)initialsToInfo.get(initials);
        if (lInfo == null) {
            lInfo = new HashSet();
            initialsToInfo.put(initials, lInfo);
        }
        return lInfo;
    }

    private IInfo addAssignTargets(ASTEntry entry, String moduleName, int doOn, String path, boolean lastIsMethod, String file) {
        String rep = NodeUtils.getFullRepresentationString((SimpleNode)entry.node);
        if (lastIsMethod) {
            List parts = StringUtils.dotSplit((String)rep);
            if (parts.size() >= 2 && ((String)parts.get(0)).equals("self")) {
                rep = (String)parts.get(1);
                AttrInfo info = new AttrInfo(ObjectsInternPool.internUnsynched((String)rep), moduleName, ObjectsInternPool.internUnsynched((String)path), false, this.getNature(), file, entry.node.beginLine, entry.node.beginColumn);
                this.add(info, doOn);
                return info;
            }
        } else {
            AttrInfo info = new AttrInfo(ObjectsInternPool.internUnsynched((String)FullRepIterable.getFirstPart((String)rep)), moduleName, ObjectsInternPool.internUnsynched((String)path), false, this.getNature(), file, entry.node.beginLine, entry.node.beginColumn);
            this.add(info, doOn);
            return info;
        }
        return null;
    }

    protected abstract IPythonNature getNature();

    public List<IInfo> addAstInfo(ModulesKey key, boolean generateDelta) throws Exception {
        int len;
        char[] charArray;
        Object doc;
        if (key instanceof ModulesKeyForFolder) {
            this.addModulesKeyForFolderToIndex(key, generateDelta);
            return new ArrayList<IInfo>(0);
        }
        boolean isZipModule = key instanceof ModulesKeyForZip;
        ModulesKeyForZip modulesKeyForZip = null;
        if (isZipModule) {
            modulesKeyForZip = (ModulesKeyForZip)key;
        }
        if ((doc = isZipModule ? FileUtilsFileBuffer.getCustomReturnFromZip((File)modulesKeyForZip.file, (String)modulesKeyForZip.zipModulePath, null) : FileUtilsFileBuffer.getCustomReturnFromFile((File)key.file, (boolean)true, null)) instanceof IDocument) {
            IDocument document = (IDocument)doc;
            charArray = document.get().toCharArray();
            len = charArray.length;
        } else if (doc instanceof FastStringBuffer) {
            FastStringBuffer fastStringBuffer = (FastStringBuffer)doc;
            charArray = fastStringBuffer.getInternalCharsArray();
            len = fastStringBuffer.length();
        } else if (doc instanceof String) {
            String str = (String)doc;
            charArray = str.toCharArray();
            len = charArray.length;
        } else if (doc instanceof char[]) {
            charArray = (char[])doc;
            len = charArray.length;
        } else {
            throw new RuntimeException("Don't know how to handle: " + doc + " -- " + doc.getClass());
        }
        SimpleNode node = FastDefinitionsParser.parse((char[])charArray, (String)key.file.getName(), (int)len, (File)key.file);
        if (node == null) {
            return null;
        }
        return this.addAstInfo(node, key, generateDelta);
    }

    protected abstract void addModulesKeyForFolderToIndex(ModulesKey var1, boolean var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<IInfo> addAstInfo(SimpleNode node, ModulesKey key, boolean generateDelta) {
        ArrayList<IInfo> createdInfos = new ArrayList<IInfo>();
        if (node == null || key.name == null) {
            return createdInfos;
        }
        try {
            Tuple<DefinitionsASTIteratorVisitor, Iterator<ASTEntry>> tup = AbstractAdditionalTokensInfo.getInnerEntriesForAST(node);
            if (DebugSettings.DEBUG_ANALYSIS_REQUESTS) {
                ToLogFile.toLogFile((Object)this, (String)("Adding ast info to: " + key.name));
            }
            try {
                Iterator entries = (Iterator)tup.o2;
                FastStack tempStack = new FastStack(10);
                Object object = this.lock;
                synchronized (object) {
                    Object object2 = ObjectsInternPool.lock;
                    synchronized (object2) {
                        String file = key.file != null ? ObjectsInternPool.internUnsynched((String)key.file.toString()) : null;
                        key.name = ObjectsInternPool.internUnsynched((String)key.name);
                        while (entries.hasNext()) {
                            Tuple<String, Boolean> pathToRoot;
                            ASTEntry entry = (ASTEntry)entries.next();
                            IInfo infoCreated = null;
                            if (entry.parent == null) {
                                NameTok name;
                                if (entry.node instanceof ClassDef) {
                                    name = (NameTok)((ClassDef)entry.node).name;
                                    ClassInfo info = new ClassInfo(ObjectsInternPool.internUnsynched((String)name.id), key.name, null, false, this.getNature(), file, name.beginLine, name.beginColumn);
                                    this.add(info, 1);
                                    infoCreated = info;
                                } else if (entry.node instanceof FunctionDef) {
                                    name = (NameTok)((FunctionDef)entry.node).name;
                                    FuncInfo info2 = new FuncInfo(ObjectsInternPool.internUnsynched((String)name.id), key.name, null, false, this.getNature(), file, name.beginLine, name.beginColumn);
                                    this.add(info2, 1);
                                    infoCreated = info2;
                                } else {
                                    infoCreated = this.addAssignTargets(entry, key.name, 1, null, false, file);
                                }
                            } else if (entry.node instanceof ClassDef || entry.node instanceof FunctionDef) {
                                pathToRoot = this.getPathToRoot(entry, false, false, (FastStack<SimpleNode>)tempStack);
                                if (pathToRoot != null && pathToRoot.o1 != null && ((String)pathToRoot.o1).length() > 0) {
                                    NameTok name;
                                    if (entry.node instanceof ClassDef) {
                                        name = (NameTok)((ClassDef)entry.node).name;
                                        ClassInfo info = new ClassInfo(ObjectsInternPool.internUnsynched((String)name.id), key.name, ObjectsInternPool.internUnsynched((String)((String)pathToRoot.o1)), false, this.getNature(), file, name.beginLine, name.beginColumn);
                                        this.add(info, 2);
                                        infoCreated = info;
                                    } else {
                                        name = (NameTok)((FunctionDef)entry.node).name;
                                        FuncInfo info2 = new FuncInfo(ObjectsInternPool.internUnsynched((String)name.id), key.name, ObjectsInternPool.internUnsynched((String)((String)pathToRoot.o1)), false, this.getNature(), file, name.beginLine, name.beginColumn);
                                        this.add(info2, 2);
                                        infoCreated = info2;
                                    }
                                }
                            } else {
                                pathToRoot = this.getPathToRoot(entry, true, false, (FastStack<SimpleNode>)tempStack);
                                if (pathToRoot != null && pathToRoot.o1 != null && ((String)pathToRoot.o1).length() > 0) {
                                    infoCreated = this.addAssignTargets(entry, key.name, 2, (String)pathToRoot.o1, (Boolean)pathToRoot.o2, file);
                                }
                            }
                            if (infoCreated == null) continue;
                            createdInfos.add(infoCreated);
                        }
                    }
                }
            }
            catch (Exception e) {
                Log.log((Throwable)e);
            }
        }
        catch (Exception e) {
            Log.log((Throwable)e);
        }
        return createdInfos;
    }

    public static Tuple<DefinitionsASTIteratorVisitor, Iterator<ASTEntry>> getInnerEntriesForAST(SimpleNode node) throws Exception {
        DefinitionsASTIteratorVisitor visitor = new DefinitionsASTIteratorVisitor();
        node.accept((VisitorIF)visitor);
        Iterator entries = visitor.getOutline();
        return new Tuple((Object)visitor, (Object)entries);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getAllModulesWithTokens() {
        HashSet<String> ret = new HashSet<String>();
        Object object = this.lock;
        synchronized (object) {
            Set<IInfo> value;
            Set<Map.Entry<String, Set<IInfo>>> entrySet = this.topLevelInitialsToInfo.entrySet();
            for (Map.Entry<String, Set<IInfo>> entry : entrySet) {
                value = entry.getValue();
                for (IInfo info : value) {
                    ret.add(info.getDeclaringModuleName());
                }
            }
            entrySet = this.innerInitialsToInfo.entrySet();
            for (Map.Entry<String, Set<IInfo>> entry : entrySet) {
                value = entry.getValue();
                for (IInfo info : value) {
                    ret.add(info.getDeclaringModuleName());
                }
            }
        }
        return ret;
    }

    private Tuple<String, Boolean> getPathToRoot(ASTEntry entry, boolean lastMayBeMethod, boolean acceptAny, FastStack<SimpleNode> tempStack) {
        if (entry.parent == null) {
            return null;
        }
        tempStack.clear();
        boolean lastIsMethod = false;
        while (entry.parent != null) {
            if (entry.parent.node instanceof ClassDef) {
                tempStack.push((Object)entry.parent.node);
            } else if (entry.parent.node instanceof FunctionDef) {
                if (!acceptAny) {
                    if (lastIsMethod) {
                        return null;
                    }
                    if (!lastMayBeMethod) {
                        return null;
                    }
                    if (tempStack.size() != 0) {
                        return null;
                    }
                }
                tempStack.push((Object)entry.parent.node);
                lastIsMethod = true;
            } else {
                return null;
            }
            entry = entry.parent;
        }
        FastStringBuffer buf = new FastStringBuffer();
        while (tempStack.size() > 0) {
            String rep = NodeUtils.getRepresentationString((SimpleNode)((SimpleNode)tempStack.pop()));
            if (rep == null) continue;
            if (buf.length() > 0) {
                buf.append(".");
            }
            buf.append(rep);
        }
        return new Tuple((Object)buf.toString(), (Object)lastIsMethod);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeInfoFromModule(String moduleName, boolean generateDelta) {
        if (DebugSettings.DEBUG_ANALYSIS_REQUESTS) {
            ToLogFile.toLogFile((Object)this, (String)("Removing ast info from: " + moduleName));
        }
        Object object = this.lock;
        synchronized (object) {
            this.removeInfoFromMap(moduleName, this.topLevelInitialsToInfo);
            this.removeInfoFromMap(moduleName, this.innerInitialsToInfo);
        }
    }

    private void removeInfoFromMap(String moduleName, SortedMap<String, Set<IInfo>> initialsToInfo) {
        Iterator<Set<IInfo>> itListOfInfo = initialsToInfo.values().iterator();
        while (itListOfInfo.hasNext()) {
            Iterator<IInfo> it = itListOfInfo.next().iterator();
            while (it.hasNext()) {
                IInfo info = it.next();
                if (info == null || info.getDeclaringModuleName() == null || !info.getDeclaringModuleName().equals(moduleName)) continue;
                it.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<IInfo> getTokensStartingWith(String qualifier, int getWhat) {
        Object object = this.lock;
        synchronized (object) {
            return this.getWithFilter(qualifier, getWhat, this.startingWithFilter, true, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<IInfo> getTokensStartingWith(String qualifier, int getWhat, Collection<IInfo> result) {
        Object object = this.lock;
        synchronized (object) {
            return this.getWithFilter(qualifier, getWhat, this.startingWithFilter, true, result);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<IInfo> getTokensEqualTo(String qualifier, int getWhat) {
        Object object = this.lock;
        synchronized (object) {
            return this.getWithFilter(qualifier, getWhat, this.equalsFilter, false, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<IInfo> getTokensEqualTo(String qualifier, int getWhat, Collection<IInfo> result) {
        Object object = this.lock;
        synchronized (object) {
            return this.getWithFilter(qualifier, getWhat, this.equalsFilter, false, result);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Collection<IInfo> getWithFilter(String qualifier, int getWhat, Filter filter, boolean useLowerCaseQual, Collection<IInfo> result) {
        Object object = this.lock;
        synchronized (object) {
            if (result == null) {
                result = new ArrayList<IInfo>();
            }
            if ((getWhat & 1) != 0) {
                this.getWithFilter(qualifier, this.topLevelInitialsToInfo, result, filter, useLowerCaseQual);
            }
            if ((getWhat & 2) != 0) {
                this.getWithFilter(qualifier, this.innerInitialsToInfo, result, filter, useLowerCaseQual);
            }
            return result;
        }
    }

    protected void getWithFilter(String qualifier, SortedMap<String, Set<IInfo>> initialsToInfo, Collection<IInfo> toks, Filter filter, boolean useLowerCaseQual) {
        String initials = this.getInitials(qualifier);
        String qualToCompare = qualifier;
        if (useLowerCaseQual) {
            qualToCompare = qualifier.toLowerCase();
        }
        SortedMap<String, Set<IInfo>> subMap = initialsToInfo.subMap(initials, String.valueOf(initials) + "\uffff\uffff\uffff\uffff");
        for (Set<IInfo> listForInitials : subMap.values()) {
            for (IInfo info : listForInitials) {
                if (!filter.doCompare(qualToCompare, info)) continue;
                toks.add(info);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<IInfo> getAllTokens() {
        Object object = this.lock;
        synchronized (object) {
            Collection<Set<IInfo>> lInfo = this.topLevelInitialsToInfo.values();
            ArrayList<IInfo> toks = new ArrayList<IInfo>();
            for (Set<IInfo> list : lInfo) {
                for (IInfo info : list) {
                    toks.add(info);
                }
            }
            lInfo = this.innerInitialsToInfo.values();
            for (Set<IInfo> list : lInfo) {
                for (IInfo info : list) {
                    toks.add(info);
                }
            }
            return toks;
        }
    }

    public void save() {
        File persistingLocation;
        try {
            persistingLocation = this.getPersistingLocation();
        }
        catch (MisconfigurationException e) {
            Log.log((String)"Error. Unable to get persisting location for additional interprer info. Configuration may be corrupted.", (Throwable)e);
            return;
        }
        this.save(persistingLocation);
    }

    protected void save(File persistingLocation) {
        try {
            FileOutputStream stream = new FileOutputStream(persistingLocation);
            OutputStreamWriter writer = new OutputStreamWriter(stream);
            try {
                FastStringBuffer tempBuf = new FastStringBuffer();
                tempBuf.append("-- VERSION_");
                tempBuf.append(5);
                tempBuf.append('\n');
                writer.write(tempBuf.getInternalCharsArray(), 0, tempBuf.length());
                tempBuf.clear();
                this.saveTo(writer, tempBuf, persistingLocation);
            }
            finally {
                try {
                    writer.close();
                }
                finally {
                    stream.close();
                }
            }
        }
        catch (Exception e) {
            Log.log((Throwable)e);
        }
    }

    protected abstract File getPersistingLocation() throws MisconfigurationException;

    protected abstract File getPersistingFolder();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveTo(OutputStreamWriter writer, FastStringBuffer tempBuf, File pathToSave) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            HashMap<String, Integer> dictionary = new HashMap<String, Integer>();
            tempBuf.append("-- START TREE 1\n");
            TreeIO.dumpTreeToBuffer(this.topLevelInitialsToInfo, tempBuf, dictionary);
            tempBuf.append("-- START TREE 2\n");
            TreeIO.dumpTreeToBuffer(this.innerInitialsToInfo, tempBuf, dictionary);
            FastStringBuffer buf2 = new FastStringBuffer(50 * (dictionary.size() + 4));
            TreeIO.dumpDictToBuffer(dictionary, buf2);
            writer.write(buf2.getInternalCharsArray(), 0, buf2.length());
            buf2 = null;
            writer.write(tempBuf.getInternalCharsArray(), 0, tempBuf.length());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void restoreSavedInfo(Object o) throws MisconfigurationException {
        Object object = this.lock;
        synchronized (object) {
            Tuple3 readFromFile = (Tuple3)o;
            SortedMap o1 = (SortedMap)readFromFile.o1;
            SortedMap o2 = (SortedMap)readFromFile.o2;
            if (o1 == null) {
                throw new RuntimeException("Error in I/O (topLevelInitialsToInfo is null). Rebuilding internal info.");
            }
            if (o2 == null) {
                throw new RuntimeException("Error in I/O (innerInitialsToInfo is null). Rebuilding internal info.");
            }
            this.topLevelInitialsToInfo = o1;
            this.innerInitialsToInfo = o2;
            if (readFromFile.o3 != null && 5 != (Integer)readFromFile.o3) {
                throw new RuntimeException("I/O version doesn't match. Rebuilding internal info.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        Object object = this.lock;
        synchronized (object) {
            FastStringBuffer buffer = new FastStringBuffer();
            buffer.append("AdditionalInfo{");
            buffer.append("topLevel=[");
            this.entrySetToString(buffer, this.topLevelInitialsToInfo.entrySet());
            buffer.append("]\n");
            buffer.append("inner=[");
            this.entrySetToString(buffer, this.innerInitialsToInfo.entrySet());
            buffer.append("]");
            buffer.append("}");
            return buffer.toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void entrySetToString(FastStringBuffer buffer, Set<Map.Entry<String, Set<IInfo>>> name) {
        Object object = this.lock;
        synchronized (object) {
            for (Map.Entry<String, Set<IInfo>> entry : name) {
                Set<IInfo> value = entry.getValue();
                for (IInfo info : value) {
                    buffer.append(info.toString());
                    buffer.append("\n");
                }
            }
        }
    }

    public static interface Filter {
        public boolean doCompare(String var1, IInfo var2);

        public boolean doCompare(String var1, String var2);
    }
}

