/*
 * Decompiled with CFR 0.152.
 */
package com.python.pydev.analysis.additionalinfo;

import com.python.pydev.analysis.AnalysisPlugin;
import com.python.pydev.analysis.additionalinfo.AbstractAdditionalDependencyInfo;
import com.python.pydev.analysis.additionalinfo.AbstractAdditionalInfoWithBuild;
import com.python.pydev.analysis.additionalinfo.AbstractAdditionalTokensInfo;
import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.python.pydev.ast.interpreter_managers.InterpreterInfo;
import org.python.pydev.core.IInterpreterInfo;
import org.python.pydev.core.IInterpreterManager;
import org.python.pydev.core.IModulesManager;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.ISystemModulesManager;
import org.python.pydev.core.MisconfigurationException;
import org.python.pydev.core.docutils.PyStringUtils;
import org.python.pydev.core.log.Log;
import org.python.pydev.plugin.nature.SystemPythonNature;
import org.python.pydev.shared_core.global_feedback.GlobalFeedback;
import org.python.pydev.shared_core.structure.Tuple;

public class AdditionalSystemInterpreterInfo
extends AbstractAdditionalInfoWithBuild {
    private final IInterpreterManager manager;
    private final String additionalInfoInterpreter;
    private static final Map<Tuple<String, String>, AbstractAdditionalTokensInfo> additionalSystemInfo = new HashMap<Tuple<String, String>, AbstractAdditionalTokensInfo>();
    private static final Object additionalSystemInfoLock = new Object();
    private final File persistingFolder;
    private final File persistingLocation;
    private IPythonNature nature;

    public IInterpreterManager getManager() {
        return this.manager;
    }

    public String getAdditionalInfoInterpreter() {
        return this.additionalInfoInterpreter;
    }

    @Override
    protected String getUIRepresentation() {
        return this.manager != null ? this.manager.getManagerRelatedName() : "Unknown manager";
    }

    @Override
    protected IPythonNature getNature() {
        return this.nature;
    }

    @Override
    protected File getPersistingFolder() {
        return this.persistingFolder;
    }

    @Override
    protected File getPersistingLocation() throws MisconfigurationException {
        return this.persistingLocation;
    }

    @Override
    protected Set<String> getPythonPathFolders() {
        HashSet<String> ret = new HashSet<String>();
        try {
            IInterpreterInfo interpreterInfo = this.manager.getInterpreterInfo(this.additionalInfoInterpreter, (IProgressMonitor)new NullProgressMonitor());
            ret.addAll(interpreterInfo.getPythonPath());
        }
        catch (MisconfigurationException e) {
            Log.log((Throwable)e);
        }
        return ret;
    }

    public AdditionalSystemInterpreterInfo(IInterpreterManager manager, String interpreter) throws MisconfigurationException {
        super(false);
        File base;
        this.manager = manager;
        this.additionalInfoInterpreter = interpreter;
        try {
            this.nature = manager != null ? new SystemPythonNature(manager) : null;
        }
        catch (MisconfigurationException e) {
            Log.log((Throwable)e);
        }
        try {
            IPath stateLocation = AnalysisPlugin.stateLocation;
            base = stateLocation.toFile();
        }
        catch (Exception e) {
            Log.logInfo((String)"Error getting persisting folder", (Throwable)e);
            base = new File(".");
        }
        File file = new File(base, String.valueOf(manager.getManagerRelatedName()) + "_" + PyStringUtils.getExeAsFileSystemValidPath((String)this.additionalInfoInterpreter));
        try {
            if (!file.exists()) {
                file.mkdirs();
            }
        }
        catch (Exception e) {
            Log.log((Throwable)e);
        }
        this.persistingFolder = file;
        this.persistingLocation = new File(this.persistingFolder, String.valueOf(manager.getManagerRelatedName()) + ".pydevsysteminfo");
        this.init();
    }

    public static AbstractAdditionalDependencyInfo getAdditionalSystemInfo(IInterpreterManager manager, String interpreter) throws MisconfigurationException {
        return AdditionalSystemInterpreterInfo.getAdditionalSystemInfo(manager, interpreter, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setAdditionalSystemInfo(IInterpreterManager manager, String executableOrJar, AdditionalSystemInterpreterInfo additionalInfo) {
        Object object = additionalSystemInfoLock;
        synchronized (object) {
            Tuple key = new Tuple((Object)manager.getManagerRelatedName(), (Object)executableOrJar);
            additionalSystemInfo.put((Tuple<String, String>)key, additionalInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AbstractAdditionalDependencyInfo getAdditionalSystemInfo(IInterpreterManager manager, String interpreter, boolean errorIfNotAvailable) throws MisconfigurationException {
        Tuple key = new Tuple((Object)manager.getManagerRelatedName(), (Object)interpreter);
        Object object = additionalSystemInfoLock;
        synchronized (object) {
            AbstractAdditionalDependencyInfo info = (AbstractAdditionalDependencyInfo)additionalSystemInfo.get(key);
            if (info == null) {
                info = new AdditionalSystemInterpreterInfo(manager, interpreter);
                additionalSystemInfo.put((Tuple<String, String>)key, info);
                if (!info.load()) {
                    try {
                        AdditionalSystemInterpreterInfo.recreateAllInfo(manager, interpreter, (IProgressMonitor)new NullProgressMonitor());
                        info = (AbstractAdditionalDependencyInfo)additionalSystemInfo.get(key);
                    }
                    catch (Exception e) {
                        Log.log((Throwable)e);
                    }
                }
            }
            return info;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void recreateAllInfo(IInterpreterManager manager, String interpreter, IProgressMonitor monitor) {
        Object object = additionalSystemInfoLock;
        synchronized (object) {
            try {
                Throwable throwable = null;
                Object var5_7 = null;
                try (GlobalFeedback.GlobalFeedbackReporter r = GlobalFeedback.start((String)"Full system reindex...");){
                    InterpreterInfo defaultInterpreterInfo;
                    ISystemModulesManager m;
                    AbstractAdditionalTokensInfo info;
                    IInterpreterInfo interpreterInfo = manager.getInterpreterInfo(interpreter, monitor);
                    int grammarVersion = interpreterInfo.getGrammarVersion();
                    AbstractAdditionalDependencyInfo currInfo = AdditionalSystemInterpreterInfo.getAdditionalSystemInfo(manager, interpreter);
                    if (currInfo != null) {
                        ((AbstractAdditionalTokensInfo)currInfo).clearAllInfo();
                    }
                    if ((info = AdditionalSystemInterpreterInfo.restoreInfoForModuleManager(monitor, (IModulesManager)(m = (defaultInterpreterInfo = (InterpreterInfo)manager.getInterpreterInfo(interpreter, monitor)).getModulesManager()), "(system: " + manager.getManagerRelatedName() + " - " + interpreter + ")", new AdditionalSystemInterpreterInfo(manager, interpreter), null, grammarVersion)) != null) {
                        additionalSystemInfo.put((Tuple<String, String>)new Tuple((Object)manager.getManagerRelatedName(), (Object)interpreter), info);
                        info.save();
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Throwable e) {
                Log.log((Throwable)e);
            }
        }
    }

    public int hashCode() {
        return this.additionalInfoInterpreter.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AdditionalSystemInterpreterInfo)) {
            return false;
        }
        AdditionalSystemInterpreterInfo additionalSystemInterpreterInfo = (AdditionalSystemInterpreterInfo)obj;
        return this.additionalInfoInterpreter.equals(additionalSystemInterpreterInfo.additionalInfoInterpreter);
    }
}

