/*
 * Decompiled with CFR 0.152.
 */
package com.python.pydev.analysis.additionalinfo.builders;

import com.python.pydev.analysis.AnalysisPreferences;
import com.python.pydev.analysis.OccurrencesAnalyzer;
import com.python.pydev.analysis.additionalinfo.AbstractAdditionalDependencyInfo;
import com.python.pydev.analysis.additionalinfo.AbstractAdditionalTokensInfo;
import com.python.pydev.analysis.additionalinfo.AdditionalProjectInterpreterInfo;
import com.python.pydev.analysis.additionalinfo.builders.AbstractAnalysisBuilderRunnable;
import com.python.pydev.analysis.additionalinfo.builders.AnalysisBuilderRunnableFactory;
import com.python.pydev.analysis.additionalinfo.builders.AnalysisBuilderRunnableForRemove;
import com.python.pydev.analysis.additionalinfo.builders.AnalysisRunner;
import com.python.pydev.analysis.additionalinfo.builders.IAnalysisBuilderRunnable;
import com.python.pydev.analysis.additionalinfo.builders.KeyForAnalysisRunnable;
import com.python.pydev.analysis.external.IExternalCodeAnalysisVisitor;
import com.python.pydev.analysis.flake8.Flake8Visitor;
import com.python.pydev.analysis.flake8.Flake8VisitorFactory;
import com.python.pydev.analysis.flake8.OnlyRemoveMarkersFlake8Visitor;
import com.python.pydev.analysis.mypy.MypyVisitor;
import com.python.pydev.analysis.mypy.MypyVisitorFactory;
import com.python.pydev.analysis.mypy.OnlyRemoveMarkersMypyVisitor;
import com.python.pydev.analysis.pylint.OnlyRemoveMarkersPyLintVisitor;
import com.python.pydev.analysis.pylint.PyLintVisitor;
import com.python.pydev.analysis.pylint.PyLintVisitorFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jface.text.IDocument;
import org.python.pydev.ast.analysis.messages.IMessage;
import org.python.pydev.ast.builder.PyDevBuilderVisitor;
import org.python.pydev.ast.codecompletion.revisited.modules.SourceModule;
import org.python.pydev.core.CheckAnalysisErrors;
import org.python.pydev.core.IModule;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.MisconfigurationException;
import org.python.pydev.core.autoedit.DefaultIndentPrefs;
import org.python.pydev.core.editor.OpenEditors;
import org.python.pydev.core.log.Log;
import org.python.pydev.core.logging.DebugSettings;
import org.python.pydev.parser.preferences.PyDevBuilderPreferences;
import org.python.pydev.shared_core.callbacks.ICallback;
import org.python.pydev.shared_core.log.ToLogFile;
import org.python.pydev.shared_core.markers.PyMarkerUtils;
import org.python.pydev.shared_core.resources.DocumentChanged;

public class AnalysisBuilderRunnable
extends AbstractAnalysisBuilderRunnable {
    public static final List<ICallback<Object, IResource>> analysisBuilderListeners = new ArrayList<ICallback<Object, IResource>>();
    private IDocument document;
    private IResource resource;
    private ICallback<IModule, Integer> module;
    private int moduleRequest;
    private IExternalCodeAnalysisVisitor pyLintVisitor;
    private IExternalCodeAnalysisVisitor mypyVisitor;
    private IExternalCodeAnalysisVisitor flake8Visitor;
    private boolean onlyRecreateCtxInsensitiveInfo;
    private IExternalCodeAnalysisVisitor[] allVisitors;
    private static boolean useEclipse32DerivedVersion = false;

    private static boolean isHierarchicallyDerived(IResource curr) {
        if (useEclipse32DerivedVersion) {
            do {
                if (!curr.isDerived()) continue;
                return true;
            } while ((curr = curr.getParent()) != null);
            return false;
        }
        try {
            return curr.isDerived(512);
        }
        catch (Throwable e) {
            useEclipse32DerivedVersion = true;
            return AnalysisBuilderRunnable.isHierarchicallyDerived(curr);
        }
    }

    AnalysisBuilderRunnable(IDocument document, IResource resource, ICallback<IModule, Integer> module, boolean isFullBuild, String moduleName, boolean forceAnalysis, int analysisCause, IAnalysisBuilderRunnable oldAnalysisBuilderThread, IPythonNature nature, long documentTime, KeyForAnalysisRunnable key, long resourceModificationStamp, List<IExternalCodeAnalysisVisitor> externalVisitors) {
        super(isFullBuild, moduleName, forceAnalysis, analysisCause, oldAnalysisBuilderThread, nature, documentTime, key, resourceModificationStamp);
        if (resource == null) {
            ToLogFile.toLogFile((Object)this, (String)("Unexpected null resource for: " + moduleName));
            return;
        }
        this.document = document;
        this.resource = resource;
        this.module = module;
        if (externalVisitors.size() > 0) {
            IExternalCodeAnalysisVisitor[] iExternalCodeAnalysisVisitorArray = this.allVisitors = externalVisitors.toArray(new IExternalCodeAnalysisVisitor[0]);
            int n = this.allVisitors.length;
            int n2 = 0;
            while (n2 < n) {
                IExternalCodeAnalysisVisitor visitor = iExternalCodeAnalysisVisitorArray[n2];
                if (visitor instanceof OnlyRemoveMarkersPyLintVisitor || visitor instanceof PyLintVisitor) {
                    this.pyLintVisitor = visitor;
                } else if (visitor instanceof OnlyRemoveMarkersMypyVisitor || visitor instanceof MypyVisitor) {
                    this.mypyVisitor = visitor;
                } else if (visitor instanceof OnlyRemoveMarkersFlake8Visitor || visitor instanceof Flake8Visitor) {
                    this.flake8Visitor = visitor;
                }
                ++n2;
            }
            if (this.pyLintVisitor == null || this.mypyVisitor == null || this.flake8Visitor == null) {
                throw new AssertionError((Object)"All visitor types must be passed.");
            }
        } else {
            this.pyLintVisitor = PyLintVisitorFactory.create(resource, document, module, this.internalCancelMonitor);
            this.mypyVisitor = MypyVisitorFactory.create(resource, document, module, this.internalCancelMonitor);
            this.flake8Visitor = Flake8VisitorFactory.create(resource, document, module, this.internalCancelMonitor);
            this.allVisitors = new IExternalCodeAnalysisVisitor[]{this.pyLintVisitor, this.mypyVisitor, this.flake8Visitor};
        }
        boolean updateIndex = analysisCause == 1;
        try {
            AbstractAdditionalDependencyInfo info;
            boolean bl = this.onlyRecreateCtxInsensitiveInfo = !forceAnalysis && analysisCause == 1 && PyDevBuilderPreferences.getAnalyzeOnlyActiveEditor();
            if (!this.onlyRecreateCtxInsensitiveInfo && !nature.isResourceInPythonpathProjectSources(resource, false)) {
                this.onlyRecreateCtxInsensitiveInfo = true;
            }
            if ((info = AdditionalProjectInterpreterInfo.getAdditionalInfoForProject(nature)) == null) {
                Log.log((String)("Unable to get additional info for: " + resource + " -- " + moduleName));
                return;
            }
            if (!isFullBuild && updateIndex) {
                AnalysisBuilderRunnableForRemove.removeInfoForModule(moduleName, nature, isFullBuild);
            }
            this.moduleRequest = this.onlyRecreateCtxInsensitiveInfo ? 2 : 1;
            if (updateIndex) {
                this.recreateCtxInsensitiveInfo(info, (SourceModule)this.module.call((Object)this.moduleRequest), nature, resource);
            }
        }
        catch (CoreException | MisconfigurationException e) {
            Log.log((Throwable)e);
        }
    }

    @Override
    protected void dispose() {
        super.dispose();
        this.document = null;
        this.resource = null;
        this.module = null;
    }

    @Override
    protected void doAnalysis() {
        if (!this.nature.startRequests()) {
            return;
        }
        try {
            int n;
            IExternalCodeAnalysisVisitor[] iExternalCodeAnalysisVisitorArray;
            IResource r;
            if (DebugSettings.DEBUG_ANALYSIS_REQUESTS) {
                ToLogFile.toLogFile((Object)this, (String)("doAnalysis() - " + this.moduleName + " " + this.getAnalysisCauseStr()));
            }
            if ((r = this.resource) == null) {
                ToLogFile.toLogFile((Object)this, (String)("Finished analysis -- resource null -- " + this.moduleName));
                return;
            }
            if (!r.getProject().isOpen()) {
                ToLogFile.toLogFile((Object)this, (String)("Finished analysis -- project closed -- " + this.moduleName));
                return;
            }
            AnalysisRunner runner = new AnalysisRunner();
            this.checkStop();
            AnalysisPreferences analysisPreferences = new AnalysisPreferences((IAdaptable)r);
            boolean makeAnalysis = runner.canDoAnalysis(this.document) && PyDevBuilderVisitor.isInPythonPath((IResource)r) && analysisPreferences.makeCodeAnalysis();
            boolean anotherVisitorRequiresAnalysis = false;
            IExternalCodeAnalysisVisitor[] iExternalCodeAnalysisVisitorArray2 = this.allVisitors;
            int n2 = this.allVisitors.length;
            int n3 = 0;
            while (n3 < n2) {
                IExternalCodeAnalysisVisitor visitor = iExternalCodeAnalysisVisitorArray2[n3];
                anotherVisitorRequiresAnalysis |= visitor.getRequiresAnalysis();
                ++n3;
            }
            if (!makeAnalysis) {
                if (DebugSettings.DEBUG_ANALYSIS_REQUESTS) {
                    ToLogFile.toLogFile((Object)this, (String)("Skipping: !makeAnalysis -- " + this.moduleName));
                }
                if (!anotherVisitorRequiresAnalysis) {
                    AnalysisRunner.deleteMarkers(r);
                    return;
                }
                boolean onlyPydevAnalysisMarkers = true;
                AnalysisRunner.deleteMarkers(r, onlyPydevAnalysisMarkers);
            }
            if (makeAnalysis && this.onlyRecreateCtxInsensitiveInfo) {
                if (DebugSettings.DEBUG_ANALYSIS_REQUESTS) {
                    ToLogFile.toLogFile((Object)this, (String)("Skipping: !forceAnalysis && analysisCause == ANALYSIS_CAUSE_BUILDER && PyDevBuilderPrefPage.getAnalyzeOnlyActiveEditor() -- " + this.moduleName));
                }
                return;
            }
            if (this.nature == null) {
                Log.log((String)("Finished analysis: null nature -- " + this.moduleName));
                return;
            }
            AbstractAdditionalDependencyInfo info = AdditionalProjectInterpreterInfo.getAdditionalInfoForProject(this.nature);
            if (info == null) {
                Log.log((String)("Unable to get additional info for: " + r + " -- " + this.moduleName));
                return;
            }
            if (makeAnalysis && DebugSettings.DEBUG_ANALYSIS_REQUESTS) {
                ToLogFile.toLogFile((Object)this, (String)("makeAnalysis:" + makeAnalysis + " " + "analysisCause: " + this.getAnalysisCauseStr() + " -- " + this.moduleName));
            }
            this.checkStop();
            if (AnalysisBuilderRunnable.isHierarchicallyDerived(r)) {
                if (DebugSettings.DEBUG_ANALYSIS_REQUESTS) {
                    ToLogFile.toLogFile((Object)this, (String)("Resource marked as derived not analyzed: " + r + " -- " + this.moduleName));
                }
                if (r != null) {
                    AnalysisRunner.deleteMarkers(r);
                }
                return;
            }
            if (!DocumentChanged.hasDocumentChanged((IResource)this.resource, (IDocument)this.document)) {
                iExternalCodeAnalysisVisitorArray = this.allVisitors;
                n = this.allVisitors.length;
                n2 = 0;
                while (n2 < n) {
                    IExternalCodeAnalysisVisitor visitor = iExternalCodeAnalysisVisitorArray[n2];
                    visitor.startVisit();
                    ++n2;
                }
            } else {
                iExternalCodeAnalysisVisitorArray = this.allVisitors;
                n = this.allVisitors.length;
                n2 = 0;
                while (n2 < n) {
                    IExternalCodeAnalysisVisitor visitor = iExternalCodeAnalysisVisitorArray[n2];
                    visitor.deleteMarkers();
                    ++n2;
                }
                if (!makeAnalysis) {
                    return;
                }
            }
            try {
                List<PyMarkerUtils.MarkerInfo> markersFromCodeAnalysis = null;
                if (makeAnalysis) {
                    OccurrencesAnalyzer analyzer = new OccurrencesAnalyzer();
                    this.checkStop();
                    SourceModule module = (SourceModule)this.module.call((Object)this.moduleRequest);
                    IMessage[] messages = analyzer.analyzeDocument(this.nature, module, analysisPreferences, this.document, this.internalCancelMonitor, DefaultIndentPrefs.get((IAdaptable)this.resource));
                    this.checkStop();
                    if (DebugSettings.DEBUG_ANALYSIS_REQUESTS) {
                        ToLogFile.toLogFile((Object)this, (String)("Adding markers for module: " + this.moduleName));
                    }
                    this.checkStop();
                    if (r != null) {
                        boolean analyzeOnlyActiveEditor = PyDevBuilderPreferences.getAnalyzeOnlyActiveEditor();
                        if (this.forceAnalysis || !analyzeOnlyActiveEditor || analyzeOnlyActiveEditor && (!PyDevBuilderPreferences.getRemoveErrorsWhenEditorIsClosed() || OpenEditors.isEditorOpenForResource((IResource)r))) {
                            markersFromCodeAnalysis = runner.setMarkers(r, this.document, messages, this.internalCancelMonitor);
                        } else if (DebugSettings.DEBUG_ANALYSIS_REQUESTS) {
                            ToLogFile.toLogFile((Object)this, (String)("Skipped adding markers for module: " + this.moduleName + " (editor not opened)."));
                        }
                    }
                }
                for (ICallback<Object, IResource> callback : analysisBuilderListeners) {
                    try {
                        callback.call((Object)r);
                    }
                    catch (Exception e) {
                        Log.log((Throwable)e);
                    }
                }
                this.checkStop();
                IExternalCodeAnalysisVisitor[] iExternalCodeAnalysisVisitorArray3 = this.allVisitors;
                int n4 = this.allVisitors.length;
                int n5 = 0;
                while (n5 < n4) {
                    IExternalCodeAnalysisVisitor visitor = iExternalCodeAnalysisVisitorArray3[n5];
                    visitor.join();
                    ++n5;
                }
                this.checkStop();
                if (r != null) {
                    iExternalCodeAnalysisVisitorArray3 = this.allVisitors;
                    n4 = this.allVisitors.length;
                    n5 = 0;
                    while (n5 < n4) {
                        IExternalCodeAnalysisVisitor visitor = iExternalCodeAnalysisVisitorArray3[n5];
                        String problemMarker = visitor.getProblemMarkerId();
                        String messageId = visitor.getMessageId();
                        List<PyMarkerUtils.MarkerInfo> markersFromVisitor = visitor.getMarkers(this.resource);
                        if (markersFromVisitor != null && markersFromVisitor.size() > 0) {
                            HashMap<Integer, ArrayList<PyMarkerUtils.MarkerInfo>> lineToMarkerInfo = new HashMap<Integer, ArrayList<PyMarkerUtils.MarkerInfo>>();
                            if (markersFromCodeAnalysis != null) {
                                for (PyMarkerUtils.MarkerInfo codeAnalysisMarkerInfo : markersFromCodeAnalysis) {
                                    ArrayList<PyMarkerUtils.MarkerInfo> list = (ArrayList<PyMarkerUtils.MarkerInfo>)lineToMarkerInfo.get(codeAnalysisMarkerInfo.lineStart);
                                    if (list == null) {
                                        list = new ArrayList<PyMarkerUtils.MarkerInfo>(2);
                                        lineToMarkerInfo.put(codeAnalysisMarkerInfo.lineStart, list);
                                    }
                                    list.add(codeAnalysisMarkerInfo);
                                }
                            }
                            if (visitor == this.pyLintVisitor) {
                                Iterator<PyMarkerUtils.MarkerInfo> visitorMarkerInfoIterator = markersFromVisitor.iterator();
                                block72: while (visitorMarkerInfoIterator.hasNext()) {
                                    PyMarkerUtils.MarkerInfo visitorMarkerInfo = visitorMarkerInfoIterator.next();
                                    List codeAnalysisMarkers = (List)lineToMarkerInfo.get(visitorMarkerInfo.lineStart);
                                    if (codeAnalysisMarkers == null || codeAnalysisMarkers.size() <= 0) continue;
                                    for (PyMarkerUtils.MarkerInfo codeAnalysisMarker : codeAnalysisMarkers) {
                                        String pyLintMessageId;
                                        Object analysisType;
                                        Map additionalInfo;
                                        if (codeAnalysisMarker.severity < 0 || (additionalInfo = codeAnalysisMarker.additionalInfo) == null || (analysisType = additionalInfo.get("PYDEV_TYPE")) == null || !(analysisType instanceof Integer) || (pyLintMessageId = CheckAnalysisErrors.getPyLintMessageIdForPyDevAnalysisType((int)((Integer)analysisType))) == null || !pyLintMessageId.equals(visitorMarkerInfo.additionalInfo.get(messageId))) continue;
                                        visitorMarkerInfoIterator.remove();
                                        continue block72;
                                    }
                                }
                            }
                            PyMarkerUtils.replaceMarkers(markersFromVisitor, (IResource)this.resource, (String)problemMarker, (boolean)true, (IProgressMonitor)this.internalCancelMonitor);
                        } else {
                            visitor.deleteMarkers();
                        }
                        ++n5;
                    }
                }
            }
            catch (OperationCanceledException e) {
                this.logOperationCancelled();
            }
            catch (Exception e) {
                Log.log((Throwable)e);
            }
        }
        finally {
            try {
                this.nature.endRequests();
            }
            catch (Throwable e) {
                Log.log((String)("Error when analyzing: " + this.moduleName), (Throwable)e);
            }
            try {
                AnalysisBuilderRunnableFactory.removeFromThreads(this.key, this);
            }
            catch (Throwable e) {
                Log.log((Throwable)e);
            }
            this.dispose();
        }
    }

    private void recreateCtxInsensitiveInfo(AbstractAdditionalTokensInfo info, SourceModule sourceModule, IPythonNature nature, IResource r) {
        boolean generateDelta = !this.isFullBuild;
        info.addAstInfo(sourceModule.getAst(), sourceModule.getModulesKey(), generateDelta);
    }
}

