/*
 * Decompiled with CFR 0.152.
 */
package com.python.pydev.analysis.additionalinfo.builders;

import com.python.pydev.analysis.additionalinfo.AbstractAdditionalDependencyInfo;
import com.python.pydev.analysis.additionalinfo.AdditionalProjectInterpreterInfo;
import com.python.pydev.analysis.additionalinfo.builders.AnalysisBuilderRunnableFactory;
import com.python.pydev.analysis.additionalinfo.builders.IAnalysisBuilderRunnable;
import com.python.pydev.analysis.external.IExternalCodeAnalysisVisitor;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.IDocument;
import org.python.pydev.ast.builder.PyDevBuilderVisitor;
import org.python.pydev.ast.codecompletion.revisited.modules.SourceModule;
import org.python.pydev.core.IModule;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.MisconfigurationException;
import org.python.pydev.core.concurrency.IRunnableWithMonitor;
import org.python.pydev.core.concurrency.RunnableAsJobsPoolThread;
import org.python.pydev.core.log.Log;
import org.python.pydev.core.logging.DebugSettings;
import org.python.pydev.parser.fastparser.FastDefinitionsParser;
import org.python.pydev.plugin.nature.PythonNature;
import org.python.pydev.shared_core.callbacks.ICallback;
import org.python.pydev.shared_core.callbacks.ICallback0;
import org.python.pydev.shared_core.log.ToLogFile;

public class AnalysisBuilderVisitor
extends PyDevBuilderVisitor {
    protected int getPriority() {
        return 6;
    }

    public void visitChangedResource(IResource resource, ICallback0<IDocument> document, IProgressMonitor monitor) {
        this.visitChangedResource(resource, document, monitor, false);
    }

    public void visitChangedResource(final IResource resource, ICallback0<IDocument> document, IProgressMonitor monitor, boolean forceAnalysis) {
        String moduleName;
        final PythonNature nature = this.getPythonNature(resource);
        if (nature == null) {
            return;
        }
        final SourceModule[] module = new SourceModule[1];
        final IDocument doc = (IDocument)document.call();
        if (doc == null) {
            return;
        }
        try {
            moduleName = this.getModuleName(resource, (IPythonNature)nature);
        }
        catch (MisconfigurationException e) {
            Log.log((Throwable)e);
            return;
        }
        ICallback<IModule, Integer> moduleCallback = new ICallback<IModule, Integer>(){

            public IModule call(Integer arg) {
                if (arg == 1) {
                    if (module[0] != null) {
                        return module[0];
                    }
                    try {
                        module[0] = AnalysisBuilderVisitor.this.getSourceModule(resource, doc, (IPythonNature)nature);
                    }
                    catch (MisconfigurationException e1) {
                        throw new RuntimeException(e1);
                    }
                    if (module[0] != null) {
                        return module[0];
                    }
                    try {
                        module[0] = AnalysisBuilderVisitor.this.createSoureModule(resource, doc, moduleName);
                    }
                    catch (MisconfigurationException e) {
                        throw new RuntimeException(e);
                    }
                    return module[0];
                }
                if (arg == 2) {
                    IFile f;
                    IPath location;
                    if (DebugSettings.DEBUG_ANALYSIS_REQUESTS) {
                        ToLogFile.toLogFile((Object)this, (String)"PyDevBuilderPrefPage.getAnalyzeOnlyActiveEditor()");
                    }
                    if ((location = (f = (IFile)resource).getLocation()) != null) {
                        String file = location.toOSString();
                        File f2 = new File(file);
                        return new SourceModule(moduleName, f2, FastDefinitionsParser.parse((String)doc.get(), (String)moduleName, (File)f2), null, (IPythonNature)nature);
                    }
                    return null;
                }
                throw new RuntimeException("Unexpected parameter: " + arg);
            }
        };
        long documentTime = this.getDocumentTime();
        if (documentTime == -1L) {
            Log.log((String)"Warning: The document time in the visitor is -1. Changing for current time.");
            documentTime = System.currentTimeMillis();
        }
        this.doVisitChangedResource((IPythonNature)nature, resource, doc, moduleCallback, null, monitor, forceAnalysis, 1, documentTime, false);
    }

    public void doVisitChangedResource(IPythonNature nature, IResource resource, ICallback<IModule, Integer> moduleCallback, final IModule module, IProgressMonitor monitor, boolean forceAnalysis, int analysisCause, long documentTime, boolean forceAnalyzeInThisThread) {
        String moduleName;
        if (DebugSettings.DEBUG_ANALYSIS_REQUESTS) {
            if (analysisCause == 1) {
                System.out.println("doVisitChangedResource: BUILDER -- " + documentTime);
            } else {
                System.out.println("doVisitChangedResource: PARSER -- " + documentTime);
            }
        }
        if (module != null) {
            if (moduleCallback != null) {
                Log.log((String)("Only the module or the moduleCallback must be specified for: " + resource));
                return;
            }
            this.setModuleInCache(resource, module);
            moduleCallback = new ICallback<IModule, Integer>(){

                public IModule call(Integer arg) {
                    return module;
                }
            };
        } else if (moduleCallback == null) {
            Log.log((String)("Either the module or the moduleCallback must be specified for: " + resource));
            return;
        }
        try {
            moduleName = this.getModuleName(resource, nature);
        }
        catch (MisconfigurationException e) {
            Log.log((Throwable)e);
            return;
        }
        IAnalysisBuilderRunnable runnable = AnalysisBuilderRunnableFactory.createRunnable(resource.getName(), nature, this.isFullBuild(), true, analysisCause, documentTime, resource.getModificationStamp());
        if (runnable == null) {
            return;
        }
        this.execRunnable(moduleName, runnable, forceAnalyzeInThisThread);
    }

    public void doVisitChangedResource(IPythonNature nature, IResource resource, IDocument document, ICallback<IModule, Integer> moduleCallback, IModule module, IProgressMonitor monitor, boolean forceAnalysis, int analysisCause, long documentTime, boolean forceAnalyzeInThisThread) {
        this.doVisitChangedResource(nature, resource, document, moduleCallback, module, monitor, forceAnalysis, analysisCause, documentTime, forceAnalyzeInThisThread, new ArrayList<IExternalCodeAnalysisVisitor>());
    }

    public void doVisitChangedResource(IPythonNature nature, IResource resource, IDocument document, ICallback<IModule, Integer> moduleCallback, final IModule module, IProgressMonitor monitor, boolean forceAnalysis, int analysisCause, long documentTime, boolean forceAnalyzeInThisThread, List<IExternalCodeAnalysisVisitor> externalVisitors) {
        String moduleName;
        if (DebugSettings.DEBUG_ANALYSIS_REQUESTS) {
            if (analysisCause == 1) {
                System.out.println("doVisitChangedResource: BUILDER -- " + documentTime);
            } else {
                System.out.println("doVisitChangedResource: PARSER -- " + documentTime);
            }
        }
        if (module != null) {
            if (moduleCallback != null) {
                Log.log((String)("Only the module or the moduleCallback must be specified for: " + resource));
                return;
            }
            this.setModuleInCache(resource, module);
            moduleCallback = new ICallback<IModule, Integer>(){

                public IModule call(Integer arg) {
                    return module;
                }
            };
        } else if (moduleCallback == null) {
            Log.log((String)("Either the module or the moduleCallback must be specified for: " + resource));
            return;
        }
        try {
            moduleName = this.getModuleName(resource, nature);
        }
        catch (MisconfigurationException e) {
            Log.log((Throwable)e);
            return;
        }
        IAnalysisBuilderRunnable runnable = AnalysisBuilderRunnableFactory.createRunnable(document, resource, moduleCallback, this.isFullBuild(), moduleName, forceAnalysis, analysisCause, nature, documentTime, resource.getModificationStamp(), externalVisitors);
        if (runnable == null) {
            return;
        }
        this.execRunnable(moduleName, runnable, forceAnalyzeInThisThread);
    }

    private void execRunnable(String moduleName, IAnalysisBuilderRunnable runnable, boolean forceAnalyzeInThisThread) {
        if (this.isFullBuild() || forceAnalyzeInThisThread) {
            runnable.run();
        } else {
            RunnableAsJobsPoolThread.getSingleton().scheduleToRun((IRunnableWithMonitor)runnable, "PyDev: Code Analysis:" + moduleName);
        }
    }

    public void visitRemovedResource(IResource resource, ICallback0<IDocument> document, IProgressMonitor monitor) {
        PythonNature nature = this.getPythonNature(resource);
        if (nature == null) {
            return;
        }
        if (resource.getType() == 2) {
            return;
        }
        if (!this.isFullBuild()) {
            String moduleName;
            try {
                moduleName = this.getModuleName(resource, (IPythonNature)nature);
            }
            catch (MisconfigurationException e) {
                Log.log((Throwable)e);
                return;
            }
            long documentTime = this.getDocumentTime();
            if (documentTime == -1L) {
                Log.log((String)("Warning: The document time in the visitor for remove is -1. Changing for current time. Resource: " + resource + ". Module name: " + moduleName));
                documentTime = System.currentTimeMillis();
            }
            long resourceModificationStamp = resource.getModificationStamp();
            IAnalysisBuilderRunnable runnable = AnalysisBuilderRunnableFactory.createRunnable(moduleName, (IPythonNature)nature, this.isFullBuild(), false, 1, documentTime, resourceModificationStamp);
            if (runnable == null) {
                return;
            }
            this.execRunnable(moduleName, runnable, false);
        }
    }

    public void visitingWillStart(IProgressMonitor monitor, boolean isFullBuild, IPythonNature nature) {
        if (isFullBuild) {
            AbstractAdditionalDependencyInfo info;
            try {
                info = AdditionalProjectInterpreterInfo.getAdditionalInfoForProject(nature);
            }
            catch (MisconfigurationException e) {
                Log.log((Throwable)e);
                return;
            }
            info.clearAllInfo();
        }
    }
}

