/*
 * Decompiled with CFR 0.152.
 */
package com.python.pydev.analysis.additionalinfo.builders;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.IDocument;
import org.python.pydev.ast.analysis.messages.IMessage;
import org.python.pydev.core.docutils.PySelection;
import org.python.pydev.core.log.Log;
import org.python.pydev.shared_core.markers.PyMarkerUtils;

public class AnalysisRunner {
    public static final String PYDEV_CODE_ANALYSIS_IGNORE = "@PydevCodeAnalysisIgnore";
    public static final String PYDEV_CODE_ANALYSIS_IGNORE2 = "flake8: noqa";
    public static final String PYDEV_ANALYSIS_TYPE = "PYDEV_TYPE";
    public static final String PYDEV_ANALYSIS_ADDITIONAL_INFO = "PYDEV_INFO";
    public static final String PYDEV_ANALYSIS_PROBLEM_MARKER = "com.python.pydev.analysis.pydev_analysis_problemmarker";
    public static final String PYLINT_PROBLEM_MARKER = "org.python.pydev.pylintproblemmarker";
    public static final String MYPY_PROBLEM_MARKER = "org.python.pydev.mypyproblemmarker";
    public static final String FLAKE8_PROBLEM_MARKER = "org.python.pydev.flake8problemmarker";
    private static final boolean DEBUG_ANALYSIS_RUNNER = false;

    public boolean canDoAnalysis(IDocument document) {
        if (document == null) {
            return false;
        }
        int i = 0;
        while (i < 3) {
            String commentPart;
            String line = PySelection.getLine((IDocument)document, (int)i);
            int commentIndex = line.indexOf(35);
            if (commentIndex != -1 && ((commentPart = line.substring(commentIndex)).contains(PYDEV_CODE_ANALYSIS_IGNORE) || commentPart.contains(PYDEV_CODE_ANALYSIS_IGNORE2))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static void deleteMarkers(IResource resource) {
        AnalysisRunner.deleteMarkers(resource, false);
    }

    public static void deleteMarkers(IResource resource, boolean onlyPydevAnalysisMarkers) {
        if (resource == null) {
            return;
        }
        try {
            resource.deleteMarkers(PYDEV_ANALYSIS_PROBLEM_MARKER, true, 0);
        }
        catch (CoreException e) {
            if (resource.exists()) {
                Log.log((Throwable)e);
            }
        }
        catch (Exception e) {
            Log.log((Throwable)e);
        }
        if (onlyPydevAnalysisMarkers) {
            return;
        }
        try {
            if (resource != null) {
                resource.deleteMarkers(PYLINT_PROBLEM_MARKER, false, 0);
            }
        }
        catch (CoreException e3) {
            Log.log((Throwable)e3);
        }
        try {
            if (resource != null) {
                resource.deleteMarkers(MYPY_PROBLEM_MARKER, false, 0);
            }
        }
        catch (CoreException e3) {
            Log.log((Throwable)e3);
        }
        try {
            if (resource != null) {
                resource.deleteMarkers(FLAKE8_PROBLEM_MARKER, false, 0);
            }
        }
        catch (CoreException e3) {
            Log.log((Throwable)e3);
        }
    }

    public List<PyMarkerUtils.MarkerInfo> setMarkers(IResource resource, IDocument document, IMessage[] messages, IProgressMonitor monitor) {
        ArrayList<PyMarkerUtils.MarkerInfo> lst;
        block4: {
            if (resource == null) {
                return null;
            }
            try {
                lst = this.generateMarkers(document, messages, monitor);
                if (!monitor.isCanceled()) break block4;
                return null;
            }
            catch (Exception e) {
                Log.log((String)("Error when setting markers on: " + resource), (Throwable)e);
                return null;
            }
        }
        PyMarkerUtils.replaceMarkers(lst, (IResource)resource, (String)PYDEV_ANALYSIS_PROBLEM_MARKER, (boolean)true, (IProgressMonitor)monitor);
        return lst;
    }

    public ArrayList<PyMarkerUtils.MarkerInfo> generateMarkers(IDocument document, IMessage[] messages, IProgressMonitor monitor) {
        ArrayList<PyMarkerUtils.MarkerInfo> lst = new ArrayList<PyMarkerUtils.MarkerInfo>();
        IMessage[] iMessageArray = messages;
        int n = messages.length;
        int n2 = 0;
        while (n2 < n) {
            IMessage m = iMessageArray[n2];
            HashMap<String, Object> additionalInfo = new HashMap<String, Object>();
            additionalInfo.put(PYDEV_ANALYSIS_TYPE, m.getType());
            List infoForType = m.getAdditionalInfo();
            if (infoForType != null) {
                additionalInfo.put(PYDEV_ANALYSIS_ADDITIONAL_INFO, infoForType);
            }
            int startLine = m.getStartLine(document) - 1;
            int startCol = m.getStartCol(document) - 1;
            int endLine = m.getEndLine(document) - 1;
            int endCol = m.getEndCol(document) - 1;
            String msg = m.getMessage();
            if (monitor.isCanceled()) {
                return null;
            }
            PyMarkerUtils.MarkerInfo markerInfo = new PyMarkerUtils.MarkerInfo(document, msg, PYDEV_ANALYSIS_PROBLEM_MARKER, m.getSeverity(), false, false, startLine, startCol, endLine, endCol, additionalInfo);
            lst.add(markerInfo);
            ++n2;
        }
        return lst;
    }
}

