/*
 * Decompiled with CFR 0.152.
 */
package com.python.pydev.analysis.flake8;

import com.python.pydev.analysis.external.ExternalAnalizerProcessWatchDoc;
import com.python.pydev.analysis.external.IExternalAnalyzer;
import com.python.pydev.analysis.external.IExternalCodeAnalysisStream;
import com.python.pydev.analysis.external.WriteToStreamHelper;
import com.python.pydev.analysis.flake8.Flake8CodesConfigHandler;
import com.python.pydev.analysis.flake8.Flake8Preferences;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.python.pydev.ast.runners.SimpleRunner;
import org.python.pydev.core.CheckAnalysisErrors;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.MisconfigurationException;
import org.python.pydev.core.PythonNatureWithoutProjectException;
import org.python.pydev.core.log.Log;
import org.python.pydev.plugin.nature.PythonNature;
import org.python.pydev.shared_core.SharedCorePlugin;
import org.python.pydev.shared_core.callbacks.ICallback0;
import org.python.pydev.shared_core.io.FileUtils;
import org.python.pydev.shared_core.markers.PyMarkerUtils;
import org.python.pydev.shared_core.process.ProcessUtils;
import org.python.pydev.shared_core.string.FastStringBuffer;
import org.python.pydev.shared_core.string.StringUtils;
import org.python.pydev.shared_core.structure.Tuple;

final class Flake8Analysis
implements IExternalAnalyzer {
    private final IResource resource;
    private final IDocument fDocument;
    private final IPath location;
    private final Map<IResource, List<PyMarkerUtils.MarkerInfo>> fileToMarkers = new HashMap<IResource, List<PyMarkerUtils.MarkerInfo>>();
    private final IProgressMonitor monitor;
    private Thread processWatchDoc;
    private final File flake8Location;
    private static Pattern FLAKE8_MATCH_PATTERN = Pattern.compile("\\A\\s*(.*)\\s*\\:\\s*(\\d+)\\s*\\:\\s*(\\d+)\\s*\\:\\s*(\\w+\\d+\\s(?:\\(.*\\))?)\\s*(.*)\\Z");

    public Flake8Analysis(IResource resource, IDocument document, IPath location, IProgressMonitor monitor, File flake8Location) {
        this.resource = resource;
        this.fDocument = document;
        this.location = location;
        this.monitor = monitor;
        this.flake8Location = flake8Location;
    }

    void createFlake8Process(IExternalCodeAnalysisStream out) throws CoreException, MisconfigurationException, PythonNatureWithoutProjectException {
        String flake8Executable = FileUtils.getFileAbsolutePath((File)this.flake8Location);
        String target = this.location.toOSString();
        ArrayList<String> cmdList = new ArrayList<String>();
        cmdList.add(flake8Executable);
        String userArgs = StringUtils.replaceNewLines((String)Flake8Preferences.getFlake8Args((IAdaptable)this.resource), (String)" ");
        ArrayList<String> userArgsAsList = new ArrayList<String>(Arrays.asList(ProcessUtils.parseArguments((String)userArgs)));
        IProject project = this.resource.getProject();
        if (project == null || !project.isAccessible()) {
            Log.log((String)("Unable to run flake8 in: " + target + ". Project not available (" + project + ")."));
            return;
        }
        File workingDir = project.getLocation().toFile();
        for (String s : userArgsAsList) {
            if (s.startsWith("--format=")) continue;
            cmdList.add(s);
        }
        cmdList.add("--format=default");
        cmdList.add(target);
        String[] args = cmdList.toArray(new String[0]);
        WriteToStreamHelper.write("Flake8: Executing command line:", out, new Object[]{args});
        PythonNature nature = PythonNature.getPythonNature((IProject)project);
        ICallback0 launchProcessCallback = () -> Flake8Analysis.lambda$0(args, workingDir, (IPythonNature)nature);
        this.processWatchDoc = new ExternalAnalizerProcessWatchDoc(out, this.monitor, this, (ICallback0<Process>)launchProcessCallback, project, true);
        this.processWatchDoc.start();
    }

    @Override
    public void afterRunProcess(String output, String errors, IExternalCodeAnalysisStream out) {
        boolean resourceIsContainer = this.resource instanceof IContainer;
        IProject project = null;
        IFile moduleFile = null;
        if (resourceIsContainer) {
            project = this.resource.getProject();
            if (project == null) {
                Log.log((String)"Expected resource to have project for Flake8Analysis.");
                return;
            }
            if (!project.isAccessible()) {
                Log.log((String)"Expected project to be accessible for Flake8Analysis.");
                return;
            }
        } else if (this.resource instanceof IFile) {
            moduleFile = (IFile)this.resource;
        } else {
            return;
        }
        output = output.trim();
        errors = errors.trim();
        if (!output.isEmpty()) {
            WriteToStreamHelper.write("Flake8: The stdout of the command line is:\n", out, output);
        }
        if (!errors.isEmpty()) {
            WriteToStreamHelper.write("Flake8: The stderr of the command line is:\n", out, errors);
        }
        if (output.indexOf("Traceback (most recent call last):") != -1) {
            RuntimeException e = new RuntimeException("Flake8 ERROR: \n" + output);
            Log.log((Throwable)e);
            return;
        }
        if (errors.indexOf("Traceback (most recent call last):") != -1) {
            RuntimeException e = new RuntimeException("Flake8 ERROR: \n" + errors);
            Log.log((Throwable)e);
            return;
        }
        FastStringBuffer fileNameBuf = new FastStringBuffer();
        String loc = this.location != null ? this.location.toString().toLowerCase() : null;
        String res = null;
        if (this.resource != null && this.resource.getFullPath() != null) {
            res = this.resource.getFullPath().toString().toLowerCase();
        }
        HashMap<IFile, IDocument> resourceToDocCache = new HashMap<IFile, IDocument>();
        Map<String, Tuple<Set<Tuple<Integer, Integer>>, Integer>> codeSeverities = null;
        if (!SharedCorePlugin.inTestMode()) {
            codeSeverities = Flake8CodesConfigHandler.getCodeSeveritiesFromConfig((IAdaptable)this.resource);
        }
        for (String outputLine : StringUtils.iterLines((String)output)) {
            if (this.monitor.isCanceled()) {
                return;
            }
            try {
                IDocument document;
                outputLine = outputLine.trim();
                Matcher m = FLAKE8_MATCH_PATTERN.matcher(outputLine);
                if (!m.matches()) continue;
                if (resourceIsContainer) {
                    Path filePath = new Path(outputLine.substring(m.start(1), m.end(1)));
                    filePath = filePath.makeRelativeTo(project.getLocation());
                    try {
                        moduleFile = project.getFile((IPath)filePath);
                    }
                    catch (Exception e) {
                        Log.log((Throwable)e);
                        continue;
                    }
                    document = (IDocument)resourceToDocCache.get(moduleFile);
                    if (document == null) {
                        document = FileUtils.getDocFromResource((IResource)moduleFile);
                        if (document == null) continue;
                        resourceToDocCache.put(moduleFile, document);
                    }
                } else {
                    document = this.fDocument;
                    fileNameBuf.clear();
                    fileNameBuf.append(outputLine.substring(m.start(1), m.end(1))).trim().replaceAll('\\', '/');
                    if (fileNameBuf.startsWith("./")) {
                        fileNameBuf.deleteFirstChars(2);
                    }
                    String fileName = fileNameBuf.toString().toLowerCase();
                    if (!(loc == null && res == null || loc != null && loc.contains(fileName) || res != null && res.contains(fileName))) continue;
                }
                String code = outputLine.substring(m.start(4), m.end(4)).trim();
                Tuple<String, Tuple<Integer, Integer>> codeTup = Flake8CodesConfigHandler.getCodeTuple(code);
                String prefix = (String)codeTup.o1;
                Tuple range = (Tuple)codeTup.o2;
                int priority = this.getPriorityFromCodeSeverityMap(prefix, (Tuple<Integer, Integer>)range, codeSeverities);
                if (priority <= -1) continue;
                int line = Integer.parseInt(outputLine.substring(m.start(2), m.end(2)));
                int column = Integer.parseInt(outputLine.substring(m.start(3), m.end(3))) - 1;
                String message = outputLine.substring(m.start(5), m.end(5));
                IRegion region = null;
                try {
                    region = document.getLineInformation(line - 1);
                }
                catch (Exception e) {
                    region = document.getLineInformation(line);
                }
                String lineContents = document.get(region.getOffset(), region.getLength());
                if (CheckAnalysisErrors.isFlake8ErrorHandledAtLine((String)lineContents, (String)code)) continue;
                this.addToMarkers(String.valueOf(message) + " (" + code + ")", priority, code, line - 1, column, lineContents, moduleFile, document);
            }
            catch (Exception e) {
                Log.log((Throwable)e);
            }
        }
    }

    private int getPriorityFromCodeSeverityMap(String prefix, Tuple<Integer, Integer> range, Map<String, Tuple<Set<Tuple<Integer, Integer>>, Integer>> codeSeverities) {
        Tuple<Set<Tuple<Integer, Integer>>, Integer> valueTup;
        if (codeSeverities != null && (valueTup = codeSeverities.get(prefix)) != null) {
            Set set = (Set)valueTup.o1;
            int severity = (Integer)valueTup.o2;
            for (Tuple baseRange : set) {
                boolean overlappedRanges = Flake8CodesConfigHandler.checkRangeOverlap(range, (Tuple<Integer, Integer>)baseRange);
                if (!overlappedRanges) continue;
                return severity;
            }
        }
        return 1;
    }

    private void addToMarkers(String message, int priority, String id, int line, int column, String lineContents, IFile moduleFile, IDocument document) {
        int colEnd;
        int colStart;
        HashMap<String, String> additionalInfo = new HashMap<String, String>();
        additionalInfo.put("flake8_message_id", id);
        List<PyMarkerUtils.MarkerInfo> list = this.fileToMarkers.get(moduleFile);
        if (list == null) {
            list = new ArrayList<PyMarkerUtils.MarkerInfo>();
            this.fileToMarkers.put((IResource)moduleFile, list);
        }
        if ((colStart = column) == (colEnd = lineContents.length())) {
            colStart = 0;
        }
        list.add(new PyMarkerUtils.MarkerInfo(document, "Flake8: " + message, "org.python.pydev.flake8problemmarker", priority, false, false, line, colStart, line, colEnd, additionalInfo));
    }

    public List<PyMarkerUtils.MarkerInfo> getMarkers(IResource resource) {
        List<PyMarkerUtils.MarkerInfo> ret = this.fileToMarkers.get(resource);
        if (ret == null) {
            return new ArrayList<PyMarkerUtils.MarkerInfo>();
        }
        return new ArrayList<PyMarkerUtils.MarkerInfo>(ret);
    }

    @Override
    public void join() {
        if (this.processWatchDoc != null) {
            try {
                this.processWatchDoc.join();
            }
            catch (InterruptedException e) {
                Log.log((Throwable)e);
            }
        }
    }

    private static /* synthetic */ Process lambda$0(String[] stringArray, File file, IPythonNature iPythonNature) {
        SimpleRunner simpleRunner = new SimpleRunner();
        Tuple r = simpleRunner.run(stringArray, file, iPythonNature, null, null);
        Process process = (Process)r.o1;
        return process;
    }
}

