/*
 * Decompiled with CFR 0.152.
 */
package com.python.pydev.analysis.flake8;

import com.python.pydev.analysis.flake8.Flake8Analysis;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import junit.framework.TestCase;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.python.pydev.core.MisconfigurationException;
import org.python.pydev.core.PythonNatureWithoutProjectException;
import org.python.pydev.plugin.nature.PythonNature;
import org.python.pydev.shared_core.io.FileUtils;
import org.python.pydev.shared_core.markers.PyMarkerUtils;
import org.python.pydev.shared_core.resource_stubs.FileStub;
import org.python.pydev.shared_core.resource_stubs.IProjectStub;
import org.python.pydev.shared_core.resource_stubs.ProjectStub;

public class Flake8AnalysisTest
extends TestCase {
    private File tempDir;
    private FileStub file;
    private int index = 0;
    private List<PyMarkerUtils.MarkerInfo> markers;

    protected void setUp() throws Exception {
        super.setUp();
        this.tempDir = FileUtils.getTempFileAt((File)new File("."), (String)"data_flake8_analysis");
        this.tempDir.mkdirs();
        ProjectStub project = new ProjectStub(this.tempDir, (IProjectNature)new PythonNature());
        this.file = new FileStub((IProjectStub)project, new File("snippet.py"));
    }

    private void setUpTestForAssertions(IDocument document, String output) {
        Flake8Analysis flake8Analysis = new Flake8Analysis((IResource)this.file, document, null, (IProgressMonitor)new NullProgressMonitor(), null);
        flake8Analysis.afterRunProcess(output, "", null);
        this.setMarkersAndResetIndex(flake8Analysis);
    }

    private void setMarkersAndResetIndex(Flake8Analysis flake8Analysis) {
        this.markers = flake8Analysis.getMarkers((IResource)this.file);
        this.index = 0;
    }

    private void assertMarkersValidity(int expectedAmountOfMarkers) {
        Flake8AnalysisTest.assertEquals((int)expectedAmountOfMarkers, (int)this.markers.size());
        for (PyMarkerUtils.MarkerInfo marker : this.markers) {
            Flake8AnalysisTest.assertEquals((int)marker.lineStart, (int)marker.lineEnd);
        }
    }

    private void assertMarkerEquals(int line, int column, String violationCode, String message) {
        PyMarkerUtils.MarkerInfo marker = this.markers.get(this.index);
        Flake8AnalysisTest.assertEquals((String)(String.valueOf(this.index) + ": MarkerInfo lineStart"), (int)line, (int)marker.lineStart);
        Flake8AnalysisTest.assertEquals((String)(String.valueOf(this.index) + ": MarkerInfo colStart"), (int)column, (int)marker.colStart);
        Flake8AnalysisTest.assertEquals((String)(String.valueOf(this.index) + ": MarkerInfo message_id"), (Object)violationCode, marker.additionalInfo.get("flake8_message_id"));
        Flake8AnalysisTest.assertEquals((String)(String.valueOf(this.index) + ": MarkerInfo message"), (String)("Flake8: " + message), (String)marker.message);
        HashMap attribMap = marker.getAsMap();
        Flake8AnalysisTest.assertEquals((String)(String.valueOf(this.index) + ": IMarker.LINE_NUMBER"), (Object)(line + 1), attribMap.get("lineNumber"));
        ++this.index;
    }

    public void testMarkersMessage() throws CoreException, MisconfigurationException, PythonNatureWithoutProjectException {
        Document document = new Document("x = 10");
        String output = ".\\snippet.py:1:7: W292 no newline at end of file";
        this.setUpTestForAssertions((IDocument)document, output);
        this.assertMarkersValidity(1);
        this.assertMarkerEquals(0, 0, "W292", "no newline at end of file (W292)");
    }

    public void testMarkersMessage1() {
        Document document = new Document("import math\nx = \"longlinelonglinelonglinelonglinelonglinelonglinelonglinelonglinelonglinelongline\"\ny = 20\n    f = 10\ndef foo():\n        w = 10\n    pass");
        String output = ".\\snippet.py:1:1: E902 IndentationError: unindent does not match any outer indentation level\n.\\snippet.py:2:80: E501 line too long (80 > 79 characters)\n.\\snippet.py:4:5: E113 unexpected indentation\n.\\snippet.py:5:1: E302 expected 2 blank lines, found 0\n.\\snippet.py:6:9: E117 over-indented";
        this.setUpTestForAssertions((IDocument)document, output);
        this.assertMarkersValidity(5);
        this.assertMarkerEquals(0, 0, "E902", "IndentationError: unindent does not match any outer indentation level (E902)");
        this.assertMarkerEquals(1, 79, "E501", "line too long (80 > 79 characters) (E501)");
        this.assertMarkerEquals(3, 4, "E113", "unexpected indentation (E113)");
        this.assertMarkerEquals(4, 0, "E302", "expected 2 blank lines, found 0 (E302)");
        this.assertMarkerEquals(5, 8, "E117", "over-indented (E117)");
    }

    public void testMarkerSpecificNoqa() {
        Document document = new Document("y = 20\n    f = 10 #noqa: E302\ndef foo():\n        w = 10\n    pass");
        String output = ".\\snippet.py:1:1: E902 IndentationError: unindent does not match any outer level\n.\\snippet.py:2:5: E113 unexpected indentation\n.\\snippet.py:3:1: E302 expected 2 blank lines, found 0\n.\\snippet.py:4:9: E117 over-indented";
        this.setUpTestForAssertions((IDocument)document, output);
        this.assertMarkersValidity(4);
        this.assertMarkerEquals(0, 0, "E902", "IndentationError: unindent does not match any outer level (E902)");
        this.assertMarkerEquals(1, 4, "E113", "unexpected indentation (E113)");
        this.assertMarkerEquals(2, 0, "E302", "expected 2 blank lines, found 0 (E302)");
        this.assertMarkerEquals(3, 8, "E117", "over-indented (E117)");
    }

    public void testMarkerSpecificNoqa1() {
        Document document = new Document("y = 20\n    f = 10 #noqa: E113\ndef foo():\n        w = 10\n    pass");
        String output = ".\\snippet.py:1:1: E902 IndentationError: unindent does not match any outer level\n.\\snippet.py:2:5: E113 unexpected indentation\n.\\snippet.py:3:1: E302 expected 2 blank lines, found 0\n.\\snippet.py:4:9: E117 over-indented";
        this.setUpTestForAssertions((IDocument)document, output);
        this.assertMarkersValidity(3);
        this.assertMarkerEquals(0, 0, "E902", "IndentationError: unindent does not match any outer level (E902)");
        this.assertMarkerEquals(2, 0, "E302", "expected 2 blank lines, found 0 (E302)");
        this.assertMarkerEquals(3, 8, "E117", "over-indented (E117)");
    }
}

