/*
 * Decompiled with CFR 0.152.
 */
package com.python.pydev.analysis.flake8;

import com.python.pydev.analysis.flake8.Flake8Preferences;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IAdaptable;
import org.python.pydev.core.log.Log;
import org.python.pydev.json.eclipsesource.JsonObject;
import org.python.pydev.json.eclipsesource.JsonValue;
import org.python.pydev.shared_core.string.StringUtils;
import org.python.pydev.shared_core.structure.Tuple;

public class Flake8CodesConfigHandler {
    private static final Pattern FLAKE8_CODE_PATTERN = Pattern.compile("\\A\\s*([a-zA-Z]+)([0-9]+|(?:\\[\\s*\\-?[0-9]+\\s*,\\s*\\-?[0-9]+\\s*\\])|)\\s*\\Z");
    private static final Map<String, Integer> POSSIBLE_SEVERITIES = Flake8CodesConfigHandler.initPossibleSeverities();

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    public static final Optional<String> checkJsonFormat(JsonValue jsonValue) {
        if (!jsonValue.isObject()) {
            return Optional.of("Flake8 codes config JSON must be an object.");
        }
        jsonObject = jsonValue.asObject();
        nonOverlappedRanges = new HashMap<String, HashSet<E>>();
        codes = jsonObject.names();
        i = 0;
        while (i < codes.size()) {
            block9: {
                code = (String)codes.get(i);
                codeRep = "Code entry " + i;
                m = Flake8CodesConfigHandler.FLAKE8_CODE_PATTERN.matcher(code);
                if (!m.matches()) {
                    return Optional.of(String.valueOf(codeRep) + " does not match any of \"prefix\", \"prefixN\" (example: \"prefix123\") or \"prefix[N1,N2]\" patterns.");
                }
                prefix = m.group(1);
                identifier = m.group(2);
                range = Flake8CodesConfigHandler.getRangeFromIdentifier(identifier);
                init = (Integer)range.o1;
                if (init > (end = ((Integer)range.o2).intValue()) && end != -1) {
                    return Optional.of(String.valueOf(codeRep) + " range init is greater than range end.");
                }
                set = (HashSet<Object>)nonOverlappedRanges.get(prefix);
                if (set != null) break block9;
                set = new HashSet<Object>();
                set.add(range);
                nonOverlappedRanges.put(prefix, set);
                ** GOTO lbl41
            }
            overlapErrorMessage = Optional.of(String.valueOf(codeRep) + " overlap other \"" + prefix + "\" code.");
            universalTup = new Tuple((Object)-1, (Object)-1);
            if (init == -1 && end == -1) {
                if (set.contains(universalTup)) {
                    return overlapErrorMessage;
                }
                set.add(universalTup);
            } else {
                for (Tuple tup : set) {
                    if (tup.equals((Object)universalTup) || !Flake8CodesConfigHandler.checkRangeOverlap(range, (Tuple<Integer, Integer>)tup)) continue;
                    return overlapErrorMessage;
                }
                set.add(range);
lbl41:
                // 2 sources

                severity = jsonObject.get(code);
                severityError = Flake8CodesConfigHandler.checkSeverity(codeRep, severity);
                if (!severityError.isEmpty()) {
                    return severityError;
                }
            }
            ++i;
        }
        return Optional.empty();
    }

    private static Map<String, Integer> initPossibleSeverities() {
        HashMap<String, Integer> ret = new HashMap<String, Integer>();
        ret.put("ignore", -1);
        ret.put("error", 2);
        ret.put("warning", 1);
        ret.put("info", 0);
        return ret;
    }

    private static Optional<String> checkSeverity(String codeRep, JsonValue severity) {
        block7: {
            if (severity.isNumber()) {
                Collection<Integer> possibleNumbers = POSSIBLE_SEVERITIES.values();
                Optional<String> errorMessage = Optional.of(String.valueOf(codeRep) + " value does not match any string or " + possibleNumbers.toString() + " integer error values");
                try {
                    if (!possibleNumbers.contains(severity.asInt())) {
                        return errorMessage;
                    }
                    break block7;
                }
                catch (Exception e) {
                    return errorMessage;
                }
            }
            if (severity.isString()) {
                String severityStr;
                Set<String> possibleStrings = POSSIBLE_SEVERITIES.keySet();
                if (!possibleStrings.contains(severityStr = severity.asString().trim())) {
                    return Optional.of(String.valueOf(codeRep) + " value does not match any integer or " + possibleStrings.toString() + " string error values");
                }
            } else {
                return Optional.of(String.valueOf(codeRep) + " value is neither a string or an integer");
            }
        }
        return Optional.empty();
    }

    public static boolean checkRangeOverlap(Tuple<Integer, Integer> compareRange, Tuple<Integer, Integer> baseRange) {
        int c1 = (Integer)compareRange.o1;
        int c2 = (Integer)compareRange.o2;
        int b1 = (Integer)baseRange.o1;
        int b2 = (Integer)baseRange.o2;
        if (b1 == c1 || b2 == c2) {
            return true;
        }
        return !(c1 > b2 && b2 != -1 || b1 > c2 && c2 != -1);
    }

    private static final Tuple<Integer, Integer> getRangeFromIdentifier(String identifier) {
        if (identifier.contains("[")) {
            String valuesStr = identifier.substring(1, identifier.length() - 1);
            List values = StringUtils.split((String)valuesStr, (char)',');
            int firstValue = Integer.parseInt(((String)values.get(0)).trim());
            int secondValue = Integer.parseInt(((String)values.get(1)).trim());
            return new Tuple((Object)firstValue, (Object)secondValue);
        }
        if (identifier.isBlank()) {
            return new Tuple((Object)-1, (Object)-1);
        }
        int value = Integer.parseInt(identifier);
        return new Tuple((Object)value, (Object)value);
    }

    public static Map<String, Tuple<Set<Tuple<Integer, Integer>>, Integer>> getCodeSeveritiesFromConfig(IAdaptable projectAdaptable) {
        HashMap<String, Tuple<Set<Tuple<Integer, Integer>>, Integer>> ret = new HashMap<String, Tuple<Set<Tuple<Integer, Integer>>, Integer>>();
        String str = Flake8Preferences.getCodesConfig(projectAdaptable);
        JsonObject jsonObject = null;
        try {
            jsonObject = JsonObject.readFrom((String)str);
        }
        catch (Exception e) {
            Log.log((Throwable)e);
            return ret;
        }
        for (String code : jsonObject.names()) {
            Set<Tuple> set;
            Tuple<String, Tuple<Integer, Integer>> codeTup = Flake8CodesConfigHandler.getCodeTuple(code);
            String prefix = (String)codeTup.o1;
            Tuple range = (Tuple)codeTup.o2;
            int severity = Flake8CodesConfigHandler.getSeverity(jsonObject.get(code));
            Tuple valueTup = (Tuple)ret.get(prefix);
            if (valueTup == null) {
                set = new HashSet();
                set.add(range);
                ret.put(prefix, (Tuple<Set<Tuple<Integer, Integer>>, Integer>)new Tuple(set, (Object)severity));
                continue;
            }
            set = (Set)valueTup.o1;
            set.add(range);
        }
        return ret;
    }

    private static int getSeverity(JsonValue jsonValue) {
        if (jsonValue.isNumber()) {
            return jsonValue.asInt();
        }
        return POSSIBLE_SEVERITIES.get(jsonValue.asString().trim());
    }

    public static Tuple<String, Tuple<Integer, Integer>> getCodeTuple(String code) {
        int prefixEnd = code.length();
        int i = 0;
        while (i < code.length()) {
            char c = code.charAt(i);
            if (!Character.isAlphabetic(c)) {
                prefixEnd = i;
                break;
            }
            ++i;
        }
        String prefix = code.substring(0, prefixEnd);
        String identifier = code.substring(prefixEnd);
        Tuple<Integer, Integer> range = Flake8CodesConfigHandler.getRangeFromIdentifier(identifier);
        return new Tuple((Object)prefix, range);
    }
}

