/*
 * Decompiled with CFR 0.152.
 */
package com.python.pydev.analysis.flake8;

import com.python.pydev.analysis.flake8.Flake8CodesConfigHandler;
import java.util.Optional;
import junit.framework.TestCase;
import org.junit.Assert;
import org.python.pydev.json.eclipsesource.JsonValue;
import org.python.pydev.shared_core.structure.Tuple;

public class Flake8CodesConfigHandlerTest
extends TestCase {
    public void testJsonFormatError() {
        String str = "[\n    {\n        \"something\":\"anything\"\n    }\n]\n\n";
        Optional<String> errorMessage = Flake8CodesConfigHandler.checkJsonFormat(JsonValue.readFrom((String)str));
        System.out.println(errorMessage.get());
        Assert.assertNotEquals(Optional.empty(), errorMessage);
    }

    public void testJsonFormatError2() {
        String str = "{\n\"foo[\": \"ignore\"\n}";
        Optional<String> errorMessage = Flake8CodesConfigHandler.checkJsonFormat(JsonValue.readFrom((String)str));
        System.out.println(errorMessage.get());
        Assert.assertNotEquals(Optional.empty(), errorMessage);
    }

    public void testJsonFormatError3() {
        String str = "{\n\"foo%!$!@\": \"ignore\"\n}";
        Optional<String> errorMessage = Flake8CodesConfigHandler.checkJsonFormat(JsonValue.readFrom((String)str));
        System.out.println(errorMessage.get());
        Assert.assertNotEquals(Optional.empty(), errorMessage);
    }

    public void testJsonFormatError4() {
        String str = "{\n\"foo[]\": \"ignore\"\n}";
        Optional<String> errorMessage = Flake8CodesConfigHandler.checkJsonFormat(JsonValue.readFrom((String)str));
        System.out.println(errorMessage.get());
        Assert.assertNotEquals(Optional.empty(), errorMessage);
    }

    public void testJsonFormatError5() {
        String str = "{\n\"foo]\": \"ignore\"\n}";
        Optional<String> errorMessage = Flake8CodesConfigHandler.checkJsonFormat(JsonValue.readFrom((String)str));
        System.out.println(errorMessage.get());
        Assert.assertNotEquals(Optional.empty(), errorMessage);
    }

    public void testJsonFormatError6() {
        String str = "{\n\"foo[-1, 100]\": 0,\n\"foo[-1, 300]\": 1\n}";
        Optional<String> errorMessage = Flake8CodesConfigHandler.checkJsonFormat(JsonValue.readFrom((String)str));
        System.out.println(errorMessage.get());
        Assert.assertNotEquals(Optional.empty(), errorMessage);
    }

    public void testJsonFormatError7() {
        String str = "{\n\"foo[100, 300]\": 0,\n\"foo[200, 400]\": 1\n}";
        Optional<String> errorMessage = Flake8CodesConfigHandler.checkJsonFormat(JsonValue.readFrom((String)str));
        System.out.println(errorMessage.get());
        Assert.assertNotEquals(Optional.empty(), errorMessage);
    }

    public void testJsonFormatError8() {
        String str = "{\n\"foo[100, 300]\": 0,\n\"foo[200, -1]\": 1\n}";
        Optional<String> errorMessage = Flake8CodesConfigHandler.checkJsonFormat(JsonValue.readFrom((String)str));
        System.out.println(errorMessage.get());
        Assert.assertNotEquals(Optional.empty(), errorMessage);
    }

    public void testJsonFormatError9() {
        String str = "{\n\"foo[100, -1]\": 0,\n\"foo[200, 300]\": 1\n}";
        Optional<String> errorMessage = Flake8CodesConfigHandler.checkJsonFormat(JsonValue.readFrom((String)str));
        System.out.println(errorMessage.get());
        Assert.assertNotEquals(Optional.empty(), errorMessage);
    }

    public void testJsonFormatError10() {
        String str = "{\n\"foo[-1, -1]\": 0,\n\"foo[-1, -1]\": 1\n}";
        Optional<String> errorMessage = Flake8CodesConfigHandler.checkJsonFormat(JsonValue.readFrom((String)str));
        System.out.println(errorMessage.get());
        Assert.assertNotEquals(Optional.empty(), errorMessage);
    }

    public void testJsonFormatError11() {
        String str = "{\n\"foo[200, 300]\": 0,\n\"foo[300, 400]\": 1\n}";
        Optional<String> errorMessage = Flake8CodesConfigHandler.checkJsonFormat(JsonValue.readFrom((String)str));
        System.out.println(errorMessage.get());
        Assert.assertNotEquals(Optional.empty(), errorMessage);
    }

    public void testJsonFormatError12() {
        String str = "{\n\"foo[200, 200]\": 0,\n\"foo200\": 1\n}";
        Optional<String> errorMessage = Flake8CodesConfigHandler.checkJsonFormat(JsonValue.readFrom((String)str));
        System.out.println(errorMessage.get());
        Assert.assertNotEquals(Optional.empty(), errorMessage);
    }

    public void testJsonFormatError13() {
        String str = "{\n\"foo[200, 300]\": 0,\n\"foo250\": 1\n}";
        Optional<String> errorMessage = Flake8CodesConfigHandler.checkJsonFormat(JsonValue.readFrom((String)str));
        System.out.println(errorMessage.get());
        Assert.assertNotEquals(Optional.empty(), errorMessage);
    }

    public void testJsonFormatError14() {
        String str = "{\n\"foo-1\": 0\n}";
        Optional<String> errorMessage = Flake8CodesConfigHandler.checkJsonFormat(JsonValue.readFrom((String)str));
        System.out.println(errorMessage.get());
        Assert.assertNotEquals(Optional.empty(), errorMessage);
    }

    public void testJsonFormatError15() {
        String str = "{\n\"foo\": 0,\n\"foo\": 1\n}";
        Optional<String> errorMessage = Flake8CodesConfigHandler.checkJsonFormat(JsonValue.readFrom((String)str));
        System.out.println(errorMessage.get());
        Assert.assertNotEquals(Optional.empty(), errorMessage);
    }

    public void testJsonFormatError16() {
        String str = "{\n\"foo\": 10\n}";
        Optional<String> errorMessage = Flake8CodesConfigHandler.checkJsonFormat(JsonValue.readFrom((String)str));
        System.out.println(errorMessage.get());
        Assert.assertNotEquals(Optional.empty(), errorMessage);
    }

    public void testJsonFormatError17() {
        String str = "{\n\"foo\": -2\n}";
        Optional<String> errorMessage = Flake8CodesConfigHandler.checkJsonFormat(JsonValue.readFrom((String)str));
        System.out.println(errorMessage.get());
        Assert.assertNotEquals(Optional.empty(), errorMessage);
    }

    public void testJsonFormatError18() {
        String str = "{\n\"foo\": \"ingnore\"\n}";
        Optional<String> errorMessage = Flake8CodesConfigHandler.checkJsonFormat(JsonValue.readFrom((String)str));
        System.out.println(errorMessage.get());
        Assert.assertNotEquals(Optional.empty(), errorMessage);
    }

    public void testJsonFormatError19() {
        String str = "{\n\"foo[200, 100]\": 0\n}";
        Optional<String> errorMessage = Flake8CodesConfigHandler.checkJsonFormat(JsonValue.readFrom((String)str));
        System.out.println(errorMessage.get());
        Assert.assertNotEquals(Optional.empty(), errorMessage);
    }

    public void testJsonFormatError20() {
        String str = "{\n\"foo[200, 100]\": 0\n}";
        Optional<String> errorMessage = Flake8CodesConfigHandler.checkJsonFormat(JsonValue.readFrom((String)str));
        System.out.println(errorMessage.get());
        Assert.assertNotEquals(Optional.empty(), errorMessage);
    }

    public void testJsonFormatError21() {
        String str = "{\n\"foo[200, 100]\": \"\"\n}";
        Optional<String> errorMessage = Flake8CodesConfigHandler.checkJsonFormat(JsonValue.readFrom((String)str));
        System.out.println(errorMessage.get());
        Assert.assertNotEquals(Optional.empty(), errorMessage);
    }

    public void testJsonFormatNoError() {
        String str = "{\n\"foo[100, -1]\": 0,\n\"foo[-1, 99]\": 1\n}";
        Flake8CodesConfigHandlerTest.assertEquals(Optional.empty(), Flake8CodesConfigHandler.checkJsonFormat(JsonValue.readFrom((String)str)));
    }

    public void testJsonFormatNoError2() {
        String str = "{\n\"foo[-1, 100]\": 0,\n\"foo[101, -1]\": 1\n}";
        Flake8CodesConfigHandlerTest.assertEquals(Optional.empty(), Flake8CodesConfigHandler.checkJsonFormat(JsonValue.readFrom((String)str)));
    }

    public void testJsonFormatNoError3() {
        String str = "{\n\"foo[100, 200]\": 0,\n\"foo[201, 400]\": 1\n}";
        Flake8CodesConfigHandlerTest.assertEquals(Optional.empty(), Flake8CodesConfigHandler.checkJsonFormat(JsonValue.readFrom((String)str)));
    }

    public void testJsonFormatNoError4() {
        String str = "{\n\"foo[-1, -1]\": 0,\n\"foo[100, 400]\": 1\n}";
        Flake8CodesConfigHandlerTest.assertEquals(Optional.empty(), Flake8CodesConfigHandler.checkJsonFormat(JsonValue.readFrom((String)str)));
    }

    public void testJsonFormatNoError5() {
        String str = "{\n\"foo99\": 0,\n\"foo[100, 400]\": 1\n}";
        Flake8CodesConfigHandlerTest.assertEquals(Optional.empty(), Flake8CodesConfigHandler.checkJsonFormat(JsonValue.readFrom((String)str)));
    }

    public void testJsonFormatNoError6() {
        String str = "{\n\"foo\": 0,\n\"foo[100, 400]\": 1\n}";
        Flake8CodesConfigHandlerTest.assertEquals(Optional.empty(), Flake8CodesConfigHandler.checkJsonFormat(JsonValue.readFrom((String)str)));
    }

    public void testJsonFormatNoError7() {
        String str = "{\n\"foo\": 1,\n\"foo[100, 400]\": 2\n}";
        Flake8CodesConfigHandlerTest.assertEquals(Optional.empty(), Flake8CodesConfigHandler.checkJsonFormat(JsonValue.readFrom((String)str)));
    }

    public void testJsonFormatNoError8() {
        String str = "{\n\"foo\": \"ignore\",\n\"foo[100, 400]\": \"info\"\n}";
        Flake8CodesConfigHandlerTest.assertEquals(Optional.empty(), Flake8CodesConfigHandler.checkJsonFormat(JsonValue.readFrom((String)str)));
    }

    public void testJsonFormatNoError9() {
        String str = "{\n\"foo\": \"warning\",\n\"foo[100, 400]\": \"error\"\n}";
        Flake8CodesConfigHandlerTest.assertEquals(Optional.empty(), Flake8CodesConfigHandler.checkJsonFormat(JsonValue.readFrom((String)str)));
    }

    public void testRangeOverlap() {
        Tuple range1 = new Tuple((Object)0, (Object)100);
        Tuple range2 = new Tuple((Object)0, (Object)100);
        Flake8CodesConfigHandlerTest.assertTrue((boolean)Flake8CodesConfigHandler.checkRangeOverlap((Tuple<Integer, Integer>)range1, (Tuple<Integer, Integer>)range2));
    }

    public void testRangeOverlap2() {
        Tuple range1 = new Tuple((Object)100, (Object)200);
        Tuple range2 = new Tuple((Object)-1, (Object)300);
        Flake8CodesConfigHandlerTest.assertTrue((boolean)Flake8CodesConfigHandler.checkRangeOverlap((Tuple<Integer, Integer>)range1, (Tuple<Integer, Integer>)range2));
    }

    public void testRangeOverlap3() {
        Tuple range1 = new Tuple((Object)-1, (Object)300);
        Tuple range2 = new Tuple((Object)100, (Object)200);
        Flake8CodesConfigHandlerTest.assertTrue((boolean)Flake8CodesConfigHandler.checkRangeOverlap((Tuple<Integer, Integer>)range1, (Tuple<Integer, Integer>)range2));
    }

    public void testRangeOverlap4() {
        Tuple range1 = new Tuple((Object)-1, (Object)-1);
        Tuple range2 = new Tuple((Object)100, (Object)200);
        Flake8CodesConfigHandlerTest.assertTrue((boolean)Flake8CodesConfigHandler.checkRangeOverlap((Tuple<Integer, Integer>)range1, (Tuple<Integer, Integer>)range2));
    }

    public void testRangeOverlap5() {
        Tuple range1 = new Tuple((Object)100, (Object)200);
        Tuple range2 = new Tuple((Object)-1, (Object)-1);
        Flake8CodesConfigHandlerTest.assertTrue((boolean)Flake8CodesConfigHandler.checkRangeOverlap((Tuple<Integer, Integer>)range1, (Tuple<Integer, Integer>)range2));
    }

    public void testRangeOverlap6() {
        Tuple range1 = new Tuple((Object)100, (Object)200);
        Tuple range2 = new Tuple((Object)150, (Object)180);
        Flake8CodesConfigHandlerTest.assertTrue((boolean)Flake8CodesConfigHandler.checkRangeOverlap((Tuple<Integer, Integer>)range1, (Tuple<Integer, Integer>)range2));
    }

    public void testRangeOverlap7() {
        Tuple range1 = new Tuple((Object)150, (Object)180);
        Tuple range2 = new Tuple((Object)100, (Object)200);
        Flake8CodesConfigHandlerTest.assertTrue((boolean)Flake8CodesConfigHandler.checkRangeOverlap((Tuple<Integer, Integer>)range1, (Tuple<Integer, Integer>)range2));
    }

    public void testRangeOverlap8() {
        Tuple range1 = new Tuple((Object)50, (Object)150);
        Tuple range2 = new Tuple((Object)100, (Object)200);
        Flake8CodesConfigHandlerTest.assertTrue((boolean)Flake8CodesConfigHandler.checkRangeOverlap((Tuple<Integer, Integer>)range1, (Tuple<Integer, Integer>)range2));
    }

    public void testRangeOverlap9() {
        Tuple range1 = new Tuple((Object)100, (Object)200);
        Tuple range2 = new Tuple((Object)50, (Object)150);
        Flake8CodesConfigHandlerTest.assertTrue((boolean)Flake8CodesConfigHandler.checkRangeOverlap((Tuple<Integer, Integer>)range1, (Tuple<Integer, Integer>)range2));
    }

    public void testRangeOverlap10() {
        Tuple range1 = new Tuple((Object)100, (Object)-1);
        Tuple range2 = new Tuple((Object)101, (Object)150);
        Flake8CodesConfigHandlerTest.assertTrue((boolean)Flake8CodesConfigHandler.checkRangeOverlap((Tuple<Integer, Integer>)range1, (Tuple<Integer, Integer>)range2));
    }

    public void testRangeOverlap11() {
        Tuple range1 = new Tuple((Object)-1, (Object)100);
        Tuple range2 = new Tuple((Object)50, (Object)50);
        Flake8CodesConfigHandlerTest.assertTrue((boolean)Flake8CodesConfigHandler.checkRangeOverlap((Tuple<Integer, Integer>)range1, (Tuple<Integer, Integer>)range2));
    }

    public void testRangeOverlap12() {
        Tuple range1 = new Tuple((Object)50, (Object)50);
        Tuple range2 = new Tuple((Object)-1, (Object)100);
        Flake8CodesConfigHandlerTest.assertTrue((boolean)Flake8CodesConfigHandler.checkRangeOverlap((Tuple<Integer, Integer>)range1, (Tuple<Integer, Integer>)range2));
    }

    public void testRangeNoOverlap() {
        Tuple range1 = new Tuple((Object)0, (Object)50);
        Tuple range2 = new Tuple((Object)51, (Object)100);
        Flake8CodesConfigHandlerTest.assertFalse((boolean)Flake8CodesConfigHandler.checkRangeOverlap((Tuple<Integer, Integer>)range1, (Tuple<Integer, Integer>)range2));
    }

    public void testRangeNoOverlap2() {
        Tuple range1 = new Tuple((Object)51, (Object)100);
        Tuple range2 = new Tuple((Object)0, (Object)50);
        Flake8CodesConfigHandlerTest.assertFalse((boolean)Flake8CodesConfigHandler.checkRangeOverlap((Tuple<Integer, Integer>)range1, (Tuple<Integer, Integer>)range2));
    }

    public void testRangeNoOverlap3() {
        Tuple range1 = new Tuple((Object)-1, (Object)50);
        Tuple range2 = new Tuple((Object)51, (Object)100);
        Flake8CodesConfigHandlerTest.assertFalse((boolean)Flake8CodesConfigHandler.checkRangeOverlap((Tuple<Integer, Integer>)range1, (Tuple<Integer, Integer>)range2));
    }

    public void testRangeNoOverlap4() {
        Tuple range1 = new Tuple((Object)51, (Object)100);
        Tuple range2 = new Tuple((Object)-1, (Object)50);
        Flake8CodesConfigHandlerTest.assertFalse((boolean)Flake8CodesConfigHandler.checkRangeOverlap((Tuple<Integer, Integer>)range1, (Tuple<Integer, Integer>)range2));
    }

    public void testRangeNoOverlap5() {
        Tuple range1 = new Tuple((Object)0, (Object)50);
        Tuple range2 = new Tuple((Object)51, (Object)-1);
        Flake8CodesConfigHandlerTest.assertFalse((boolean)Flake8CodesConfigHandler.checkRangeOverlap((Tuple<Integer, Integer>)range1, (Tuple<Integer, Integer>)range2));
    }

    public void testRangeNoOverlap6() {
        Tuple range1 = new Tuple((Object)51, (Object)-1);
        Tuple range2 = new Tuple((Object)0, (Object)50);
        Flake8CodesConfigHandlerTest.assertFalse((boolean)Flake8CodesConfigHandler.checkRangeOverlap((Tuple<Integer, Integer>)range1, (Tuple<Integer, Integer>)range2));
    }
}

