/*
 * Decompiled with CFR 0.152.
 */
package com.python.pydev.analysis.mypy;

import com.python.pydev.analysis.mypy.MypyAnalysis;
import java.io.File;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import junit.framework.TestCase;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.python.pydev.shared_core.io.FileUtils;
import org.python.pydev.shared_core.markers.PyMarkerUtils;
import org.python.pydev.shared_core.resource_stubs.FileStub;
import org.python.pydev.shared_core.resource_stubs.IProjectStub;
import org.python.pydev.shared_core.resource_stubs.ProjectStub;

public class MypyAnalysisTest
extends TestCase {
    private File tempDir;
    private FileStub file;

    protected void setUp() throws Exception {
        super.setUp();
        this.tempDir = FileUtils.getTempFileAt((File)new File("."), (String)"data_mypy_analysis");
        this.tempDir.mkdirs();
        ProjectStub project = new ProjectStub(this.tempDir, null);
        this.file = new FileStub((IProjectStub)project, new File(this.tempDir, "snippet.py"));
    }

    public void testMarkersMessage() {
        Document document = new Document("from typing import Protocol\n\n\nclass IBar(Protocol):\n\n    def bar(self) -> bool:\n        pass\n\n    def foo(self) -> bool:\n        pass\n\n\nclass NotBar(object):\n\n    def bar(self) -> int:\n        pass\n\n    def foo(self) -> int:\n        pass\n\n\ndef call(a:IBar) -> IBar:\n    pass\n\n\nx:IBar = NotBar()");
        MypyAnalysis mypyAnalysis = new MypyAnalysis((IResource)this.file, (IDocument)document, null, (IProgressMonitor)new NullProgressMonitor(), null);
        String output = "snippet.py:26:11: error: Incompatible types in assignment (expression has type \"NotBar\", variable has type \"IBar\")\nsnippet.py:26:11: note: Following member(s) of \"NotBar\" have conflicts:\nsnippet.py:26:11: note:     Expected:\nsnippet.py:26:11: note:         def bar(self) -> bool\nsnippet.py:26:11: note:     Got:\nsnippet.py:26:11: note:         def bar(self) -> int\nsnippet.py:26:11: note:     Expected:\nsnippet.py:26:11: note:         def foo(self) -> bool\nsnippet.py:26:11: note:     Got:\nsnippet.py:26:11: note:         def foo(self) -> int\nFound 1 error in 1 file (checked 1 source file)\n";
        mypyAnalysis.afterRunProcess(output, "", null);
        MypyAnalysisTest.assertEquals((int)1, (int)mypyAnalysis.getMarkers((IResource)this.file).size());
        String expected = "Mypy: Incompatible types in assignment (expression has type \"NotBar\", variable has type \"IBar\")\nFollowing member(s) of \"NotBar\" have conflicts:\nExpected:\ndef bar(self) -> bool\nGot:\ndef bar(self) -> int\nExpected:\ndef foo(self) -> bool\nGot:\ndef foo(self) -> int";
        MypyAnalysisTest.assertEquals((String)expected, (String)mypyAnalysis.getMarkers((IResource)this.file).get((int)0).message);
    }

    public void testMarkersMessageWithoutCol() {
        Document document = new Document("from typing import Protocol\n\n\nclass IBar(Protocol):\n\n    def bar(self) -> bool:\n        pass\n\n    def foo(self) -> bool:\n        pass\n\n\nclass NotBar(object):\n\n    def bar(self) -> int:\n        pass\n\n    def foo(self) -> int:\n        pass\n\n\ndef call(a:IBar) -> IBar:\n    pass\n\n\nx:IBar = NotBar()");
        MypyAnalysis mypyAnalysis = new MypyAnalysis((IResource)this.file, (IDocument)document, null, (IProgressMonitor)new NullProgressMonitor(), null);
        String output = "snippet.py:26: error: Incompatible types in assignment (expression has type \"NotBar\", variable has type \"IBar\")\nsnippet.py:26:11: note: Following member(s) of \"NotBar\" have conflicts:\nsnippet.py:26:11: note:     Expected:\nsnippet.py:26:11: note:         def bar(self) -> bool\nsnippet.py:26:11: note:     Got:\nsnippet.py:26:11: note:         def bar(self) -> int\nsnippet.py:26:11: note:     Expected:\nsnippet.py:26:11: note:         def foo(self) -> bool\nsnippet.py:26:11: note:     Got:\nsnippet.py:26:11: note:         def foo(self) -> int\nFound 1 error in 1 file (checked 1 source file)\n";
        mypyAnalysis.afterRunProcess(output, "", null);
        MypyAnalysisTest.assertEquals((int)2, (int)mypyAnalysis.getMarkers((IResource)this.file).size());
        String expected1 = "Mypy: Following member(s) of \"NotBar\" have conflicts:\nExpected:\ndef bar(self) -> bool\nGot:\ndef bar(self) -> int\nExpected:\ndef foo(self) -> bool\nGot:\ndef foo(self) -> int";
        String expected2 = "Mypy: Incompatible types in assignment (expression has type \"NotBar\", variable has type \"IBar\")";
        List<PyMarkerUtils.MarkerInfo> markers = mypyAnalysis.getMarkers((IResource)this.file);
        HashSet<String> s = new HashSet<String>();
        s.add(expected1);
        s.add(expected2);
        MypyAnalysisTest.assertEquals(s, new HashSet<String>(Arrays.asList(markers.get((int)0).message, markers.get((int)1).message)));
    }

    public void testMarkersMessageWithoutCol2() {
        Document document = new Document("def method(a: int):\n    pass\n\nmethod('')  # type: ignore -- error due to this comment\nmethod('')  # This is not reported due to the invalid type ignore in the other line");
        MypyAnalysis mypyAnalysis = new MypyAnalysis((IResource)this.file, (IDocument)document, null, (IProgressMonitor)new NullProgressMonitor(), null);
        String output = "snippet.py:4: error: Invalid \"type: ignore\" comment";
        mypyAnalysis.afterRunProcess(output, "", null);
        MypyAnalysisTest.assertEquals((int)1, (int)mypyAnalysis.getMarkers((IResource)this.file).size());
        String expected = "Mypy: Invalid \"type: ignore\" comment";
        MypyAnalysisTest.assertEquals((String)expected, (String)mypyAnalysis.getMarkers((IResource)this.file).get((int)0).message);
    }

    public void testMarkersMessage2() {
        Document document = new Document("from typing import Protocol\n\n\nclass IBar(Protocol):\n\n    def bar(self) -> bool:\n        pass\n\n    def foo(self) -> bool:\n        pass\n\n\nclass NotBar(object):\n\n    def bar(self) -> int:\n        pass\n\n    def foo(self) -> int:\n        pass\n\n\ndef call(a:IBar) -> IBar:\n    pass\n\n\nx:IBar = NotBar() # noqa");
        MypyAnalysis mypyAnalysis = new MypyAnalysis((IResource)this.file, (IDocument)document, null, (IProgressMonitor)new NullProgressMonitor(), null);
        String output = "snippet.py:26:11: error: Incompatible types in assignment (expression has type \"NotBar\", variable has type \"IBar\")\nsnippet.py:26:11: note: Following member(s) of \"NotBar\" have conflicts:\nsnippet.py:26:11: note:     Expected:\nsnippet.py:26:11: note:         def bar(self) -> bool\nsnippet.py:26:11: note:     Got:\nsnippet.py:26:11: note:         def bar(self) -> int\nsnippet.py:26:11: note:     Expected:\nsnippet.py:26:11: note:         def foo(self) -> bool\nsnippet.py:26:11: note:     Got:\nsnippet.py:26:11: note:         def foo(self) -> int\nFound 1 error in 1 file (checked 1 source file)\n";
        mypyAnalysis.afterRunProcess(output, "", null);
        MypyAnalysisTest.assertEquals((int)0, (int)mypyAnalysis.getMarkers((IResource)this.file).size());
    }

    public void testMessagesFromAnotherFile() {
        Document document = new Document("some_variable = 10");
        Path docPath = new Path("/sample/src/package1/module1.py");
        MypyAnalysis mypyAnalysis = new MypyAnalysis((IResource)this.file, (IDocument)document, (IPath)docPath, (IProgressMonitor)new NullProgressMonitor(), null);
        String output = " src\\package1-stubs\\__init__.pyi:10:1: error: Name 'logger' already defined on line 9\nFound 1 error in 1 file (checked 1 source file)\n";
        mypyAnalysis.afterRunProcess(output, "", null);
        MypyAnalysisTest.assertEquals((int)0, (int)mypyAnalysis.getMarkers((IResource)this.file).size());
    }
}

