/*
 * Decompiled with CFR 0.152.
 */
package com.python.pydev.analysis.mypy;

import com.python.pydev.analysis.external.IExternalCodeAnalysisStream;
import java.io.File;
import java.net.MalformedURLException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.python.pydev.core.log.Log;
import org.python.pydev.core.preferences.PyScopedPreferences;
import org.python.pydev.plugin.nature.PythonNature;
import org.python.pydev.shared_core.callbacks.ICallback;

public class MypyPreferences {
    public static final String MYPY_FILE_LOCATION = "MYPY_FILE_LOCATION";
    public static final String USE_MYPY = "USE_MYPY";
    public static final boolean DEFAULT_USE_MYPY = false;
    public static final String MYPY_USE_CONSOLE = "MYPY_USE_CONSOLE";
    public static final boolean DEFAULT_MYPY_USE_CONSOLE = false;
    public static final String MYPY_ADD_PROJECT_FOLDERS_TO_MYPYPATH = "MYPY_ADD_PROJECT_FOLDERS_TO_MYPYPATH";
    public static final boolean DEFAULT_MYPY_ADD_PROJECT_FOLDERS_TO_MYPYPATH = true;
    public static final String SEARCH_MYPY_LOCATION = "SEARCH_MYPY_LOCATION";
    public static final String LOCATION_SEARCH = "SEARCH";
    public static final String LOCATION_SPECIFY = "SPECIFY";
    public static final String DEFAULT_SEARCH_MYPY_LOCATION = "SEARCH";
    public static final String MYPY_ARGS = "MYPY_ARGS";
    public static final String DEFAULT_MYPY_ARGS = "--follow-imports=silent --show-column-numbers";
    public static ICallback<IExternalCodeAnalysisStream, IAdaptable> createMypyStream = projectAdaptable -> null;

    public static boolean useMypy(IAdaptable projectAdaptable) {
        return PyScopedPreferences.getBoolean((String)USE_MYPY, (IAdaptable)projectAdaptable);
    }

    public static boolean useMypyConsole(IAdaptable projectAdaptable) {
        return PyScopedPreferences.getBoolean((String)MYPY_USE_CONSOLE, (IAdaptable)projectAdaptable);
    }

    public static boolean getAddProjectFoldersToMyPyPath(IAdaptable projectAdaptable) {
        return PyScopedPreferences.getBoolean((String)MYPY_ADD_PROJECT_FOLDERS_TO_MYPYPATH, (IAdaptable)projectAdaptable);
    }

    public static String getMypyArgs(IAdaptable projectAdaptable) {
        return PyScopedPreferences.getString((String)MYPY_ARGS, (IAdaptable)projectAdaptable);
    }

    public static File getMypyLocation(PythonNature pythonNature) {
        String searchlocation;
        IProject project = pythonNature.getProject();
        switch (searchlocation = PyScopedPreferences.getString((String)SEARCH_MYPY_LOCATION, (IAdaptable)project)) {
            case "SPECIFY": {
                return new File(PyScopedPreferences.getString((String)MYPY_FILE_LOCATION, (IAdaptable)project));
            }
        }
        try {
            return pythonNature.getProjectInterpreter().searchExecutableForInterpreter("mypy", false);
        }
        catch (Exception e) {
            Log.log((Throwable)e);
            return null;
        }
    }

    public static IExternalCodeAnalysisStream getConsoleOutputStream(IAdaptable projectAdaptable) throws MalformedURLException {
        return (IExternalCodeAnalysisStream)createMypyStream.call((Object)projectAdaptable);
    }
}

