/*
 * Decompiled with CFR 0.152.
 */
package com.python.pydev.analysis.pep8;

import com.python.pydev.analysis.AnalysisPreferences;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.python.pydev.ast.analysis.IAnalysisPreferences;
import org.python.pydev.ast.analysis.messages.IMessage;
import org.python.pydev.ast.analysis.messages.Message;
import org.python.pydev.ast.codecompletion.revisited.modules.SourceModule;
import org.python.pydev.core.CheckAnalysisErrors;
import org.python.pydev.core.CorePlugin;
import org.python.pydev.core.docutils.PySelection;
import org.python.pydev.core.log.Log;
import org.python.pydev.core.pep8.Pep8Runner;
import org.python.pydev.shared_core.jython.JythonPep8Core;
import org.python.pydev.shared_core.string.StringUtils;

public class Pep8Visitor {
    private final List<IMessage> messages = new ArrayList<IMessage>();
    private IAnalysisPreferences prefs;
    private IDocument document;
    private String messageToIgnore;

    public List<IMessage> getMessages(SourceModule module, IDocument document, IProgressMonitor monitor, IAnalysisPreferences prefs) {
        try {
            if (prefs.getSeverityForType(15) < 1) {
                return this.messages;
            }
            this.prefs = prefs;
            this.document = document;
            this.messageToIgnore = prefs.getRequiredMessageToIgnore(15);
            File pep8Loc = CorePlugin.getPep8Location();
            if (pep8Loc == null) {
                Log.log((String)"Unable to get pycodestyle module.");
                return this.messages;
            }
            IAdaptable projectAdaptable = prefs.getProjectAdaptable();
            if (AnalysisPreferences.useSystemInterpreter(projectAdaptable) || !JythonPep8Core.isAnalyzeCallbackSet()) {
                String parameters = AnalysisPreferences.getPep8CommandLineAsStr(projectAdaptable);
                String output = Pep8Runner.runWithPep8BaseScript((IDocument)document, (String)parameters, (String)"pycodestyle.py");
                if (output == null) {
                    output = "";
                }
                List splitInLines = StringUtils.splitInLines((String)output, (boolean)false);
                for (String line : splitInLines) {
                    try {
                        List lst = StringUtils.split((String)line, (char)':', (int)4);
                        int lineNumber = Integer.parseInt((String)lst.get(1));
                        int offset = Integer.parseInt((String)lst.get(2)) - 1;
                        String text = (String)lst.get(3);
                        this.reportError(lineNumber, offset, text, null);
                    }
                    catch (Exception e) {
                        Log.log((String)("Error parsing line: " + line), (Throwable)e);
                    }
                }
                return this.messages;
            }
            String[] pep8CommandLine = AnalysisPreferences.getPep8CommandLine(projectAdaptable);
            boolean useConsole = AnalysisPreferences.useConsole(projectAdaptable);
            new JythonPep8Core(module.getFile().getAbsolutePath(), document, useConsole, (Object)this, pep8CommandLine).analyze();
        }
        catch (Exception e) {
            Log.log((String)("Error analyzing: " + module), (Throwable)e);
        }
        return this.messages;
    }

    public void reportError(int lineNumber, int offset, String text, Object check) {
        int startLine;
        String line;
        int len;
        try {
            len = this.document.getLineLength(lineNumber - 1);
        }
        catch (BadLocationException e) {
            return;
        }
        if (this.messageToIgnore != null && CheckAnalysisErrors.isCodeAnalysisErrorHandled((String)(line = PySelection.getLine((IDocument)this.document, (int)(startLine = lineNumber - 1))), (String)this.messageToIgnore)) {
            return;
        }
        this.messages.add((IMessage)new Message(15, (Object)text, lineNumber, lineNumber, offset + 1, len, this.prefs));
    }
}

