/*
 * Decompiled with CFR 0.152.
 */
package com.python.pydev.analysis.pylint;

import com.python.pydev.analysis.pylint.PyLintAnalysis;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import junit.framework.TestCase;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.python.pydev.core.IInterpreterInfo;
import org.python.pydev.core.MisconfigurationException;
import org.python.pydev.core.PythonNatureWithoutProjectException;
import org.python.pydev.core.preferences.PydevPrefs;
import org.python.pydev.shared_core.io.FileUtils;
import org.python.pydev.shared_core.markers.PyMarkerUtils;
import org.python.pydev.shared_core.resource_stubs.FileStub;
import org.python.pydev.shared_core.resource_stubs.IProjectStub;
import org.python.pydev.shared_core.resource_stubs.ProjectStub;

public class PyLintAnalysisTest
extends TestCase {
    private File tempDir;

    protected void setUp() throws Exception {
        super.setUp();
        this.tempDir = FileUtils.getTempFileAt((File)new File("."), (String)"data_pylint_analysis");
        this.tempDir.mkdirs();
    }

    public void testMarkersInfoOutput() throws IInterpreterInfo.UnableToFindExecutableException, MisconfigurationException, PythonNatureWithoutProjectException {
        ProjectStub project = new ProjectStub(this.tempDir, null);
        FileStub file = new FileStub((IProjectStub)project, new File(this.tempDir, "file.py"));
        Document document = new Document("import string\n\nshift = 3\nchoice = input(\"would you like to encode or decode?\")\nword = input(\"Please enter text\")\nletters = string.ascii_letters + string.punctuation + string.digits\nencoded = ''\nif choice == \"encode\":\n    for letter in word:\n        if letter == ' ':\n            encoded = encoded + ' '\n        else:\n            x = letters.index(letter) + shift\n            encoded=encoded + letters[x]\nif choice == \"decode\":\n    for letter in word:\n        if letter == ' ':\n            encoded = encoded + ' '\n        else:\n            x = letters.index(letter) - shift\n            encoded = encoded + letters[x]\nprint(encoded)\nprint(\"This line is really long\") # This comment is part of the long line, going over the 100 char limit");
        PyLintAnalysis pyLintAnalysis = new PyLintAnalysis((IResource)file, (IDocument)document, null, (IProgressMonitor)new NullProgressMonitor(), null);
        String output = "PyLint: The stdout of the command line is:\n ************* Module snippet\nC: 14,19: (bad-whitespace) Exactly one space required around assignment\n            encoded=encoded + letters[x]\n\n                   ^\nC: 17,25: (trailing-whitespace) Trailing whitespace\nW: 22, 0: (unnecessary-semicolon) Unnecessary semicolon\nC: 23, 0: (line-too-long) Line too long (106/100)\nC: 23, 0: (missing-final-newline) Final newline missing\nC:  1, 0: (missing-module-docstring) Missing module docstring\nC:  3, 0: (invalid-name) Constant name \"shift\" doesn't conform to UPPER_CASE naming style\nC:  7, 0: (invalid-name) Constant name \"encoded\" doesn't conform to UPPER_CASE naming style\nC: 11,12: (invalid-name) Constant name \"encoded\" doesn't conform to UPPER_CASE naming style\n\n------------------------------------------------------------------\n\nYour code has been rated at 5.50/10 (previous run: 5.26/10, +0.00)\n";
        PydevPrefs.getEclipsePreferences().putInt("SEVERITY_WARNINGS", 2);
        PydevPrefs.getEclipsePreferences().putInt("SEVERITY_CODING_STANDARD", 2);
        PydevPrefs.getEclipsePreferences().putInt("SEVERITY_REFACTOR", 2);
        pyLintAnalysis.afterRunProcess(output, "No config file found, using default configuration\n", null);
        List<PyMarkerUtils.MarkerInfo> markers = pyLintAnalysis.getMarkers((IResource)file);
        for (PyMarkerUtils.MarkerInfo marker : markers) {
            PyLintAnalysisTest.assertEquals((int)marker.lineStart, (int)marker.lineEnd);
        }
        PyLintAnalysisTest.assertEquals((int)9, (int)markers.size());
        this.assertMarkerEquals(0, 13, "bad-whitespace", "Exactly one space required around assignment", markers);
        this.assertMarkerEquals(1, 16, "trailing-whitespace", "Trailing whitespace", markers);
        this.assertMarkerEquals(2, 21, "unnecessary-semicolon", "Unnecessary semicolon", markers);
        this.assertMarkerEquals(3, 22, "line-too-long", "Line too long (106/100)", markers);
        this.assertMarkerEquals(4, 22, "missing-final-newline", "Final newline missing", markers);
        this.assertMarkerEquals(5, 0, "missing-module-docstring", "Missing module docstring", markers);
        this.assertMarkerEquals(6, 2, "invalid-name", "Constant name \"shift\" doesn't conform to UPPER_CASE naming style", markers);
        this.assertMarkerEquals(7, 6, "invalid-name", "Constant name \"encoded\" doesn't conform to UPPER_CASE naming style", markers);
        this.assertMarkerEquals(8, 10, "invalid-name", "Constant name \"encoded\" doesn't conform to UPPER_CASE naming style", markers);
    }

    private void assertMarkerEquals(int index, int line, String message_id, String message, List<PyMarkerUtils.MarkerInfo> actualMarkers) {
        PyMarkerUtils.MarkerInfo actualMarker = actualMarkers.get(index);
        PyLintAnalysisTest.assertEquals((String)(String.valueOf(index) + ": MarkerInfo lineStart"), (int)line, (int)actualMarker.lineStart);
        PyLintAnalysisTest.assertEquals((String)(String.valueOf(index) + ": MarkerInfo message_id"), (Object)message_id, actualMarker.additionalInfo.get("pylint_message_id"));
        PyLintAnalysisTest.assertEquals((String)(String.valueOf(index) + ": MarkerInfo message"), (String)("PyLint: " + message), (String)actualMarker.message);
        HashMap attribMap = actualMarker.getAsMap();
        PyLintAnalysisTest.assertEquals((String)(String.valueOf(index) + ": IMarker.LINE_NUMBER"), (Object)(line + 1), attribMap.get("lineNumber"));
    }
}

