/*
 * Decompiled with CFR 0.152.
 */
package com.python.pydev.analysis.pylint;

import com.python.pydev.analysis.external.IExternalCodeAnalysisStream;
import java.io.File;
import java.net.MalformedURLException;
import org.eclipse.core.runtime.IAdaptable;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.log.Log;
import org.python.pydev.core.preferences.PyScopedPreferences;
import org.python.pydev.shared_core.callbacks.ICallback;

public class PyLintPreferences {
    public static final String PYLINT_FILE_LOCATION = "PYLINT_FILE_LOCATION";
    public static final String USE_PYLINT = "USE_PYLINT";
    public static final boolean DEFAULT_USE_PYLINT = false;
    public static final int SEVERITY_IGNORE = -1;
    public static final String SEVERITY_ERRORS = "SEVERITY_ERRORS";
    public static final int DEFAULT_SEVERITY_ERRORS = 2;
    public static final String SEVERITY_WARNINGS = "SEVERITY_WARNINGS";
    public static final int DEFAULT_SEVERITY_WARNINGS = 1;
    public static final String SEVERITY_FATAL = "SEVERITY_FATAL";
    public static final int DEFAULT_SEVERITY_FATAL = 2;
    public static final String SEVERITY_CODING_STANDARD = "SEVERITY_CODING_STANDARD";
    public static final int DEFAULT_SEVERITY_CODING_STANDARD = -1;
    public static final String SEVERITY_REFACTOR = "SEVERITY_REFACTOR";
    public static final int DEFAULT_SEVERITY_REFACTOR = -1;
    public static final String SEVERITY_INFO = "SEVERITY_INFO";
    public static final int DEFAULT_SEVERITY_INFO = 0;
    public static final String USE_CONSOLE = "USE_CONSOLE";
    public static final boolean DEFAULT_USE_CONSOLE = false;
    public static final String SEARCH_PYLINT_LOCATION = "SEARCH_PYLINT_LOCATION";
    public static final String LOCATION_SEARCH = "SEARCH";
    public static final String LOCATION_SPECIFY = "SPECIFY";
    public static final String DEFAULT_SEARCH_PYLINT_LOCATION = "SEARCH";
    public static final String PYLINT_ARGS = "PYLINT_ARGS";
    public static final String DEFAULT_PYLINT_ARGS = "";
    public static ICallback<IExternalCodeAnalysisStream, IAdaptable> createPyLintStream = projectAdaptable -> null;

    public static boolean usePyLint(IAdaptable projectAdaptable) {
        return PyScopedPreferences.getBoolean((String)USE_PYLINT, (IAdaptable)projectAdaptable);
    }

    public static boolean useConsole(IAdaptable projectAdaptable) {
        return PyScopedPreferences.getBoolean((String)USE_CONSOLE, (IAdaptable)projectAdaptable);
    }

    public static String getPyLintArgs(IAdaptable projectAdaptable) {
        return PyScopedPreferences.getString((String)PYLINT_ARGS, (IAdaptable)projectAdaptable);
    }

    public static int wSeverity(IAdaptable projectAdaptable) {
        return PyScopedPreferences.getInt((String)SEVERITY_WARNINGS, (IAdaptable)projectAdaptable, (int)1);
    }

    public static File getPyLintLocation(IPythonNature pythonNature, IAdaptable projectAdaptable) {
        if (LOCATION_SPECIFY.equals(PyScopedPreferences.getString((String)SEARCH_PYLINT_LOCATION, (IAdaptable)projectAdaptable))) {
            return new File(PyScopedPreferences.getString((String)PYLINT_FILE_LOCATION, (IAdaptable)projectAdaptable));
        }
        try {
            return pythonNature.getProjectInterpreter().searchExecutableForInterpreter("pylint", false);
        }
        catch (Exception e) {
            Log.log((Throwable)e);
            return null;
        }
    }

    public static int eSeverity(IAdaptable projectAdaptable) {
        return PyScopedPreferences.getInt((String)SEVERITY_ERRORS, (IAdaptable)projectAdaptable, (int)2);
    }

    public static int fSeverity(IAdaptable projectAdaptable) {
        return PyScopedPreferences.getInt((String)SEVERITY_FATAL, (IAdaptable)projectAdaptable, (int)2);
    }

    public static int cSeverity(IAdaptable projectAdaptable) {
        return PyScopedPreferences.getInt((String)SEVERITY_CODING_STANDARD, (IAdaptable)projectAdaptable, (int)-1);
    }

    public static int rSeverity(IAdaptable projectAdaptable) {
        return PyScopedPreferences.getInt((String)SEVERITY_REFACTOR, (IAdaptable)projectAdaptable, (int)-1);
    }

    public static int iSeverity(IAdaptable projectAdaptable) {
        return PyScopedPreferences.getInt((String)SEVERITY_INFO, (IAdaptable)projectAdaptable, (int)0);
    }

    public static IExternalCodeAnalysisStream getConsoleOutputStream(IAdaptable projectAdaptable) throws MalformedURLException {
        return (IExternalCodeAnalysisStream)createPyLintStream.call((Object)projectAdaptable);
    }
}

