/*
 * Decompiled with CFR 0.152.
 */
package com.python.pydev.analysis.refactoring.changes;

import com.python.pydev.analysis.refactoring.changes.PyChange;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.python.pydev.shared_core.io.FileUtils;
import org.python.pydev.shared_core.string.FullRepIterable;
import org.python.pydev.shared_core.string.StringUtils;
import org.python.pydev.shared_core.utils.ArrayUtils;

public final class PyRenameResourceChange
extends PyChange {
    private final String fComment;
    private final String fNewName;
    private final IPath fResourcePath;
    private final long fStampToRestore;
    private final String fInitialName;
    private final IResource[] fCreatedFiles;
    private IContainer target;

    private PyRenameResourceChange(IPath resourcePath, String initialName, String newName, String comment, long stampToRestore, IResource[] createdFiles) {
        this.fResourcePath = resourcePath;
        this.fNewName = newName;
        this.fInitialName = initialName;
        this.fComment = comment;
        this.fStampToRestore = stampToRestore;
        this.fCreatedFiles = createdFiles;
    }

    public PyRenameResourceChange(IResource resource, String initialName, String newName, String comment, IContainer target) {
        this(resource.getFullPath(), initialName, newName, comment, -1L, new IResource[0]);
        this.target = target;
    }

    public Object getModifiedElement() {
        return this.getResource();
    }

    public String getName() {
        return StringUtils.format((String)"Change %s to %s", (Object[])new Object[]{this.fInitialName, this.fNewName});
    }

    public String getNewName() {
        return this.fNewName;
    }

    private IResource getResource() {
        return ResourcesPlugin.getWorkspace().getRoot().findMember(this.fResourcePath);
    }

    public RefactoringStatus isValid(IProgressMonitor pm) throws CoreException {
        IResource resource = this.getResource();
        if (resource == null || !resource.exists()) {
            return RefactoringStatus.createFatalErrorStatus((String)StringUtils.format((String)"Resource %s does not exist", (Object[])new Object[]{this.fResourcePath}));
        }
        return super.isValid(pm, 2);
    }

    public Change perform(IProgressMonitor pm) throws CoreException {
        try {
            IPath newPath;
            pm.beginTask(this.getName(), 1);
            IResource resource = this.getResource();
            long currentStamp = resource.getModificationStamp();
            IContainer destination = this.target != null ? this.target : PyRenameResourceChange.getDestination(resource, this.fInitialName, this.fNewName, pm);
            IResource[] createdFiles = this.createDestination(destination);
            boolean copyChildrenInsteadOfMove = false;
            if (resource.getType() == 1) {
                newPath = destination.getFullPath().append(String.valueOf(FullRepIterable.getLastPart((String)this.fNewName)) + ".py");
            } else {
                newPath = destination.getFullPath().append(FullRepIterable.getLastPart((String)this.fNewName));
                IPath fullPath = resource.getFullPath();
                if (FileUtils.isPrefixOf((IPath)fullPath, (IPath)newPath)) {
                    copyChildrenInsteadOfMove = true;
                }
            }
            if (copyChildrenInsteadOfMove) {
                IContainer container = (IContainer)resource;
                IResource[] members = container.members(true);
                IFolder folder = container.getFolder((IPath)new Path(newPath.lastSegment()));
                IFile initFile = container.getFile((IPath)new Path("__init__.py"));
                folder.create(0, true, null);
                createdFiles = (IResource[])ArrayUtils.concatArrays((Object[][])new IResource[][]{createdFiles, {folder}});
                IResource[] iResourceArray = members;
                int n = members.length;
                int n2 = 0;
                while (n2 < n) {
                    IResource member = iResourceArray[n2];
                    member.move(newPath.append(member.getFullPath().lastSegment()), 32, pm);
                    ++n2;
                }
                initFile.create((InputStream)new ByteArrayInputStream(new byte[0]), 0, null);
            } else {
                resource.move(newPath, 32, pm);
            }
            if (this.fStampToRestore != -1L) {
                IResource newResource = ResourcesPlugin.getWorkspace().getRoot().findMember(newPath);
                newResource.revertModificationStamp(this.fStampToRestore);
            }
            IResource[] iResourceArray = this.fCreatedFiles;
            int n = this.fCreatedFiles.length;
            int n3 = 0;
            while (n3 < n) {
                IResource r = iResourceArray[n3];
                r.delete(true, null);
                ++n3;
            }
            PyRenameResourceChange pyRenameResourceChange = new PyRenameResourceChange(newPath, this.fNewName, this.fInitialName, this.fComment, currentStamp, createdFiles);
            return pyRenameResourceChange;
        }
        finally {
            pm.done();
        }
    }

    private IResource[] createDestination(IContainer destination) throws CoreException {
        ArrayList<Object> lst = new ArrayList<Object>();
        if (!destination.exists()) {
            IContainer parent = destination.getParent();
            lst.addAll(Arrays.asList(this.createDestination(parent)));
            IFolder folder = parent.getFolder((IPath)new Path(destination.getFullPath().lastSegment()));
            IFile file = destination.getFile((IPath)new Path("__init__.py"));
            folder.create(0, true, null);
            file.create((InputStream)new ByteArrayInputStream(new byte[0]), 0, null);
            lst.add(file);
            lst.add(folder);
        }
        return lst.toArray(new IResource[lst.size()]);
    }

    public static IContainer getDestination(IResource initialResource, String initialName, String finalName, IProgressMonitor pm) {
        List initialParts = StringUtils.split((String)initialName, (String)".");
        List finalParts = StringUtils.split((String)finalName, (String)".");
        int startFrom = 0;
        int finalPartSize = finalParts.size();
        int initialPartSize = initialParts.size();
        String initialNamePart = (String)initialParts.remove(--initialPartSize);
        String finalNamePart = (String)finalParts.remove(--finalPartSize);
        while (startFrom < finalPartSize) {
            String initial;
            String part = (String)finalParts.get(startFrom);
            if (startFrom >= initialPartSize || !(initial = (String)initialParts.get(startFrom)).equals(part)) break;
            ++startFrom;
        }
        List createParts = finalParts.subList(startFrom, finalPartSize);
        List backtrackParts = initialParts.subList(startFrom, initialPartSize);
        Collections.reverse(backtrackParts);
        IResource resource = initialResource;
        IContainer container = resource.getParent();
        for (String string : backtrackParts) {
            container = container.getParent();
        }
        if (createParts.size() > 0) {
            container = container.getFolder((IPath)new Path(StringUtils.join((String)"/", createParts)));
        }
        return container;
    }
}

