/*
 * Decompiled with CFR 0.152.
 */
package com.python.pydev.analysis.refactoring.refactorer;

import com.python.pydev.analysis.additionalinfo.AbstractAdditionalDependencyInfo;
import com.python.pydev.analysis.additionalinfo.AbstractAdditionalTokensInfo;
import com.python.pydev.analysis.additionalinfo.AdditionalProjectInterpreterInfo;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.python.pydev.ast.refactoring.RefactoringRequest;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.MisconfigurationException;
import org.python.pydev.core.ModulesKey;
import org.python.pydev.plugin.nature.PythonNature;
import org.python.pydev.plugin.nature.SystemPythonNature;
import org.python.pydev.shared_core.io.FileUtils;
import org.python.pydev.shared_core.structure.Tuple;

public class RefactorerFindReferences {
    public static ArrayList<Tuple<List<ModulesKey>, IPythonNature>> FORCED_RETURN;

    public List<Tuple<List<ModulesKey>, IPythonNature>> findPossibleReferences(RefactoringRequest request) throws OperationCanceledException {
        String initialName = request.qualifier;
        ArrayList<Tuple<List<ModulesKey>, IPythonNature>> ret = request.getPossibleReferences(initialName);
        if (ret != null) {
            return ret;
        }
        if (FORCED_RETURN != null) {
            ret = new ArrayList<Tuple<List<ModulesKey>, IPythonNature>>();
            for (Tuple<List<ModulesKey>, IPythonNature> f : FORCED_RETURN) {
                for (ModulesKey k : (List)f.o1) {
                    String object = FileUtils.getFileContents((File)k.file);
                    if (object.indexOf(request.qualifier) == -1) continue;
                    ret.add((Tuple<List<ModulesKey>, IPythonNature>)new Tuple(Arrays.asList(k), (Object)((IPythonNature)f.o2)));
                }
            }
            return ret;
        }
        ret = new ArrayList();
        try {
            try {
                IProject project = request.nature.getProject();
                List<Tuple<AbstractAdditionalTokensInfo, IPythonNature>> infoAndNature = null;
                if (project == null) {
                    if (request.nature instanceof SystemPythonNature) {
                        SystemPythonNature systemPythonNature = (SystemPythonNature)request.nature;
                        int interpreterType = systemPythonNature.getInterpreterType();
                        List naturesRelatedTo = PythonNature.getPythonNaturesRelatedTo((int)interpreterType);
                        infoAndNature = new ArrayList<Tuple<AbstractAdditionalTokensInfo, IPythonNature>>();
                        for (IPythonNature iPythonNature : naturesRelatedTo) {
                            AbstractAdditionalDependencyInfo o1;
                            if (iPythonNature.getProject() == null || !iPythonNature.getProject().isAccessible() || (o1 = AdditionalProjectInterpreterInfo.getAdditionalInfoForProject(iPythonNature)) == null) continue;
                            infoAndNature.add((Tuple<AbstractAdditionalTokensInfo, IPythonNature>)new Tuple((Object)o1, (Object)iPythonNature));
                        }
                    }
                } else {
                    infoAndNature = AdditionalProjectInterpreterInfo.getAdditionalInfoAndNature(request.nature, false, true, true);
                }
                if (infoAndNature == null || infoAndNature.size() == 0) {
                    return ret;
                }
                request.getMonitor().beginTask("Find possible references", infoAndNature.size());
                request.getMonitor().setTaskName("Find possible references");
                try {
                    for (Tuple<AbstractAdditionalTokensInfo, IPythonNature> tuple : infoAndNature) {
                        try {
                            SubProgressMonitor sub = new SubProgressMonitor(request.getMonitor(), 1);
                            request.pushMonitor((IProgressMonitor)sub);
                            if (!(tuple.o1 instanceof AdditionalProjectInterpreterInfo) || tuple.o2 == null) continue;
                            AdditionalProjectInterpreterInfo info = (AdditionalProjectInterpreterInfo)tuple.o1;
                            List<ModulesKey> modulesWithToken = info.getModulesWithToken(initialName, (IProgressMonitor)sub);
                            if (!sub.isCanceled()) {
                                ret.add((Tuple<List<ModulesKey>, IPythonNature>)new Tuple(modulesWithToken, (Object)((IPythonNature)tuple.o2)));
                                continue;
                            }
                            break;
                        }
                        finally {
                            request.popMonitor().done();
                        }
                    }
                }
                finally {
                    request.getMonitor().done();
                }
            }
            catch (MisconfigurationException e) {
                throw new RuntimeException(e);
            }
        }
        catch (OperationCanceledException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        request.setPossibleReferences(initialName, ret);
        return ret;
    }
}

