/*
 * Decompiled with CFR 0.152.
 */
package com.python.pydev.analysis.refactoring.wizards;

import com.python.pydev.analysis.refactoring.wizards.IRefactorRenameProcess;
import com.python.pydev.analysis.refactoring.wizards.rename.PyRenameAnyLocalProcess;
import com.python.pydev.analysis.refactoring.wizards.rename.PyRenameAttributeProcess;
import com.python.pydev.analysis.refactoring.wizards.rename.PyRenameClassProcess;
import com.python.pydev.analysis.refactoring.wizards.rename.PyRenameFunctionProcess;
import com.python.pydev.analysis.refactoring.wizards.rename.PyRenameGlobalProcess;
import com.python.pydev.analysis.refactoring.wizards.rename.PyRenameImportProcess;
import com.python.pydev.analysis.refactoring.wizards.rename.PyRenameLocalProcess;
import com.python.pydev.analysis.refactoring.wizards.rename.PyRenameParameterProcess;
import com.python.pydev.analysis.refactoring.wizards.rename.PyRenameSelfAttributeProcess;
import org.python.pydev.ast.codecompletion.revisited.visitors.AssignDefinition;
import org.python.pydev.ast.codecompletion.revisited.visitors.Definition;
import org.python.pydev.ast.codecompletion.revisited.visitors.KeywordParameterDefinition;
import org.python.pydev.ast.refactoring.RefactoringRequest;
import org.python.pydev.parser.jython.SimpleNode;
import org.python.pydev.parser.jython.ast.ClassDef;
import org.python.pydev.parser.jython.ast.FunctionDef;
import org.python.pydev.parser.jython.ast.Name;
import org.python.pydev.parser.visitors.NodeUtils;
import org.python.pydev.shared_core.structure.FastStack;

public class RefactorProcessFactory {
    public static IRefactorRenameProcess getProcess(Definition definition, RefactoringRequest request) {
        if (definition instanceof AssignDefinition) {
            AssignDefinition d = (AssignDefinition)definition;
            if (d.target.indexOf(46) != -1) {
                if (d.target.startsWith("self.")) {
                    return new PyRenameSelfAttributeProcess(definition, d.target);
                }
                return new PyRenameAttributeProcess(definition, d.target);
            }
            if (definition.scope != null) {
                Object peek;
                if (definition.scope.isLastClassDef()) {
                    return new PyRenameAttributeProcess(definition, d.target);
                }
                FastStack scopeStack = definition.scope.getScopeStack();
                if (request.moduleName.equals(definition.module.getName()) && !scopeStack.empty() && (peek = scopeStack.peek()) instanceof FunctionDef) {
                    return new PyRenameLocalProcess(definition);
                }
            }
            return new PyRenameGlobalProcess(definition);
        }
        if (RefactorProcessFactory.isModuleRename(definition)) {
            return new PyRenameImportProcess(definition);
        }
        if (definition.ast != null) {
            if (definition.ast instanceof ClassDef) {
                return new PyRenameClassProcess(definition);
            }
            if (definition.ast instanceof Name) {
                Name n = (Name)definition.ast;
                if (n.ctx == 6 || n.ctx == 8) {
                    return new PyRenameParameterProcess(definition);
                }
            }
            if (definition instanceof KeywordParameterDefinition) {
                return new PyRenameParameterProcess((KeywordParameterDefinition)definition, request.nature);
            }
            if (definition.ast instanceof FunctionDef) {
                return new PyRenameFunctionProcess(definition);
            }
        }
        if (definition.scope != null) {
            Object peek;
            if (definition.scope.isLastClassDef()) {
                return new PyRenameAttributeProcess(definition, definition.value);
            }
            FastStack scopeStack = definition.scope.getScopeStack();
            if (request.moduleName.equals(definition.module.getName()) && !scopeStack.empty() && (peek = scopeStack.peek()) instanceof FunctionDef) {
                return new PyRenameLocalProcess(definition);
            }
        }
        return new PyRenameAnyLocalProcess();
    }

    public static IRefactorRenameProcess getRenameAnyProcess() {
        return new PyRenameAnyLocalProcess();
    }

    public static boolean isModuleRename(Definition definition) {
        if (definition == null) {
            return false;
        }
        if (!(definition instanceof AssignDefinition)) {
            if (NodeUtils.isImport((SimpleNode)definition.ast)) {
                return true;
            }
            if (definition.ast == null && definition.value.isEmpty()) {
                return true;
            }
        }
        return false;
    }
}

