/*
 * Decompiled with CFR 0.152.
 */
package com.python.pydev.analysis.scopeanalysis;

import com.python.pydev.analysis.scopeanalysis.TextSearchMatchAccess;
import com.python.pydev.analysis.scopeanalysis.TextSearchRequestor;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;

public class TokenMatching {
    private final ReusableMatchAccess fMatchAccess;
    private final TextSearchRequestor fCollector;
    private final CharSequence fSearchText;

    public TokenMatching(TextSearchRequestor collector, ReusableMatchAccess matchAccess, CharSequence searchText) {
        this.fCollector = collector;
        this.fMatchAccess = matchAccess;
        this.fSearchText = searchText;
    }

    public TokenMatching(TextSearchRequestor collector, CharSequence searchText) {
        this(collector, new ReusableMatchAccess(), searchText);
    }

    public TokenMatching(CharSequence searchText) {
        this(new TextSearchRequestor(){}, new ReusableMatchAccess(), searchText);
    }

    public boolean hasMatch(String searchInput) throws CoreException {
        return this.hasMatch(null, searchInput, (IProgressMonitor)new NullProgressMonitor());
    }

    public boolean hasMatch(IFile file, String searchInput, IProgressMonitor monitor) throws CoreException {
        return this.collectMatches(null, searchInput, (IProgressMonitor)new NullProgressMonitor(), true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean collectMatches(IFile file, String searchInput, IProgressMonitor monitor, boolean onlyFirstMatch) throws CoreException {
        boolean foundMatch = false;
        try {
            int k = 0;
            int total = 0;
            char prev = '\uffff';
            int searchTextLen = this.fSearchText.length();
            int searchInputLen = searchInput.length();
            try {
                int i = 0;
                while (i < searchInputLen) {
                    ++total;
                    char c = searchInput.charAt(i);
                    if (!(c != this.fSearchText.charAt(k) || k <= 0 && Character.isJavaIdentifierPart(prev))) {
                        if (++k == searchTextLen) {
                            k = 0;
                            boolean ok = false;
                            if (i + 1 == searchInputLen) {
                                ok = true;
                            } else {
                                c = searchInput.charAt(i + 1);
                                if (!Character.isJavaIdentifierPart(c)) {
                                    ok = true;
                                }
                            }
                            if (ok) {
                                this.fMatchAccess.initialize(file, i - searchTextLen + 1, searchTextLen, searchInput);
                                this.fCollector.acceptPatternMatch(this.fMatchAccess);
                                foundMatch = true;
                                if (onlyFirstMatch) {
                                    boolean bl = foundMatch;
                                    return bl;
                                }
                            }
                        }
                    } else {
                        k = 0;
                    }
                    prev = c;
                    if (total++ == 20) {
                        if (monitor.isCanceled()) {
                            throw new OperationCanceledException("Operation Canceled");
                        }
                        total = 0;
                    }
                    ++i;
                }
                return foundMatch;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                return foundMatch;
            }
        }
        finally {
            this.fMatchAccess.initialize(null, 0, 0, "");
        }
    }

    public static ArrayList<Integer> getMatchOffsets(String match, String fullString) throws CoreException {
        final ArrayList<Integer> offsets = new ArrayList<Integer>();
        TextSearchRequestor textSearchRequestor = new TextSearchRequestor(){

            @Override
            public boolean acceptPatternMatch(TextSearchMatchAccess matchAccess) throws CoreException {
                offsets.add(matchAccess.getMatchOffset());
                return true;
            }
        };
        TokenMatching matching = new TokenMatching(textSearchRequestor, match);
        matching.collectMatches(null, fullString, (IProgressMonitor)new NullProgressMonitor(), false);
        return offsets;
    }

    public static class ReusableMatchAccess
    extends TextSearchMatchAccess {
        private int fOffset;
        private int fLength;
        private IFile fFile;
        private CharSequence fContent;

        public void initialize(IFile file, int offset, int length, CharSequence content) {
            this.fFile = file;
            this.fOffset = offset;
            this.fLength = length;
            this.fContent = content;
        }

        @Override
        public IFile getFile() {
            return this.fFile;
        }

        @Override
        public int getMatchOffset() {
            return this.fOffset;
        }

        @Override
        public int getMatchLength() {
            return this.fLength;
        }

        @Override
        public int getFileContentLength() {
            return this.fContent.length();
        }

        @Override
        public char getFileContentChar(int offset) {
            return this.fContent.charAt(offset);
        }

        @Override
        public String getFileContent(int offset, int length) {
            return this.fContent.subSequence(offset, offset + length).toString();
        }
    }
}

