/*
 * Decompiled with CFR 0.152.
 */
package com.python.pydev.analysis.visitors;

import com.python.pydev.analysis.visitors.MessagesManager;
import com.python.pydev.analysis.visitors.OccurrencesVisitor;
import com.python.pydev.analysis.visitors.ZopeInterfaceComputer;
import java.util.HashMap;
import java.util.Map;
import org.python.pydev.ast.codecompletion.revisited.modules.SourceToken;
import org.python.pydev.ast.codecompletion.revisited.visitors.AbstractVisitor;
import org.python.pydev.core.ICompletionCache;
import org.python.pydev.core.IModule;
import org.python.pydev.core.IToken;
import org.python.pydev.parser.jython.SimpleNode;
import org.python.pydev.parser.jython.ast.Assign;
import org.python.pydev.parser.jython.ast.Call;
import org.python.pydev.parser.jython.ast.ClassDef;
import org.python.pydev.parser.jython.ast.FunctionDef;
import org.python.pydev.parser.jython.ast.Name;
import org.python.pydev.parser.jython.ast.decoratorsType;
import org.python.pydev.parser.jython.ast.exprType;
import org.python.pydev.parser.visitors.NodeUtils;
import org.python.pydev.shared_core.string.FastStringBuffer;
import org.python.pydev.shared_core.string.FullRepIterable;
import org.python.pydev.shared_core.structure.FastStack;
import org.python.pydev.shared_core.structure.Tuple;

public final class NoSelfChecker {
    private final FastStack<Integer> scope = new FastStack(10);
    private final FastStack<HashMap<String, Tuple<Expected, FunctionDef>>> maybeNoSelfDefinedItems = new FastStack(10);
    private FastStack<String> classBases = new FastStack(10);
    private final String moduleName;
    private final MessagesManager messagesManager;
    private final IModule module;
    private final FastStack<ZopeInterfaceComputer> zopeInterfaceComputers = new FastStack(3);
    private final ICompletionCache completionCache;

    public NoSelfChecker(OccurrencesVisitor visitor) {
        this.messagesManager = visitor.messagesManager;
        this.moduleName = visitor.moduleName;
        this.module = visitor.current;
        this.completionCache = visitor.completionCache;
        this.scope.push((Object)1);
    }

    public void beforeClassDef(ClassDef node) {
        this.scope.push((Object)4);
        this.zopeInterfaceComputers.push((Object)new ZopeInterfaceComputer(node, this.module, this.completionCache));
        FastStringBuffer buf = new FastStringBuffer();
        exprType[] exprTypeArray = node.bases;
        int n = node.bases.length;
        int n2 = 0;
        while (n2 < n) {
            exprType base = exprTypeArray[n2];
            if (base != null) {
                String rep;
                if (buf.length() > 0) {
                    buf.append(",");
                }
                if ((rep = NodeUtils.getRepresentationString((SimpleNode)base)) != null) {
                    buf.append(FullRepIterable.getLastPart((String)rep));
                }
            }
            ++n2;
        }
        this.classBases.push((Object)buf.toString());
        this.maybeNoSelfDefinedItems.push(new HashMap());
    }

    public void afterClassDef(ClassDef node) {
        this.scope.pop();
        this.zopeInterfaceComputers.pop();
        this.classBases.pop();
        this.creteMessagesForStack(this.maybeNoSelfDefinedItems);
    }

    private void creteMessagesForStack(FastStack<HashMap<String, Tuple<Expected, FunctionDef>>> stack) {
        HashMap noDefinedItems = (HashMap)stack.pop();
        for (Map.Entry entry : noDefinedItems.entrySet()) {
            Expected expected = (Expected)((Tuple)entry.getValue()).o1;
            if (expected.expected.equals(expected.received)) continue;
            SourceToken token = AbstractVisitor.makeToken((SimpleNode)((SimpleNode)((Tuple)entry.getValue()).o2), (String)this.moduleName, null);
            this.messagesManager.addMessage(7, (IToken)token, token, ((Expected)((Tuple)entry.getValue()).o1).expected);
        }
    }

    public void beforeFunctionDef(FunctionDef node) {
        if (((Integer)this.scope.peek()).equals(4)) {
            exprType arg;
            boolean startsWithSelf = false;
            boolean startsWithCls = false;
            String received = "";
            if (node.args != null && node.args.args.length > 0 && (arg = node.args.args[0]) instanceof Name) {
                Name n = (Name)arg;
                if (n.id.equals("self")) {
                    startsWithSelf = true;
                } else if (n.id.equals("cls")) {
                    startsWithCls = true;
                }
                received = n.id;
            }
            boolean isStaticMethod = false;
            boolean isClassMethod = false;
            if (node.decs != null) {
                decoratorsType[] decoratorsTypeArray = node.decs;
                int n = node.decs.length;
                int n2 = 0;
                while (n2 < n) {
                    String rep;
                    decoratorsType dec = decoratorsTypeArray[n2];
                    if (dec != null && (rep = NodeUtils.getRepresentationString((SimpleNode)dec.func)) != null) {
                        if (rep.equals("staticmethod")) {
                            isStaticMethod = true;
                        } else if (rep.equals("classmethod")) {
                            isClassMethod = true;
                        }
                    }
                    ++n2;
                }
            }
            ZopeInterfaceComputer zopeInterfaceComputer = (ZopeInterfaceComputer)this.zopeInterfaceComputers.peek();
            String rep = NodeUtils.getRepresentationString((SimpleNode)node);
            if (rep.equals("__new__")) {
                if (!(startsWithCls || startsWithSelf || zopeInterfaceComputer.isZopeInterface())) {
                    ((HashMap)this.maybeNoSelfDefinedItems.peek()).put(rep, new Tuple((Object)new Expected("self or cls", received), (Object)node));
                }
            } else if (!(startsWithSelf || startsWithCls || isStaticMethod || isClassMethod)) {
                if (!zopeInterfaceComputer.isZopeInterface()) {
                    ((HashMap)this.maybeNoSelfDefinedItems.peek()).put(rep, new Tuple((Object)new Expected("self", received), (Object)node));
                }
            } else if (startsWithCls && !isClassMethod && !isStaticMethod) {
                String classBase = (String)this.classBases.peek();
                if (!(rep.equals("__init__") && "type".equals(classBase) || zopeInterfaceComputer.isZopeInterface())) {
                    ((HashMap)this.maybeNoSelfDefinedItems.peek()).put(rep, new Tuple((Object)new Expected("self", received), (Object)node));
                }
            }
        }
        this.scope.push((Object)2);
    }

    public void afterFunctionDef(FunctionDef node) {
        this.scope.pop();
    }

    public void visitAssign(Assign node) {
        if (node.targets.length == 1) {
            exprType t = node.targets[0];
            String rep = NodeUtils.getRepresentationString((SimpleNode)t);
            if (rep == null) {
                return;
            }
            if ((Integer)this.scope.peek() != 4) {
                return;
            }
            Tuple tup = (Tuple)((HashMap)this.maybeNoSelfDefinedItems.peek()).get(rep);
            if (tup == null) {
                return;
            }
            FunctionDef def = (FunctionDef)tup.o2;
            if (def == null) {
                return;
            }
            exprType expr = node.value;
            if (expr instanceof Call) {
                String argRep;
                Call call = (Call)expr;
                if (call.args.length == 1 && (argRep = NodeUtils.getRepresentationString((SimpleNode)call.args[0])) != null && argRep.equals(rep)) {
                    String funcCall = NodeUtils.getRepresentationString((SimpleNode)call.func);
                    if (def != null && funcCall != null && funcCall.equals("staticmethod")) {
                        ((HashMap)this.maybeNoSelfDefinedItems.peek()).remove(rep);
                    } else if (funcCall != null && funcCall.equals("classmethod")) {
                        ((Expected)tup.o1).expected = "cls";
                    }
                }
            }
        }
    }

    public static class Expected {
        public String expected;
        public String received;

        public Expected(String expected, String received) {
            this.expected = expected;
            this.received = received;
        }
    }
}

