/*
 * Decompiled with CFR 0.152.
 */
package com.python.pydev.analysis.visitors;

import java.util.HashSet;
import java.util.LinkedList;
import org.python.pydev.ast.codecompletion.revisited.CompletionState;
import org.python.pydev.ast.codecompletion.revisited.visitors.Definition;
import org.python.pydev.ast.refactoring.PyRefactoringFindDefinition;
import org.python.pydev.core.ICompletionCache;
import org.python.pydev.core.ICompletionState;
import org.python.pydev.core.IDefinition;
import org.python.pydev.core.IModule;
import org.python.pydev.core.log.Log;
import org.python.pydev.parser.jython.SimpleNode;
import org.python.pydev.parser.jython.ast.ClassDef;
import org.python.pydev.parser.jython.ast.exprType;
import org.python.pydev.parser.visitors.NodeUtils;
import org.python.pydev.shared_core.structure.Tuple3;

public class ZopeInterfaceComputer {
    public final ClassDef classDef;
    private final IModule module;
    private final ICompletionCache completionCache;
    private Boolean isZopeInterface;

    public ZopeInterfaceComputer(ClassDef classDef, IModule module, ICompletionCache completionCache) {
        this.classDef = classDef;
        this.module = module;
        this.isZopeInterface = null;
        this.completionCache = completionCache;
    }

    public boolean isZopeInterface() {
        if (this.isZopeInterface != null) {
            return this.isZopeInterface;
        }
        HashSet<Tuple3> whereWePassed = new HashSet<Tuple3>();
        LinkedList<NodeAndModule> verify = new LinkedList<NodeAndModule>();
        exprType[] exprTypeArray = this.classDef.bases;
        int n = this.classDef.bases.length;
        int n2 = 0;
        while (n2 < n) {
            exprType n3 = exprTypeArray[n2];
            verify.add(new NodeAndModule((SimpleNode)n3, this.module));
            ++n2;
        }
        while (!verify.isEmpty()) {
            IDefinition[] definitions;
            NodeAndModule nodeAndModule = (NodeAndModule)verify.removeFirst();
            IDefinition[] iDefinitionArray = definitions = this.findDefinitionsForNodeAndModule(nodeAndModule);
            int n4 = definitions.length;
            int n5 = 0;
            while (n5 < n4) {
                IDefinition iDefinition = iDefinitionArray[n5];
                Definition definition = (Definition)iDefinition;
                if (this.isDefinitionZopeInterface(definition)) {
                    this.isZopeInterface = true;
                    return this.isZopeInterface;
                }
                Tuple3 tup = PyRefactoringFindDefinition.getTupFromDefinition((Definition)definition);
                if (!whereWePassed.contains(tup)) {
                    whereWePassed.add(tup);
                    if (definition.ast instanceof ClassDef && definition.module != null) {
                        ClassDef classDef2 = (ClassDef)definition.ast;
                        exprType[] exprTypeArray2 = classDef2.bases;
                        int n6 = classDef2.bases.length;
                        int n7 = 0;
                        while (n7 < n6) {
                            exprType base = exprTypeArray2[n7];
                            verify.add(new NodeAndModule((SimpleNode)base, definition.module));
                            ++n7;
                        }
                    }
                }
                ++n5;
            }
        }
        this.isZopeInterface = false;
        return this.isZopeInterface;
    }

    private IDefinition[] findDefinitionsForNodeAndModule(NodeAndModule nodeAndModule) {
        CompletionState state = new CompletionState(nodeAndModule.beginLine, nodeAndModule.beginColumn, nodeAndModule.getRep(), nodeAndModule.module.getNature(), "", this.completionCache);
        try {
            return nodeAndModule.module.findDefinition((ICompletionState)state, state.getLine() + 1, state.getCol() + 1, nodeAndModule.module.getNature());
        }
        catch (Exception e) {
            Log.log((Throwable)e);
            return new IDefinition[0];
        }
    }

    private boolean isDefinitionZopeInterface(Definition definition) {
        if (definition.module != null) {
            String moduleName = definition.module.getName();
            if ("zope.interface.__init__".equals(moduleName) && "Interface".equals(definition.value)) {
                return true;
            }
            if ("zope.interface.interface".equals(moduleName) && "Interface".equals(definition.value)) {
                return true;
            }
        }
        return false;
    }

    private static class NodeAndModule {
        public final SimpleNode node;
        public final IModule module;
        public final int beginLine;
        public final int beginColumn;

        public NodeAndModule(SimpleNode n, IModule module) {
            this.node = n;
            this.module = module;
            this.beginLine = n.beginLine;
            this.beginColumn = n.beginColumn;
        }

        public String getRep() {
            return NodeUtils.getFullRepresentationString((SimpleNode)this.node);
        }
    }
}

