/*
 * Decompiled with CFR 0.152.
 */
package com.python.pydev.codecompletion.ctxinsensitive;

import com.python.pydev.analysis.AnalysisPlugin;
import com.python.pydev.analysis.AnalysisPreferences;
import com.python.pydev.analysis.additionalinfo.AbstractAdditionalDependencyInfo;
import com.python.pydev.analysis.additionalinfo.AbstractAdditionalTokensInfo;
import com.python.pydev.analysis.additionalinfo.AdditionalProjectInterpreterInfo;
import com.python.pydev.analysis.additionalinfo.AdditionalSystemInterpreterInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.python.pydev.ast.codecompletion.CompletionRequest;
import org.python.pydev.ast.codecompletion.IPyDevCompletionParticipant;
import org.python.pydev.ast.codecompletion.IPyDevCompletionParticipant2;
import org.python.pydev.ast.codecompletion.IPyDevCompletionParticipant3;
import org.python.pydev.ast.codecompletion.ProposalsComparator;
import org.python.pydev.ast.codecompletion.PyCodeCompletionPreferences;
import org.python.pydev.ast.codecompletion.PyCodeCompletionUtils;
import org.python.pydev.ast.codecompletion.revisited.modules.SourceToken;
import org.python.pydev.ast.codecompletion.revisited.visitors.Definition;
import org.python.pydev.ast.item_pointer.ItemPointer;
import org.python.pydev.core.ICodeCompletionASTManager;
import org.python.pydev.core.ICompletionState;
import org.python.pydev.core.IDefinition;
import org.python.pydev.core.IInfo;
import org.python.pydev.core.ILocalScope;
import org.python.pydev.core.IModule;
import org.python.pydev.core.IModuleRequestState;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.IToken;
import org.python.pydev.core.IterTokenEntry;
import org.python.pydev.core.MisconfigurationException;
import org.python.pydev.core.NoExceptionCloseable;
import org.python.pydev.core.TokensList;
import org.python.pydev.core.TokensOrProposalsList;
import org.python.pydev.core.docutils.PySelection;
import org.python.pydev.core.interactive_console.IScriptConsoleViewer;
import org.python.pydev.core.log.Log;
import org.python.pydev.core.proposals.CompletionProposalFactory;
import org.python.pydev.core.structure.CompletionRecursionException;
import org.python.pydev.parser.jython.SimpleNode;
import org.python.pydev.parser.jython.ast.FunctionDef;
import org.python.pydev.parser.jython.ast.Name;
import org.python.pydev.parser.jython.ast.decoratorsType;
import org.python.pydev.parser.visitors.NodeUtils;
import org.python.pydev.plugin.nature.SystemPythonNature;
import org.python.pydev.shared_core.code_completion.ICompletionProposalHandle;
import org.python.pydev.shared_core.code_completion.IPyCompletionProposal;
import org.python.pydev.shared_core.string.FastStringBuffer;
import org.python.pydev.shared_core.string.FullRepIterable;
import org.python.pydev.shared_core.structure.FastStack;
import org.python.pydev.shared_core.structure.LinkedListWarningOnSlowOperations;

public class CtxParticipant
implements IPyDevCompletionParticipant,
IPyDevCompletionParticipant2,
IPyDevCompletionParticipant3 {
    private static final Pattern FIXTURE_PATTERN = Pattern.compile("\\bfixture\\b");
    private static final Pattern YIELD_FIXTURE_PATTERN = Pattern.compile("\\byield_fixture\\b");

    public Collection<ICompletionProposalHandle> computeConsoleCompletions(PySelection.ActivationTokenAndQualifier tokenAndQual, Set<IPythonNature> naturesUsed, IScriptConsoleViewer viewer, int requestOffset) {
        ArrayList<ICompletionProposalHandle> completions = new ArrayList<ICompletionProposalHandle>();
        if (tokenAndQual.activationToken != null && tokenAndQual.activationToken.length() > 0) {
            return completions;
        }
        String qual = tokenAndQual.qualifier;
        if (qual.length() >= PyCodeCompletionPreferences.getCharsForContextInsensitiveGlobalTokensCompletion() && naturesUsed != null && naturesUsed.size() > 0) {
            boolean addAutoImport = AnalysisPreferences.doAutoImport(null);
            int qlen = qual.length();
            boolean useSubstringMatchInCodeCompletion = PyCodeCompletionPreferences.getUseSubstringMatchInCodeCompletion();
            PyCodeCompletionUtils.IFilter nameFilter = PyCodeCompletionUtils.getNameFilter((boolean)useSubstringMatchInCodeCompletion, (String)qual);
            for (IPythonNature nature : naturesUsed) {
                try {
                    AbstractAdditionalDependencyInfo additionalInfo;
                    if (nature instanceof SystemPythonNature) {
                        SystemPythonNature systemPythonNature = (SystemPythonNature)nature;
                        additionalInfo = AdditionalSystemInterpreterInfo.getAdditionalSystemInfo(systemPythonNature.getRelatedInterpreterManager(), systemPythonNature.getProjectInterpreter().getExecutableOrJar());
                        this.fillNatureCompletionsForConsole(viewer, requestOffset, completions, qual, addAutoImport, qlen, nameFilter, nature, additionalInfo, useSubstringMatchInCodeCompletion);
                        continue;
                    }
                    additionalInfo = AdditionalProjectInterpreterInfo.getAdditionalInfoForProject(nature);
                    this.fillNatureCompletionsForConsole(viewer, requestOffset, completions, qual, addAutoImport, qlen, nameFilter, nature, additionalInfo, useSubstringMatchInCodeCompletion);
                }
                catch (MisconfigurationException e) {
                    Log.log((Throwable)e);
                }
            }
        }
        return completions;
    }

    private void fillNatureCompletionsForConsole(IScriptConsoleViewer viewer, int requestOffset, List<ICompletionProposalHandle> completions, String qual, boolean addAutoImport, int qlen, PyCodeCompletionUtils.IFilter nameFilter, IPythonNature nature, AbstractAdditionalTokensInfo additionalInfo, boolean useSubstringMatchInCodeCompletion) {
        Collection<IInfo> tokensStartingWith = useSubstringMatchInCodeCompletion ? additionalInfo.getTokensStartingWith("", 1) : additionalInfo.getTokensStartingWith(qual, 1);
        FastStringBuffer realImportRep = new FastStringBuffer();
        FastStringBuffer displayString = new FastStringBuffer();
        FastStringBuffer tempBuf = new FastStringBuffer();
        boolean doIgnoreImportsStartingWithUnder = AnalysisPreferences.doIgnoreImportsStartingWithUnder(null);
        ProposalsComparator.CompareContext compareContext = new ProposalsComparator.CompareContext(nature);
        for (IInfo info : tokensStartingWith) {
            String rep;
            String declaringModuleName = info.getDeclaringModuleName();
            boolean hasInit = false;
            if (declaringModuleName.endsWith(".__init__")) {
                declaringModuleName = declaringModuleName.substring(0, declaringModuleName.length() - 9);
                hasInit = true;
            }
            if (!nameFilter.acceptName(rep = info.getName())) continue;
            if (addAutoImport) {
                realImportRep.clear();
                realImportRep.append("from ");
                realImportRep.append(AnalysisPreferences.removeImportsStartingWithUnderIfNeeded(declaringModuleName, tempBuf, doIgnoreImportsStartingWithUnder));
                realImportRep.append(" import ");
                realImportRep.append(rep);
            }
            displayString.clear();
            displayString.append(rep);
            displayString.append(" - ");
            displayString.append(declaringModuleName);
            if (hasInit) {
                displayString.append(".__init__");
            }
            String displayAsStr = displayString.toString();
            ICompletionProposalHandle proposal = CompletionProposalFactory.get().createPyConsoleCompletion(rep, requestOffset - qlen, qlen, realImportRep.length(), info.getType(), displayAsStr, null, "", displayAsStr.equals(qual) ? 40 : 50, realImportRep.toString(), viewer, (IPyCompletionProposal.ICompareContext)compareContext);
            completions.add(proposal);
        }
    }

    private Collection<ICompletionProposalHandle> getThem(CompletionRequest request, ICompletionState state, boolean addAutoImport) throws MisconfigurationException {
        ArrayList<ICompletionProposalHandle> completions = new ArrayList<ICompletionProposalHandle>();
        if (request.isInCalltip) {
            return completions;
        }
        HashSet<String> importedNames = this.getImportedNames(state);
        String qual = request.qualifier;
        if (qual.length() >= PyCodeCompletionPreferences.getCharsForContextInsensitiveGlobalTokensCompletion()) {
            PyCodeCompletionUtils.IFilter nameFilter = PyCodeCompletionUtils.getNameFilter((boolean)request.useSubstringMatchInCodeCompletion, (String)qual);
            String initialModule = request.resolveModule();
            List<IInfo> tokensStartingWith = request.useSubstringMatchInCodeCompletion ? AdditionalProjectInterpreterInfo.getTokensStartingWith("", request.nature, 1) : AdditionalProjectInterpreterInfo.getTokensStartingWith(qual, request.nature, 1);
            FastStringBuffer realImportRep = new FastStringBuffer();
            FastStringBuffer displayString = new FastStringBuffer();
            FastStringBuffer tempBuf = new FastStringBuffer();
            IProject projectAdaptable = request.getNature() != null ? request.getNature().getProject() : null;
            boolean doIgnoreImportsStartingWithUnder = AnalysisPreferences.doIgnoreImportsStartingWithUnder((IAdaptable)projectAdaptable);
            for (IInfo info : tokensStartingWith) {
                String rep;
                String declaringModuleName = info.getDeclaringModuleName();
                if (initialModule != null && declaringModuleName != null && (initialModule.equals(declaringModuleName) || "builtins".equals(declaringModuleName) || "__builtin__".equals(declaringModuleName))) continue;
                boolean hasInit = false;
                if (declaringModuleName.endsWith(".__init__")) {
                    declaringModuleName = declaringModuleName.substring(0, declaringModuleName.length() - 9);
                    hasInit = true;
                }
                if (!nameFilter.acceptName(rep = info.getName()) || importedNames.contains(rep)) continue;
                if (addAutoImport) {
                    realImportRep.clear();
                    realImportRep.append("from ");
                    realImportRep.append(AnalysisPreferences.removeImportsStartingWithUnderIfNeeded(declaringModuleName, tempBuf, doIgnoreImportsStartingWithUnder));
                    realImportRep.append(" import ");
                    realImportRep.append(rep);
                }
                displayString.clear();
                displayString.append(rep);
                displayString.append(" - ");
                displayString.append(declaringModuleName);
                if (hasInit) {
                    displayString.append(".__init__");
                }
                String displayAsStr = displayString.toString();
                ICompletionProposalHandle proposal = CompletionProposalFactory.get().createCtxInsensitiveImportComplProposal(rep, request.documentOffset - request.qlen, request.qlen, realImportRep.length(), info.getType(), displayAsStr, null, "", displayAsStr.equals(qual) ? 40 : 50, realImportRep.toString(), (IPyCompletionProposal.ICompareContext)new ProposalsComparator.CompareContext(info.getNature()));
                completions.add(proposal);
            }
        }
        return completions;
    }

    private HashSet<String> getImportedNames(ICompletionState state) {
        TokensList tokenImportedModules = state.getTokenImportedModules();
        HashSet<String> importedNames = new HashSet<String>();
        if (tokenImportedModules != null) {
            for (IterTokenEntry entry : tokenImportedModules) {
                IToken token = entry.getToken();
                importedNames.add(token.getRepresentation());
            }
        }
        return importedNames;
    }

    public TokensOrProposalsList getGlobalCompletions(CompletionRequest request, ICompletionState state) throws MisconfigurationException {
        IProject projectAdaptable = request.getNature() != null ? request.getNature().getProject() : null;
        return new TokensOrProposalsList(this.getThem(request, state, AnalysisPreferences.doAutoImport((IAdaptable)projectAdaptable)));
    }

    public IDefinition findDefinitionForMethodParameter(Definition d, IPythonNature nature, ICompletionState completionCache) {
        if (d.ast instanceof Name) {
            ItemPointer itemPointer;
            FunctionDef functionDef;
            String representationString;
            Object peek;
            Name name = (Name)d.ast;
            if (name.ctx == 6 && d.scope != null && !d.scope.getScopeStack().empty() && (peek = d.scope.getScopeStack().peek()) instanceof FunctionDef && (representationString = NodeUtils.getRepresentationString((SimpleNode)(functionDef = (FunctionDef)peek))) != null && representationString.startsWith("test") && (itemPointer = this.findItemPointerFromPyTestFixture(nature, completionCache, name.id)) != null) {
                return itemPointer.definition;
            }
        }
        return null;
    }

    private ItemPointer findItemPointerFromPyTestFixture(IPythonNature nature, ICompletionState completionCache, String fixtureName) {
        try {
            ICodeCompletionASTManager astManager = nature.getAstManager();
            if (astManager != null) {
                List<IInfo> tokensEqualTo = AdditionalProjectInterpreterInfo.getTokensEqualTo(fixtureName, nature, 1);
                for (IInfo iInfo : tokensEqualTo) {
                    LinkedListWarningOnSlowOperations pointers = new LinkedListWarningOnSlowOperations();
                    AnalysisPlugin.getDefinitionFromIInfo((List<ItemPointer>)pointers, astManager, nature, iInfo, completionCache, true, true);
                    for (ItemPointer itemPointer : pointers) {
                        if (!(itemPointer.definition.ast instanceof FunctionDef)) continue;
                        FunctionDef functionDef = (FunctionDef)itemPointer.definition.ast;
                        if (functionDef.decs == null) continue;
                        decoratorsType[] decoratorsTypeArray = functionDef.decs;
                        int n = functionDef.decs.length;
                        int n2 = 0;
                        while (n2 < n) {
                            decoratorsType dec = decoratorsTypeArray[n2];
                            String decoratorFuncName = NodeUtils.getRepresentationString((SimpleNode)dec.func);
                            if (decoratorFuncName != null && (FIXTURE_PATTERN.matcher(decoratorFuncName).find() || YIELD_FIXTURE_PATTERN.matcher(decoratorFuncName).find())) {
                                return itemPointer;
                            }
                            ++n2;
                        }
                    }
                }
            }
        }
        catch (MisconfigurationException e1) {
            Log.log((Throwable)e1);
        }
        return null;
    }

    public TokensList getCompletionsForMethodParameter(ICompletionState state, ILocalScope localScope, TokensList interfaceForLocal) throws CompletionRecursionException {
        ArrayList<SourceToken> ret;
        block9: {
            List<IInfo> tokensStartingWith;
            TokensList completionsFromItemPointer;
            ItemPointer itemPointer;
            ICodeCompletionASTManager astManager;
            FunctionDef testFuncDef;
            String representationString;
            Object peek;
            ret = new ArrayList<SourceToken>();
            String qual = state.getQualifier();
            String activationToken = state.getActivationToken();
            FastStack scopeStack = localScope.getScopeStack();
            if (!scopeStack.empty() && (peek = scopeStack.peek()) instanceof FunctionDef && (representationString = NodeUtils.getRepresentationString((SimpleNode)(testFuncDef = (FunctionDef)peek))) != null && representationString.startsWith("test") && (astManager = state.getNature().getAstManager()) != null && (itemPointer = this.findItemPointerFromPyTestFixture(state.getNature(), state, activationToken)) != null && (completionsFromItemPointer = this.getCompletionsFromItemPointer(state, astManager, itemPointer)) != null && completionsFromItemPointer.notEmpty()) {
                return completionsFromItemPointer;
            }
            if (qual.length() < PyCodeCompletionPreferences.getCharsForContextInsensitiveGlobalTokensCompletion()) break block9;
            boolean useSubstringMatchInCodeCompletion = PyCodeCompletionPreferences.getUseSubstringMatchInCodeCompletion();
            if (useSubstringMatchInCodeCompletion) {
                PyCodeCompletionUtils.IFilter nameFilter = PyCodeCompletionUtils.getNameFilter((boolean)useSubstringMatchInCodeCompletion, (String)qual);
                try {
                    tokensStartingWith = AdditionalProjectInterpreterInfo.getTokensStartingWith("", state.getNature(), 2);
                }
                catch (MisconfigurationException e) {
                    Log.log((Throwable)e);
                    return new TokensList(ret);
                }
                for (IInfo info : tokensStartingWith) {
                    if (!nameFilter.acceptName(info.getName())) continue;
                    ret.add(new SourceToken(null, info.getName(), null, null, info.getDeclaringModuleName(), info.getType(), info.getNature()));
                }
            } else {
                try {
                    tokensStartingWith = AdditionalProjectInterpreterInfo.getTokensStartingWith(qual, state.getNature(), 2);
                }
                catch (MisconfigurationException e) {
                    Log.log((Throwable)e);
                    return new TokensList(ret);
                }
                for (IInfo info : tokensStartingWith) {
                    ret.add(new SourceToken(null, info.getName(), null, null, info.getDeclaringModuleName(), info.getType(), info.getNature()));
                }
            }
        }
        return new TokensList(ret);
    }

    private TokensList getCompletionsFromItemPointer(ICompletionState state, ICodeCompletionASTManager astManager, ItemPointer itemPointer) throws CompletionRecursionException {
        Throwable throwable = null;
        Object var5_6 = null;
        try (NoExceptionCloseable x = state.pushLookingFor(ICompletionState.LookingFor.LOOKING_FOR_INSTANCED_VARIABLE);){
            ICompletionState.LookingFor currLookingFor = state.getLookingFor();
            TokensList completionFromFuncDefReturn = astManager.getCompletionFromFuncDefReturn(state, itemPointer.definition.module, (IDefinition)itemPointer.definition, true);
            if (completionFromFuncDefReturn != null && completionFromFuncDefReturn.notEmpty()) {
                completionFromFuncDefReturn.setLookingFor(currLookingFor);
                return completionFromFuncDefReturn;
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return null;
    }

    public TokensOrProposalsList getStringGlobalCompletions(CompletionRequest request, ICompletionState state) throws MisconfigurationException {
        return new TokensOrProposalsList(this.getThem(request, state, false));
    }

    public TokensList getCompletionsForTokenWithUndefinedType(ICompletionState state, ILocalScope localScope, TokensList interfaceForLocal) throws CompletionRecursionException {
        return this.getCompletionsForMethodParameter(state, localScope, interfaceForLocal);
    }

    public TokensList getCompletionsForType(ICompletionState state) throws CompletionRecursionException {
        int size;
        List<IInfo> tokensStartingWith;
        IPythonNature nature;
        block15: {
            String activationToken;
            String qual = activationToken = state.getActivationToken();
            String module = null;
            if (activationToken.indexOf(46) != -1) {
                String[] headAndTail = FullRepIterable.headAndTail((String)activationToken);
                qual = headAndTail[1];
                module = headAndTail[0];
            }
            nature = state.getNature();
            tokensStartingWith = AdditionalProjectInterpreterInfo.getTokensEqualTo(qual, nature, 3);
            size = tokensStartingWith.size();
            if (size == 0) {
                return new TokensList();
            }
            if (size == 1) {
                return this.getCompletionsForIInfo(state, nature, tokensStartingWith.get(0));
            }
            if (module != null) {
                int i = 0;
                while (i < size) {
                    TokensList ret;
                    IInfo iInfo = tokensStartingWith.get(i);
                    if (module.equals(iInfo.getDeclaringModuleName()) && (ret = this.getCompletionsForIInfo(state, nature, iInfo)) != null && ret.notEmpty()) {
                        return ret;
                    }
                    ++i;
                }
            }
            ArrayList<IInfo> newList = new ArrayList<IInfo>();
            int i = 0;
            while (i < size) {
                IInfo iInfo = tokensStartingWith.get(i);
                if (iInfo.getType() == 1) {
                    newList.add(iInfo);
                }
                ++i;
            }
            tokensStartingWith = newList;
            size = tokensStartingWith.size();
            if (size != 0) break block15;
            return null;
        }
        try {
            if (size == 1) {
                return this.getCompletionsForIInfo(state, nature, tokensStartingWith.get(0));
            }
            if (size < 5) {
                TokensList ret = new TokensList();
                int i = 0;
                while (i < size) {
                    IInfo iInfo = tokensStartingWith.get(i);
                    TokensList found = this.getCompletionsForIInfo(state, nature, iInfo);
                    if (found != null) {
                        ret.addAll(found);
                    }
                    ++i;
                }
                return ret;
            }
            return null;
        }
        catch (MisconfigurationException e) {
            return null;
        }
    }

    private TokensList getCompletionsForIInfo(ICompletionState state, IPythonNature nature, IInfo iInfo) throws CompletionRecursionException {
        ICompletionState copy = state.getCopy();
        String path = iInfo.getPath();
        String act = iInfo.getName();
        if (path != null) {
            act = String.valueOf(path) + "." + act;
        }
        copy.setActivationToken(act);
        ICodeCompletionASTManager manager = nature.getAstManager();
        IModule mod = manager.getModule(iInfo.getDeclaringModuleName(), nature, true, (IModuleRequestState)state);
        if (mod != null) {
            state.checkFindDefinitionMemory(mod, String.valueOf(iInfo.getDeclaringModuleName()) + "." + act);
            TokensList tks = manager.getCompletionsForModule(mod, copy);
            if (tks != null) {
                return tks;
            }
        }
        return null;
    }
}

