/*
 * Decompiled with CFR 0.152.
 */
package com.python.pydev.codecompletion.participant;

import com.python.pydev.analysis.AnalysisPreferences;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.python.pydev.ast.codecompletion.CompletionRequest;
import org.python.pydev.ast.codecompletion.IPyDevCompletionParticipant;
import org.python.pydev.ast.codecompletion.IPyDevCompletionParticipant2;
import org.python.pydev.ast.codecompletion.ProposalsComparator;
import org.python.pydev.ast.codecompletion.PyCodeCompletionPreferences;
import org.python.pydev.ast.codecompletion.PyCodeCompletionUtils;
import org.python.pydev.core.ICodeCompletionASTManager;
import org.python.pydev.core.ICompletionState;
import org.python.pydev.core.ILocalScope;
import org.python.pydev.core.IModulesManager;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.IToken;
import org.python.pydev.core.IterTokenEntry;
import org.python.pydev.core.MisconfigurationException;
import org.python.pydev.core.PythonNatureWithoutProjectException;
import org.python.pydev.core.TokensList;
import org.python.pydev.core.TokensOrProposalsList;
import org.python.pydev.core.docutils.PySelection;
import org.python.pydev.core.interactive_console.IScriptConsoleViewer;
import org.python.pydev.core.proposals.CompletionProposalFactory;
import org.python.pydev.shared_core.code_completion.ICompletionProposalHandle;
import org.python.pydev.shared_core.code_completion.IPyCompletionProposal;
import org.python.pydev.shared_core.string.FastStringBuffer;
import org.python.pydev.shared_core.string.FullRepIterable;

public class ImportsCompletionParticipant
implements IPyDevCompletionParticipant,
IPyDevCompletionParticipant2 {
    public Collection<ICompletionProposalHandle> computeConsoleCompletions(PySelection.ActivationTokenAndQualifier tokenAndQual, Set<IPythonNature> naturesUsed, IScriptConsoleViewer viewer, int requestOffset) {
        ArrayList<ICompletionProposalHandle> completions = new ArrayList<ICompletionProposalHandle>();
        if (tokenAndQual.activationToken != null && tokenAndQual.activationToken.length() > 0) {
            return completions;
        }
        String qual = tokenAndQual.qualifier;
        if (qual.length() >= PyCodeCompletionPreferences.getCharsForContextInsensitiveModulesCompletion() && naturesUsed != null && naturesUsed.size() > 0) {
            int qlen = qual.length();
            boolean addAutoImport = AnalysisPreferences.doAutoImport(null);
            for (IPythonNature nature : naturesUsed) {
                this.fillCompletions(requestOffset, completions, qual, nature, qlen, addAutoImport, viewer);
            }
        }
        return completions;
    }

    private void fillCompletions(int requestOffset, ArrayList<ICompletionProposalHandle> completions, String qual, IPythonNature nature, int qlen, boolean addAutoImport, IScriptConsoleViewer viewer) {
        ICodeCompletionASTManager astManager = nature.getAstManager();
        if (astManager == null) {
            return;
        }
        IModulesManager modulesManager = astManager.getModulesManager();
        try {
            if (modulesManager == null) {
                nature.getProjectInterpreter();
            }
        }
        catch (PythonNatureWithoutProjectException e) {
            throw new RuntimeException(e);
        }
        catch (MisconfigurationException e) {
            throw new RuntimeException(e);
        }
        String lowerQual = qual.toLowerCase();
        boolean useSubstringMatchInCodeCompletion = PyCodeCompletionPreferences.getUseSubstringMatchInCodeCompletion();
        Set allModuleNames = PyCodeCompletionUtils.getModulesNamesToFilterOn((boolean)useSubstringMatchInCodeCompletion, (IModulesManager)modulesManager, (String)qual);
        PyCodeCompletionUtils.IFilter nameFilter = PyCodeCompletionUtils.getNameFilter((boolean)useSubstringMatchInCodeCompletion, (String)qual);
        FastStringBuffer realImportRep = new FastStringBuffer();
        FastStringBuffer displayString = new FastStringBuffer();
        HashSet<String> alreadyFound = new HashSet<String>();
        ProposalsComparator.CompareContext compareContext = new ProposalsComparator.CompareContext(nature);
        for (String name : allModuleNames) {
            FullRepIterable iterable = new FullRepIterable(name);
            for (String string : iterable) {
                String found;
                realImportRep.clear();
                String[] strings = FullRepIterable.headAndTail((String)string);
                String importRep = strings[1];
                if (!nameFilter.acceptName(importRep)) continue;
                displayString.clear();
                displayString.append(importRep);
                String packageName = strings[0];
                if (packageName.length() > 0) {
                    if (addAutoImport) {
                        realImportRep.append("from ");
                        realImportRep.append(packageName);
                        realImportRep.append(" ");
                    }
                    displayString.append(" - ");
                    displayString.append(packageName);
                }
                if (addAutoImport) {
                    realImportRep.append("import ");
                    realImportRep.append(strings[1]);
                }
                if (alreadyFound.contains(found = displayString.toString())) continue;
                alreadyFound.add(found);
                String displayAsStr = realImportRep.toString();
                ICompletionProposalHandle proposal = CompletionProposalFactory.get().createPyConsoleCompletion(importRep, requestOffset - qlen, qlen, realImportRep.length(), 6, found, null, "", displayAsStr.toLowerCase().equals(lowerQual) ? 41 : 100, displayAsStr, viewer, (IPyCompletionProposal.ICompareContext)compareContext);
                completions.add(proposal);
            }
        }
    }

    private TokensOrProposalsList getThem(CompletionRequest request, ICompletionState state, boolean addAutoImport) throws MisconfigurationException {
        ArrayList<ICompletionProposalHandle> list = new ArrayList<ICompletionProposalHandle>();
        if (request.isInCalltip) {
            return new TokensOrProposalsList(list);
        }
        if (request.qualifier.length() >= PyCodeCompletionPreferences.getCharsForContextInsensitiveModulesCompletion()) {
            ICodeCompletionASTManager astManager = request.nature.getAstManager();
            if (astManager == null) {
                return new TokensOrProposalsList(list);
            }
            String initialModule = request.resolveModule();
            IModulesManager projectModulesManager = astManager.getModulesManager();
            String lowerQual = request.qualifier.toLowerCase();
            boolean useSubstringMatchInCodeCompletion = request.useSubstringMatchInCodeCompletion;
            IModulesManager[] managersInvolved = projectModulesManager.getManagersInvolved(true);
            int i = 0;
            while (i < managersInvolved.length) {
                IModulesManager currentManager = managersInvolved[i];
                Set allModuleNames = PyCodeCompletionUtils.getModulesNamesToFilterOn((boolean)useSubstringMatchInCodeCompletion, (IModulesManager)currentManager, (String)request.qualifier);
                PyCodeCompletionUtils.IFilter nameFilter = PyCodeCompletionUtils.getNameFilter((boolean)useSubstringMatchInCodeCompletion, (String)request.qualifier);
                FastStringBuffer realImportRep = new FastStringBuffer();
                FastStringBuffer displayString = new FastStringBuffer();
                HashSet<String> importedNames = this.getImportedNames(state);
                for (String name : allModuleNames) {
                    if (name.equals(initialModule)) continue;
                    FullRepIterable iterable = new FullRepIterable(name);
                    for (String string : iterable) {
                        realImportRep.clear();
                        String[] strings = FullRepIterable.headAndTail((String)string);
                        String importRep = strings[1];
                        if (!nameFilter.acceptName(importRep) || importedNames.contains(importRep)) continue;
                        displayString.clear();
                        displayString.append(importRep);
                        String packageName = strings[0];
                        if (packageName.length() > 0) {
                            if (addAutoImport) {
                                realImportRep.append("from ");
                                realImportRep.append(packageName);
                                realImportRep.append(" ");
                            }
                            displayString.append(" - ");
                            displayString.append(packageName);
                        }
                        if (addAutoImport) {
                            realImportRep.append("import ");
                            realImportRep.append(strings[1]);
                        }
                        String displayAsStr = displayString.toString();
                        ICompletionProposalHandle proposal = CompletionProposalFactory.get().createCtxInsensitiveImportComplProposal(importRep, request.documentOffset - request.qlen, request.qlen, realImportRep.length(), 6, displayAsStr, null, "", displayAsStr.toLowerCase().equals(lowerQual) ? 41 : 100, realImportRep.toString(), (IPyCompletionProposal.ICompareContext)new ProposalsComparator.CompareContext(currentManager.getNature()));
                        list.add(proposal);
                    }
                }
                ++i;
            }
        }
        return new TokensOrProposalsList(list);
    }

    private HashSet<String> getImportedNames(ICompletionState state) {
        TokensList tokenImportedModules = state.getTokenImportedModules();
        HashSet<String> importedNames = new HashSet<String>();
        if (tokenImportedModules != null) {
            for (IterTokenEntry entry : tokenImportedModules) {
                IToken token = entry.getToken();
                importedNames.add(token.getRepresentation());
            }
        }
        return importedNames;
    }

    public TokensOrProposalsList getGlobalCompletions(CompletionRequest request, ICompletionState state) throws MisconfigurationException {
        IProject projectAdaptable = request.getNature() != null ? request.getNature().getProject() : null;
        return this.getThem(request, state, AnalysisPreferences.doAutoImport((IAdaptable)projectAdaptable));
    }

    public TokensList getCompletionsForMethodParameter(ICompletionState state, ILocalScope localScope, TokensList interfaceForLocal) {
        return new TokensList();
    }

    public TokensOrProposalsList getStringGlobalCompletions(CompletionRequest request, ICompletionState state) throws MisconfigurationException {
        return this.getThem(request, state, false);
    }

    public TokensList getCompletionsForTokenWithUndefinedType(ICompletionState state, ILocalScope localScope, TokensList interfaceForLocal) {
        return new TokensList();
    }

    public TokensList getCompletionsForType(ICompletionState state) {
        return new TokensList();
    }
}

