/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.jython;

import java.io.File;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Path;
import org.python.core.PyList;
import org.python.core.PyObject;
import org.python.pydev.core.CorePlugin;
import org.python.pydev.core.log.Log;
import org.python.pydev.jython.JythonPlugin;
import org.python.pydev.shared_core.jython.IPythonInterpreter;
import org.python.pydev.shared_core.string.StringUtils;

public class JythonModules {
    private static final Object loadJythonLock = new Object();
    private static PyObject pep8Module;
    private static ThreadLocal<IPythonInterpreter> iSortThreadLocalInterpreter;

    static {
        iSortThreadLocalInterpreter = new ThreadLocal();
    }

    public static PyObject getPep8Module(IPythonInterpreter interpreter) {
        if (pep8Module == null) {
            pep8Module = JythonModules.getPepJythonModule(interpreter, "pycodestyle");
        }
        return pep8Module;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static PyObject getPepJythonModule(IPythonInterpreter interpreter, String module) {
        Object object = loadJythonLock;
        synchronized (object) {
            File pepModuleLoc;
            String s;
            block4: {
                s = "import sys\nadd_to_pythonpath = '%s'\nif add_to_pythonpath not in sys.path:\n    sys.path.append(add_to_pythonpath)\nimport " + module + "\n";
                pepModuleLoc = CorePlugin.getPepModuleLocation((String)(String.valueOf(module) + ".py"));
                if (pepModuleLoc != null) break block4;
                return null;
            }
            s = StringUtils.format((String)s, (Object[])new Object[]{StringUtils.replaceAllSlashes((String)pepModuleLoc.getParentFile().getAbsolutePath())});
            interpreter.exec(s);
            return (PyObject)interpreter.get(module);
        }
    }

    public static String makeISort(String fileContents, File f, Set<String> knownThirdParty) {
        IPythonInterpreter interpreter;
        IPythonInterpreter iPythonInterpreter = iSortThreadLocalInterpreter.get();
        String outputLine = "output = getattr(isort.SortImports(file_contents=fileContents, settings_path=settingsPath, known_third_party=knownThirdParty), 'output', None)\n";
        if (iPythonInterpreter == null) {
            String s = "import sys\nimport os\nadd_to_pythonpath = '%s'\nos.chdir(add_to_pythonpath)\nif add_to_pythonpath not in sys.path:\n    sys.path.append(add_to_pythonpath)\nimport isort\n" + outputLine;
            boolean useConsole = false;
            interpreter = JythonPlugin.newPythonInterpreter(useConsole, false);
            String isortContainerLocation = null;
            try {
                isortContainerLocation = CorePlugin.getScriptWithinPySrc((String)new Path("third_party").append("isort_container").toString()).toString();
                File isortContainer = new File(isortContainerLocation);
                if (!isortContainer.exists()) {
                    Log.log((String)("Specified location for isort_container does not exist (" + isortContainerLocation + ")."));
                    return null;
                }
            }
            catch (CoreException e) {
                Log.log((String)"Error getting isort_container location", (Throwable)e);
                return null;
            }
            interpreter.set("fileContents", (Object)fileContents);
            if (f != null) {
                interpreter.set("settingsPath", (Object)f.getAbsoluteFile().getParent());
            } else {
                interpreter.set("settingsPath", (Object)"");
            }
            interpreter.set("knownThirdParty", (Object)new PyList(knownThirdParty));
            s = StringUtils.format((String)s, (Object[])new Object[]{StringUtils.replaceAllSlashes((String)isortContainerLocation)});
            interpreter.exec(s);
            iSortThreadLocalInterpreter.set(interpreter);
        } else {
            interpreter = iPythonInterpreter;
            interpreter.set("fileContents", (Object)fileContents);
            if (f != null) {
                interpreter.set("settingsPath", (Object)f.getAbsoluteFile().getParent());
            } else {
                interpreter.set("settingsPath", (Object)"");
            }
            interpreter.set("knowhThirdParty", (Object)new PyList(knownThirdParty));
            interpreter.exec("isort.settings._get_config_data.cache_clear()\nisort.settings.from_path.cache_clear()\n" + outputLine);
        }
        PyObject pyObject = (PyObject)interpreter.get("output");
        if (pyObject != null && pyObject.__nonzero__()) {
            return pyObject.toString();
        }
        return null;
    }
}

