/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.process_factory;

import org.jvnet.process_factory.AbstractProcess;
import org.jvnet.process_factory.OsCheck;
import org.jvnet.unixp.UnixProcess;
import org.jvnet.winp.WinProcess;

public class ProcessFactory {
    public static AbstractProcess createProcess(long pid) {
        OsCheck.OSType operatingSystemType = OsCheck.getOperatingSystemType();
        if (operatingSystemType == OsCheck.OSType.Windows) {
            return new WinProcess(pid);
        }
        return new UnixProcess(pid);
    }

    public static AbstractProcess createProcess(Process p) throws Exception {
        OsCheck.OSType operatingSystemType = OsCheck.getOperatingSystemType();
        if (operatingSystemType == OsCheck.OSType.Windows) {
            return new WinProcess(p);
        }
        return new UnixProcess(p);
    }
}

