/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.unixp;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.StringTokenizer;
import org.jvnet.process_factory.AbstractProcess;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnixProcess
extends AbstractProcess {
    public UnixProcess(long pid) {
        super(pid);
    }

    public UnixProcess(Process p) throws Exception {
        super(UnixProcess.getPid(p));
    }

    private static long getPid(Process process) throws Exception {
        try {
            try {
                Method m = Process.class.getDeclaredMethod("pid", new Class[0]);
                m.setAccessible(true);
                Object pid = m.invoke((Object)process, new Object[0]);
                if (pid instanceof Integer) {
                    return ((Integer)pid).intValue();
                }
                if (pid instanceof Long) {
                    return (Long)pid;
                }
            }
            catch (Throwable m) {
                // empty catch block
            }
            Field f = process.getClass().getDeclaredField("pid");
            f.setAccessible(true);
            return f.getInt(process);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void killRecursively() throws IOException {
        UnixProcess.killRecursively(this.pid);
    }

    @Override
    public void kill() throws IOException {
        UnixProcess.runNoWait("kill", "-KILL", Long.toString(this.pid));
    }

    private static void stopAndListRecursively(long pid, LinkedHashSet<Long> listed) throws IOException {
        listed.add(pid);
        UnixProcess.runNoWait("kill", "-STOP", Long.toString(pid));
        Output outputPGrep = UnixProcess.runAndGetOutput("pgrep", "-P", Long.toString(pid));
        if (outputPGrep.stderr != null && outputPGrep.stderr.length() > 0) {
            throw new RuntimeException(outputPGrep.stderr);
        }
        String ids = outputPGrep.stdout;
        StringTokenizer strTok = new StringTokenizer(ids);
        while (strTok.hasMoreTokens()) {
            String nextToken = strTok.nextToken();
            long found = Long.parseLong(nextToken);
            if (listed.contains(found)) continue;
            UnixProcess.stopAndListRecursively(found, listed);
        }
    }

    private static LinkedHashSet<Long> killRecursively(long pid) throws IOException {
        LinkedHashSet<Long> listed = new LinkedHashSet<Long>();
        UnixProcess.stopAndListRecursively(pid, listed);
        ArrayList<Long> lst = new ArrayList<Long>(listed);
        Collections.reverse(lst);
        for (Long cPid : lst) {
            UnixProcess.runNoWait("kill", "-KILL", Long.toString(cPid));
        }
        return listed;
    }

    private static Output runAndGetOutput(String ... cmdarray) throws IOException {
        Process createProcess = Runtime.getRuntime().exec(cmdarray, null, null);
        return UnixProcess.getProcessOutput(createProcess);
    }

    private static void runNoWait(String ... cmdarray) throws IOException {
        Runtime.getRuntime().exec(cmdarray, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Output getProcessOutput(Process process) throws IOException {
        try {
            process.getOutputStream().close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        InputStreamReader inputStream = new InputStreamReader((InputStream)new BufferedInputStream(process.getInputStream()), StandardCharsets.UTF_8);
        InputStreamReader errorStream = new InputStreamReader((InputStream)new BufferedInputStream(process.getErrorStream()), StandardCharsets.UTF_8);
        try {
            process.waitFor();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        try {
            Object sync;
            Object object = sync = new Object();
            synchronized (object) {
                sync.wait(10L);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return new Output(UnixProcess.readInputStream(inputStream), UnixProcess.readInputStream(errorStream));
    }

    private static String readInputStream(InputStreamReader in) throws IOException {
        int c;
        StringBuffer contents = new StringBuffer();
        char[] buf = new char[80];
        while ((c = in.read(buf)) != -1) {
            contents.append(buf, 0, c);
        }
        return contents.toString();
    }

    private static class Output {
        public final String stdout;
        public final String stderr;

        public Output(String stdout, String stderr) {
            this.stdout = stdout;
            this.stderr = stderr;
        }
    }
}

