/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.core;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.python.pydev.core.GrammarsIterator;
import org.python.pydev.core.ICodeCompletionASTManager;
import org.python.pydev.core.IGrammarVersionProvider;
import org.python.pydev.core.IInterpreterInfo;
import org.python.pydev.core.IInterpreterManager;
import org.python.pydev.core.IModule;
import org.python.pydev.core.IModuleRequestState;
import org.python.pydev.core.IPythonPathNature;
import org.python.pydev.core.MisconfigurationException;
import org.python.pydev.core.PythonNatureWithoutProjectException;
import org.python.pydev.core.TokensList;
import org.python.pydev.shared_core.string.FastStringBuffer;
import org.python.pydev.shared_core.structure.Tuple;

public interface IPythonNature
extends IProjectNature,
IGrammarVersionProvider,
IAdaptable {
    public static final String PYTHON_VERSION_2_5 = "python 2.5";
    public static final String PYTHON_VERSION_2_6 = "python 2.6";
    public static final String PYTHON_VERSION_2_7 = "python 2.7";
    public static final String PYTHON_VERSION_3_0 = "python 3.5";
    public static final String PYTHON_VERSION_3_6 = "python 3.6";
    public static final String PYTHON_VERSION_3_7 = "python 3.7";
    public static final String PYTHON_VERSION_3_8 = "python 3.8";
    public static final String PYTHON_VERSION_3_9 = "python 3.9";
    public static final String PYTHON_VERSION_3_10 = "python 3.10";
    public static final String PYTHON_VERSION_INTERPRETER = "python interpreter";
    public static final String JYTHON_VERSION_2_5 = "jython 2.5";
    public static final String JYTHON_VERSION_2_6 = "jython 2.6";
    public static final String JYTHON_VERSION_2_7 = "jython 2.7";
    public static final String JYTHON_VERSION_3_0 = "jython 3.5";
    public static final String JYTHON_VERSION_3_6 = "jython 3.6";
    public static final String JYTHON_VERSION_3_7 = "jython 3.7";
    public static final String JYTHON_VERSION_3_8 = "jython 3.8";
    public static final String JYTHON_VERSION_3_9 = "jython 3.9";
    public static final String JYTHON_VERSION_3_10 = "jython 3.10";
    public static final String JYTHON_VERSION_INTERPRETER = "jython interpreter";
    public static final String IRONPYTHON_VERSION_2_5 = "ironpython 2.5";
    public static final String IRONPYTHON_VERSION_2_6 = "ironpython 2.6";
    public static final String IRONPYTHON_VERSION_2_7 = "ironpython 2.7";
    public static final String IRONPYTHON_VERSION_3_0 = "ironpython 3.5";
    public static final String IRONPYTHON_VERSION_3_6 = "ironpython 3.6";
    public static final String IRONPYTHON_VERSION_3_7 = "ironpython 3.7";
    public static final String IRONPYTHON_VERSION_3_8 = "ironpython 3.8";
    public static final String IRONPYTHON_VERSION_3_9 = "ironpython 3.9";
    public static final String IRONPYTHON_VERSION_3_10 = "ironpython 3.10";
    public static final String IRONPYTHON_VERSION_INTERPRETER = "ironpython interpreter";
    public static final int INTERPRETER_TYPE_PYTHON = 0;
    public static final int INTERPRETER_TYPE_JYTHON = 1;
    public static final int INTERPRETER_TYPE_IRONPYTHON = 2;
    public static final int INTERPRETER_TYPE_JYTHON_ECLIPSE = 3;
    public static final String DEFAULT_INTERPRETER = "Default";

    public String getVersion(boolean var1) throws CoreException;

    public Tuple<String, String> getVersionAndError(boolean var1) throws CoreException;

    public void setVersion(String var1, String var2) throws CoreException;

    public int getInterpreterType() throws CoreException;

    public File getCompletionsCacheDir();

    public void saveAstManager();

    public IPythonPathNature getPythonPathNature();

    public String resolveModule(File var1) throws MisconfigurationException;

    public String resolveModule(String var1) throws MisconfigurationException;

    public String resolveModule(IResource var1) throws MisconfigurationException;

    public String resolveModuleOnlyInProjectSources(String var1, boolean var2) throws CoreException, MisconfigurationException;

    public String resolveModuleOnlyInProjectSources(IResource var1, boolean var2) throws CoreException, MisconfigurationException;

    public ICodeCompletionASTManager getAstManager();

    public void rebuildPath();

    public IInterpreterManager getRelatedInterpreterManager();

    public TokensList getBuiltinCompletions(IModuleRequestState var1);

    public void clearBuiltinCompletions();

    public IModule getBuiltinMod(IModuleRequestState var1);

    public void clearBuiltinMod();

    public boolean isResourceInPythonpath(IResource var1) throws MisconfigurationException;

    public boolean isResourceInPythonpath(String var1) throws MisconfigurationException;

    public boolean isResourceInPythonpathProjectSources(IResource var1, boolean var2) throws MisconfigurationException, CoreException;

    public boolean isResourceInPythonpathProjectSources(String var1, boolean var2) throws MisconfigurationException, CoreException;

    public boolean startRequests();

    public void endRequests();

    public IInterpreterInfo getProjectInterpreter() throws MisconfigurationException, PythonNatureWithoutProjectException;

    public boolean isOkToUse();

    public void updateMtime();

    public long getMtime();

    public static class Versions {
        public static final HashSet<String> ALL_PYTHON_VERSIONS = new HashSet();
        public static final HashSet<String> ALL_JYTHON_VERSIONS = new HashSet();
        public static final HashSet<String> ALL_IRONPYTHON_VERSIONS = new HashSet();
        public static final HashSet<String> ALL_VERSIONS_ANY_FLAVOR = new HashSet();
        public static final List<String> VERSION_NUMBERS = new ArrayList<String>();
        public static final String JYTHON_VERSION_LATEST = "jython 2.7";
        public static final String PYTHON_VERSION_LATEST = "python 2.7";
        public static final String IRONPYTHON_VERSION_LATEST = "ironpython 2.7";
        public static final String INTERPRETER_VERSION = "interpreter";
        private static final Map<String, String> mappedVersions = new HashMap<String, String>();
        public static final String PYTHON_PREFIX = "python";
        public static final String JYTHON_PREFIX = "jython";
        public static final String IRONYTHON_PREFIX = "ironpython";
        private static List<Integer> grammarVersions;
        private static Map<String, Integer> grammarRepToVersion;

        static {
            ALL_PYTHON_VERSIONS.add(IPythonNature.PYTHON_VERSION_2_5);
            ALL_PYTHON_VERSIONS.add(IPythonNature.PYTHON_VERSION_2_6);
            ALL_PYTHON_VERSIONS.add("python 2.7");
            ALL_PYTHON_VERSIONS.add(IPythonNature.PYTHON_VERSION_3_0);
            ALL_PYTHON_VERSIONS.add(IPythonNature.PYTHON_VERSION_3_6);
            ALL_PYTHON_VERSIONS.add(IPythonNature.PYTHON_VERSION_3_7);
            ALL_PYTHON_VERSIONS.add(IPythonNature.PYTHON_VERSION_3_8);
            ALL_PYTHON_VERSIONS.add(IPythonNature.PYTHON_VERSION_3_9);
            ALL_PYTHON_VERSIONS.add(IPythonNature.PYTHON_VERSION_3_10);
            ALL_PYTHON_VERSIONS.add(IPythonNature.PYTHON_VERSION_INTERPRETER);
            ALL_JYTHON_VERSIONS.add(IPythonNature.JYTHON_VERSION_2_5);
            ALL_JYTHON_VERSIONS.add(IPythonNature.JYTHON_VERSION_2_6);
            ALL_JYTHON_VERSIONS.add("jython 2.7");
            ALL_JYTHON_VERSIONS.add(IPythonNature.JYTHON_VERSION_3_0);
            ALL_JYTHON_VERSIONS.add(IPythonNature.JYTHON_VERSION_3_6);
            ALL_JYTHON_VERSIONS.add(IPythonNature.JYTHON_VERSION_3_7);
            ALL_JYTHON_VERSIONS.add(IPythonNature.JYTHON_VERSION_3_8);
            ALL_JYTHON_VERSIONS.add(IPythonNature.JYTHON_VERSION_3_9);
            ALL_JYTHON_VERSIONS.add(IPythonNature.JYTHON_VERSION_3_10);
            ALL_JYTHON_VERSIONS.add(IPythonNature.JYTHON_VERSION_INTERPRETER);
            ALL_IRONPYTHON_VERSIONS.add(IPythonNature.IRONPYTHON_VERSION_2_5);
            ALL_IRONPYTHON_VERSIONS.add(IPythonNature.IRONPYTHON_VERSION_2_6);
            ALL_IRONPYTHON_VERSIONS.add("ironpython 2.7");
            ALL_IRONPYTHON_VERSIONS.add(IPythonNature.IRONPYTHON_VERSION_3_0);
            ALL_IRONPYTHON_VERSIONS.add(IPythonNature.IRONPYTHON_VERSION_3_6);
            ALL_IRONPYTHON_VERSIONS.add(IPythonNature.IRONPYTHON_VERSION_3_7);
            ALL_IRONPYTHON_VERSIONS.add(IPythonNature.IRONPYTHON_VERSION_3_8);
            ALL_IRONPYTHON_VERSIONS.add(IPythonNature.IRONPYTHON_VERSION_3_9);
            ALL_IRONPYTHON_VERSIONS.add(IPythonNature.IRONPYTHON_VERSION_3_10);
            ALL_IRONPYTHON_VERSIONS.add(IPythonNature.IRONPYTHON_VERSION_INTERPRETER);
            ALL_VERSIONS_ANY_FLAVOR.addAll(ALL_JYTHON_VERSIONS);
            ALL_VERSIONS_ANY_FLAVOR.addAll(ALL_PYTHON_VERSIONS);
            ALL_VERSIONS_ANY_FLAVOR.addAll(ALL_IRONPYTHON_VERSIONS);
            VERSION_NUMBERS.add("2.5");
            VERSION_NUMBERS.add("2.6");
            VERSION_NUMBERS.add("2.7");
            VERSION_NUMBERS.add("3.5");
            VERSION_NUMBERS.add("3.6");
            VERSION_NUMBERS.add("3.7");
            VERSION_NUMBERS.add("3.8");
            VERSION_NUMBERS.add("3.9");
            VERSION_NUMBERS.add("3.10");
            VERSION_NUMBERS.add(INTERPRETER_VERSION);
            mappedVersions.put("2.0", "2.5");
            mappedVersions.put("2.1", "2.5");
            mappedVersions.put("2.2", "2.5");
            mappedVersions.put("2.3", "2.5");
            mappedVersions.put("2.4", "2.5");
            mappedVersions.put("2.5", "2.5");
            mappedVersions.put("2.6", "2.6");
            mappedVersions.put("2.7", "2.7");
            mappedVersions.put("3.0", "3.5");
            mappedVersions.put("3.1", "3.5");
            mappedVersions.put("3.2", "3.5");
            mappedVersions.put("3.3", "3.5");
            mappedVersions.put("3.4", "3.5");
            mappedVersions.put("3.5", "3.5");
            mappedVersions.put("3.6", "3.6");
            mappedVersions.put("3.7", "3.7");
            mappedVersions.put("3.8", "3.8");
            mappedVersions.put("3.9", "3.9");
            mappedVersions.put("3.10", "3.10");
            grammarVersions = GrammarsIterator.createList();
            grammarRepToVersion = GrammarsIterator.createStrToInt();
        }

        public static String convertToInternalVersion(int interpreterType, String initialVersion) {
            FastStringBuffer buf;
            switch (interpreterType) {
                case 0: {
                    buf = new FastStringBuffer("python ", 5);
                    break;
                }
                case 1: {
                    buf = new FastStringBuffer("jython ", 5);
                    break;
                }
                case 2: {
                    buf = new FastStringBuffer(IRONYTHON_PREFIX, 5);
                    break;
                }
                default: {
                    throw new RuntimeException("Not Python nor Jython nor IronPython?");
                }
            }
            return Versions.convertToInternalVersion(buf, initialVersion);
        }

        public static String convertToInternalVersion(FastStringBuffer buf, String initialVersion) throws AssertionError {
            String version = mappedVersions.get(initialVersion);
            if (version != null) {
                buf.append(version);
                String fullVersion = buf.toString();
                if (ALL_VERSIONS_ANY_FLAVOR.contains(fullVersion)) {
                    return fullVersion;
                }
                throw new AssertionError((Object)("Should never get here (wrong version mapping). Initial version: " + initialVersion));
            }
            version = initialVersion;
            Assert.isTrue((!INTERPRETER_VERSION.equals(version) ? 1 : 0) != 0, (String)"The actual version must be passed, cannot be 'interpreter' at this point.");
            if (version.startsWith("3")) {
                buf.append("3.10");
            } else {
                buf.append("2.7");
            }
            String fullVersion = buf.toString();
            if (ALL_VERSIONS_ANY_FLAVOR.contains(fullVersion)) {
                return fullVersion;
            }
            throw new AssertionError((Object)("Should never get here. Initial version: " + initialVersion));
        }

        public static List<Integer> getSupportedInternalGrammarVersions() {
            return grammarVersions;
        }

        public static boolean supportsVersion(String version) {
            return mappedVersions.containsKey(version);
        }

        public static int getInternalVersion(String version) {
            return grammarRepToVersion.get(mappedVersions.get(version));
        }
    }
}

