/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.core;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.python.pydev.core.ChainIterator;
import org.python.pydev.core.ICompletionState;
import org.python.pydev.core.IObjectsList;
import org.python.pydev.core.IToken;
import org.python.pydev.core.ITypeInfo;
import org.python.pydev.core.IterTokenEntry;
import org.python.pydev.shared_core.structure.LowMemoryArrayList;

public class TokensList
implements IObjectsList,
Iterable<IterTokenEntry> {
    protected final IToken[] tokens;
    private int size;
    private final List<TokensList> appended = new LowMemoryArrayList();
    private ICompletionState.LookingFor lookingFor;
    private boolean freeze;

    public TokensList(IToken[] tokens) {
        this.tokens = tokens;
        if (tokens != null && tokens.length > 0) {
            this.size = tokens.length;
        }
    }

    public TokensList copy() {
        TokensList ret = new TokensList(this.tokens);
        ret.size = this.size;
        ret.freeze = true;
        ret.lookingFor = this.lookingFor;
        ret.appended.addAll(this.appended);
        return ret;
    }

    public TokensList() {
        this.tokens = null;
    }

    public TokensList(Collection<IToken> collection) {
        this(collection.toArray(new IToken[0]));
    }

    public TokensList(IToken token) {
        this(new IToken[]{token});
    }

    public int size() {
        return this.size;
    }

    public boolean notEmpty() {
        return this.size > 0;
    }

    public boolean empty() {
        return this.size == 0;
    }

    public void setGeneratorType(ITypeInfo type) {
        for (IterTokenEntry t : this) {
            t.getToken().setGeneratorType(type);
        }
    }

    public void addAll(TokensList lst) {
        Assert.isTrue((!this.freeze ? 1 : 0) != 0);
        Assert.isTrue((lst != this ? 1 : 0) != 0);
        if (lst == null || lst.size == 0) {
            return;
        }
        this.appended.add(lst);
        this.size += lst.size;
    }

    @Override
    public Iterator<IterTokenEntry> iterator() {
        ChainIterator<IterTokenEntry> chainIterator = new ChainIterator<IterTokenEntry>();
        this.addToIterator(chainIterator);
        chainIterator.build();
        return chainIterator;
    }

    protected void addToIterator(ChainIterator chainIterator) {
        if (this.tokens != null && this.tokens.length > 0) {
            chainIterator.add(this);
        }
        for (TokensList t : this.appended) {
            t.addToIterator(chainIterator);
        }
    }

    public IToken getFirst() {
        return this.iterator().next().getToken();
    }

    public String toString() {
        Iterator<IterTokenEntry> it = this.iterator();
        if (!it.hasNext()) {
            return "TokensList[]";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("TokensList[");
        while (true) {
            sb.append(it.next().object);
            if (!it.hasNext()) {
                return sb.append(']').toString();
            }
            sb.append(',').append(' ');
        }
    }

    public void setLookingFor(ICompletionState.LookingFor lookingFor) {
        this.freeze();
        this.lookingFor = lookingFor;
        for (TokensList t : this.appended) {
            t.setLookingFor(lookingFor);
        }
    }

    public ICompletionState.LookingFor getLookingFor() {
        if (this.lookingFor != null) {
            return this.lookingFor;
        }
        for (TokensList t : this.appended) {
            ICompletionState.LookingFor lookingFor2 = t.getLookingFor();
            if (lookingFor2 == null) continue;
            return lookingFor2;
        }
        return null;
    }

    @Override
    public Iterator<IterTokenEntry> buildIterator() {
        return new Iterator<IterTokenEntry>(){
            IterTokenEntry iterTokenEntry = new IterTokenEntry();
            int i = 0;

            @Override
            public boolean hasNext() {
                return this.i < TokensList.this.tokens.length;
            }

            @Override
            public IterTokenEntry next() {
                IToken object = TokensList.this.tokens[this.i];
                ++this.i;
                this.iterTokenEntry.object = object;
                this.iterTokenEntry.lookingFor = TokensList.this.lookingFor;
                return this.iterTokenEntry;
            }
        };
    }

    public void freeze() {
        this.freeze = true;
    }
}

