/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.core.autoedit;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.python.pydev.core.IIndentPrefs;
import org.python.pydev.shared_core.string.FastStringBuffer;
import org.python.pydev.shared_core.string.StringUtils;
import org.python.pydev.shared_core.string.TextSelectionUtils;
import org.python.pydev.shared_core.utils.IDocumentCommand;

public abstract class AbstractIndentPrefs
implements IIndentPrefs {
    private boolean forceTabs = false;

    @Override
    public boolean getForceTabs() {
        return this.forceTabs;
    }

    @Override
    public void setForceTabs(boolean forceTabs) {
        this.forceTabs = forceTabs;
    }

    @Override
    public String getIndentationString() {
        if (this.getUseSpaces(true)) {
            return StringUtils.createSpaceString((int)this.getTabWidth());
        }
        return "\t";
    }

    @Override
    public void convertToStd(IDocument document, IDocumentCommand command) {
        try {
            if (this.getUseSpaces(true)) {
                command.setText(this.convertTabsToSpaces(document, command.getText(), command.getOffset(), this.getIndentationString()));
            } else {
                command.setText(this.convertSpacesToTabs(document, command.getText(), command.getOffset(), this.getIndentationString()));
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private String convertTabsToSpaces(IDocument document, String text, int offset, String indentString) throws BadLocationException {
        if (text.indexOf("\t") != -1) {
            if (text.equals("\t")) {
                this.deleteWhitespaceAfter(document, offset);
                text = indentString;
            } else {
                char[] chars = text.toCharArray();
                FastStringBuffer newText = new FastStringBuffer();
                int count = 0;
                while (count < chars.length) {
                    if (chars[count] == '\t') {
                        newText.append(indentString);
                    } else {
                        newText.append(chars[count]);
                    }
                    ++count;
                }
                text = newText.toString();
            }
        }
        return text;
    }

    private String convertSpacesToTabs(IDocument document, String text, int offset, String indentString) throws BadLocationException {
        String spaceStr = StringUtils.createSpaceString((int)this.getTabWidth());
        while (text.startsWith(spaceStr)) {
            text = text.replaceAll(spaceStr, "\t");
        }
        return text;
    }

    private void deleteWhitespaceAfter(IDocument document, int offset) throws BadLocationException {
        if (offset < document.getLength() && !TextSelectionUtils.endsWithNewline((IDocument)document, (String)document.get(offset, 1))) {
            int lineLength = document.getLineInformationOfOffset(offset).getLength();
            int lineStart = document.getLineInformationOfOffset(offset).getOffset();
            String textAfter = document.get(offset, lineStart + lineLength - offset);
            if (textAfter.length() > 0 && this.isWhitespace(textAfter)) {
                document.replace(offset, textAfter.length(), "");
            }
        }
    }

    private boolean isWhitespace(String s) {
        int len = s.length();
        int i = len - 1;
        while (i > -1) {
            if (!Character.isWhitespace(s.charAt(i))) {
                return false;
            }
            --i;
        }
        return true;
    }
}

