/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.core.autoedit;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.python.pydev.core.IIndentPrefs;
import org.python.pydev.core.autoedit.DefaultIndentPrefs;
import org.python.pydev.core.autoedit.IHandleScriptAutoEditStrategy;
import org.python.pydev.core.autoedit.TestIndentPrefs;
import org.python.pydev.core.docutils.ImportsSelection;
import org.python.pydev.core.docutils.ParsingUtils;
import org.python.pydev.core.docutils.PySelection;
import org.python.pydev.core.docutils.PyStringUtils;
import org.python.pydev.core.docutils.PythonPairMatcher;
import org.python.pydev.core.docutils.SyntaxErrorException;
import org.python.pydev.core.log.Log;
import org.python.pydev.shared_core.SharedCorePlugin;
import org.python.pydev.shared_core.string.CoreTextSelection;
import org.python.pydev.shared_core.string.FastStringBuffer;
import org.python.pydev.shared_core.string.ICoreTextSelection;
import org.python.pydev.shared_core.string.NoPeerAvailableException;
import org.python.pydev.shared_core.string.StringUtils;
import org.python.pydev.shared_core.string.TextSelectionUtils;
import org.python.pydev.shared_core.structure.Tuple;
import org.python.pydev.shared_core.utils.DocCmd;
import org.python.pydev.shared_core.utils.IDocumentCommand;

public final class PyAutoIndentStrategy
implements IHandleScriptAutoEditStrategy {
    private IIndentPrefs prefs;
    private boolean blockSelection;
    private final IAdaptable projectAdaptable;
    private boolean considerOnlyCurrentLine = false;
    IDocument EMPTY_DOCUMENT = new Document();
    private boolean isCython;

    public PyAutoIndentStrategy(IAdaptable projectAdaptable) {
        this.projectAdaptable = projectAdaptable;
    }

    public void setIndentPrefs(IIndentPrefs prefs) {
        this.prefs = prefs;
    }

    public IIndentPrefs getIndentPrefs() {
        if (this.prefs == null) {
            this.prefs = SharedCorePlugin.inTestMode() ? new TestIndentPrefs(true, 4) : new DefaultIndentPrefs(this.projectAdaptable);
        }
        return this.prefs;
    }

    private Tuple<String, Boolean> autoIndentNewline(IDocument document, int length, String text, int offset) throws BadLocationException {
        if (offset > 0) {
            PySelection selection = new PySelection(document, offset);
            String lineWithoutComments = selection.getLineContentsToCursor(true, true);
            Tuple<Integer, Boolean> tup = this.determineSmartIndent(offset, document, this.prefs);
            int smartIndent = (Integer)tup.o1;
            boolean isInsidePar = (Boolean)tup.o2;
            if (lineWithoutComments.length() > 0) {
                int curr = lineWithoutComments.length() - 1;
                char lastChar = lineWithoutComments.charAt(curr);
                while (curr > 0 && Character.isWhitespace(lastChar)) {
                    lastChar = lineWithoutComments.charAt(--curr);
                }
                if (smartIndent == -1 && !isInsidePar && StringUtils.isClosingPeer((char)lastChar)) {
                    PythonPairMatcher matcher = new PythonPairMatcher(PyStringUtils.BRACKETS);
                    int bracketOffset = selection.getLineOffset() + curr;
                    IRegion region = matcher.match(document, bracketOffset + 1);
                    if (region != null && !PySelection.endsInSameLine((IDocument)document, (IRegion)region)) {
                        int openingBracketLine = document.getLineOfOffset(region.getOffset());
                        String openingBracketLineStr = PySelection.getLine((IDocument)document, (int)openingBracketLine);
                        int first = PySelection.getFirstCharPosition((String)openingBracketLineStr);
                        String initial = this.getCharsBeforeNewLine(text);
                        text = String.valueOf(initial) + openingBracketLineStr.substring(0, first);
                        return new Tuple((Object)text, (Object)isInsidePar);
                    }
                } else if (smartIndent == -1 && lastChar == ':') {
                    text = this.indentBasedOnStartingScope(text, selection, false);
                    return new Tuple((Object)text, (Object)isInsidePar);
                }
            }
            String trimmedLine = lineWithoutComments.trim();
            if (smartIndent >= 0 && (PyStringUtils.hasOpeningBracket(trimmedLine) || PyStringUtils.hasClosingBracket(trimmedLine))) {
                return new Tuple((Object)this.makeSmartIndent(text, smartIndent), (Object)isInsidePar);
            }
            if (PySelection.startsWithDedentToken(trimmedLine)) {
                if (lineWithoutComments.endsWith("\\")) {
                    return new Tuple((Object)(String.valueOf(text) + this.prefs.getIndentationString()), (Object)isInsidePar);
                }
                return new Tuple((Object)this.dedent(text), (Object)isInsidePar);
            }
            boolean indentBasedOnStartingScope = false;
            try {
                if (PySelection.containsOnlyWhitespaces((String)selection.getLineContentsFromCursor())) {
                    indentBasedOnStartingScope = true;
                }
            }
            catch (BadLocationException e) {
                indentBasedOnStartingScope = true;
            }
            if (indentBasedOnStartingScope) {
                String lineContentsToCursor = selection.getLineContentsToCursor();
                String trimmed = lineContentsToCursor.trim();
                if (trimmed.length() == 0) {
                    return new Tuple((Object)this.indentBasedOnStartingScope(text, selection, false), (Object)isInsidePar);
                }
                boolean endsWithTrippleSingle = trimmed.endsWith("'''");
                if ((endsWithTrippleSingle || trimmed.endsWith("\"\"\"")) && endsWithTrippleSingle) {
                    int cursorLine = -1;
                    try {
                        char c;
                        ParsingUtils parsingUtils = ParsingUtils.create(selection.getDoc(), true);
                        int cursorOffset = selection.getAbsoluteCursorOffset();
                        while (Character.isWhitespace(c = parsingUtils.charAt(--cursorOffset))) {
                        }
                        int startOffset = parsingUtils.eatLiteralsBackwards(null, cursorOffset);
                        cursorLine = selection.getLineOfOffset(startOffset);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (cursorLine == -1) {
                        cursorLine = selection.getCursorLine();
                    }
                    return new Tuple((Object)this.indentBasedOnStartingScope(text, new PySelection(selection.getDoc(), cursorLine, 0), false), (Object)isInsidePar);
                }
            }
        }
        return new Tuple((Object)text, (Object)false);
    }

    private String indentBasedOnStartingScope(String text, PySelection selection, boolean checkForLowestBeforeNewScope) {
        PySelection.LineStartingScope previousIfLine = selection.getPreviousLineThatStartsScope();
        if (previousIfLine != null) {
            String initial = this.getCharsBeforeNewLine(text);
            if (previousIfLine.lineWithDedentWhileLookingScope == null) {
                String indent = PySelection.getIndentationFromLine((String)previousIfLine.lineStartingScope);
                if (checkForLowestBeforeNewScope && previousIfLine.lineWithLowestIndent != null) {
                    indent = PySelection.getIndentationFromLine((String)previousIfLine.lineWithLowestIndent);
                    text = String.valueOf(initial) + indent;
                } else {
                    text = String.valueOf(initial) + indent + this.prefs.getIndentationString();
                }
            } else {
                String indent = PySelection.getIndentationFromLine((String)previousIfLine.lineWithDedentWhileLookingScope);
                String indentationString = this.prefs.getIndentationString();
                int i = indent.length() - indentationString.length();
                text = i > 0 && indent.length() > i ? (String.valueOf(initial) + indent).substring(0, i + 1) : initial;
            }
        }
        return text;
    }

    private int findEndOfWhiteSpace(IDocument document, int offset, int end) throws BadLocationException {
        while (offset < end) {
            char c = document.getChar(offset);
            if (c != ' ' && c != '\t') {
                return offset;
            }
            ++offset;
        }
        return end;
    }

    private void autoIndentSameAsPrevious(IDocument d, IDocumentCommand c) {
        String txt = this.autoIndentSameAsPrevious(d, c.getOffset(), c.getText(), true);
        if (txt != null) {
            c.setText(txt);
        }
    }

    private String autoIndentSameAsPrevious(IDocument d, int offset, String text, boolean considerEmptyLines) {
        if (offset == -1 || d.getLength() == 0) {
            return null;
        }
        try {
            IRegion info = d.getLineInformationOfOffset(offset);
            String line = d.get(info.getOffset(), info.getLength());
            if (!considerEmptyLines) {
                int currLine = d.getLineOfOffset(offset);
                while (PySelection.containsOnlyWhitespaces((String)line)) {
                    if (--currLine < 0) break;
                    info = d.getLineInformation(currLine);
                    line = d.get(info.getOffset(), info.getLength());
                }
            }
            int start = info.getOffset();
            int end = this.findEndOfWhiteSpace(d, start, offset);
            FastStringBuffer buf = new FastStringBuffer(text, end - start + 1);
            if (end > start) {
                buf.append(d.get(start, end - start));
            }
            return buf.toString();
        }
        catch (BadLocationException excp) {
            return null;
        }
    }

    private String dedent(String text) {
        String indentationString = this.prefs.getIndentationString();
        int indentationLength = indentationString.length();
        int len = text.length();
        if (len >= indentationLength) {
            text = text.substring(0, len - indentationLength);
        }
        return text;
    }

    private static Tuple<String, Integer> removeFirstIndent(String text, IIndentPrefs prefs) {
        String indentationString = prefs.getIndentationString();
        if (text.startsWith(indentationString)) {
            return new Tuple((Object)text.substring(indentationString.length()), (Object)indentationString.length());
        }
        return new Tuple((Object)text, (Object)0);
    }

    @Override
    public void customizeDocumentCommand(IDocument document, IDocumentCommand command) {
        if (this.blockSelection || !command.getDoIt()) {
            this.getIndentPrefs().convertToStd(document, command);
            return;
        }
        char c = command.getText().length() == 1 ? command.getText().charAt(0) : (char)'\u0000';
        String contentType = ParsingUtils.getContentType(document, command.getOffset());
        switch (c) {
            case '\"': 
            case '\'': {
                this.handleLiteral(document, command, contentType.equals("__dftl_partition_content_type"), c);
                return;
            }
        }
        boolean tabStopInComments = this.getIndentPrefs().getTabStopInComment();
        boolean isNewLine = PyAutoIndentStrategy.isNewLineText(document, command.getLength(), command.getText());
        if (!contentType.equals("__dftl_partition_content_type")) {
            if (isNewLine) {
                if (ParsingUtils.isStringContentType(contentType)) {
                    this.autoIndentSameAsPrevious(document, command);
                    return;
                }
            } else if (!ParsingUtils.isCommentContentType(contentType) || c != '\t' || !tabStopInComments) {
                this.getIndentPrefs().convertToStd(document, command);
                return;
            }
        }
        try {
            if (isNewLine) {
                this.customizeNewLine(document, command);
                this.getIndentPrefs().convertToStd(document, command);
                return;
            }
            if (c == '\u0000') {
                this.getIndentPrefs().convertToStd(document, command);
                return;
            }
            if (c == '\t') {
                this.handleTab(document, command);
                this.getIndentPrefs().convertToStd(document, command);
                return;
            }
            this.getIndentPrefs().convertToStd(document, command);
            switch (c) {
                case '[': 
                case '{': {
                    char peer;
                    PySelection ps;
                    if (this.prefs.getAutoParentesis() && PyAutoIndentStrategy.shouldClose(ps = new PySelection(document, command.getOffset()), c, peer = StringUtils.getPeer((char)c))) {
                        command.setShiftsCaret(false);
                        command.setText(String.valueOf(c) + peer);
                        command.setCaretOffset(command.getOffset() + 1);
                    }
                    return;
                }
                case '(': {
                    PyAutoIndentStrategy.handleParens(document, command, this.prefs, this.considerOnlyCurrentLine);
                    return;
                }
                case ':': {
                    if (this.prefs.getAutoColon()) {
                        this.performColonReplacement(document, command);
                    }
                    PyAutoIndentStrategy.autoDedentAfterColon(document, command, this.prefs);
                    return;
                }
                case ' ': {
                    if (this.prefs.getAutoWriteImport()) {
                        String importsTipperStr;
                        PySelection ps = new PySelection(document, command.getOffset());
                        String completeLine = ps.getLineWithoutCommentsOrLiterals();
                        String lineToCursor = ps.getLineContentsToCursor().trim();
                        String lineContentsFromCursor = ps.getLineContentsFromCursor();
                        if (!(completeLine.indexOf(" import ") != -1 || !StringUtils.leftTrim((String)completeLine).startsWith("from ") || completeLine.startsWith("import ") || completeLine.endsWith(" import") || lineToCursor.endsWith(" import") || lineContentsFromCursor.startsWith("import") || completeLine.startsWith("cimport ") || completeLine.endsWith(" cimport") || lineToCursor.endsWith(" cimport") || lineContentsFromCursor.startsWith("cimport") || (importsTipperStr = ImportsSelection.getImportsTipperStr((String)lineToCursor, (boolean)false).importsTipperStr).length() <= 0 || this.isCython)) {
                            command.setText(" import ");
                        }
                    }
                    PyAutoIndentStrategy.autoDedentElif(document, command, this.getIndentPrefs());
                    return;
                }
                case ')': 
                case ']': 
                case '}': {
                    if (this.prefs.getAutoBraces() && command.getOffset() < document.getLength() && document.get(command.getOffset(), 1).equals(command.getText())) {
                        boolean found = false;
                        int i = 1;
                        while (i <= PyStringUtils.BRACKETS.length && !found) {
                            char b = PyStringUtils.BRACKETS[i];
                            if (b == c) {
                                found = true;
                                this.performPairReplacement(document, command);
                            }
                            i += 2;
                        }
                    }
                    return;
                }
            }
        }
        catch (BadLocationException e) {
            command.setText("BadLocationException");
            throw new RuntimeException(e);
        }
    }

    public static boolean isNewLineText(IDocument document, int length, String text) {
        return length == 0 && text != null && TextSelectionUtils.endsWithNewline((IDocument)document, (String)text) && text.length() < 3;
    }

    public static void handleParens(IDocument document, IDocumentCommand command, IIndentPrefs prefs, boolean considerOnlyCurrentLine) throws BadLocationException {
        PyAutoIndentStrategy.autoDedentElif(document, command, prefs);
        PyAutoIndentStrategy.customizeParenthesis(document, command, considerOnlyCurrentLine, prefs);
    }

    @Override
    public void setConsiderOnlyCurrentLine(boolean considerOnlyCurrentLine) {
        this.considerOnlyCurrentLine = considerOnlyCurrentLine;
    }

    public boolean getConsiderOnlyCurrentLine() {
        return this.considerOnlyCurrentLine;
    }

    private void handleLiteral(IDocument document, IDocumentCommand command, boolean isDefaultContext, char literalChar) {
        boolean hasMatchesAfter;
        if (!this.prefs.getAutoLiterals()) {
            return;
        }
        TextSelectionUtils ps = new TextSelectionUtils(document, (ICoreTextSelection)new CoreTextSelection(document, command.getOffset(), command.getLength()));
        if (command.getLength() > 0) {
            try {
                ps.deleteSelection();
                command.setLength(0);
                ps.setSelection(command.getOffset(), command.getOffset());
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        try {
            char nextChar = ps.getCharAfterCurrentOffset();
            if (Character.isJavaIdentifierPart(nextChar)) {
                return;
            }
        }
        catch (BadLocationException nextChar) {
            // empty catch block
        }
        String cursorLineContents = ps.getCursorLineContents();
        if (cursorLineContents.indexOf(literalChar) == -1) {
            if (!isDefaultContext) {
                return;
            }
            command.setText(StringUtils.getWithClosedPeer((char)literalChar));
            command.setShiftsCaret(false);
            command.setCaretOffset(command.getOffset() + 1);
            return;
        }
        boolean balanced = this.isLiteralBalanced(cursorLineContents);
        Tuple beforeAndAfterMatchingChars = ps.getBeforeAndAfterMatchingChars(literalChar);
        int matchesBefore = ((String)beforeAndAfterMatchingChars.o1).length();
        int matchesAfter = ((String)beforeAndAfterMatchingChars.o2).length();
        boolean hasMatchesBefore = matchesBefore != 0;
        boolean bl = hasMatchesAfter = matchesAfter != 0;
        if (!hasMatchesBefore && !hasMatchesAfter) {
            if (balanced) {
                if (!isDefaultContext) {
                    return;
                }
                command.setText(StringUtils.getWithClosedPeer((char)literalChar));
                command.setShiftsCaret(false);
                command.setCaretOffset(command.getOffset() + 1);
            }
        } else if (matchesAfter == 1) {
            command.setText("");
            command.setShiftsCaret(false);
            command.setCaretOffset(command.getOffset() + 1);
        }
    }

    private boolean isLiteralBalanced(String cursorLineContents) {
        ParsingUtils parsingUtils = ParsingUtils.create(cursorLineContents, true);
        int offset = 0;
        int end = cursorLineContents.length();
        boolean balanced = true;
        while (offset < end) {
            int eaten;
            char curr;
            if ((curr = cursorLineContents.charAt(offset++)) != '\"' && curr != '\'') continue;
            try {
                eaten = parsingUtils.eatLiterals(null, offset - 1) + 1;
            }
            catch (SyntaxErrorException e) {
                balanced = false;
                break;
            }
            if (eaten <= offset) continue;
            offset = eaten;
        }
        return balanced;
    }

    private void handleTab(IDocument document, IDocumentCommand command) throws BadLocationException {
        PySelection ps = new PySelection(document, command.getOffset());
        String lineContentsToCursor = ps.getLineContentsToCursor();
        int currSize = lineContentsToCursor.length();
        int cursorLine = ps.getCursorLine();
        if (lineContentsToCursor.trim().length() == 0) {
            int firstCharPosition;
            String nextLine = ps.getLine(cursorLine + 1);
            String prevLine = ps.getLine(cursorLine - 1);
            boolean forceTryOnNext = false;
            if (prevLine.trim().length() == 0 && nextLine.trim().length() > 0) {
                forceTryOnNext = true;
            }
            if ((forceTryOnNext || nextLine.trim().startsWith("@") || PySelection.matchesFunctionLine(nextLine)) && currSize < (firstCharPosition = PySelection.getFirstCharPosition((String)nextLine))) {
                String txt = nextLine.substring(currSize, firstCharPosition);
                command.setText(txt);
                return;
            }
        }
        if (cursorLine > 0) {
            String prevExpectedIndent;
            IRegion prevLineInfo = document.getLineInformation(cursorLine - 1);
            int prevLineEndOffset = prevLineInfo.getOffset() + prevLineInfo.getLength();
            String txt = prevExpectedIndent = this.autoIndentSameAsPrevious(document, prevLineEndOffset, "\n", false);
            Tuple<String, Boolean> prevLineTup = this.autoIndentNewline(document, 0, txt, prevLineEndOffset);
            txt = (String)prevLineTup.o1;
            txt = txt.substring(1);
            prevExpectedIndent = prevExpectedIndent.substring(1);
            if (txt.length() > 0) {
                int sizeExpected = txt.length();
                int sizeApplied = currSize + sizeExpected;
                if (currSize >= sizeExpected) {
                    boolean applied = false;
                    if (((Boolean)prevLineTup.o2).booleanValue()) {
                        int len = sizeApplied - sizeExpected;
                        if (prevExpectedIndent.length() > len) {
                            command.setText(prevExpectedIndent.substring(len));
                            applied = true;
                        }
                    }
                    if (!applied) {
                        this.applyDefaultForTab(command, currSize);
                    }
                } else if (sizeExpected == sizeApplied) {
                    if (command.getLength() == 0) {
                        ps.deleteSpacesAfter(command.getOffset());
                    }
                    command.setText(txt);
                } else if (sizeApplied > sizeExpected) {
                    ps.deleteSpacesAfter(command.getOffset());
                    command.setText(txt.substring(0, sizeExpected - currSize));
                }
            } else {
                this.applyDefaultForTab(command, currSize);
            }
        } else {
            this.applyDefaultForTab(command, currSize);
        }
    }

    public static void customizeParenthesis(IDocument document, IDocumentCommand command, boolean considerOnlyCurrentLine, IIndentPrefs prefs) throws BadLocationException {
        PySelection ps;
        if (prefs.getAutoParentesis() && PyAutoIndentStrategy.shouldClose(ps = new PySelection(document, command.getOffset()), '(', ')')) {
            PyAutoIndentStrategy.customizeParenthesis2(command, considerOnlyCurrentLine, prefs, ps);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void customizeParenthesis2(IDocumentCommand command, boolean considerOnlyCurrentLine, IIndentPrefs prefs, PySelection ps) {
        String line = ps.getLine();
        boolean hasClass = line.indexOf("class ") != -1;
        boolean hasClassMethodDef = line.indexOf(" def ") != -1 || line.indexOf("\tdef ") != -1;
        boolean hasMethodDef = line.indexOf("def ") != -1;
        boolean hasDoublePoint = line.indexOf(":") != -1;
        command.setShiftsCaret(false);
        if (!hasDoublePoint && (hasClass || hasClassMethodDef || hasMethodDef)) {
            if (hasClass) {
                command.setText("():");
                command.setCaretOffset(command.getOffset() + 1);
                return;
            }
            if (hasClassMethodDef && prefs.getAutoAddSelf()) {
                String prevLine = ps.getLine(ps.getCursorLine() - 1);
                if (prevLine.indexOf("@classmethod") != -1) {
                    command.setText("(cls):");
                    command.setCaretOffset(command.getOffset() + 4);
                    return;
                }
                if (prevLine.indexOf("@staticmethod") != -1) {
                    command.setText("():");
                    command.setCaretOffset(command.getOffset() + 1);
                    return;
                }
                boolean addRegular = true;
                if (!considerOnlyCurrentLine) {
                    int firstCharPosition = PySelection.getFirstCharPosition((String)line);
                    PySelection.LineStartingScope scopeStart = ps.getPreviousLineThatStartsScope(PySelection.CLASS_AND_FUNC_TOKENS, false, firstCharPosition);
                    if (scopeStart != null) {
                        if (scopeStart.lineStartingScope != null && scopeStart.lineStartingScope.indexOf("def ") != -1) {
                            int iPrevDef;
                            int iCurrDef = PySelection.getFirstCharPosition((String)line);
                            if (iCurrDef > (iPrevDef = PySelection.getFirstCharPosition((String)scopeStart.lineStartingScope))) {
                                addRegular = false;
                            } else if (iCurrDef == iPrevDef && scopeStart.lineStartingScope.indexOf("self") == -1) {
                                if (scopeStart.iLineStartingScope <= 0) {
                                    addRegular = false;
                                } else {
                                    String line2;
                                    addRegular = false;
                                    int i = scopeStart.iLineStartingScope - 1;
                                    do {
                                        line2 = ps.getLine(i).trim();
                                        --i;
                                        if (!line2.startsWith("@classmethod") && !line2.startsWith("@staticmethod")) continue;
                                        addRegular = true;
                                        break;
                                    } while (line2.startsWith("@"));
                                }
                            }
                        }
                    } else {
                        addRegular = false;
                    }
                }
                if (addRegular) {
                    if ("__exit__".equals(ps.getFunctionName(line))) {
                        command.setText("(self, exc_type, exc_val, exc_tb):");
                    } else {
                        command.setText("(self):");
                    }
                    command.setCaretOffset(command.getOffset() + 5);
                    return;
                } else {
                    command.setText("():");
                    command.setCaretOffset(command.getOffset() + 1);
                }
                return;
            }
            if (!hasMethodDef) throw new RuntimeException(String.valueOf(PyAutoIndentStrategy.class.toString()) + ": customizeDocumentCommand()");
            command.setText("():");
            command.setCaretOffset(command.getOffset() + 1);
            return;
        }
        command.setText("()");
        command.setCaretOffset(command.getOffset() + 1);
    }

    @Override
    public void customizeNewLine(IDocument document, IDocumentCommand command) throws BadLocationException {
        this.prefs = this.getIndentPrefs();
        this.autoIndentSameAsPrevious(document, command);
        if (this.prefs.getSmartIndentPar()) {
            PySelection selection = new PySelection(document, command.getOffset());
            if (selection.getCursorLineContents().trim().length() > 0) {
                command.setText((String)this.autoIndentNewline((IDocument)document, (int)command.getLength(), (String)command.getText(), (int)command.getOffset()).o1);
                if (PySelection.containsOnlyWhitespaces((String)selection.getLineContentsToCursor())) {
                    command.setCaretOffset(command.getOffset() + selection.countSpacesAfter(command.getOffset()));
                }
            }
        } else {
            TextSelectionUtils selection = new TextSelectionUtils(document, command.getOffset());
            if (selection.getLineContentsToCursor().trim().endsWith(":")) {
                command.setText(String.valueOf(command.getText()) + this.prefs.getIndentationString());
            }
        }
    }

    private void applyDefaultForTab(IDocumentCommand command, int lineContentsToCursorLen) {
        IIndentPrefs prefs = this.getIndentPrefs();
        if (prefs.getUseSpaces(true)) {
            int tabWidth = this.getIndentPrefs().getTabWidth();
            int mod = (lineContentsToCursorLen + tabWidth) % tabWidth;
            command.setText(StringUtils.createSpaceString((int)(tabWidth - mod)));
        }
    }

    public static Tuple<String, Integer> autoDedentStatement(IDocument document, IDocumentCommand command, String tok, String[] tokens, IIndentPrefs prefs) throws BadLocationException {
        return PyAutoIndentStrategy.autoDedentStatement(document, command, tok, tokens, prefs, true);
    }

    public static Tuple<String, Integer> autoDedentStatement(IDocument document, IDocumentCommand command, String tok, String[] tokens, IIndentPrefs prefs, boolean applyDedentInDocument) throws BadLocationException {
        String previousIfLine;
        PySelection ps;
        String lineContents;
        if (prefs.getAutoDedentElse() && command.getDoIt() && (lineContents = (ps = new PySelection(document, command.getOffset())).getCursorLineContents()).trim().equals(tok) && (previousIfLine = ps.getPreviousLineThatStartsWithToken(tokens)) != null) {
            String ifIndent = PySelection.getIndentationFromLine((String)previousIfLine);
            String lineIndent = PySelection.getIndentationFromLine((String)lineContents);
            String indent = prefs.getIndentationString();
            if (lineIndent.length() == ifIndent.length() + indent.length()) {
                Tuple<String, Integer> dedented = PyAutoIndentStrategy.removeFirstIndent(lineContents, prefs);
                if (applyDedentInDocument) {
                    ps.replaceLineContentsToSelection((String)dedented.o1);
                }
                command.setOffset(command.getOffset() - (Integer)dedented.o2);
                return dedented;
            }
        }
        return null;
    }

    public static Tuple<String, Integer> autoDedentAfterColon(IDocument document, IDocumentCommand command, IIndentPrefs prefs) throws BadLocationException {
        Tuple<String, Integer> ret = null;
        ret = PyAutoIndentStrategy.autoDedentStatement(document, command, "else", PySelection.TOKENS_BEFORE_ELSE, prefs);
        if (ret != null) {
            return ret;
        }
        ret = PyAutoIndentStrategy.autoDedentStatement(document, command, "except", PySelection.TOKENS_BEFORE_EXCEPT, prefs);
        if (ret != null) {
            return ret;
        }
        ret = PyAutoIndentStrategy.autoDedentStatement(document, command, "finally", PySelection.TOKENS_BEFORE_FINALLY, prefs);
        if (ret != null) {
            return ret;
        }
        return null;
    }

    public static Tuple<String, Integer> autoDedentElif(IDocument document, IDocumentCommand command, IIndentPrefs prefs) throws BadLocationException {
        return PyAutoIndentStrategy.autoDedentStatement(document, command, "elif", PySelection.TOKENS_BEFORE_ELIF, prefs);
    }

    private String makeSmartIndent(String text, int smartIndent) throws BadLocationException {
        if (smartIndent > 0) {
            String initial = text;
            initial = this.getCharsBeforeNewLine(initial);
            String indentationString = this.prefs.getIndentationString();
            int indentationSteps = smartIndent / this.prefs.getTabWidth();
            int spaceSteps = smartIndent % this.prefs.getTabWidth();
            StringBuffer b = new StringBuffer(smartIndent);
            while (indentationSteps > 0) {
                --indentationSteps;
                b.append(indentationString);
            }
            if (this.prefs.getUseSpaces(true)) {
                while (spaceSteps >= 0) {
                    --spaceSteps;
                    b.append(" ");
                }
            }
            return String.valueOf(initial) + b.toString();
        }
        return text;
    }

    private String getCharsBeforeNewLine(String initial) {
        int initialLength = initial.length();
        int i = 0;
        while (i < initialLength) {
            char theChar = initial.charAt(i);
            if (theChar != '\r' && theChar != '\n') {
                if (i <= 0) break;
                initial = initial.substring(0, i);
                break;
            }
            ++i;
        }
        return initial;
    }

    private void performColonReplacement(IDocument document, IDocumentCommand command) {
        int documentLength;
        PySelection ps = new PySelection(document, command.getOffset());
        int absoluteOffset = ps.getAbsoluteCursorOffset();
        if (absoluteOffset < (documentLength = ps.getDoc().getLength())) {
            try {
                char currentCharacter = document.getChar(absoluteOffset);
                if (currentCharacter == ':') {
                    command.setText("");
                    command.setCaretOffset(command.getOffset() + 1);
                }
            }
            catch (BadLocationException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void performPairReplacement(IDocument document, IDocumentCommand command) throws BadLocationException {
        boolean skipChar = this.canSkipCloseParenthesis(document, command);
        if (skipChar) {
            command.setText("");
            command.setCaretOffset(command.getOffset() + 1);
        }
    }

    @Override
    public boolean canSkipCloseParenthesis(IDocument document, IDocumentCommand command) throws BadLocationException {
        PySelection ps = new PySelection(document, command.getOffset());
        int absoluteCursorOffset = ps.getAbsoluteCursorOffset();
        if (absoluteCursorOffset >= document.getLength()) {
            return false;
        }
        char c = ps.getCharAtCurrentOffset();
        if (command.getText() != null && command.getText().length() == 1 && command.getText().charAt(0) == c) {
            try {
                char peer = StringUtils.getPeer((char)c);
                FastStringBuffer doc = new FastStringBuffer(document.get(), 2);
                ParsingUtils.removeCommentsWhitespacesAndLiterals(doc, false);
                int chars = StringUtils.countChars((char)c, (FastStringBuffer)doc);
                int peers = StringUtils.countChars((char)peer, (FastStringBuffer)doc);
                boolean skipChar = chars == peers;
                return skipChar;
            }
            catch (NoPeerAvailableException e) {
                return false;
            }
            catch (SyntaxErrorException e) {
                throw new RuntimeException(e);
            }
        }
        return false;
    }

    public static boolean shouldClose(PySelection ps, char c, char peer) throws BadLocationException {
        int closingPeerLine;
        PySelection.LineStartingScope nextLineThatStartsScope;
        PythonPairMatcher matcher = new PythonPairMatcher(PyStringUtils.BRACKETS);
        String lineContentsFromCursor = ps.getLineContentsFromCursor();
        int i = 0;
        while (i < lineContentsFromCursor.length()) {
            char charAt = lineContentsFromCursor.charAt(i);
            if (!Character.isWhitespace(charAt)) {
                if (charAt == ',' || StringUtils.isClosingPeer((char)charAt)) break;
                return false;
            }
            ++i;
        }
        int lineStartingNextScope = (nextLineThatStartsScope = ps.getNextLineThatStartsScope()) == null ? Integer.MAX_VALUE : nextLineThatStartsScope.iLineStartingScope;
        int closingPeerFoundAtOffset = ps.getAbsoluteCursorOffset() - 1;
        do {
            if ((closingPeerFoundAtOffset = matcher.searchForClosingPeer(closingPeerFoundAtOffset, c, peer, ps.getDoc())) == -1) {
                return true;
            }
            IRegion match = matcher.match(ps.getDoc(), closingPeerFoundAtOffset + 1);
            if (match == null) {
                return false;
            }
            try {
                closingPeerLine = ps.getDoc().getLineOfOffset(closingPeerFoundAtOffset);
            }
            catch (Exception e) {
                break;
            }
        } while (lineStartingNextScope > closingPeerLine);
        return true;
    }

    public Tuple<Integer, Boolean> determineSmartIndent(int offset, IDocument document, IIndentPrefs prefs) throws BadLocationException {
        PythonPairMatcher matcher = new PythonPairMatcher(PyStringUtils.BRACKETS);
        int openingPeerOffset = matcher.searchForAnyOpeningPeer(offset, document);
        if (openingPeerOffset == -1) {
            return new Tuple((Object)-1, (Object)false);
        }
        IRegion lineInformationOfOffset = document.getLineInformationOfOffset(openingPeerOffset);
        boolean openingPeerIsInCurrentLine = PySelection.isInside((int)offset, (IRegion)lineInformationOfOffset);
        boolean indentToParAsPep8 = prefs.getIndentToParAsPep8();
        boolean indentToParLevel = prefs.getIndentToParLevel();
        int indentAfterParWidth = prefs.getIndentAfterParWidth();
        PySelection ps = new PySelection(document, offset);
        String lineContentsToCursor = ps.getLineContentsToCursor();
        if (indentToParAsPep8) {
            String trimmed = lineContentsToCursor.trim();
            if (trimmed.endsWith("(") || trimmed.endsWith("[") || trimmed.endsWith("{")) {
                indentToParLevel = false;
                indentAfterParWidth = PySelection.matchesFunctionLine(trimmed) || PySelection.matchesClassLine(trimmed) ? (prefs.getUseSpaces(true) ? 2 : 3) : (prefs.getUseSpaces(true) ? 1 : 2);
            } else {
                indentToParLevel = true;
            }
        }
        int len = -1;
        String contents = "";
        if (indentToParLevel) {
            String fromParToCursor;
            if (!openingPeerIsInCurrentLine) {
                try {
                    char openingChar = document.getChar(openingPeerOffset);
                    int closingPeerOffset = matcher.searchForClosingPeer(openingPeerOffset, openingChar, StringUtils.getPeer((char)openingChar), document);
                    if (closingPeerOffset == -1 || offset <= closingPeerOffset) {
                        if (PyStringUtils.hasUnbalancedClosingPeers(lineContentsToCursor)) {
                            int peerI = lineContentsToCursor.length() - 1;
                            while (peerI >= 0) {
                                IRegion lineInformationOfOffset2;
                                int currLineOffset;
                                int foundAtOffset;
                                char c = lineContentsToCursor.charAt(peerI);
                                if (StringUtils.isClosingPeer((char)c) && (foundAtOffset = matcher.searchForOpeningPeer(ps.getLineOffset() + peerI, StringUtils.getPeer((char)c), c, document)) != -1 && (currLineOffset = ps.getLineOffset()) != (lineInformationOfOffset2 = document.getLineInformationOfOffset(foundAtOffset)).getOffset()) {
                                    String line = ps.getLine(ps.getLineOfOffset(lineInformationOfOffset2.getOffset()));
                                    int openPeerI = 0;
                                    while (openPeerI < line.length()) {
                                        char f = line.charAt(openPeerI);
                                        if (StringUtils.isOpeningPeer((char)f)) {
                                            int closingPeerOffsetFound = matcher.searchForClosingPeer(lineInformationOfOffset2.getOffset() + openPeerI, f, StringUtils.getPeer((char)f), document);
                                            if (closingPeerOffsetFound != -1 && closingPeerOffsetFound <= offset) break;
                                            return this.determineSmartIndent(lineInformationOfOffset2.getLength() + lineInformationOfOffset2.getOffset(), document, prefs);
                                        }
                                        ++openPeerI;
                                    }
                                    return new Tuple((Object)(TextSelectionUtils.getFirstCharRelativePosition((IDocument)document, (int)foundAtOffset) - 1), (Object)true);
                                }
                                --peerI;
                            }
                        }
                        return new Tuple((Object)-1, (Object)true);
                    }
                }
                catch (Exception e) {
                    Log.log(e);
                    return new Tuple((Object)-1, (Object)true);
                }
            }
            if (openingPeerIsInCurrentLine && openingPeerOffset < offset && (fromParToCursor = document.get(openingPeerOffset, offset - openingPeerOffset)).length() > 0 && fromParToCursor.charAt(0) == '(' && !PySelection.containsOnlyWhitespaces((String)(fromParToCursor = fromParToCursor.substring(1)))) {
                int firstCharPosition = PySelection.getFirstCharPosition((String)fromParToCursor);
                openingPeerOffset += firstCharPosition;
            }
            int openingPeerLineOffset = lineInformationOfOffset.getOffset();
            len = openingPeerOffset - openingPeerLineOffset;
            contents = document.get(openingPeerLineOffset, len);
        } else {
            if (!openingPeerIsInCurrentLine) {
                return new Tuple((Object)-1, (Object)true);
            }
            int line = document.getLineOfOffset(openingPeerOffset);
            String indent = prefs.getIndentationString();
            contents = PySelection.getLine((IDocument)document, (int)line);
            contents = PySelection.getIndentationFromLine((String)contents);
            StringBuffer sb = new StringBuffer();
            int i = 0;
            while (i < indentAfterParWidth) {
                sb.append(indent);
                ++i;
            }
            contents = String.valueOf(contents) + sb.substring(0, sb.length() - 1);
            len = contents.length();
        }
        int i = 0;
        while (i < contents.length()) {
            if (contents.charAt(i) == '\t') {
                len += prefs.getTabWidth() - 1;
            }
            ++i;
        }
        return new Tuple((Object)len, (Object)true);
    }

    public void setBlockSelection(boolean blockSelection) {
        this.blockSelection = blockSelection;
    }

    @Override
    public String convertTabs(String cmd) {
        DocCmd newStr = new DocCmd(0, 0, cmd);
        this.getIndentPrefs().convertToStd(this.EMPTY_DOCUMENT, (IDocumentCommand)newStr);
        cmd = newStr.text;
        return cmd;
    }

    public void setCythonFile(boolean isCython) {
        this.isCython = isCython;
    }
}

