/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.core.cache;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public final class SoftHashMap<Key, Val>
extends AbstractMap<Key, Val> {
    private final Map<Key, SoftValue<Key, Val>> map = new HashMap<Key, SoftValue<Key, Val>>();
    private ReferenceQueue<Val> queue = new ReferenceQueue();

    @Override
    public Val get(Object key) {
        Val res = null;
        SoftValue<Key, Val> sr = this.map.get(key);
        if (sr != null && (res = (Val)sr.get()) == null) {
            this.removeStaleEntries();
        }
        return res;
    }

    public void removeStaleEntries() {
        SoftValue softValue;
        while ((softValue = (SoftValue)this.queue.poll()) != null) {
            SoftValue<Key, Val> curr = this.map.get(softValue.key);
            if (curr != softValue) continue;
            this.map.remove(softValue.key);
        }
    }

    @Override
    public Val put(Key key, Val value) {
        this.map.put(key, new SoftValue<Key, Val>(value, key, this.queue));
        return value;
    }

    @Override
    public Val remove(Object key) {
        this.map.remove(key);
        return null;
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public void clear() {
        this.map.clear();
        this.queue = new ReferenceQueue();
    }

    @Override
    public Set entrySet() {
        throw new UnsupportedOperationException("Not implemented!");
    }

    private static final class SoftValue<Key, Val>
    extends SoftReference<Val> {
        private final Key key;

        private SoftValue(Val value, Key key, ReferenceQueue<Val> queue) {
            super(value, queue);
            this.key = key;
        }
    }
}

