/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.core.docutils;

import java.io.IOException;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.python.pydev.core.docutils.ParsingUtils;
import org.python.pydev.core.docutils.PySelection;
import org.python.pydev.core.docutils.SyntaxErrorException;
import org.python.pydev.shared_core.string.FastStringBuffer;

public class PythonCodeReader {
    public static final int EOF = -1;
    private boolean fForward = false;
    private IDocument fDocument;
    private int fOffset;
    private int fEnd = -1;
    private boolean fOnlyInCurrentStmt;
    private ParsingUtils fParsingUtils;
    private FastStringBuffer wordBuffer = new FastStringBuffer();
    private int wordBufferOffset = -1;
    private int handledLine = -1;

    public int getOffset() {
        return this.fForward ? this.fOffset - 1 : this.fOffset;
    }

    public void configureForwardReader(IDocument document, int offset, int length, boolean skipComments, boolean skipStrings, boolean onlyInCurrentStmt) throws IOException {
        Assert.isTrue((boolean)skipComments);
        Assert.isTrue((boolean)skipStrings);
        this.fParsingUtils = ParsingUtils.create(document);
        this.fOnlyInCurrentStmt = onlyInCurrentStmt;
        this.fDocument = document;
        this.fOffset = offset;
        this.fForward = true;
        this.fEnd = Math.min(this.fDocument.getLength(), this.fOffset + length);
    }

    public void configureBackwardReader(IDocument document, int offset, boolean skipComments, boolean skipStrings, boolean onlyInCurrentStmt) throws IOException {
        Assert.isTrue((boolean)skipComments);
        Assert.isTrue((boolean)skipStrings);
        this.fParsingUtils = ParsingUtils.create(document);
        this.fOnlyInCurrentStmt = onlyInCurrentStmt;
        this.fDocument = document;
        this.fOffset = offset;
        this.fForward = false;
    }

    public void close() throws IOException {
        this.fDocument = null;
    }

    public int read() throws IOException {
        try {
            return this.fForward ? this.readForwards() : this.readBackwards();
        }
        catch (BadLocationException x) {
            return -1;
        }
    }

    private int readForwards() throws BadLocationException {
        if (this.wordBufferOffset >= 0) {
            if (this.wordBufferOffset < this.wordBuffer.length()) {
                ++this.fOffset;
                return this.wordBuffer.charAt(this.wordBufferOffset++);
            }
            this.wordBuffer.clear();
            this.wordBufferOffset = -1;
        }
        while (this.fOffset < this.fEnd) {
            char current = this.fDocument.getChar(this.fOffset++);
            switch (current) {
                case '#': {
                    this.fOffset = this.fParsingUtils.eatComments(null, this.fOffset);
                    return current;
                }
                case '\"': 
                case '\'': {
                    try {
                        this.fOffset = this.fParsingUtils.eatLiterals(null, this.fOffset - 1) + 1;
                        break;
                    }
                    catch (SyntaxErrorException e) {
                        return -1;
                    }
                }
                default: {
                    if (this.fOnlyInCurrentStmt && Character.isJavaIdentifierPart(current)) {
                        this.wordBuffer.clear().append(current);
                        int offset = this.fOffset;
                        while (offset < this.fEnd) {
                            char c;
                            if (!Character.isJavaIdentifierPart(c = this.fDocument.getChar(offset++))) break;
                            this.wordBuffer.append(c);
                        }
                        if (PySelection.STATEMENT_TOKENS.contains(this.wordBuffer.toString())) {
                            return -1;
                        }
                        this.wordBufferOffset = 1;
                        return current;
                    }
                    return current;
                }
            }
        }
        return -1;
    }

    private int readBackwards() throws BadLocationException {
        if (this.wordBufferOffset >= 0) {
            if (this.wordBufferOffset > 0) {
                --this.fOffset;
                return this.wordBuffer.charAt(--this.wordBufferOffset);
            }
            this.wordBuffer.clear();
            this.wordBufferOffset = -1;
        }
        while (this.fOffset > 0) {
            --this.fOffset;
            this.handleComment();
            if (this.fOffset < 0) {
                return -1;
            }
            char current = this.fDocument.getChar(this.fOffset);
            switch (current) {
                case '\"': 
                case '\'': {
                    try {
                        this.fOffset = this.fParsingUtils.eatLiteralsBackwards(null, this.fOffset);
                        break;
                    }
                    catch (SyntaxErrorException e) {
                        return -1;
                    }
                }
                default: {
                    if (this.fOnlyInCurrentStmt && Character.isJavaIdentifierPart(current)) {
                        this.wordBuffer.clear();
                        int offset = this.fOffset;
                        while (offset >= 0) {
                            char c;
                            if (!Character.isJavaIdentifierPart(c = this.fDocument.getChar(offset--))) break;
                            this.wordBuffer.append(c);
                        }
                        this.wordBuffer.reverse();
                        if (PySelection.STATEMENT_TOKENS.contains(this.wordBuffer.toString())) {
                            return -1;
                        }
                        this.wordBufferOffset = this.wordBuffer.length() - 1;
                        return current;
                    }
                    return current;
                }
            }
        }
        return -1;
    }

    private void handleComment() throws BadLocationException {
        int i;
        int lineOfOffset = this.fDocument.getLineOfOffset(this.fOffset);
        if (this.handledLine == lineOfOffset) {
            return;
        }
        this.handledLine = lineOfOffset;
        String line = PySelection.getLine((IDocument)this.fDocument, (int)lineOfOffset);
        int fromIndex = 0;
        IRegion lineInformation = null;
        while ((i = line.indexOf(35, fromIndex)) != -1) {
            int offset;
            String contentType;
            fromIndex = i + 1;
            if (lineInformation == null) {
                lineInformation = this.fDocument.getLineInformation(lineOfOffset);
            }
            if (!(contentType = ParsingUtils.getContentType(this.fDocument, (offset = lineInformation.getOffset() + i) + 1)).equals("__python_comment") || offset >= this.fOffset) continue;
            this.fOffset = offset;
            return;
        }
    }
}

