/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.json.eclipsesource;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.python.pydev.json.eclipsesource.JsonValue;
import org.python.pydev.json.eclipsesource.JsonWriter;

public class JsonArray
extends JsonValue
implements Iterable<JsonValue> {
    private final List<JsonValue> values;

    public JsonArray() {
        this.values = new ArrayList<JsonValue>();
    }

    public JsonArray(JsonArray array) {
        if (array == null) {
            throw new NullPointerException("array is null");
        }
        this.values = new ArrayList<JsonValue>(array.values);
    }

    private JsonArray(List<JsonValue> values) {
        this.values = values;
    }

    public static JsonArray readFrom(Reader reader) throws IOException {
        return JsonValue.readFrom(reader).asArray();
    }

    public static JsonArray readFrom(String string) {
        return JsonValue.readFrom(string).asArray();
    }

    public static JsonArray unmodifiableArray(JsonArray array) {
        return new JsonArray(Collections.unmodifiableList(array.values));
    }

    public JsonArray add(long value) {
        this.values.add(JsonArray.valueOf(value));
        return this;
    }

    public JsonArray add(float value) {
        this.values.add(JsonArray.valueOf(value));
        return this;
    }

    public JsonArray add(double value) {
        this.values.add(JsonArray.valueOf(value));
        return this;
    }

    public JsonArray add(boolean value) {
        this.values.add(JsonArray.valueOf(value));
        return this;
    }

    public JsonArray add(String value) {
        this.values.add(JsonArray.valueOf(value));
        return this;
    }

    public JsonArray add(JsonValue value) {
        if (value == null) {
            throw new NullPointerException("value is null");
        }
        this.values.add(value);
        return this;
    }

    public int size() {
        return this.values.size();
    }

    public boolean isEmpty() {
        return this.values.isEmpty();
    }

    public JsonValue get(int index) {
        return this.values.get(index);
    }

    public List<JsonValue> values() {
        return Collections.unmodifiableList(this.values);
    }

    @Override
    public Iterator<JsonValue> iterator() {
        return Collections.unmodifiableList(this.values).iterator();
    }

    @Override
    protected void write(JsonWriter writer) throws IOException {
        writer.writeBeginArray();
        int length = this.values.size();
        int i = 0;
        while (i < length) {
            if (i != 0) {
                writer.writeArrayValueSeparator();
            }
            this.values.get(i).write(writer);
            ++i;
        }
        writer.writeEndArray();
    }

    @Override
    public boolean isArray() {
        return true;
    }

    @Override
    public JsonArray asArray() {
        return this;
    }

    public int hashCode() {
        return this.values.hashCode();
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        JsonArray other = (JsonArray)object;
        return this.values.equals(other.values);
    }
}

