/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.json.eclipsesource;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import org.python.pydev.json.eclipsesource.JsonArray;
import org.python.pydev.json.eclipsesource.JsonLiteral;
import org.python.pydev.json.eclipsesource.JsonNumber;
import org.python.pydev.json.eclipsesource.JsonObject;
import org.python.pydev.json.eclipsesource.JsonParser;
import org.python.pydev.json.eclipsesource.JsonString;
import org.python.pydev.json.eclipsesource.JsonWriter;
import org.python.pydev.json.eclipsesource.PrettyJsonWriter;

public abstract class JsonValue {
    public static final JsonValue TRUE = new JsonLiteral("true");
    public static final JsonValue FALSE = new JsonLiteral("false");
    public static final JsonValue NULL = new JsonLiteral("null");

    JsonValue() {
    }

    public static JsonValue readFrom(Reader reader) throws IOException {
        return new JsonParser(reader).parse();
    }

    public static JsonValue readFrom(String text) {
        try {
            return new JsonParser(new StringReader(text)).parse();
        }
        catch (IOException exception) {
            throw new RuntimeException(exception);
        }
    }

    public static JsonValue valueOf(long value) {
        return new JsonNumber(Long.toString(value, 10));
    }

    public static JsonValue valueOf(float value) {
        if (Float.isInfinite(value) || Float.isNaN(value)) {
            throw new IllegalArgumentException("Infinite and NaN values not permitted in JSON");
        }
        return new JsonNumber(Float.toString(value));
    }

    public static JsonValue valueOf(double value) {
        if (Double.isInfinite(value) || Double.isNaN(value)) {
            throw new IllegalArgumentException("Infinite and NaN values not permitted in JSON");
        }
        return new JsonNumber(Double.toString(value));
    }

    public static JsonValue valueOf(String string) {
        return string == null ? NULL : new JsonString(string);
    }

    public static JsonValue valueOf(boolean value) {
        return value ? TRUE : FALSE;
    }

    public boolean isObject() {
        return false;
    }

    public boolean isArray() {
        return false;
    }

    public boolean isNumber() {
        return false;
    }

    public boolean isString() {
        return false;
    }

    public boolean isBoolean() {
        return false;
    }

    public boolean isTrue() {
        return false;
    }

    public boolean isFalse() {
        return false;
    }

    public boolean isNull() {
        return false;
    }

    public JsonObject asObject() {
        throw new UnsupportedOperationException("Not an object: " + this.toString());
    }

    public JsonArray asArray() {
        throw new UnsupportedOperationException("Not an array: " + this.toString());
    }

    public int asInt() {
        throw new UnsupportedOperationException("Not a number: " + this.toString());
    }

    public long asLong() {
        throw new UnsupportedOperationException("Not a number: " + this.toString());
    }

    public float asFloat() {
        throw new UnsupportedOperationException("Not a number: " + this.toString());
    }

    public double asDouble() {
        throw new UnsupportedOperationException("Not a number: " + this.toString());
    }

    public String asString() {
        throw new UnsupportedOperationException("Not a string: " + this.toString());
    }

    public boolean asBoolean() {
        throw new UnsupportedOperationException("Not a boolean: " + this.toString());
    }

    public void writeTo(Writer writer) throws IOException {
        this.write(new JsonWriter(writer));
    }

    public String toString() {
        StringWriter stringWriter = new StringWriter();
        JsonWriter jsonWriter = new JsonWriter(stringWriter);
        try {
            this.write(jsonWriter);
        }
        catch (IOException exception) {
            throw new RuntimeException(exception);
        }
        return stringWriter.toString();
    }

    public String toPrettyString() {
        StringWriter stringWriter = new StringWriter();
        PrettyJsonWriter jsonWriter = new PrettyJsonWriter(stringWriter);
        try {
            this.write(jsonWriter);
        }
        catch (IOException exception) {
            throw new RuntimeException(exception);
        }
        return stringWriter.toString();
    }

    public boolean equals(Object object) {
        return super.equals(object);
    }

    protected abstract void write(JsonWriter var1) throws IOException;
}

