/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.ast.analysis.messages;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.python.pydev.ast.analysis.IAnalysisPreferences;
import org.python.pydev.ast.analysis.messages.AbstractMessage;
import org.python.pydev.ast.analysis.messages.IMessage;
import org.python.pydev.core.IToken;
import org.python.pydev.shared_core.string.FastStringBuffer;

public class CompositeMessage
extends AbstractMessage {
    List<IMessage> msgs = new ArrayList<IMessage>();
    public static int MAXIMUM_NUMBER_OF_INTERNAL_MESSAGES = 15;
    private boolean addSupressMessage = false;
    private String shortMessage;

    public CompositeMessage(int type, IToken generator, IAnalysisPreferences prefs) {
        super(type, generator, prefs);
    }

    public CompositeMessage(int type, int startLine, int endLine, int startCol, int endCol, IAnalysisPreferences prefs) {
        super(type, startLine, endLine, startCol, endCol, prefs);
    }

    public void addMessage(IMessage msg) {
        if (this.shortMessage != null) {
            throw new RuntimeException("Cannot add more messages after it's own short message was requested.");
        }
        if (this.msgs.size() > MAXIMUM_NUMBER_OF_INTERNAL_MESSAGES) {
            this.addSupressMessage = true;
            return;
        }
        if (!this.msgs.contains(msg)) {
            this.msgs.add(msg);
        }
    }

    @Override
    public String getShortMessage() {
        if (this.shortMessage == null) {
            FastStringBuffer buffer = new FastStringBuffer(this.msgs.size() * 40);
            ArrayList<String> messages = new ArrayList<String>();
            for (IMessage msg : this.msgs) {
                messages.add(msg.getShortMessage().toString());
            }
            Collections.sort(messages);
            Iterator<IMessage> iter = messages.iterator();
            while (iter.hasNext()) {
                buffer.append((String)((Object)iter.next()));
                if (!iter.hasNext()) continue;
                buffer.append(", ");
            }
            if (this.addSupressMessage) {
                buffer.append("... others suppressed");
            }
            this.shortMessage = buffer.toString();
        }
        return this.shortMessage;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof CompositeMessage)) {
            return false;
        }
        CompositeMessage m = (CompositeMessage)obj;
        return m.getMessage().equals(this.getMessage());
    }

    public int hashCode() {
        return this.getMessage().hashCode();
    }
}

