/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.ast.codecompletion;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IRegion;
import org.python.pydev.ast.codecompletion.AbstractPyCodeCompletion;
import org.python.pydev.ast.codecompletion.CompletionRequest;
import org.python.pydev.ast.codecompletion.IPyDevCompletionParticipant;
import org.python.pydev.ast.codecompletion.PyCodeCompletionPreferences;
import org.python.pydev.ast.codecompletion.PyCodeCompletionUtils;
import org.python.pydev.ast.codecompletion.PyStringCodeCompletion;
import org.python.pydev.ast.codecompletion.revisited.AbstractASTManager;
import org.python.pydev.ast.codecompletion.revisited.AssignAnalysis;
import org.python.pydev.ast.codecompletion.revisited.CompletionState;
import org.python.pydev.ast.codecompletion.revisited.modules.ClassDefTokensExtractor;
import org.python.pydev.ast.codecompletion.revisited.modules.SourceModule;
import org.python.pydev.ast.codecompletion.revisited.modules.SourceToken;
import org.python.pydev.ast.codecompletion.revisited.visitors.Definition;
import org.python.pydev.ast.codecompletion.revisited.visitors.FindScopeVisitor;
import org.python.pydev.ast.codecompletion.shell.AbstractShell;
import org.python.pydev.ast.codecompletion.shell.CompletionsShell;
import org.python.pydev.ast.refactoring.PyRefactoringFindDefinition;
import org.python.pydev.ast.refactoring.RefactoringRequest;
import org.python.pydev.core.ExtensionHelper;
import org.python.pydev.core.ICodeCompletionASTManager;
import org.python.pydev.core.ICompletionRequest;
import org.python.pydev.core.ICompletionState;
import org.python.pydev.core.IDefinition;
import org.python.pydev.core.IGrammarVersionProvider;
import org.python.pydev.core.ILocalScope;
import org.python.pydev.core.IModule;
import org.python.pydev.core.IModuleRequestState;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.IToken;
import org.python.pydev.core.ITokenCompletionRequest;
import org.python.pydev.core.IterEntry;
import org.python.pydev.core.IterTokenEntry;
import org.python.pydev.core.MisconfigurationException;
import org.python.pydev.core.NoExceptionCloseable;
import org.python.pydev.core.PythonNatureWithoutProjectException;
import org.python.pydev.core.TokensList;
import org.python.pydev.core.TokensListMixedLookingFor;
import org.python.pydev.core.TokensOrProposalsList;
import org.python.pydev.core.docutils.ParsingUtils;
import org.python.pydev.core.docutils.PySelection;
import org.python.pydev.core.log.Log;
import org.python.pydev.core.logging.DebugSettings;
import org.python.pydev.core.proposals.CompletionProposalFactory;
import org.python.pydev.core.structure.CompletionRecursionException;
import org.python.pydev.parser.jython.SimpleNode;
import org.python.pydev.parser.jython.ast.ClassDef;
import org.python.pydev.parser.jython.ast.FunctionDef;
import org.python.pydev.parser.jython.ast.Name;
import org.python.pydev.parser.jython.ast.NameTok;
import org.python.pydev.parser.jython.ast.Return;
import org.python.pydev.parser.jython.ast.VisitorIF;
import org.python.pydev.parser.jython.ast.factory.AdapterPrefs;
import org.python.pydev.parser.jython.ast.factory.PyAstFactory;
import org.python.pydev.parser.jython.ast.stmtType;
import org.python.pydev.parser.visitors.NodeUtils;
import org.python.pydev.shared_core.SharedCorePlugin;
import org.python.pydev.shared_core.callbacks.ICallback;
import org.python.pydev.shared_core.code_completion.ICompletionProposalHandle;
import org.python.pydev.shared_core.image.IImageCache;
import org.python.pydev.shared_core.image.IImageHandle;
import org.python.pydev.shared_core.log.ToLogFile;
import org.python.pydev.shared_core.model.ISimpleNode;
import org.python.pydev.shared_core.string.FullRepIterable;
import org.python.pydev.shared_core.structure.FastStack;
import org.python.pydev.shared_core.structure.ImmutableTuple;
import org.python.pydev.shared_core.structure.OrderedMap;
import org.python.pydev.shared_core.structure.Tuple;

public class PyCodeCompletion
extends AbstractPyCodeCompletion {
    public static ICallback<Object, CompletionRecursionException> onCompletionRecursionException;

    @Override
    public TokensOrProposalsList getCodeCompletionProposals(CompletionRequest request) throws CoreException, BadLocationException, IOException, MisconfigurationException, PythonNatureWithoutProjectException {
        ArrayList<ICompletionProposalHandle> ret;
        block40: {
            if (request.getPySelection().getCursorLineContents().trim().startsWith("#")) {
                return new PyStringCodeCompletion().getCodeCompletionProposals(request);
            }
            if (PySelection.isCompletionForLiteralNumber((String)request.getActivationToken())) {
                return new TokensOrProposalsList();
            }
            if (DebugSettings.DEBUG_CODE_COMPLETION) {
                ToLogFile.toLogFile((Object)this, (String)"Starting getCodeCompletionProposals");
                ToLogFile.addLogLevel();
                ToLogFile.toLogFile((Object)this, (String)("Request:" + request));
            }
            ret = new ArrayList<ICompletionProposalHandle>();
            PySelection ps = request.getPySelection();
            int lineCtx = ps.isRightAfterDeclarationInLine();
            if (lineCtx != PySelection.DECLARATION_NONE) {
                if (lineCtx == PySelection.DECLARATION_METHOD) {
                    this.createOverrideCodeCompletions(request, ret, ps);
                }
                request.showTemplates = false;
                return new TokensOrProposalsList(ret);
            }
            try {
                IPythonNature nature = request.nature;
                this.checkPythonNature(nature);
                ICodeCompletionASTManager astManager = nature.getAstManager();
                if (astManager == null) {
                    return new TokensOrProposalsList(ret);
                }
                TokensOrProposalsList tokensList = new TokensOrProposalsList();
                String trimmed = request.activationToken.replace('.', ' ').trim();
                ICodeCompletionASTManager.ImportInfo importsTipper = this.getImportsTipperStr(request);
                int line = request.doc.getLineOfOffset(request.documentOffset);
                IRegion region = request.doc.getLineInformation(line);
                CompletionState state = new CompletionState(line, request.documentOffset - region.getOffset(), null, request.nature, request.qualifier);
                state.setCancelMonitor(request.getCancelMonitor());
                state.setIsInCalltip(request.isInCalltip);
                HashMap<String, IterTokenEntry> alreadyChecked = new HashMap<String, IterTokenEntry>();
                boolean importsTip = false;
                if (request.activationToken.startsWith("super()")) {
                    this.createSuperCodeCompletions(request, tokensList, ps);
                } else if (importsTipper.importsTipperStr.length() != 0) {
                    request.isInCalltip = false;
                    request.isInMethodKeywordParam = false;
                    importsTip = this.doImportCompletion(request, astManager, tokensList, importsTipper);
                } else if (trimmed.length() > 0 && request.activationToken.indexOf(46) != -1) {
                    TokensList tokenCompletions = new TokensList();
                    PyCodeCompletion.doTokenCompletion(request, astManager, tokenCompletions, trimmed, state);
                    tokensList.addAll(tokenCompletions);
                    this.handleKeywordParam(request, line, alreadyChecked);
                } else {
                    if (request.isInCalltip) {
                        state.setLookingFor(ICompletionState.LookingFor.LOOKING_FOR_INSTANCED_VARIABLE);
                    }
                    this.doGlobalsCompletion(request, astManager, tokensList, state);
                    this.handleKeywordParam(request, line, alreadyChecked);
                }
                ArrayList<Object> analyzedTokens = null;
                if (request.qualifier.length() >= PyCodeCompletionPreferences.getArgumentsDeepAnalysisNChars()) {
                    state.pushFindResolveImportMemoryCtx();
                    try {
                        PyCodeCompletionUtils.IFilter nameFilter = PyCodeCompletionUtils.getNameFilter(request.useSubstringMatchInCodeCompletion, request.qualifier);
                        int i = 0;
                        analyzedTokens = new ArrayList<Object>();
                        Iterator it = tokensList.iterator();
                        while (it.hasNext()) {
                            SourceToken sourceToken;
                            if (++i > 10000) {
                                break;
                            }
                            IterEntry entry = (IterEntry)it.next();
                            Object o = entry.object;
                            if (!(o instanceof IToken)) {
                                analyzedTokens.add(o);
                                continue;
                            }
                            IToken initialToken = (IToken)o;
                            IToken token = initialToken;
                            String strRep = token.getRepresentation();
                            IterTokenEntry iterTokenEntry = (IterTokenEntry)alreadyChecked.get(strRep);
                            IToken prev = iterTokenEntry == null ? null : iterTokenEntry.getToken();
                            if (prev != null && prev.getArgs().length() != 0 || !nameFilter.acceptName(strRep)) continue;
                            IModule current = request.getModule();
                            while (token.isImportFrom()) {
                                if (token.getArgs().length() > 0) break;
                                ICompletionState s = state.getCopyForResolveImportWithActTok(token.getRepresentation());
                                s.checkFindResolveImportMemory(token);
                                ImmutableTuple modTok = astManager.resolveImport(s, token, current);
                                IToken token2 = (IToken)modTok.o2;
                                current = (IModule)modTok.o1;
                                if (token2 == null || initialToken == token2) break;
                                String args = token2.getArgs();
                                if (args.length() > 0) {
                                    initialToken.setArgs(args);
                                    initialToken.setDocStr(token2.getDocStr());
                                    if (!(initialToken instanceof SourceToken) || !(token2 instanceof SourceToken)) break;
                                    SourceToken initialSourceToken = (SourceToken)initialToken;
                                    SourceToken token2SourceToken = (SourceToken)token2;
                                    initialSourceToken.setAst(token2SourceToken.getAst());
                                    break;
                                }
                                if (token2 == null || token2.equals(token) && token2.getArgs().equals(token.getArgs()) && token2.getParentPackage().equals(token.getParentPackage())) break;
                                token = token2;
                            }
                            if (token instanceof SourceToken && (sourceToken = (SourceToken)token).getAst() instanceof ClassDef && token.getArgs().length() == 0) {
                                IModule module;
                                String parentPackage;
                                ClassDef classDef = (ClassDef)sourceToken.getAst();
                                if (classDef.bases != null && classDef.bases.length > 0 && (parentPackage = sourceToken.getParentPackage()) != null && (module = parentPackage.equals(current.getName()) ? current : astManager.getModule(parentPackage, nature, true, (IModuleRequestState)state)) != null && module instanceof SourceModule) {
                                    SourceModule sourceModule = (SourceModule)module;
                                    int j = 0;
                                    block12: while (j < classDef.bases.length) {
                                        try {
                                            TokensList completions;
                                            ICompletionState.LookingFor lookingFor = state.getLookingFor();
                                            try {
                                                ClassDefTokensExtractor classTokensExtractor = new ClassDefTokensExtractor(classDef, sourceModule, state);
                                                completions = classTokensExtractor.getCompletionsForBase(astManager, (SimpleNode)classDef.bases[j]);
                                            }
                                            finally {
                                                state.setLookingFor(lookingFor, true);
                                            }
                                            if (completions != null && completions.size() > 0) {
                                                for (IterTokenEntry entry1 : completions) {
                                                    IToken comp = entry1.getToken();
                                                    if (!"__init__".equals(comp.getRepresentation())) continue;
                                                    if (comp.getArgs().length() <= 0) break block12;
                                                    initialToken.setArgs(comp.getArgs());
                                                    break block12;
                                                }
                                            }
                                        }
                                        catch (CompletionRecursionException completionRecursionException) {
                                            // empty catch block
                                        }
                                        ++j;
                                    }
                                }
                            }
                            alreadyChecked.put(strRep, new IterTokenEntry(initialToken, entry.lookingFor));
                        }
                    }
                    finally {
                        state.popFindResolveImportMemoryCtx();
                    }
                }
                if (analyzedTokens == null) {
                    tokensList.addAll(new TokensListMixedLookingFor(alreadyChecked.values()));
                } else {
                    tokensList = new TokensOrProposalsList(analyzedTokens.toArray(new Object[0]));
                    tokensList.addAll(new TokensListMixedLookingFor(alreadyChecked.values()));
                }
                PyCodeCompletion.changeItokenToCompletionPropostal(request, ret, tokensList, importsTip, state);
            }
            catch (CompletionRecursionException e) {
                if (onCompletionRecursionException != null) {
                    onCompletionRecursionException.call((Object)e);
                }
                if (!DebugSettings.DEBUG_CODE_COMPLETION) break block40;
                ToLogFile.toLogFile((Exception)((Object)e));
            }
        }
        if (DebugSettings.DEBUG_CODE_COMPLETION) {
            ToLogFile.remLogLevel();
            ToLogFile.toLogFile((Object)this, (String)("Finished completion. Returned:" + ret.size() + " completions.\r\n"));
        }
        return new TokensOrProposalsList(ret);
    }

    private void createSuperCodeCompletions(CompletionRequest request, TokensOrProposalsList tokensList, PySelection ps) throws BadLocationException, CompletionRecursionException, MisconfigurationException {
        Tuple insideParensBaseClasses;
        String lineContentsToCursor = ps.getLineContentsToCursor();
        PySelection.LineStartingScope scopeStart = ps.getPreviousLineThatStartsScope(PySelection.CLASS_TOKEN, false, PySelection.getFirstCharPosition((String)lineContentsToCursor));
        String className = null;
        if (scopeStart != null && (className = PySelection.getClassNameInLine((String)scopeStart.lineStartingScope)) != null && className.length() > 0 && (insideParensBaseClasses = ps.getInsideParentesisToks(true, scopeStart.iLineStartingScope)) != null) {
            for (String baseClass : (List)insideParensBaseClasses.o1) {
                CompletionState state = new CompletionState(-1, -1, null, request.nature, baseClass);
                String actTok = request.activationToken.replace("super()", baseClass);
                if (actTok.endsWith(".")) {
                    actTok = actTok.substring(0, actTok.length() - 1);
                }
                state.setActivationToken(actTok);
                state.setIsInCalltip(false);
                IPythonNature pythonNature = request.nature;
                this.checkPythonNature(pythonNature);
                ICodeCompletionASTManager astManager = pythonNature.getAstManager();
                if (astManager == null) {
                    return;
                }
                IModule module = request.getModule();
                if (module == null) continue;
                Throwable throwable = null;
                Object var16_17 = null;
                try (NoExceptionCloseable c = state.pushLookingFor(ICompletionState.LookingFor.LOOKING_FOR_INSTANCED_VARIABLE);){
                    ICompletionState.LookingFor lookingFor = state.getLookingFor();
                    TokensList comps = astManager.getCompletionsForModule(module, (ICompletionState)state, true, true);
                    tokensList.addAll(comps);
                    comps.setLookingFor(lookingFor);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
        }
    }

    private void createOverrideCodeCompletions(CompletionRequest request, ArrayList<ICompletionProposalHandle> ret, PySelection ps) throws BadLocationException {
        Tuple insideParensBaseClasses;
        IImageCache imageCache = SharedCorePlugin.getImageCache();
        IImageHandle imageOverride = imageCache != null ? imageCache.get("icons/new/method_obj.gif") : null;
        String lineContentsToCursor = ps.getLineContentsToCursor();
        PySelection.LineStartingScope scopeStart = ps.getPreviousLineThatStartsScope(PySelection.CLASS_TOKEN, false, PySelection.getFirstCharPosition((String)lineContentsToCursor));
        String className = null;
        if (scopeStart != null && (className = PySelection.getClassNameInLine((String)scopeStart.lineStartingScope)) != null && className.length() > 0 && (insideParensBaseClasses = ps.getInsideParentesisToks(true, scopeStart.iLineStartingScope)) != null) {
            OrderedMap map = new OrderedMap();
            for (String baseClass : (List)insideParensBaseClasses.o1) {
                try {
                    CompletionState state = new CompletionState(-1, -1, null, request.nature, baseClass);
                    state.setActivationToken(baseClass);
                    state.setIsInCalltip(false);
                    IPythonNature pythonNature = request.nature;
                    this.checkPythonNature(pythonNature);
                    ICodeCompletionASTManager astManager = pythonNature.getAstManager();
                    if (astManager == null) {
                        return;
                    }
                    IModule module = request.getModule();
                    if (module == null) continue;
                    TokensList comps = astManager.getCompletionsForModule(module, (ICompletionState)state, true, true);
                    for (IterTokenEntry entry : comps) {
                        IToken iToken = entry.getToken();
                        String representation = iToken.getRepresentation();
                        ImmutableTuple curr = (ImmutableTuple)map.get((Object)representation);
                        if (curr != null && curr.o1 instanceof SourceToken) continue;
                        int type = iToken.getType();
                        if (iToken instanceof SourceToken && ((SourceToken)iToken).getAst() instanceof FunctionDef) {
                            map.put((Object)representation, (Object)new ImmutableTuple((Object)iToken, (Object)baseClass));
                            continue;
                        }
                        if (type != 2 && type != -1 && type != 4) continue;
                        map.put((Object)representation, (Object)new ImmutableTuple((Object)iToken, (Object)baseClass));
                    }
                }
                catch (Exception e) {
                    Log.log((Throwable)e);
                }
            }
            for (ImmutableTuple tokenAndBaseClass : map.values()) {
                FunctionDef functionDef = null;
                if (tokenAndBaseClass.o1 instanceof SourceToken) {
                    SourceToken sourceToken = (SourceToken)tokenAndBaseClass.o1;
                    SimpleNode ast = sourceToken.getAst();
                    if (ast instanceof FunctionDef) {
                        functionDef = (FunctionDef)ast;
                    } else {
                        functionDef = sourceToken.getAliased().createCopy();
                        NameTok t = (NameTok)functionDef.name;
                        t.id = sourceToken.getRepresentation();
                    }
                } else {
                    String representation = ((IToken)tokenAndBaseClass.o1).getRepresentation();
                    PyAstFactory factory = new PyAstFactory(new AdapterPrefs(ps.getEndLineDelim(), (IGrammarVersionProvider)request.nature));
                    functionDef = factory.createFunctionDef(representation);
                    functionDef.args = factory.createArguments(true, new String[0]);
                    functionDef.args.vararg = new NameTok("args", 5);
                    functionDef.args.kwarg = new NameTok("kwargs", 6);
                    if (!representation.equals("__init__")) {
                        functionDef.body = new stmtType[]{new Return(null)};
                    }
                }
                if (functionDef == null) continue;
                ret.add(CompletionProposalFactory.get().createOverrideMethodCompletionProposal((ICompletionRequest)request, ps, ps.getAbsoluteCursorOffset(), 0, 0, imageOverride, (ISimpleNode)functionDef, (String)tokenAndBaseClass.o2, className));
            }
        }
    }

    private static void fillTokensWithJediCompletions(CompletionRequest request, PySelection ps, IPythonNature nature, ICodeCompletionASTManager astManager, TokensOrProposalsList tokensList) throws IOException, CoreException, MisconfigurationException, PythonNatureWithoutProjectException {
        List<IToken> completions;
        try {
            char c = ps.getCharBeforeCurrentOffset();
            if (c == '(') {
                System.out.println("Get call def.");
            }
        }
        catch (BadLocationException e) {
            Log.log((Throwable)e);
        }
        CompletionsShell shell = (CompletionsShell)AbstractShell.getServerShell(nature, AbstractShell.getShellId());
        String charset = "utf-8";
        List completePythonPath = astManager.getModulesManager().getCompletePythonPath(nature.getProjectInterpreter(), nature.getRelatedInterpreterManager());
        try {
            completions = shell.getJediCompletions(request.editorFile, ps, charset, completePythonPath);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        tokensList.addAll(new TokensList(completions));
    }

    private void handleKeywordParam(CompletionRequest request, int line, Map<String, IterTokenEntry> alreadyChecked) throws BadLocationException, CompletionRecursionException {
        if (request.isInMethodKeywordParam) {
            PySelection ps = new PySelection(request.doc, request.offsetForKeywordParam);
            RefactoringRequest findRequest = new RefactoringRequest(request.editorFile, ps, (IProgressMonitor)new NullProgressMonitor(), request.nature, null);
            ArrayList<IDefinition> selected = new ArrayList<IDefinition>();
            CompletionState completionState = new CompletionState();
            PyRefactoringFindDefinition.findActualDefinition(findRequest, completionState, selected);
            HashSet<String> ignore = new HashSet<String>();
            ignore.add("self");
            ignore.add("cls");
            for (IDefinition iDefinition : selected) {
                if (!(iDefinition instanceof Definition)) continue;
                Definition definition = (Definition)iDefinition;
                if (definition.ast == null) continue;
                String args = NodeUtils.getNodeArgs((SimpleNode)definition.ast);
                String fullArgs = NodeUtils.getFullArgs((SimpleNode)definition.ast);
                StringTokenizer tokenizer = new StringTokenizer(args, "(, )");
                while (tokenizer.hasMoreTokens()) {
                    String nextToken = tokenizer.nextToken();
                    if (ignore.contains(nextToken)) continue;
                    String kwParam = String.valueOf(nextToken) + "=";
                    NameTok node = new NameTok(kwParam, 6);
                    SourceToken sourceToken = new SourceToken((SimpleNode)node, kwParam, "", "", "", 9, definition.module != null ? definition.module.getNature() : null);
                    sourceToken.setDocStr(fullArgs);
                    alreadyChecked.put(kwParam, new IterTokenEntry((Object)sourceToken));
                }
            }
        }
    }

    private void doGlobalsCompletion(CompletionRequest request, ICodeCompletionASTManager astManager, TokensOrProposalsList tokensList, ICompletionState state) throws CompletionRecursionException, MisconfigurationException {
        IModule module;
        state.setActivationToken(request.activationToken);
        if (DebugSettings.DEBUG_CODE_COMPLETION) {
            ToLogFile.toLogFile((Object)this, (String)"astManager.getCompletionsForToken");
            ToLogFile.addLogLevel();
        }
        if ((module = request.getModule()) == null) {
            ToLogFile.remLogLevel();
            ToLogFile.toLogFile((Object)this, (String)"END astManager.getCompletionsForToken: null module");
            return;
        }
        TokensList comps = astManager.getCompletionsForModule(module, state, true, true);
        if (DebugSettings.DEBUG_CODE_COMPLETION) {
            ToLogFile.remLogLevel();
            ToLogFile.toLogFile((Object)this, (String)"END astManager.getCompletionsForToken");
        }
        tokensList.addAll(comps);
        tokensList.addAll(this.getGlobalsFromParticipants(request, state));
    }

    public static void doTokenCompletion(ITokenCompletionRequest request, ICodeCompletionASTManager astManager, TokensList tokensList, String trimmed, ICompletionState state) throws CompletionRecursionException, MisconfigurationException, IOException, CoreException, PythonNatureWithoutProjectException {
        if (request.getActivationToken().endsWith(".")) {
            request.setActivationToken(request.getActivationToken().substring(0, request.getActivationToken().length() - 1));
        }
        String initialActivationToken = request.getActivationToken();
        int parI = request.getActivationToken().indexOf(40);
        if (parI != -1) {
            request.setActivationToken(ParsingUtils.removeCalls((String)request.getActivationToken()));
        }
        char[] toks = new char[]{'.', ' '};
        boolean lookInGlobals = true;
        if (trimmed.equals("self") || FullRepIterable.getFirstPart((String)trimmed, (char[])toks).equals("self")) {
            lookInGlobals = !PyCodeCompletion.getSelfOrClsCompletions(request, tokensList, state, false, true, "self");
        } else if (trimmed.equals("cls") || FullRepIterable.getFirstPart((String)trimmed, (char[])toks).equals("cls")) {
            boolean bl = lookInGlobals = !PyCodeCompletion.getSelfOrClsCompletions(request, tokensList, state, false, true, "cls");
        }
        if (lookInGlobals) {
            state.setActivationToken(initialActivationToken);
            IModule module = request.getModule();
            if (module != null) {
                TokensList comps = astManager.getCompletionsForModule(module, state, true, true);
                tokensList.addAll(comps);
            }
        }
    }

    private boolean doImportCompletion(CompletionRequest request, ICodeCompletionASTManager astManager, TokensOrProposalsList tokensList, ICodeCompletionASTManager.ImportInfo importsTipper) throws CompletionRecursionException, MisconfigurationException {
        boolean importsTip = true;
        importsTipper.importsTipperStr = importsTipper.importsTipperStr.trim();
        TokensList imports = astManager.getCompletionsForImport(importsTipper, (ICompletionRequest)request, false);
        tokensList.addAll(imports);
        return importsTip;
    }

    private void checkPythonNature(IPythonNature pythonNature) {
        if (pythonNature == null) {
            throw new RuntimeException("Unable to get python nature.");
        }
    }

    private TokensOrProposalsList getGlobalsFromParticipants(CompletionRequest request, ICompletionState state) throws MisconfigurationException {
        TokensOrProposalsList ret = new TokensOrProposalsList();
        List participants = ExtensionHelper.getParticipants((String)"org.python.pydev.pydev_completion");
        for (IPyDevCompletionParticipant participant : participants) {
            ret.addAll(participant.getGlobalCompletions(request, state));
        }
        return ret;
    }

    public static boolean getSelfOrClsCompletions(ITokenCompletionRequest request, TokensList theList, ICompletionState state, boolean getOnlySupers, boolean checkIfInCorrectScope, String lookForRep) throws MisconfigurationException {
        IModule module = request.getModule();
        SimpleNode s = null;
        if (module instanceof SourceModule) {
            SourceModule sourceModule = (SourceModule)module;
            s = sourceModule.getAst();
        }
        if (s != null) {
            FindScopeVisitor visitor;
            block9: {
                visitor = new FindScopeVisitor(state.getLine() + 1, 1, state.getNature());
                s.accept((VisitorIF)visitor);
                if (!checkIfInCorrectScope) break block9;
                boolean scopeCorrect = false;
                FastStack scopeStack = visitor.scope.getScopeStack();
                Iterator it = scopeStack.topDownIterator();
                while (!scopeCorrect && it.hasNext()) {
                    String rep;
                    ISimpleNode node = (ISimpleNode)it.next();
                    if (!(node instanceof FunctionDef)) continue;
                    FunctionDef funcDef = (FunctionDef)node;
                    if (funcDef.args == null || funcDef.args.args == null || funcDef.args.args.length <= 0 || (rep = NodeUtils.getRepresentationString((SimpleNode)funcDef.args.args[0])) == null || !rep.equals("self") && !rep.equals("cls")) continue;
                    scopeCorrect = true;
                }
                if (scopeCorrect) break block9;
                return false;
            }
            try {
                TokensList tokensList = new TokensList();
                if (lookForRep.equals("self")) {
                    state.setLookingFor(ICompletionState.LookingFor.LOOKING_FOR_INSTANCED_VARIABLE);
                } else {
                    state.setLookingFor(ICompletionState.LookingFor.LOOKING_FOR_CLASSMETHOD_VARIABLE);
                }
                ICompletionState.LookingFor lookingFor = state.getLookingFor();
                PyCodeCompletion.getSelfOrClsCompletions(visitor.scope, request, tokensList, state, getOnlySupers);
                if (tokensList.notEmpty()) {
                    tokensList.setLookingFor(lookingFor);
                    theList.addAll(tokensList);
                }
            }
            catch (Exception e1) {
                Log.log((Throwable)e1);
            }
            return true;
        }
        return false;
    }

    public static void getSelfOrClsCompletions(ILocalScope scope, ITokenCompletionRequest request, TokensList theList, ICompletionState state, boolean getOnlySupers) throws BadLocationException, MisconfigurationException {
        Iterator it = scope.iterator();
        while (it.hasNext()) {
            IModule module;
            SimpleNode node;
            List possibleClassesForActivationToken = scope.getPossibleClassesForActivationToken(request.getActivationToken());
            if (possibleClassesForActivationToken != null && possibleClassesForActivationToken.size() > 0) {
                ICodeCompletionASTManager astManager = request.getNature().getAstManager();
                IModule module2 = request.getModule();
                if (module2 != null) {
                    try {
                        TokensList completions = astManager.getCompletionsFromTokenInLocalScope(module2, state.getCopyWithActTok(request.getActivationToken()), false, false, scope);
                        theList.addAll(completions);
                    }
                    catch (CompletionRecursionException completions) {
                        // empty catch block
                    }
                }
            }
            if (!((node = (SimpleNode)it.next()) instanceof ClassDef)) continue;
            ClassDef d = (ClassDef)node;
            if (getOnlySupers) {
                int i = 0;
                while (i < d.bases.length) {
                    if (d.bases[i] instanceof Name) {
                        Name n = (Name)d.bases[i];
                        state.setActivationToken(n.id);
                        try {
                            ICodeCompletionASTManager astManager = request.getNature().getAstManager();
                            module = request.getModule();
                            if (module != null) {
                                TokensList completions = astManager.getCompletionsForModule(module, state, true, true);
                                theList.addAll(completions);
                            }
                        }
                        catch (CompletionRecursionException astManager) {
                            // empty catch block
                        }
                    }
                    ++i;
                }
                continue;
            }
            String trimmed = request.getActivationToken().replace('.', ' ').trim();
            String[] actTokStrs = trimmed.split(" ");
            if (actTokStrs.length == 0 || !actTokStrs[0].equals("self") && !actTokStrs[0].equals("cls")) {
                throw new AssertionError((Object)"We need to have at least one token (self or cls) for doing completions in the class.");
            }
            if (actTokStrs.length == 1) {
                state.setActivationToken(NodeUtils.getNameFromNameTok((NameTok)((NameTok)d.name)));
                try {
                    ICodeCompletionASTManager astManager = request.getNature().getAstManager();
                    IModule module3 = request.getModule();
                    TokensList completions = astManager.getCompletionsForModule(module3, state, true, true);
                    theList.addAll(completions);
                }
                catch (CompletionRecursionException astManager) {}
                continue;
            }
            int line = request.getLine();
            int col = request.getCol();
            module = request.getModule();
            AbstractASTManager astMan = (AbstractASTManager)request.getNature().getAstManager();
            TokensList assignCompletions = new AssignAnalysis().getAssignCompletions((ICodeCompletionASTManager)astMan, (IModule)module, (ICompletionState)new CompletionState((int)line, (int)col, (String)request.getActivationToken(), (IPythonNature)request.getNature(), (String)request.getQualifier()), (ILocalScope)scope).completions;
            theList.addAll(assignCompletions);
        }
    }
}

