/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.ast.codecompletion;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Optional;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.python.pydev.ast.codecompletion.CompletionRequest;
import org.python.pydev.ast.codecompletion.PyCodeCompletion;
import org.python.pydev.ast.codecompletion.revisited.CompletionState;
import org.python.pydev.core.ICodeCompletionASTManager;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.MisconfigurationException;
import org.python.pydev.core.PythonNatureWithoutProjectException;
import org.python.pydev.core.TokensList;
import org.python.pydev.core.TokensOrProposalsList;
import org.python.pydev.core.partition.PyPartitionScanner;
import org.python.pydev.core.structure.CompletionRecursionException;
import org.python.pydev.shared_core.code_completion.ICompletionProposalHandle;
import org.python.pydev.shared_core.partitioner.FastPartitioner;
import org.python.pydev.shared_core.string.TextSelectionUtils;
import org.python.pydev.shared_core.structure.Tuple;

public class PyCodeCompletionsForTypedDict {
    private final Optional<CompletionRequest> artificialRequest;

    public PyCodeCompletionsForTypedDict(CompletionRequest request) throws BadLocationException {
        this.artificialRequest = this.createArtificialRequest(request);
    }

    public TokensOrProposalsList getStringCompletions() throws CoreException, BadLocationException, IOException, MisconfigurationException, PythonNatureWithoutProjectException, CompletionRecursionException {
        if (this.artificialRequest.isPresent()) {
            CompletionRequest request = this.artificialRequest.get();
            int line = request.doc.getLineOfOffset(request.documentOffset);
            IRegion region = request.doc.getLineInformation(line);
            CompletionState state = new CompletionState(line, request.documentOffset - region.getOffset(), null, request.nature, request.qualifier);
            state.setCancelMonitor(request.getCancelMonitor());
            state.setIsInCalltip(false);
            TokensList tokenCompletions = new TokensList();
            IPythonNature nature = request.nature;
            if (nature == null) {
                throw new RuntimeException("Unable to get python nature.");
            }
            ICodeCompletionASTManager astManager = nature.getAstManager();
            if (astManager == null) {
                return new TokensOrProposalsList();
            }
            String trimmed = request.getActivationToken().replace('.', ' ').trim();
            PyCodeCompletion.doTokenCompletion(request, astManager, tokenCompletions, trimmed, state);
            TokensOrProposalsList tokensList = new TokensOrProposalsList();
            tokensList.addAll(tokenCompletions);
            ArrayList<ICompletionProposalHandle> completionProposals = new ArrayList<ICompletionProposalHandle>();
            PyCodeCompletion.changeItokenToCompletionPropostal(request, completionProposals, tokensList, false, state);
            TokensOrProposalsList ret = new TokensOrProposalsList(completionProposals);
            return ret;
        }
        return null;
    }

    public boolean isTypedDictCompletionRequest() {
        return this.artificialRequest.isPresent();
    }

    private Optional<CompletionRequest> createArtificialRequest(CompletionRequest request) throws BadLocationException {
        Optional<Tuple<String, Integer>> maybeQualifierAndOffset = this.getDictKeyQualifierAndOffset(request);
        if (maybeQualifierAndOffset.isPresent()) {
            Tuple<String, Integer> qualifierAndOffset = maybeQualifierAndOffset.get();
            Optional<String> activationToken = this.getActivationTokenForDictKey(request, (Integer)qualifierAndOffset.o2);
            if (activationToken.isPresent()) {
                String parsedQualifier = (String)qualifierAndOffset.o1;
                CompletionRequest artificialRequest = new CompletionRequest(request.editorFile, request.nature, request.doc, activationToken.get(), request.documentOffset, request.qlen, request.codeCompletion, parsedQualifier, request.useSubstringMatchInCodeCompletion);
                artificialRequest.setCancelMonitor(request.getCancelMonitor());
                artificialRequest.filterToken = (name, tokenType) -> tokenType == 3 && (!name.startsWith("__") || !name.endsWith("__"));
                return Optional.of(artificialRequest);
            }
        }
        return Optional.empty();
    }

    private Optional<Tuple<String, Integer>> getDictKeyQualifierAndOffset(CompletionRequest request) throws BadLocationException {
        IDocumentPartitioner partitioner = PyPartitionScanner.checkPartitionScanner((IDocument)request.doc);
        FastPartitioner fastPartitioner = (FastPartitioner)partitioner;
        ITypedRegion partition = fastPartitioner.getPartition(request.documentOffset);
        String partitionType = partition.getType();
        if ("__python_singleline_bytes_or_unicode1".equals(partitionType) || "__python_singleline_bytes_or_unicode2".equals(partitionType)) {
            return Optional.of(this.getDictKeyQualifierAndOffsetForProbablyCorrectContents(request, partition));
        }
        return Optional.empty();
    }

    private Tuple<String, Integer> getDictKeyQualifierAndOffsetForProbablyCorrectContents(CompletionRequest request, ITypedRegion partition) throws BadLocationException {
        IDocument doc = request.doc;
        int qualifierOffset = partition.getOffset();
        int strContentLen = partition.getLength() - 2;
        String qualifier = "";
        if (strContentLen > 0) {
            qualifier = doc.get(qualifierOffset + 1, strContentLen);
        }
        Tuple ret = new Tuple((Object)qualifier, (Object)qualifierOffset);
        return ret;
    }

    private Optional<String> getActivationTokenForDictKey(CompletionRequest request, int qualifierOffset) throws BadLocationException {
        IDocument doc = request.doc;
        int i = qualifierOffset - 1;
        char c = doc.getChar(i);
        if (c == '[') {
            String activationToken = this.extractBeforeBracketActivationToken(i, doc);
            return Optional.of(activationToken);
        }
        return Optional.empty();
    }

    private String extractBeforeBracketActivationToken(int keyOffset, IDocument doc) throws BadLocationException {
        Tuple extractActivationToken = TextSelectionUtils.extractActivationToken((IDocument)doc, (int)keyOffset, (boolean)true);
        String ret = (String)extractActivationToken.o1;
        if (!ret.endsWith(".")) {
            ret = String.valueOf(ret) + '.';
        }
        return ret;
    }
}

