/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.ast.codecompletion;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateContext;
import org.python.pydev.ast.codecompletion.AbstractTemplateCodeCompletion;
import org.python.pydev.ast.codecompletion.CompletionRequest;
import org.python.pydev.ast.codecompletion.IPyDevCompletionParticipant;
import org.python.pydev.ast.codecompletion.PyCodeCompletion;
import org.python.pydev.ast.codecompletion.PyCodeCompletionImages;
import org.python.pydev.ast.codecompletion.PyCodeCompletionsForTypedDict;
import org.python.pydev.ast.codecompletion.revisited.CompletionCache;
import org.python.pydev.ast.codecompletion.revisited.CompletionStateFactory;
import org.python.pydev.core.ExtensionHelper;
import org.python.pydev.core.ICompletionState;
import org.python.pydev.core.IPythonPartitions;
import org.python.pydev.core.MisconfigurationException;
import org.python.pydev.core.PythonNatureWithoutProjectException;
import org.python.pydev.core.TokensOrProposalsList;
import org.python.pydev.core.docutils.PySelection;
import org.python.pydev.core.log.Log;
import org.python.pydev.core.partition.PyPartitionScanner;
import org.python.pydev.core.proposals.CompletionProposalFactory;
import org.python.pydev.core.structure.CompletionRecursionException;
import org.python.pydev.parser.fastparser.grammar_fstrings_common.FStringsAST;
import org.python.pydev.parser.fastparser.grammar_fstrings_common.SimpleNode;
import org.python.pydev.parser.grammar_fstrings.FStringsGrammarFactory;
import org.python.pydev.shared_core.code_completion.ICompletionProposalHandle;
import org.python.pydev.shared_core.image.IImageHandle;
import org.python.pydev.shared_core.partitioner.FastPartitioner;
import org.python.pydev.shared_core.string.DocIterator;
import org.python.pydev.shared_core.string.TextSelectionUtils;
import org.python.pydev.shared_core.structure.Tuple;

public class PyStringCodeCompletion
extends AbstractTemplateCodeCompletion {
    public static String[] EPYDOC_FIELDS = new String[]{"param", "param ${param}: ${cursor}", "A description of the parameter for a function or method.", "type", "type ${param}: ${cursor}", "The expected type for the parameter, var or property", "return", "return: ", "The return value for a function or method.", "rtype", "rtype: ", "The type of the return value for a function or method.", "keyword", "keyword ${param}: ${cursor}", "A description of the keyword parameter.", "raise", "raise ${exception}: ${cursor}", "A description of the circumstances under which a function or method raises an exception", "ivar", "ivar ${ivar}: ${cursor}", "A description of a class instance variable", "cvar", "cvar ${cvar}: ${cursor}", "A description of a static class variable", "var", "var ${var}: ${cursor}", "A description of a module variable", "group", "group ${group}: ${cursor}", "Organizes a set of related children of a module or class into a group. g is the name of the group; and c1,...,cn are the names of the children in the group. To define multiple groups, use multiple group fields.", "sort", "sort: ", "Specifies the sort order for the children of a module or class. c1,...,cn are the names of the children, in the order in which they should appear. Any children that are not included in this list will appear after the children from this list, in alphabetical order.", "see", "see: ", "A description of a related topic. see fields typically use documentation crossreference links or external hyperlinks that link to the related topic.", "note", "note: ", "A note about an object. Multiple note fields may be used to list separate notes.", "attention", "attention: ", "An important note about an object. Multiple attention fields may be used to list separate notes.", "bug", "bug: ", "A description of a bug in an object. Multiple bug fields may be used to report separate bugs.", "warning", "warning: ", "A warning about an object. Multiple warning fields may be used to report separate warnings.", "version", "version: ", "The current version of an object.", "todo", "todo: ", "A planned change to an object. If the optional argument ver  is given, then it specifies the version for which the change will be made. Multiple todo fields may be used if multiple changes are planned.", "deprecated", "deprecated: ", "Indicates that an object is deprecated. The body of the field describe the reason why the object is deprecated.", "since", "since: ", "The date or version when an object was first introduced.", "status", "status: ", "The current status of an object.", "change", "change: ", "A change log entry for this object.", "requires", "requires: ", "A requirement for using an object. Multiple requires  fields may be used if an object has multiple requirements.", "precondition", "precondition: ", "A condition that must be true before an object is used. Multiple precondition fields may be used if an object has multiple preconditions.", "postcondition", "postcondition: ", "A condition that is guaranteed to be true after an object is used. Multiple postcondition fields may be used if an object has multiple postconditions.", "invariant", "invariant: ", "A condition which should always be true for an object. Multiple invariant fields may be used if an object has multiple invariants.", "author", "author: ", "The author(s) of an object. Multiple author  fields may be used if an object has multiple authors.", "organization", "organization: ", "The organization that created or maintains an object.", "copyright", "copyright: ", "The copyright information for an object.", "license", "license: ", "The licensing information for an object.", "contact", "contact: ", "Contact information for the author or maintainer of a module, class, function, or method. Multiple contact fields may be used if an object has multiple contacts.", "summary", "summary: ", "A summary description for an object. This description overrides the default summary (which is constructed from the first sentence of the object's description)."};

    @Override
    public TokensOrProposalsList getCodeCompletionProposals(CompletionRequest request) throws CoreException, BadLocationException, MisconfigurationException, IOException, PythonNatureWithoutProjectException {
        ArrayList<ICompletionProposalHandle> completionProposals = new ArrayList<ICompletionProposalHandle>();
        request.showTemplates = false;
        this.fillWithEpydocFields(request, completionProposals);
        TokensOrProposalsList ret = new TokensOrProposalsList();
        if (completionProposals.size() == 0) {
            PyCodeCompletionsForTypedDict pyCodeCompletionsForTypedDict;
            IDocument doc = request.doc;
            FastPartitioner fastPartitioner = (FastPartitioner)PyPartitionScanner.checkPartitionScanner((IDocument)doc);
            ITypedRegion partition = fastPartitioner.getPartition(request.documentOffset);
            String partitionType = partition.getType();
            if (IPythonPartitions.F_STRING_PARTITIONS.contains(partitionType)) {
                int requestOffset = request.documentOffset;
                int partitionOffset = partition.getOffset();
                int partitionLine = doc.getLineOfOffset(partitionOffset);
                int partitionCol = partitionOffset - doc.getLineOffset(partitionLine);
                String str = doc.get(partitionOffset, partition.getLength());
                FStringsAST ast = null;
                try {
                    ast = FStringsGrammarFactory.createGrammar((String)str).f_string();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (ast != null && ast.hasChildren()) {
                    for (SimpleNode node : ast.getBalancedExpressionsToBeEvaluatedInRegularGrammar()) {
                        int nodeOffset = node.beginLine > 1 ? TextSelectionUtils.getAbsoluteCursorOffset((IDocument)doc, (int)(partitionLine + node.beginLine - 1), (int)(node.beginColumn - 1)) : TextSelectionUtils.getAbsoluteCursorOffset((IDocument)doc, (int)(partitionLine + node.beginLine - 1), (int)(partitionCol + node.beginColumn - 1));
                        int nodeEndOffset = node.endLine > 1 ? TextSelectionUtils.getAbsoluteCursorOffset((IDocument)doc, (int)(partitionLine + node.endLine - 1), (int)node.endColumn) : TextSelectionUtils.getAbsoluteCursorOffset((IDocument)doc, (int)(partitionLine + node.endLine - 1), (int)(partitionCol + node.endColumn));
                        if (requestOffset < nodeOffset || requestOffset > nodeEndOffset) continue;
                        return new PyCodeCompletion().getCodeCompletionProposals(request);
                    }
                }
            }
            if ((pyCodeCompletionsForTypedDict = new PyCodeCompletionsForTypedDict(request)).isTypedDictCompletionRequest()) {
                try {
                    TokensOrProposalsList completionsForTypedDict = pyCodeCompletionsForTypedDict.getStringCompletions();
                    if (completionsForTypedDict != null) {
                        return completionsForTypedDict;
                    }
                }
                catch (CompletionRecursionException e) {
                    Log.log((Throwable)e);
                }
                return new TokensOrProposalsList();
            }
            TokensOrProposalsList stringGlobalsFromParticipants = this.getStringGlobalsFromParticipants(request, CompletionStateFactory.getEmptyCompletionState(request.activationToken, request.nature, new CompletionCache()));
            ret.addAll(stringGlobalsFromParticipants);
        }
        this.fillWithParams(request, completionProposals);
        ret.addAll(new TokensOrProposalsList(completionProposals));
        return ret;
    }

    private void fillWithParams(CompletionRequest request, List<ICompletionProposalHandle> ret) {
        PySelection ps = new PySelection(request.doc, request.documentOffset);
        try {
            String lineContentsToCursor = ps.getLineContentsToCursor();
            String trimmed = lineContentsToCursor.trim();
            if (!(trimmed.startsWith("@param") || trimmed.startsWith("@type") || trimmed.startsWith(":param") || trimmed.startsWith(":type"))) {
                return;
            }
            if (request.activationToken.trim().length() != 0) {
                return;
            }
            String initial = request.qualifier;
            DocIterator iterator = new DocIterator(false, (TextSelectionUtils)ps);
            while (iterator.hasNext()) {
                int currentLine;
                PySelection selection;
                String line = iterator.next().trim();
                if (!line.startsWith("def ") || !(selection = new PySelection(request.doc, currentLine = iterator.getCurrentLine() + 1, 0)).isInFunctionLine(true)) continue;
                Tuple insideParentesisToks = selection.getInsideParentesisToks(false);
                for (String str : (List)insideParentesisToks.o1) {
                    if (!str.startsWith(initial)) continue;
                    ret.add(CompletionProposalFactory.get().createPyLinkedModeCompletionProposal(str, request.documentOffset - request.qlen, request.qlen, str.length(), PyCodeCompletionImages.getImageForType(5), null, null, "", 0, 1, "", null));
                }
                return;
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    private void fillWithEpydocFields(CompletionRequest request, List<ICompletionProposalHandle> ret) {
        try {
            String lineContentsToCursor;
            boolean createFields;
            Region region = new Region(request.documentOffset - request.qlen, request.qlen);
            IImageHandle image = PyCodeCompletionImages.getImageForType(8);
            TemplateContext context = this.createContext((IRegion)region, request.doc);
            char c = request.doc.getChar(request.documentOffset - request.qualifier.length() - 1);
            boolean bl = createFields = c == '@' || c == ':';
            if (createFields && (lineContentsToCursor = PySelection.getLineContentsToCursor((IDocument)request.doc, (int)(request.documentOffset - request.qualifier.length() - 1))).trim().length() != 0) {
                createFields = false;
            }
            if (createFields) {
                int i = 0;
                while (i < EPYDOC_FIELDS.length) {
                    String f = EPYDOC_FIELDS[i];
                    if (f.startsWith(request.qualifier)) {
                        Template t = new Template(f, EPYDOC_FIELDS[i + 2], "", EPYDOC_FIELDS[i + 1], false);
                        ret.add(CompletionProposalFactory.get().createPyTemplateProposalForTests(t, context, (IRegion)region, image, 5));
                    }
                    i += 2;
                    ++i;
                }
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    private TokensOrProposalsList getStringGlobalsFromParticipants(CompletionRequest request, ICompletionState state) throws MisconfigurationException {
        TokensOrProposalsList ret = new TokensOrProposalsList();
        List participants = ExtensionHelper.getParticipants((String)"org.python.pydev.pydev_completion");
        for (IPyDevCompletionParticipant participant : participants) {
            ret.addAll(participant.getStringGlobalCompletions(request, state));
        }
        return ret;
    }
}

