/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.ast.codecompletion.revisited;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.python.pydev.ast.codecompletion.PyCodeCompletionPreferences;
import org.python.pydev.ast.codecompletion.revisited.CompletionCache;
import org.python.pydev.ast.codecompletion.revisited.CompletionStateFactory;
import org.python.pydev.ast.codecompletion.revisited.CompletionStateWrapper;
import org.python.pydev.ast.codecompletion.revisited.visitors.Definition;
import org.python.pydev.core.ICompletionCache;
import org.python.pydev.core.ICompletionState;
import org.python.pydev.core.IDefinition;
import org.python.pydev.core.IModule;
import org.python.pydev.core.IModuleRequestState;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.IToken;
import org.python.pydev.core.NoExceptionCloseable;
import org.python.pydev.core.TokensList;
import org.python.pydev.core.preferences.InterpreterGeneralPreferences;
import org.python.pydev.core.structure.CompletionRecursionException;
import org.python.pydev.shared_core.SharedCorePlugin;
import org.python.pydev.shared_core.string.FastStringBuffer;
import org.python.pydev.shared_core.structure.Tuple3;

public final class CompletionState
implements ICompletionState,
IModuleRequestState {
    private String activationToken;
    private int line = -1;
    private int col = -1;
    private IPythonNature nature;
    private String qualifier;
    private int levelGetCompletionsUnpackingObject = 0;
    private final Memo<String> memory = new Memo();
    private final Memo<Definition> definitionMemory = new Memo();
    private final Memo<IModule> wildImportMemory = new Memo();
    private final Memo<String> importedModsCalled = new Memo();
    private final Memo<String> findMemory = new Memo();
    private final Memo<String> resolveImportMemory = new Memo();
    private final Memo<String> findDefinitionMemory = new Memo();
    private final Memo<String> findLocalDefinedDefinitionMemory = new Memo();
    private Stack<Memo<IToken>> findResolveImportMemory = new Stack();
    private final Memo<String> findModuleCompletionsMemory = new Memo();
    private final Memo<String> findSourceFromCompiledMemory = new Memo(1);
    private boolean builtinsGotten = false;
    private boolean localImportsGotten = false;
    private boolean isInCalltip = false;
    private boolean acceptTypeshed = InterpreterGeneralPreferences.getUseTypeshed();
    private ICompletionState.LookingFor lookingForInstance = ICompletionState.LookingFor.LOOKING_FOR_INSTANCE_UNDEFINED;
    private TokensList tokenImportedModules;
    private final ICompletionCache completionCache;
    private String fullActivationToken;
    private long initialMillis = 0L;
    private long maxMillisToComplete;
    private IProgressMonitor cancelMonitor;
    Set<Tuple3<Integer, Integer, IModule>> foundSameDefinitionMemory = new HashSet<Tuple3<Integer, Integer, IModule>>();
    private Set<AlreadySerched> alreadySearchedInAssign = new HashSet<AlreadySerched>();
    int assign = 0;
    private final Map<IModule, ICompletionState.ModuleHandleOrNotGotten> pyIStubModule = new HashMap<IModule, ICompletionState.ModuleHandleOrNotGotten>();

    public void setCancelMonitor(IProgressMonitor cancelMonitor) {
        this.cancelMonitor = cancelMonitor;
    }

    public ICompletionState getCopy() {
        return new CompletionStateWrapper(this);
    }

    public ICompletionState getCopyForResolveImportWithActTok(String actTok) {
        CompletionState state = (CompletionState)CompletionStateFactory.getEmptyCompletionState(actTok, this.nature, this.completionCache);
        state.nature = this.nature;
        state.findResolveImportMemory = this.findResolveImportMemory;
        return state;
    }

    public CompletionState(int line2, int col2, String token, IPythonNature nature2, String qualifier) {
        this(line2, col2, token, nature2, qualifier, new CompletionCache());
    }

    public CompletionState(int line2, int col2, String token, IPythonNature nature2, String qualifier, ICompletionCache completionCache) {
        this.line = line2;
        this.col = col2;
        this.activationToken = token;
        this.nature = nature2;
        this.qualifier = qualifier;
        Assert.isNotNull((Object)completionCache);
        this.completionCache = completionCache;
    }

    public CompletionState() {
        this.activationToken = "";
        this.completionCache = new CompletionCache();
    }

    public void checkWildImportInMemory(IModule caller, IModule wild) throws CompletionRecursionException {
        if (this.wildImportMemory.isInRecursion(caller, wild)) {
            throw new CompletionRecursionException("Possible recursion found -- probably programming error -- (caller: " + caller.getName() + ", import: " + wild.getName() + " ) - stopping analysis.");
        }
    }

    public void checkDefinitionMemory(IModule module, IDefinition definition) throws CompletionRecursionException {
        if (this.definitionMemory.isInRecursion(module, (Definition)definition)) {
            throw new CompletionRecursionException("Possible recursion found -- probably programming error --  (module: " + module.getName() + ", token: " + definition + ") - stopping analysis.");
        }
    }

    public void checkFindMemory(IModule module, String value) throws CompletionRecursionException {
        if (this.findMemory.isInRecursion(module, value)) {
            throw new CompletionRecursionException("Possible recursion found -- probably programming error --  (module: " + module.getName() + ", value: " + value + ") - stopping analysis.");
        }
    }

    public void checkResolveImportMemory(IModule module, String value) throws CompletionRecursionException {
        if (this.resolveImportMemory.isInRecursion(module, value)) {
            throw new CompletionRecursionException("Possible recursion found -- probably programming error --  (module: " + module.getName() + ", value: " + value + ") - stopping analysis.");
        }
    }

    public void checkFindDefinitionMemory(IModule mod, String tok) throws CompletionRecursionException {
        if (this.findDefinitionMemory.isInRecursion(mod, tok)) {
            throw new CompletionRecursionException("Possible recursion found -- probably programming error --  (module: " + mod.getName() + ", value: " + tok + ") - stopping analysis.");
        }
    }

    public void checkFindLocalDefinedDefinitionMemory(IModule mod, String tok) throws CompletionRecursionException {
        if (this.findLocalDefinedDefinitionMemory.isInRecursion(mod, tok)) {
            throw new CompletionRecursionException("Possible recursion found -- probably programming error --  (module: " + mod.getName() + ", value: " + tok + ") - stopping analysis.");
        }
    }

    public void checkMemory(IModule module, String base) throws CompletionRecursionException {
        if (this.memory.isInRecursion(module, base)) {
            throw new CompletionRecursionException("Possible recursion found -- probably programming error --  (module: " + module.getName() + ", token: " + base + ") - stopping analysis.");
        }
    }

    public void checkMaxTimeForCompletion() throws CompletionRecursionException {
        if (this.cancelMonitor != null && this.cancelMonitor.isCanceled()) {
            throw new CompletionRecursionException("Completion cancelled.");
        }
        if (this.initialMillis <= 0L) {
            this.initialMillis = System.currentTimeMillis();
            this.maxMillisToComplete = SharedCorePlugin.inTestMode() ? Long.MAX_VALUE : (long)PyCodeCompletionPreferences.getMaximumNumberOfMillisToCompleteCodeCompletionRequest();
        } else {
            long diff = System.currentTimeMillis() - this.initialMillis;
            if (diff > this.maxMillisToComplete) {
                throw new CompletionRecursionException("Stopping analysis: completion took too much time to complete. Max set to: " + this.maxMillisToComplete + " millis. Current: " + diff + " millis. Note: this " + "value may be changed in the code-completion preferences.");
            }
        }
    }

    public boolean checkFoudSameDefinition(int line, int col, IModule mod) {
        Tuple3 key = new Tuple3((Object)line, (Object)col, (Object)mod);
        if (this.foundSameDefinitionMemory.contains(key)) {
            return true;
        }
        this.foundSameDefinitionMemory.add((Tuple3<Integer, Integer, IModule>)key);
        return false;
    }

    public boolean canStillCheckFindSourceFromCompiled(IModule mod, String tok) {
        return !this.findSourceFromCompiledMemory.isInRecursion(mod, tok);
    }

    public void checkFindResolveImportMemory(IToken token) throws CompletionRecursionException {
        for (Memo memo : this.findResolveImportMemory) {
            if (!memo.isInRecursion(null, token)) continue;
            throw new CompletionRecursionException("Possible recursion found -- probably programming error --  (token: " + token + ") - stopping analysis.");
        }
    }

    public void popFindResolveImportMemoryCtx() {
        this.findResolveImportMemory.pop();
    }

    public void pushFindResolveImportMemoryCtx() {
        this.findResolveImportMemory.push(new Memo());
    }

    public void checkFindModuleCompletionsMemory(IModule mod, String tok) throws CompletionRecursionException {
        if (this.findModuleCompletionsMemory.isInRecursion(mod, tok)) {
            throw new CompletionRecursionException("Possible recursion found -- probably programming error --  (module: " + mod.getName() + ", token: " + tok + ") - stopping analysis.");
        }
    }

    public String getActivationToken() {
        return this.activationToken;
    }

    public IPythonNature getNature() {
        return this.nature;
    }

    public void setActivationToken(String string) {
        this.activationToken = string;
    }

    public String getFullActivationToken() {
        return this.fullActivationToken;
    }

    public void setFullActivationToken(String act) {
        this.fullActivationToken = act;
    }

    public void setBuiltinsGotten(boolean b) {
        this.builtinsGotten = b;
    }

    public void setCol(int i) {
        this.col = i;
    }

    public void setLine(int i) {
        this.line = i;
    }

    public void setLocalImportsGotten(boolean b) {
        this.localImportsGotten = b;
    }

    public boolean getLocalImportsGotten() {
        return this.localImportsGotten;
    }

    public int getLine() {
        return this.line;
    }

    public int getCol() {
        return this.col;
    }

    public boolean getBuiltinsGotten() {
        return this.builtinsGotten;
    }

    public boolean getAcceptTypeshed() {
        return this.acceptTypeshed;
    }

    public void setAcceptTypeshed(boolean acceptTypeshed) {
        if (!InterpreterGeneralPreferences.getUseTypeshed()) {
            acceptTypeshed = false;
        }
        this.acceptTypeshed = acceptTypeshed;
    }

    public void raiseNFindTokensOnImportedModsCalled(IModule mod, String tok) throws CompletionRecursionException {
        if (this.importedModsCalled.isInRecursion(mod, tok)) {
            throw new CompletionRecursionException("Possible recursion found (mod: " + mod.getName() + ", tok: " + tok + " ) - stopping analysis.");
        }
    }

    public boolean getIsInCalltip() {
        return this.isInCalltip;
    }

    public void setLookingFor(ICompletionState.LookingFor b) {
        this.setLookingFor(b, false);
    }

    public void setLookingFor(ICompletionState.LookingFor b, boolean force) {
        if (this.lookingForInstance == ICompletionState.LookingFor.LOOKING_FOR_INSTANCE_UNDEFINED || force) {
            this.lookingForInstance = b;
        }
    }

    public ICompletionState.LookingFor getLookingFor() {
        return this.lookingForInstance;
    }

    public ICompletionState getCopyWithActTok(String value) {
        ICompletionState copy = this.getCopy();
        copy.setActivationToken(value);
        return copy;
    }

    public ICompletionState getCopyWithActTok(String value, int line, int col) {
        ICompletionState copy = this.getCopy();
        copy.setLine(line);
        copy.setCol(col);
        copy.setActivationToken(value);
        return copy;
    }

    public String getQualifier() {
        return this.qualifier;
    }

    public void setIsInCalltip(boolean isInCalltip) {
        this.isInCalltip = isInCalltip;
    }

    public void setTokenImportedModules(TokensList tokenImportedModules) {
        if (tokenImportedModules != null && this.tokenImportedModules == null) {
            this.tokenImportedModules = tokenImportedModules.copy();
        }
    }

    public TokensList getTokenImportedModules() {
        return this.tokenImportedModules;
    }

    public void add(Object key, Object n) {
        this.completionCache.add(key, n);
    }

    public Object getObj(Object o) {
        return this.completionCache.getObj(o);
    }

    public void remove(Object key) {
        this.completionCache.remove(key);
    }

    public void removeStaleEntries() {
        this.completionCache.removeStaleEntries();
    }

    public void clear() {
        this.completionCache.clear();
    }

    public boolean getAlreadySearchedInAssign(int line, int col, IModule module, String value, String actTok) {
        AlreadySerched s = new AlreadySerched(line, col, module, value, actTok);
        if (this.alreadySearchedInAssign.contains(s)) {
            return true;
        }
        this.alreadySearchedInAssign.add(s);
        return false;
    }

    public int pushAssign() {
        ++this.assign;
        return this.assign;
    }

    public void popAssign() {
        --this.assign;
        if (this.assign == 0) {
            this.alreadySearchedInAssign.clear();
        }
    }

    public void pushGetCompletionsUnpackingObject() throws CompletionRecursionException {
        ++this.levelGetCompletionsUnpackingObject;
        if (this.levelGetCompletionsUnpackingObject > 15) {
            throw new CompletionRecursionException("Error: recursion detected getting completions unpacking object. Activation token: " + this.getActivationToken());
        }
    }

    public void popGetCompletionsUnpackingObject() {
        --this.levelGetCompletionsUnpackingObject;
    }

    public ICompletionState.ModuleHandleOrNotGotten getPyiStubModule(IModule module) {
        return this.pyIStubModule.get(module);
    }

    public void setPyIStubModule(IModule module, IModule pyIModule) {
        this.pyIStubModule.put(module, new ICompletionState.ModuleHandleOrNotGotten(pyIModule));
    }

    public NoExceptionCloseable pushLookingFor(ICompletionState.LookingFor lookingFor) {
        final ICompletionState.LookingFor prev = this.getLookingFor();
        if (lookingFor != null) {
            this.setLookingFor(lookingFor, true);
        }
        return new NoExceptionCloseable(){

            public void close() {
                CompletionState.this.setLookingFor(prev, true);
            }
        };
    }

    public String toString() {
        FastStringBuffer buf = new FastStringBuffer();
        buf.append("CompletionState[ ");
        buf.append(this.activationToken);
        buf.append(" ]");
        return buf.toString();
    }

    private static class AlreadySerched {
        private final int line;
        private final int col;
        private final IModule module;
        private final String actTok;
        private final String value;

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.actTok == null ? 0 : this.actTok.hashCode());
            result = 31 * result + this.col;
            result = 31 * result + this.line;
            result = 31 * result + (this.module == null ? 0 : this.module.hashCode());
            result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            AlreadySerched other = (AlreadySerched)obj;
            if (this.actTok == null ? other.actTok != null : !this.actTok.equals(other.actTok)) {
                return false;
            }
            if (this.col != other.col) {
                return false;
            }
            if (this.line != other.line) {
                return false;
            }
            if (this.module == null ? other.module != null : !this.module.equals(other.module)) {
                return false;
            }
            return !(this.value == null ? other.value != null : !this.value.equals(other.value));
        }

        AlreadySerched(int line, int col, IModule module, String value, String actTok) {
            this.line = line;
            this.col = col;
            this.module = module;
            this.actTok = actTok;
            this.value = value;
        }
    }

    private static class Memo<E> {
        private int max;
        private static final int MAX_NUMBER_OF_OCURRENCES = 5;
        public Map<IModule, Map<E, Integer>> memo = new HashMap<IModule, Map<E, Integer>>();

        public Memo() {
            this.max = 5;
        }

        public Memo(int max) {
            this.max = max;
        }

        public boolean isInRecursion(IModule caller, E def) {
            Integer numberOfOccurences;
            Map<Object, Object> val;
            boolean occuredMoreThanMax = false;
            if (!this.memo.containsKey(caller)) {
                val = new HashMap();
                this.memo.put(caller, val);
            } else {
                val = this.memo.get(caller);
                if (val.containsKey(def) && (numberOfOccurences = (Integer)val.get(def)) > this.max) {
                    occuredMoreThanMax = true;
                }
            }
            numberOfOccurences = (Integer)val.get(def);
            if (numberOfOccurences == null) {
                val.put(def, 1);
            } else {
                val.put(def, numberOfOccurences + 1);
            }
            return occuredMoreThanMax;
        }
    }
}

