/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.ast.codecompletion.revisited;

import java.io.File;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.text.IDocument;
import org.python.pydev.ast.codecompletion.revisited.CachePyiModules;
import org.python.pydev.ast.codecompletion.revisited.ModulesFoundStructure;
import org.python.pydev.ast.codecompletion.revisited.ModulesManagerCache;
import org.python.pydev.ast.codecompletion.revisited.PyPublicTreeMap;
import org.python.pydev.ast.codecompletion.revisited.PythonPathHelper;
import org.python.pydev.ast.codecompletion.revisited.modules.AbstractModule;
import org.python.pydev.ast.codecompletion.revisited.modules.CompiledModule;
import org.python.pydev.ast.codecompletion.revisited.modules.EmptyModule;
import org.python.pydev.ast.codecompletion.revisited.modules.EmptyModuleForFolder;
import org.python.pydev.ast.codecompletion.revisited.modules.EmptyModuleForZip;
import org.python.pydev.ast.codecompletion.revisited.modules.InitFromDirModule;
import org.python.pydev.ast.codecompletion.revisited.modules.SourceModule;
import org.python.pydev.core.CorePlugin;
import org.python.pydev.core.FileUtilsFileBuffer;
import org.python.pydev.core.ICompletionState;
import org.python.pydev.core.IGrammarVersionProvider;
import org.python.pydev.core.IModule;
import org.python.pydev.core.IModuleRequestState;
import org.python.pydev.core.IModulesManager;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.MisconfigurationException;
import org.python.pydev.core.ModulesKey;
import org.python.pydev.core.ModulesKeyForFolder;
import org.python.pydev.core.ModulesKeyForZip;
import org.python.pydev.core.log.Log;
import org.python.pydev.core.preferences.FileTypesPreferences;
import org.python.pydev.parser.PyParser;
import org.python.pydev.parser.jython.SimpleNode;
import org.python.pydev.parser.jython.ast.Assign;
import org.python.pydev.parser.jython.ast.Call;
import org.python.pydev.parser.jython.ast.ClassDef;
import org.python.pydev.parser.jython.ast.Import;
import org.python.pydev.parser.jython.ast.Module;
import org.python.pydev.parser.jython.ast.Name;
import org.python.pydev.parser.jython.ast.NameTok;
import org.python.pydev.parser.jython.ast.NameTokType;
import org.python.pydev.parser.jython.ast.aliasType;
import org.python.pydev.parser.jython.ast.exprType;
import org.python.pydev.parser.jython.ast.stmtType;
import org.python.pydev.parser.visitors.NodeUtils;
import org.python.pydev.shared_core.cache.LRUMap;
import org.python.pydev.shared_core.callbacks.ICallback2;
import org.python.pydev.shared_core.callbacks.ICallbackListener;
import org.python.pydev.shared_core.io.FileUtils;
import org.python.pydev.shared_core.out_of_memory.OnExpectedOutOfMemory;
import org.python.pydev.shared_core.parsing.BaseParser;
import org.python.pydev.shared_core.string.FastStringBuffer;
import org.python.pydev.shared_core.string.FullRepIterable;
import org.python.pydev.shared_core.string.StringUtils;
import org.python.pydev.shared_core.structure.Tuple;

public abstract class ModulesManager
implements IModulesManager {
    private static final String MODULES_MANAGER_V3 = "MODULES_MANAGER_V3\n";
    private static final boolean DEBUG_BUILD = false;
    private static final boolean DEBUG_TEMPORARY_MODULES = false;
    private static final boolean DEBUG_ZIP = false;
    private static final double ONE_MINUTE_IN_MILLIS = 60000.0;
    protected volatile CompletionCache completionCache = null;
    protected final Object lockCompletionCache = new Object();
    private volatile int completionCacheI = 0;
    protected final PyPublicTreeMap<ModulesKey, ModulesKey> modulesKeys = new PyPublicTreeMap();
    protected final Object modulesKeysLock = new Object();
    protected static final ModulesManagerCache cache;
    protected static final ModulesManagerCache cachePredefined;
    private static final CachePyiModules cachePyiModules;
    protected final PythonPathHelper pythonPathHelper = new PythonPathHelper();
    public final Map<String, SortedMap<Integer, IModule>> temporaryModules = new HashMap<String, SortedMap<Integer, IModule>>();
    private final Object lockTemporaryModules = new Object();
    private int nextHandle = 0;
    public static ICallback2<AbstractModule, EmptyModuleForZip, IPythonNature> createModuleFromJar;
    private final Object lockAccessCreateCompiledModuleLock = new Object();
    private final Map<String, Object> createCompiledModuleLock = new LRUMap(50);

    static {
        OnExpectedOutOfMemory.clearCacheOnOutOfMemory.registerListener((ICallbackListener)new ICallbackListener<Object>(){

            public Object call(Object obj) {
                ModulesManager.clearCache();
                return null;
            }
        });
        cache = new ModulesManagerCache();
        cachePredefined = new ModulesManagerCache();
        cachePyiModules = new CachePyiModules();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean startCompletionCache() {
        Object object = this.lockCompletionCache;
        synchronized (object) {
            if (this.completionCache == null) {
                this.completionCache = new CompletionCache();
            }
            ++this.completionCacheI;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endCompletionCache() {
        Object object = this.lockCompletionCache;
        synchronized (object) {
            --this.completionCacheI;
            if (this.completionCacheI == 0) {
                this.completionCache = null;
            } else if (this.completionCacheI < 0) {
                throw new RuntimeException("Completion cache negative (request unsynched)");
            }
        }
    }

    public PythonPathHelper getPythonPathHelper() {
        return this.pythonPathHelper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveToFile(File workspaceMetadataFile) {
        FastStringBuffer buf;
        if (workspaceMetadataFile.exists() && !workspaceMetadataFile.isDirectory()) {
            try {
                FileUtils.deleteFile((File)workspaceMetadataFile);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (!workspaceMetadataFile.exists()) {
            workspaceMetadataFile.mkdirs();
        }
        File modulesKeysFile = new File(workspaceMetadataFile, "modulesKeys");
        File pythonpatHelperFile = new File(workspaceMetadataFile, "pythonpath");
        HashMap<String, Integer> commonTokens = new HashMap<String, Integer>();
        Object object = this.modulesKeysLock;
        synchronized (object) {
            buf = new FastStringBuffer(this.modulesKeys.size() * 50);
            buf.append(MODULES_MANAGER_V3);
            for (ModulesKey next : this.modulesKeys.keySet()) {
                buf.append(next.name);
                if (next.file != null) {
                    buf.append("|");
                    if (next instanceof ModulesKeyForZip) {
                        ModulesKeyForZip modulesKeyForZip = (ModulesKeyForZip)next;
                        if (modulesKeyForZip.zipModulePath != null) {
                            String fileStr = next.file.toString();
                            Integer t = (Integer)commonTokens.get(fileStr);
                            if (t == null) {
                                t = commonTokens.size();
                                commonTokens.put(fileStr, t);
                            }
                            buf.append(t.intValue());
                            buf.append("|");
                            buf.append(modulesKeyForZip.zipModulePath);
                            buf.append("|");
                            buf.append(modulesKeyForZip.isFile ? (char)'1' : '0');
                        }
                    } else if (next instanceof ModulesKeyForFolder) {
                        ModulesKeyForFolder modulesKeyForFolder = (ModulesKeyForFolder)next;
                        if (modulesKeyForFolder.file != null) {
                            buf.append(modulesKeyForFolder.file.toString());
                            buf.append("|^");
                        }
                    } else {
                        buf.append(next.file.toString());
                    }
                }
                buf.append('\n');
            }
        }
        if (commonTokens.size() > 0) {
            FastStringBuffer header = new FastStringBuffer(buf.length() + commonTokens.size() * 50);
            header.append(MODULES_MANAGER_V3);
            header.append("--COMMON--\n");
            for (Map.Entry entries : commonTokens.entrySet()) {
                header.append(((Integer)entries.getValue()).intValue());
                header.append('=');
                header.append((String)entries.getKey());
                header.append('\n');
            }
            header.append("--END-COMMON--\n");
            header.append(buf);
            buf = header;
        }
        FileUtils.writeStrToFile((String)buf.toString(), (File)modulesKeysFile);
        this.pythonPathHelper.saveToFile(pythonpatHelperFile);
    }

    public static void loadFromFile(ModulesManager modulesManager, File workspaceMetadataFile) throws IOException {
        if (workspaceMetadataFile.exists() && !workspaceMetadataFile.isDirectory()) {
            throw new IOException("Expecting: " + workspaceMetadataFile + " to be a directory.");
        }
        File modulesKeysFile = new File(workspaceMetadataFile, "modulesKeys");
        File pythonpatHelperFile = new File(workspaceMetadataFile, "pythonpath");
        if (!modulesKeysFile.isFile()) {
            throw new IOException("Expecting: " + modulesKeysFile + " to exist (and be a file).");
        }
        if (!pythonpatHelperFile.isFile()) {
            throw new IOException("Expecting: " + pythonpatHelperFile + " to exist (and be a file).");
        }
        String fileContents = FileUtils.getFileContents((File)modulesKeysFile);
        if (!fileContents.startsWith(MODULES_MANAGER_V3)) {
            throw new RuntimeException("Could not load modules manager from " + modulesKeysFile + " (version changed).");
        }
        HashMap<Integer, String> intToString = new HashMap<Integer, String>();
        if ((fileContents = fileContents.substring(MODULES_MANAGER_V3.length())).startsWith("--COMMON--\n")) {
            String header = fileContents.substring("--COMMON--\n".length());
            header = header.substring(0, header.indexOf("--END-COMMON--\n"));
            fileContents = fileContents.substring(fileContents.indexOf("--END-COMMON--\n") + "--END-COMMON--\n".length());
            for (String line : StringUtils.iterLines((String)header)) {
                List split = StringUtils.split((String)(line = line.trim()), (char)'=');
                if (split.size() != 2) continue;
                try {
                    int i = Integer.parseInt((String)split.get(0));
                    intToString.put(i, (String)split.get(1));
                }
                catch (NumberFormatException e) {
                    Log.log((Throwable)e);
                }
            }
            if (fileContents.startsWith(MODULES_MANAGER_V3)) {
                fileContents = fileContents.substring(MODULES_MANAGER_V3.length());
            }
        }
        ModulesManager.handleFileContents(modulesManager, fileContents, intToString);
        if (modulesManager.pythonPathHelper == null) {
            throw new IOException("Pythonpath helper not properly restored. " + modulesManager.getClass().getName() + " dir:" + workspaceMetadataFile);
        }
        modulesManager.pythonPathHelper.loadFromFile(pythonpatHelperFile);
        if (modulesManager.pythonPathHelper.getPythonpath() == null) {
            throw new IOException("Pythonpath helper pythonpath not properly restored. " + modulesManager.getClass().getName() + " dir:" + workspaceMetadataFile);
        }
        if (modulesManager.pythonPathHelper.getPythonpath().size() == 0) {
            throw new IOException("Pythonpath helper pythonpath restored with no contents. " + modulesManager.getClass().getName() + " dir:" + workspaceMetadataFile);
        }
        if (modulesManager.modulesKeys.size() < 2) {
            throw new IOException("Only " + modulesManager.modulesKeys.size() + " modules restored in I/O. " + modulesManager.getClass().getName() + " dir:" + workspaceMetadataFile);
        }
    }

    static void handleFileContents(ModulesManager modulesManager, String fileContents, HashMap<Integer, String> intToString) {
        String trimmed;
        String string = fileContents;
        int len = string.length();
        final ArrayList<ModulesKey> lst = new ArrayList<ModulesKey>();
        int start = 0;
        int i = 0;
        String[] parts = new String[4];
        int partsFound = 0;
        while (i < len) {
            char c = string.charAt(i);
            if (c == '\r') {
                trimmed = string.substring(start, i).trim();
                if (trimmed.length() > 0) {
                    parts[partsFound] = trimmed;
                    ++partsFound;
                }
                ModulesManager.handleLineParts(modulesManager, intToString, parts, partsFound, lst);
                partsFound = 0;
                if (i < len - 1 && string.charAt(i + 1) == '\n') {
                    ++i;
                }
                start = i + 1;
            } else if (c == '\n') {
                trimmed = string.substring(start, i).trim();
                if (trimmed.length() > 0) {
                    parts[partsFound] = trimmed;
                    ++partsFound;
                }
                ModulesManager.handleLineParts(modulesManager, intToString, parts, partsFound, lst);
                partsFound = 0;
                start = i + 1;
            } else if (c == '|') {
                trimmed = string.substring(start, i).trim();
                if (trimmed.length() > 0) {
                    parts[partsFound] = trimmed;
                    ++partsFound;
                }
                start = i + 1;
            }
            ++i;
        }
        if (start < len && start != i) {
            trimmed = string.substring(start, i).trim();
            if (trimmed.length() > 0) {
                parts[partsFound] = trimmed;
                ++partsFound;
            }
            ModulesManager.handleLineParts(modulesManager, intToString, parts, partsFound, lst);
        }
        try {
            final int size = lst.size();
            modulesManager.modulesKeys.buildFromSorted(size, new Iterator(){
                private int i = 0;

                @Override
                public boolean hasNext() {
                    return this.i < size;
                }

                public Object next() {
                    final ModulesKey next = (ModulesKey)lst.get(this.i);
                    ++this.i;
                    return new Map.Entry(){

                        public Object getKey() {
                            return next;
                        }

                        public Object getValue() {
                            return next;
                        }

                        public Object setValue(Object value) {
                            throw new UnsupportedOperationException();
                        }
                    };
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            }, null, null);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static void handleLineParts(ModulesManager modulesManager, HashMap<Integer, String> intToString, String[] split, int size, ArrayList<ModulesKey> lst) {
        if (size > 0 && split[0].length() > 0) {
            if (size == 1) {
                ModulesKey key = new ModulesKey(split[0], null);
                lst.add(key);
            } else if (size == 2) {
                ModulesKey key = new ModulesKey(split[0], new File(split[1]));
                lst.add(key);
            } else if (size == 3) {
                try {
                    ModulesKeyForFolder key = new ModulesKeyForFolder(split[0], new File(split[1]));
                    lst.add((ModulesKey)key);
                }
                catch (NumberFormatException e) {
                    Log.log((Throwable)e);
                }
            } else if (size == 4) {
                try {
                    ModulesKeyForZip key = new ModulesKeyForZip(split[0], new File(intToString.get(Integer.parseInt(split[1]))), split[2], split[3].equals("1"));
                    lst.add((ModulesKey)key);
                }
                catch (NumberFormatException e) {
                    Log.log((Throwable)e);
                }
            }
        }
    }

    protected Map<ModulesKey, AbstractModule> getModules() {
        throw new RuntimeException("Deprecated");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changePythonPath(String pythonpath, IProject project, IProgressMonitor monitor) {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        this.pythonPathHelper.setPythonPath(pythonpath);
        ModulesFoundStructure modulesFound = this.pythonPathHelper.getModulesFoundStructure(project, monitor);
        PyPublicTreeMap<ModulesKey, ModulesKey> keys = ModulesManager.buildKeysFromModulesFound(monitor, modulesFound);
        this.onChangePythonpath(keys);
        Object object = this.modulesKeysLock;
        synchronized (object) {
            cache.clear();
            cachePredefined.clear();
            this.modulesKeys.clear();
            this.modulesKeys.putAll(keys);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Tuple<List<ModulesKey>, List<ModulesKey>> diffModules(AbstractMap<ModulesKey, ModulesKey> keysFound) {
        ArrayList<ModulesKey> newKeys = new ArrayList<ModulesKey>();
        ArrayList<ModulesKey> removedKeys = new ArrayList<ModulesKey>();
        Iterator<ModulesKey> it = keysFound.keySet().iterator();
        Object object = this.modulesKeysLock;
        synchronized (object) {
            ModulesKey modulesKey;
            while (it.hasNext()) {
                ModulesKey next = it.next();
                modulesKey = this.modulesKeys.get(next);
                if (modulesKey != null && modulesKey.getClass() == next.getClass()) continue;
                newKeys.add(next);
            }
            for (ModulesKey next : this.modulesKeys.keySet()) {
                modulesKey = keysFound.get(next);
                if (modulesKey != null && modulesKey.getClass() == next.getClass()) continue;
                removedKeys.add(next);
            }
        }
        return new Tuple(newKeys, removedKeys);
    }

    public static PyPublicTreeMap<ModulesKey, ModulesKey> buildKeysFromModulesFound(IProgressMonitor monitor, ModulesFoundStructure modulesFound) {
        PyPublicTreeMap<ModulesKey, ModulesKey> keys = new PyPublicTreeMap<ModulesKey, ModulesKey>();
        ModulesManager.buildKeysForRegularEntries(monitor, modulesFound, keys, false);
        for (ModulesFoundStructure.ZipContents zipContents : modulesFound.zipContents) {
            if (monitor.isCanceled()) break;
            ModulesManager.buildKeysForZipContents(keys, zipContents);
        }
        return keys;
    }

    public static void buildKeysForRegularEntries(IProgressMonitor monitor, ModulesFoundStructure modulesFound, PyPublicTreeMap<ModulesKey, ModulesKey> keys, boolean includeOnlySourceModules) {
        String[] dottedValidSourceFiles = FileTypesPreferences.getDottedValidSourceFiles();
        int j = 0;
        FastStringBuffer buffer = new FastStringBuffer();
        HashMap<String, File> packages = new HashMap<String, File>();
        Iterator<Map.Entry<File, String>> iterator = modulesFound.regularModules.entrySet().iterator();
        while (iterator.hasNext() && !monitor.isCanceled()) {
            Map.Entry<File, String> entry = iterator.next();
            String m = entry.getValue();
            if (m != null) {
                if (j % 20 == 0) {
                    buffer.clear();
                    monitor.setTaskName(buffer.append("Module resolved: ").append(m).toString());
                    monitor.worked(1);
                }
                File f = entry.getKey();
                if (!includeOnlySourceModules || PythonPathHelper.isValidSourceFile(f.getName())) {
                    String packageM = FullRepIterable.getParentModule((String)m);
                    File packageF = f.getParentFile();
                    while (!packageM.isEmpty()) {
                        packages.put(packageM, packageF);
                        packageM = FullRepIterable.getParentModule((String)packageM);
                        packageF = packageF.getParentFile();
                    }
                    ModulesKey modulesKey = new ModulesKey(m, f);
                    if (!keys.containsKey(modulesKey)) {
                        keys.put(modulesKey, modulesKey);
                    } else if (PythonPathHelper.isValidSourceFile(f.getName(), dottedValidSourceFiles)) {
                        keys.put(modulesKey, modulesKey);
                    }
                }
            }
            ++j;
        }
        for (Map.Entry packageEntry : packages.entrySet()) {
            buffer.clear();
            File f = (File)packageEntry.getValue();
            ModulesKeyForFolder modulesKeyForFolder = new ModulesKeyForFolder(buffer.append((String)packageEntry.getKey()).append(".__init__").toString(), f);
            if (keys.containsKey(modulesKeyForFolder)) continue;
            keys.put((ModulesKey)modulesKeyForFolder, (ModulesKey)modulesKeyForFolder);
        }
    }

    public static void buildKeysForZipContents(PyPublicTreeMap<ModulesKey, ModulesKey> keys, ModulesFoundStructure.ZipContents zipContents) {
        for (String filePathInZip : zipContents.foundFileZipPaths) {
            String modName = StringUtils.stripExtension((String)filePathInZip).replace('/', '.');
            ModulesKeyForZip k = new ModulesKeyForZip(modName, zipContents.zipFile, filePathInZip, true);
            keys.put((ModulesKey)k, (ModulesKey)k);
            if (zipContents.zipContentsType != ModulesFoundStructure.ZipContents.ZIP_CONTENTS_TYPE_JAR) continue;
            for (String s : new FullRepIterable(FullRepIterable.getWithoutLastPart((String)modName))) {
                k = new ModulesKeyForZip(s, zipContents.zipFile, s.replace('.', '/'), false);
                keys.put((ModulesKey)k, (ModulesKey)k);
            }
        }
    }

    protected void onChangePythonpath(SortedMap<ModulesKey, ModulesKey> keys) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doRemoveSingleModule(ModulesKey key) {
        Object object = this.modulesKeysLock;
        synchronized (object) {
            this.modulesKeys.remove(key);
            cache.remove(key, this);
        }
    }

    protected void removeThem(Collection<ModulesKey> toRem) {
        Iterator<ModulesKey> iter = toRem.iterator();
        while (iter.hasNext()) {
            this.doRemoveSingleModule(iter.next());
        }
    }

    public void removeModules(Collection<ModulesKey> toRem) {
        this.removeThem(toRem);
    }

    public IModule addModule(ModulesKey key) {
        AbstractModule ret = AbstractModule.createEmptyModule(key);
        this.doAddSingleModule(key, ret);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasModule(ModulesKey key) {
        Object object = this.modulesKeysLock;
        synchronized (object) {
            return this.modulesKeys.containsKey(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doAddSingleModule(ModulesKey key, AbstractModule n) {
        Object object = this.modulesKeysLock;
        synchronized (object) {
            this.modulesKeys.put(key, key);
            cache.add(key, n, this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getAllModuleNames(boolean addDependencies, String partStartingWithLowerCase) {
        HashSet<String> s = new HashSet<String>();
        Object object = this.modulesKeysLock;
        synchronized (object) {
            for (ModulesKey key : this.modulesKeys.keySet()) {
                if (!key.hasPartStartingWith(partStartingWithLowerCase)) continue;
                s.add(key.name);
            }
        }
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SortedMap<ModulesKey, ModulesKey> getAllDirectModulesStartingWith(String strStartingWith) {
        if (strStartingWith.length() == 0) {
            Object object = this.modulesKeysLock;
            synchronized (object) {
                return new PyPublicTreeMap<ModulesKey, ModulesKey>((SortedMap<ModulesKey, ModulesKey>)this.modulesKeys);
            }
        }
        ModulesKey startingWith = new ModulesKey(strStartingWith, null);
        ModulesKey endingWith = new ModulesKey(String.valueOf(strStartingWith) + "\uffff\uffff\uffff\uffff", null);
        Object object = this.modulesKeysLock;
        synchronized (object) {
            return new PyPublicTreeMap<ModulesKey, ModulesKey>(this.modulesKeys.subMap(startingWith, endingWith));
        }
    }

    public SortedMap<ModulesKey, ModulesKey> getAllModulesStartingWith(String strStartingWith) {
        return this.getAllDirectModulesStartingWith(strStartingWith);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ModulesKey[] getOnlyDirectModules() {
        Object object = this.modulesKeysLock;
        synchronized (object) {
            return this.modulesKeys.keySet().toArray(new ModulesKey[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSize(boolean addDependenciesSize) {
        Object object = this.modulesKeysLock;
        synchronized (object) {
            return this.modulesKeys.size();
        }
    }

    public IModule getModule(String name, IPythonNature nature, boolean dontSearchInit, IModuleRequestState moduleRequest) {
        return this.getModule(true, name, nature, dontSearchInit, moduleRequest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int pushTemporaryModule(String moduleName, IModule module) {
        Object object = this.lockTemporaryModules;
        synchronized (object) {
            SortedMap<Integer, IModule> map = this.temporaryModules.get(moduleName);
            if (map == null) {
                map = new TreeMap<Integer, IModule>();
                this.temporaryModules.put(moduleName, map);
            }
            if (module instanceof AbstractModule) {
                module = this.decorateModule((AbstractModule)module, null);
            }
            ++this.nextHandle;
            map.put(this.nextHandle, module);
            return this.nextHandle;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void popTemporaryModule(String moduleName, int handle) {
        Object object = this.lockTemporaryModules;
        synchronized (object) {
            SortedMap<Integer, IModule> stack = this.temporaryModules.get(moduleName);
            try {
                if (stack != null) {
                    stack.remove(handle);
                    if (stack.size() == 0) {
                        this.temporaryModules.remove(moduleName);
                    }
                }
            }
            catch (Throwable e) {
                Log.log((Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IModule getModule(boolean acceptCompiledModule, String name, IPythonNature nature, boolean dontSearchInit, IModuleRequestState moduleRequest) {
        SourceModule sourceModule;
        SourceModule s;
        Object object = this.lockTemporaryModules;
        synchronized (object) {
            SortedMap<Integer, IModule> map = this.temporaryModules.get(name);
            if (map != null && map.size() > 0) {
                return (IModule)map.get(map.lastKey());
            }
        }
        AbstractModule n = null;
        ModulesKey keyForCacheAccess = new ModulesKey(null, null);
        if (!dontSearchInit && n == null) {
            keyForCacheAccess.name = (String)StringUtils.join((String)".", (String[])new String[]{name, "__init__"}, null);
            n = cache.getObj(keyForCacheAccess, this);
            if (n != null) {
                name = keyForCacheAccess.name;
            }
        }
        if (n == null) {
            keyForCacheAccess.name = name;
            n = cache.getObj(keyForCacheAccess, this);
        }
        if (n instanceof SourceModule && !(s = (SourceModule)n).isSynched()) {
            n = (AbstractModule)this.addModule(this.createModulesKey(s.getName(), s.getFile()));
        }
        if (n instanceof EmptyModule) {
            EmptyModule e;
            block40: {
                e = (EmptyModule)n;
                if (e.f != null) {
                    if (!e.f.exists()) {
                        keyForCacheAccess.name = name;
                        keyForCacheAccess.file = e.f;
                        this.doRemoveSingleModule(keyForCacheAccess);
                        n = null;
                    } else if ((n = this.checkOverride(name, nature, n)) instanceof EmptyModule) {
                        if (e instanceof EmptyModuleForZip) {
                            EmptyModuleForZip emptyModuleForZip = (EmptyModuleForZip)e;
                            if (emptyModuleForZip.pathInZip.endsWith(".class") || !emptyModuleForZip.isFile) {
                                try {
                                    if (createModuleFromJar != null) {
                                        n = (AbstractModule)createModuleFromJar.call((Object)emptyModuleForZip, (Object)nature);
                                        n = this.decorateModule(n, nature);
                                        break block40;
                                    }
                                    n = null;
                                }
                                catch (Throwable e1) {
                                    Log.log((String)("Unable to create module from jar (note: JDT is required for Jython development): " + emptyModuleForZip + " project: " + (nature != null ? nature.getProject() : "null")), (Throwable)e1);
                                    n = null;
                                }
                            } else if (FileTypesPreferences.isValidDll((String)emptyModuleForZip.pathInZip)) {
                                n = new CompiledModule(name, this, nature);
                                n = this.decorateModule(n, nature);
                            } else if (PythonPathHelper.isValidSourceFile(emptyModuleForZip.pathInZip)) {
                                try {
                                    IDocument doc = FileUtilsFileBuffer.getDocFromZip((File)emptyModuleForZip.f, (String)emptyModuleForZip.pathInZip);
                                    n = AbstractModule.createModuleFromDoc(name, emptyModuleForZip.f, doc, this.getNature(), false);
                                    SourceModule zipModule = (SourceModule)n;
                                    zipModule.zipFilePath = emptyModuleForZip.pathInZip;
                                    n = this.decorateModule(n, nature);
                                }
                                catch (Exception exc1) {
                                    Log.log((Throwable)exc1);
                                    n = null;
                                }
                            }
                        } else if (e instanceof EmptyModuleForFolder) {
                            try {
                                n = new InitFromDirModule(name, e.f, (SimpleNode)new Module(new stmtType[0]), null, this.getNature());
                                n = this.decorateModule(n, nature);
                            }
                            catch (Exception e1) {
                                Log.log((Throwable)e1);
                                n = null;
                            }
                        } else {
                            try {
                                n = AbstractModule.createModule(name, e.f, this.getNature(), true);
                                n = this.decorateModule(n, nature);
                            }
                            catch (IOException exc) {
                                keyForCacheAccess.name = name;
                                keyForCacheAccess.file = e.f;
                                this.doRemoveSingleModule(keyForCacheAccess);
                                n = null;
                            }
                            catch (MisconfigurationException exc) {
                                Log.log((Throwable)exc);
                                n = null;
                            }
                        }
                    }
                } else if ((n = this.checkOverride(name, nature, n)) instanceof EmptyModule) {
                    if (acceptCompiledModule) {
                        n = new CompiledModule(name, this, nature);
                        n = this.decorateModule(n, nature);
                    } else {
                        return null;
                    }
                }
            }
            if (n != null) {
                this.doAddSingleModule(this.createModulesKey(name, e.f), n);
            } else {
                Log.log((String)("The module " + name + " could not be found nor created!"));
            }
        }
        if (n instanceof EmptyModule) {
            throw new RuntimeException("Should not be an empty module anymore: " + n);
        }
        if (n instanceof SourceModule && (sourceModule = (SourceModule)n).isBootstrapModule()) {
            n = new CompiledModule(name, this, nature);
            n = this.decorateModule(n, nature);
        }
        return n;
    }

    private AbstractModule decorateModule(AbstractModule n, IPythonNature nature) {
        block13: {
            block14: {
                stmtType[] body;
                if (!(n instanceof SourceModule)) break block13;
                if (!"django.db.models.base".equals(n.getName())) break block14;
                SourceModule sourceModule = (SourceModule)n;
                SimpleNode ast = sourceModule.getAst();
                boolean found = false;
                Module module = (Module)ast;
                stmtType[] stmtTypeArray = body = module.body;
                int n2 = body.length;
                int n3 = 0;
                while (n3 < n2) {
                    stmtType node = stmtTypeArray[n3];
                    if (node instanceof ClassDef && "Model".equals(NodeUtils.getRepresentationString((SimpleNode)node))) {
                        found = true;
                        Object[][] metaclassAttrs = new Object[][]{{"objects", NodeUtils.makeAttribute((String)"django.db.models.manager.Manager()")}, {"DoesNotExist", new Name("Exception", 1, false)}, {"MultipleObjectsReturned", new Name("Exception", 1, false)}};
                        ClassDef classDef = (ClassDef)node;
                        stmtType[] newBody = new stmtType[classDef.body.length + metaclassAttrs.length];
                        System.arraycopy(classDef.body, 0, newBody, metaclassAttrs.length, classDef.body.length);
                        int i = 0;
                        Object[][] objectArrayArray = metaclassAttrs;
                        int n4 = metaclassAttrs.length;
                        int n5 = 0;
                        while (n5 < n4) {
                            Object[] objAndType = objectArrayArray[n5];
                            Name name = new Name((String)objAndType[0], 2, false);
                            name.beginColumn = classDef.beginColumn + 4;
                            name.beginLine = classDef.beginLine + 1;
                            newBody[i] = new Assign(new exprType[]{name}, (exprType)objAndType[1], null);
                            newBody[i].beginColumn = classDef.beginColumn + 4;
                            newBody[i].beginLine = classDef.beginLine + 1;
                            ++i;
                            ++n5;
                        }
                        classDef.body = newBody;
                        break;
                    }
                    ++n3;
                }
                if (!found) break block13;
                stmtType[] newBody = new stmtType[body.length + 1];
                System.arraycopy(body, 0, newBody, 1, body.length);
                Import importNode = new Import(new aliasType[]{new aliasType((NameTokType)new NameTok("django.db.models.manager", 7), null)});
                newBody[0] = importNode;
                module.body = newBody;
                break block13;
            }
            if ("django.db.models.manager".equals(n.getName())) {
                stmtType[] body;
                SourceModule sourceModule = (SourceModule)n;
                SimpleNode ast = sourceModule.getAst();
                Module module = (Module)ast;
                stmtType[] stmtTypeArray = body = module.body;
                int n6 = body.length;
                int newBody = 0;
                while (newBody < n6) {
                    stmtType node = stmtTypeArray[newBody];
                    if (node instanceof ClassDef && "Manager".equals(NodeUtils.getRepresentationString((SimpleNode)node))) {
                        ClassDef classDef = (ClassDef)node;
                        stmtType[] newBody2 = null;
                        try {
                            File managerBody = CorePlugin.getBundleInfo().getRelativePath((IPath)new Path("pysrc/stubs/_django_manager_body.py"));
                            IDocument doc = FileUtilsFileBuffer.getDocFromFile((File)managerBody);
                            IGrammarVersionProvider provider = new IGrammarVersionProvider(){

                                public int getGrammarVersion() throws MisconfigurationException {
                                    return 104;
                                }

                                public IGrammarVersionProvider.AdditionalGrammarVersionsToCheck getAdditionalGrammarVersions() throws MisconfigurationException {
                                    return null;
                                }
                            };
                            BaseParser.ParseOutput obj = PyParser.reparseDocument((PyParser.ParserInfo)new PyParser.ParserInfo(doc, provider, "_django_manager_body", managerBody));
                            Module ast2 = (Module)obj.ast;
                            stmtType[] stmtTypeArray2 = newBody2 = ast2.body;
                            int n7 = newBody2.length;
                            int n8 = 0;
                            while (n8 < n7) {
                                stmtType b = stmtTypeArray2[n8];
                                b.beginColumn = classDef.beginColumn + 4;
                                b.beginLine = classDef.beginLine + 1;
                                ++n8;
                            }
                            classDef.body = newBody2;
                            break;
                        }
                        catch (Exception e) {
                            Log.log((Throwable)e);
                        }
                    }
                    ++newBody;
                }
            } else if ("typing".equals(n.getName())) {
                Module module = (Module)((SourceModule)n).getAst();
                stmtType[] stmtTypeArray = module.body;
                int n9 = module.body.length;
                int n10 = 0;
                while (n10 < n9) {
                    stmtType node = stmtTypeArray[n10];
                    if (node instanceof Assign && ((Assign)node).value instanceof Call && ((Call)((Assign)node).value).func instanceof Name && "_alias".equals(((Name)((Call)((Assign)node).value).func).id) && ((Call)((Assign)node).value).args.length >= 1) {
                        Assign assign = (Assign)node;
                        assign.value = ((Call)assign.value).args[0];
                    }
                    ++n10;
                }
            }
        }
        return n;
    }

    private AbstractModule checkOverride(String name, IPythonNature nature, AbstractModule emptyModule) {
        return emptyModule;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ModulesKey createModulesKey(String name, File f) {
        ModulesKey newEntry = new ModulesKey(name, f);
        Object object = this.modulesKeysLock;
        synchronized (object) {
            PyPublicTreeMap.Entry<ModulesKey, ModulesKey> oldEntry = this.modulesKeys.getEntry(newEntry);
            if (oldEntry != null) {
                return oldEntry.getKey();
            }
            return newEntry;
        }
    }

    public static void clearCache() {
        cache.clear();
        cachePredefined.clear();
        cachePyiModules.clear();
    }

    public boolean isInPythonPath(IResource member, IProject container) {
        return this.resolveModule(member, container) != null;
    }

    public String resolveModule(IResource member, IProject container) {
        File inOs = member.getLocation().toFile();
        return this.pythonPathHelper.resolveModule(FileUtils.getFileAbsolutePath((File)inOs), false, container);
    }

    protected String getResolveModuleErr(IResource member) {
        return "Unable to find the path " + member + " in the project were it\n" + "is added as a source folder for pydev." + this.getClass();
    }

    public String resolveModule(String full) {
        return this.pythonPathHelper.resolveModule(full, false, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getCompiledModuleCreationLock(String name) {
        Object object = this.lockAccessCreateCompiledModuleLock;
        synchronized (object) {
            Object lock = this.createCompiledModuleLock.get(name);
            if (lock == null) {
                lock = new Object();
                this.createCompiledModuleLock.put(name, lock);
            }
            return lock;
        }
    }

    public IModule getPyiStubModule(IModule module, ICompletionState completionState) {
        ICompletionState.ModuleHandleOrNotGotten pyiStubModule = completionState.getPyiStubModule(module);
        if (pyiStubModule != null) {
            return pyiStubModule.get();
        }
        SourceModule ret = cachePyiModules.getPyiStubModule(module);
        completionState.setPyIStubModule(module, (IModule)ret);
        return ret;
    }

    protected static class CompletionCache {
        public IModulesManager[] referencedManagersWithoutSystem;
        public IModulesManager[] referredManagersWithoutSystem;
        public IModulesManager[] referencedManagersWithSystem;
        public IModulesManager[] referredManagersWithSystem;
        private long creationTime;
        private int calls = 0;

        protected CompletionCache() {
        }

        public IModulesManager[] getManagers(boolean referenced, boolean checkSystemManager) {
            long diff;
            ++this.calls;
            if (this.calls % 30 == 0 && (double)(diff = System.currentTimeMillis() - this.creationTime) > 60000.0) {
                String msg = String.format("Warning: the cache related to project dependencies is the same for %.2f minutes.", (double)diff / 60000.0);
                Log.logInfo((String)msg);
            }
            if (referenced) {
                if (checkSystemManager) {
                    return this.referencedManagersWithSystem;
                }
                return this.referencedManagersWithoutSystem;
            }
            if (checkSystemManager) {
                return this.referredManagersWithSystem;
            }
            return this.referredManagersWithoutSystem;
        }

        public void setManagers(IModulesManager[] ret, boolean referenced, boolean checkSystemManager) {
            if (this.creationTime == 0L) {
                this.creationTime = System.currentTimeMillis();
            }
            if (referenced) {
                if (checkSystemManager) {
                    this.referencedManagersWithSystem = ret;
                } else {
                    this.referencedManagersWithoutSystem = ret;
                }
            } else if (checkSystemManager) {
                this.referredManagersWithSystem = ret;
            } else {
                this.referredManagersWithoutSystem = ret;
            }
        }
    }
}

