/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.ast.codecompletion.shell;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.python.copiedfromeclipsesrc.JDTNotAvailableException;
import org.python.pydev.ast.codecompletion.revisited.ModulesManager;
import org.python.pydev.ast.codecompletion.shell.AbstractShell;
import org.python.pydev.ast.codecompletion.shell.CythonShell;
import org.python.pydev.ast.codecompletion.shell.IronpythonShell;
import org.python.pydev.ast.codecompletion.shell.JythonShell;
import org.python.pydev.ast.codecompletion.shell.PythonShell;
import org.python.pydev.ast.interpreter_managers.InterpreterManagersAPI;
import org.python.pydev.core.IInterpreterInfo;
import org.python.pydev.core.IInterpreterManager;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.MisconfigurationException;
import org.python.pydev.core.PythonNatureWithoutProjectException;
import org.python.pydev.core.ShellId;
import org.python.pydev.core.log.Log;
import org.python.pydev.core.logging.DebugSettings;
import org.python.pydev.shared_core.log.ToLogFile;

public class ShellsContainer {
    private static Map<String, Map<ShellId, AbstractShell>> shells = new HashMap<String, Map<ShellId, AbstractShell>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void stopServerShell(IInterpreterInfo interpreter, ShellId id) {
        Map<String, Map<ShellId, AbstractShell>> map = shells;
        synchronized (map) {
            Map<ShellId, AbstractShell> typeToShell = ShellsContainer.getTypeToShellFromId(interpreter);
            AbstractShell pythonShell = typeToShell.get(id);
            if (pythonShell != null) {
                try {
                    pythonShell.endIt();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            typeToShell.remove(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void shutdownAllShells() {
        Map<String, Map<ShellId, AbstractShell>> map = shells;
        synchronized (map) {
            if (DebugSettings.DEBUG_CODE_COMPLETION) {
                ToLogFile.toLogFile((String)"Shutting down all shells (for good)...", AbstractShell.class);
            }
            Iterator<Map<ShellId, AbstractShell>> iter = shells.values().iterator();
            while (iter.hasNext()) {
                AbstractShell.finishedForGood = true;
                Map<ShellId, AbstractShell> rel = iter.next();
                if (rel == null) continue;
                for (AbstractShell element : rel.values()) {
                    if (element == null) continue;
                    try {
                        element.shutdown();
                    }
                    catch (Exception e) {
                        Log.log((Throwable)e);
                    }
                }
            }
            shells.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String restartAllShells() {
        String ret = "";
        Map<String, Map<ShellId, AbstractShell>> map = shells;
        synchronized (map) {
            try {
                if (DebugSettings.DEBUG_CODE_COMPLETION) {
                    ToLogFile.toLogFile((String)"Restarting all shells and clearing caches...", AbstractShell.class);
                }
                for (Map<ShellId, AbstractShell> val : shells.values()) {
                    IInterpreterManager[] interpreterManagers;
                    for (AbstractShell val2 : val.values()) {
                        if (val2 == null) continue;
                        val2.endIt();
                    }
                    IInterpreterManager[] iInterpreterManagerArray = interpreterManagers = InterpreterManagersAPI.getAllInterpreterManagers();
                    int n = interpreterManagers.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IInterpreterManager iInterpreterManager = iInterpreterManagerArray[n2];
                        if (iInterpreterManager != null) {
                            try {
                                iInterpreterManager.clearCaches();
                            }
                            catch (Exception e) {
                                Log.log((Throwable)e);
                                ret = String.valueOf(ret) + e.getMessage() + "\n";
                            }
                        }
                        ++n2;
                    }
                    ModulesManager.clearCache();
                }
            }
            catch (Exception e) {
                Log.log((Throwable)e);
                ret = String.valueOf(ret) + e.getMessage() + "\n";
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<ShellId, AbstractShell> getTypeToShellFromId(IInterpreterInfo interpreter) {
        Map<String, Map<ShellId, AbstractShell>> map = shells;
        synchronized (map) {
            Map<ShellId, AbstractShell> typeToShell = shells.get(interpreter.getExecutableOrJar());
            if (typeToShell == null) {
                typeToShell = new HashMap<ShellId, AbstractShell>();
                shells.put(interpreter.getExecutableOrJar(), typeToShell);
            }
            return typeToShell;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void putServerShell(IPythonNature nature, ShellId id, AbstractShell shell) {
        Map<String, Map<ShellId, AbstractShell>> map = shells;
        synchronized (map) {
            try {
                Map<ShellId, AbstractShell> typeToShell = ShellsContainer.getTypeToShellFromId(nature.getProjectInterpreter());
                typeToShell.put(id, shell);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static AbstractShell getServerShell(IPythonNature nature, ShellId id) throws IOException, JDTNotAvailableException, CoreException, MisconfigurationException, PythonNatureWithoutProjectException {
        return ShellsContainer.getServerShell(nature.getProjectInterpreter(), nature.getInterpreterType(), id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static AbstractShell getServerShell(IInterpreterInfo interpreter, int relatedTo, ShellId id) throws IOException, JDTNotAvailableException, CoreException, MisconfigurationException {
        AbstractShell pythonShell = null;
        Map<String, Map<ShellId, AbstractShell>> map = shells;
        synchronized (map) {
            Map<ShellId, AbstractShell> typeToShell;
            if (DebugSettings.DEBUG_CODE_COMPLETION) {
                ToLogFile.toLogFile((String)"Synchronizing on shells...", AbstractShell.class);
            }
            if (DebugSettings.DEBUG_CODE_COMPLETION) {
                String flavor;
                switch (relatedTo) {
                    case 1: {
                        flavor = "Jython";
                        break;
                    }
                    case 2: {
                        flavor = "IronPython";
                        break;
                    }
                    default: {
                        flavor = "Python";
                    }
                }
                ToLogFile.toLogFile((String)("Getting shell related to:" + flavor + " id:" + id + " interpreter: " + interpreter.getExecutableOrJar()), AbstractShell.class);
            }
            if ((pythonShell = (typeToShell = ShellsContainer.getTypeToShellFromId(interpreter)).get(id)) == null) {
                if (DebugSettings.DEBUG_CODE_COMPLETION) {
                    ToLogFile.toLogFile((String)"pythonShell == null", AbstractShell.class);
                }
                if (id == ShellId.CYTHON_MAIN_THREAD_SHELL || id == ShellId.CYTHON_OTHER_THREADS_SHELL) {
                    pythonShell = new CythonShell();
                } else if (relatedTo == 0) {
                    pythonShell = new PythonShell();
                } else if (relatedTo == 1) {
                    pythonShell = new JythonShell();
                } else if (relatedTo == 2) {
                    pythonShell = new IronpythonShell();
                } else {
                    throw new RuntimeException("unknown related id");
                }
                if (DebugSettings.DEBUG_CODE_COMPLETION) {
                    ToLogFile.toLogFile((String)"pythonShell.startIt()", AbstractShell.class);
                    ToLogFile.addLogLevel();
                }
                pythonShell.startIt(interpreter);
                if (DebugSettings.DEBUG_CODE_COMPLETION) {
                    ToLogFile.remLogLevel();
                    ToLogFile.toLogFile((String)"Finished pythonShell.startIt()", AbstractShell.class);
                }
                typeToShell.put(id, pythonShell);
            }
        }
        return pythonShell;
    }
}

