/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.ast.formatter;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.python.pydev.core.IPyFormatStdProvider;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.MisconfigurationException;
import org.python.pydev.core.docutils.ParsingUtils;
import org.python.pydev.core.docutils.PySelection;
import org.python.pydev.core.docutils.SyntaxErrorException;
import org.python.pydev.core.formatter.FormatStd;
import org.python.pydev.core.formatter.PyFormatStdManageBlankLines;
import org.python.pydev.core.formatter.PyFormatterPreferences;
import org.python.pydev.core.log.Log;
import org.python.pydev.core.pep8.BlackRunner;
import org.python.pydev.core.pep8.Pep8Runner;
import org.python.pydev.shared_core.io.FileUtils;
import org.python.pydev.shared_core.string.FastStringBuffer;
import org.python.pydev.shared_core.string.StringUtils;
import org.python.pydev.shared_core.string.TextSelectionUtils;
import org.python.pydev.shared_core.utils.ArrayUtils;
import org.python.pydev.shared_core.utils.DocUtils;

public class PyFormatter {
    private static final String[] BLOCK_COMMENT_SKIPS = new String[]{"###", "***", "---", "===", "+++", "@@@", "!!!", "~~~"};
    private static Set<String> unaryWords = new HashSet<String>();

    static {
        unaryWords.add("and");
        unaryWords.add("as");
        unaryWords.add("assert");
        unaryWords.add("break");
        unaryWords.add("class");
        unaryWords.add("continue");
        unaryWords.add("def");
        unaryWords.add("del");
        unaryWords.add("elif");
        unaryWords.add("else");
        unaryWords.add("except");
        unaryWords.add("exec");
        unaryWords.add("finally");
        unaryWords.add("for");
        unaryWords.add("from");
        unaryWords.add("global");
        unaryWords.add("if");
        unaryWords.add("import");
        unaryWords.add("in");
        unaryWords.add("is");
        unaryWords.add("lambda");
        unaryWords.add("nonlocal");
        unaryWords.add("not");
        unaryWords.add("or");
        unaryWords.add("pass");
        unaryWords.add("print");
        unaryWords.add("raise");
        unaryWords.add("return");
        unaryWords.add("try");
        unaryWords.add("while");
        unaryWords.add("with");
        unaryWords.add("yield");
    }

    /*
     * Enabled aggressive block sorting
     */
    public static FastStringBuffer formatStr(String doc, FormatStd std, int parensLevel, String delimiter, boolean throwSyntaxError) throws SyntaxErrorException {
        char[] cs = doc.toCharArray();
        FastStringBuffer buf = new FastStringBuffer();
        FastStringBuffer tempBuf = new FastStringBuffer();
        ParsingUtils parsingUtils = ParsingUtils.create((Object)cs, (boolean)throwSyntaxError);
        char lastChar = '\u0000';
        int length = cs.length;
        int i = 0;
        while (i < length) {
            char c = cs[i];
            block0 : switch (c) {
                case '\"': 
                case '\'': {
                    i = parsingUtils.eatLiterals(buf, i, std.trimMultilineLiterals);
                    break;
                }
                case '#': {
                    i = PyFormatter.handleComment(std, cs, buf, tempBuf, parsingUtils, i);
                    break;
                }
                case ',': {
                    i = PyFormatter.formatForComma(std, cs, buf, i, tempBuf);
                    break;
                }
                case '(': {
                    i = PyFormatter.formatForPar(parsingUtils, cs, i, std, buf, parensLevel + 1, delimiter, throwSyntaxError);
                    break;
                }
                case '*': {
                    boolean isOperator = false;
                    int j = buf.length() - 1;
                    while (j >= 0) {
                        char localC = buf.charAt(j);
                        if (Character.isWhitespace(localC)) {
                            --j;
                            continue;
                        }
                        if (localC != '(') {
                            // empty if block
                        }
                        if (Character.isJavaIdentifierPart(localC)) {
                            tempBuf.clear();
                            while (Character.isJavaIdentifierPart(localC)) {
                                tempBuf.append(localC);
                                if (--j < 0) break;
                                localC = buf.charAt(j);
                            }
                            String reversed = tempBuf.reverse().toString();
                            if (!reversed.equals("import") && !reversed.equals("lambda")) {
                                isOperator = true;
                            }
                        }
                        if (localC != '\'' && localC != ')' && localC != ']') break;
                        isOperator = true;
                        break;
                    }
                    if (!isOperator) {
                        buf.append('*');
                        break;
                    }
                }
                case '+': 
                case '-': {
                    if (c == '-' || c == '+') {
                        tempBuf.clear();
                        boolean started = false;
                        for (int j = buf.length() - 1; j >= 0; --j) {
                            char localC = buf.charAt(j);
                            if (localC == ' ' || localC == '\t') {
                                if (started) break;
                                continue;
                            }
                            started = true;
                            if (!Character.isJavaIdentifierPart(localC) && localC != '.') break;
                            tempBuf.append(localC);
                        }
                        boolean isExponential = true;
                        String partialNumber = tempBuf.reverse().toString();
                        int partialLen = partialNumber.length();
                        if (partialLen < 2 || !Character.isDigit(partialNumber.charAt(0))) {
                            isExponential = false;
                        } else if (partialNumber.charAt(partialLen - 1) != 'e' && partialNumber.charAt(partialLen - 1) != 'E') {
                            isExponential = false;
                        }
                        if (isExponential) {
                            buf.rightTrimWhitespacesAndTabs();
                            buf.append(c);
                            int initial = i;
                            while (++i < length && (c = cs[i]) == ' ' || c == '\t') {
                            }
                            if (i <= initial) break;
                            --i;
                            break;
                        }
                    }
                }
                case '!': 
                case '%': 
                case '&': 
                case '/': 
                case ':': 
                case '<': 
                case '>': 
                case '^': 
                case '|': 
                case '~': {
                    i = PyFormatter.handleOperator(std, cs, buf, parsingUtils, i, c);
                    c = cs[i];
                    break;
                }
                case '@': {
                    String append = "@";
                    if (i < length - 1 && cs[i + 1] == '=') {
                        ++i;
                        append = "@=";
                    } else if (buf.getLastWord().trim().isEmpty()) {
                        buf.append('@');
                        break;
                    }
                    while (true) {
                        if (buf.length() <= 0 || buf.lastChar() != ' ') {
                            if (std.operatorsWithSpace) {
                                buf.append(' ');
                            }
                            buf.append(append);
                            if (std.operatorsWithSpace) {
                                buf.append(' ');
                            }
                            i = parsingUtils.eatWhitespaces(null, i + 1);
                            break block0;
                        }
                        buf.deleteLast();
                    }
                }
                case '=': {
                    if (i < length - 1 && cs[i + 1] == '=') {
                        i = PyFormatter.handleOperator(std, cs, buf, parsingUtils, i, c);
                        c = cs[i];
                        break;
                    }
                    while (true) {
                        if (buf.length() <= 0 || buf.lastChar() != ' ') {
                            boolean surroundWithSpaces = std.operatorsWithSpace;
                            if (parensLevel > 0) {
                                surroundWithSpaces = std.assignWithSpaceInsideParens;
                            }
                            if (surroundWithSpaces) {
                                buf.append(' ');
                            }
                            buf.append('=');
                            if (surroundWithSpaces) {
                                buf.append(' ');
                            }
                            i = parsingUtils.eatWhitespaces(null, i + 1);
                            break block0;
                        }
                        buf.deleteLast();
                    }
                }
                case '\n': 
                case '\r': {
                    if (lastChar == ',' && std.spaceAfterComma && buf.lastChar() == ' ') {
                        buf.deleteLast();
                    }
                    if (std.trimLines) {
                        buf.rightTrimWhitespacesAndTabs();
                    }
                    buf.append(c);
                    break;
                }
                default: {
                    buf.append(c);
                }
            }
            lastChar = c;
            ++i;
        }
        if (parensLevel == 0 && std.trimLines) {
            buf.rightTrimWhitespacesAndTabs();
        }
        return buf;
    }

    private static int handleComment(FormatStd std, char[] cs, FastStringBuffer buf, FastStringBuffer tempBuf, ParsingUtils parsingUtils, int i) {
        if (std.spacesBeforeComment != -1) {
            int j = i - 1;
            while (j >= 0) {
                char cj = cs[j];
                if (cj != '\t' && cj != ' ') {
                    if (cj == '\r' || cj == '\n') break;
                    buf.rightTrimWhitespacesAndTabs();
                    buf.appendN(' ', std.spacesBeforeComment);
                    break;
                }
                --j;
            }
        }
        tempBuf.clear();
        i = parsingUtils.eatComments(tempBuf, i);
        if (std.trimLines) {
            String endLine = "";
            if (tempBuf.endsWith("\r\n")) {
                endLine = "\r\n";
                tempBuf.deleteLastChars(2);
            } else if (tempBuf.endsWith('\r') || tempBuf.endsWith('\n')) {
                endLine = String.valueOf(endLine) + tempBuf.lastChar();
                tempBuf.deleteLast();
            }
            tempBuf.rightTrimWhitespacesAndTabs();
            tempBuf.append(endLine);
        }
        PyFormatter.formatComment(std, tempBuf, false);
        buf.append(tempBuf);
        return i;
    }

    public static void formatComment(FormatStd std, FastStringBuffer bufWithComment, boolean addEvenIfEmpty) {
        if (std.spacesInStartComment > 0) {
            Assert.isTrue((bufWithComment.charAt(0) == '#' ? 1 : 0) != 0);
            int len = bufWithComment.length();
            int firstCharFound = 10;
            String bufAsString = bufWithComment.toString();
            if (FileUtils.isPythonShebangLine((String)bufAsString)) {
                return;
            }
            int spacesFound = 0;
            String remainingStringContent = "";
            int j = 1;
            while (j < len) {
                char c = bufWithComment.charAt(j);
                firstCharFound = c;
                if (c != ' ') {
                    remainingStringContent = bufAsString.substring(j).trim();
                    break;
                }
                ++spacesFound;
                ++j;
            }
            if (addEvenIfEmpty || firstCharFound != 13 && firstCharFound != 10) {
                String[] stringArray = BLOCK_COMMENT_SKIPS;
                int n = BLOCK_COMMENT_SKIPS.length;
                int n2 = 0;
                while (n2 < n) {
                    String s = stringArray[n2];
                    if (remainingStringContent.endsWith(s) || remainingStringContent.startsWith(s)) {
                        return;
                    }
                    ++n2;
                }
                int diff = std.spacesInStartComment - spacesFound;
                if (diff > 0) {
                    bufWithComment.insertN(1, ' ', diff);
                }
            }
        }
    }

    private static int handleOperator(FormatStd std, char[] cs, FastStringBuffer buf, ParsingUtils parsingUtils, int i, char c) {
        boolean isUnaryWithContents = true;
        boolean isUnary = false;
        boolean changeWhitespacesBefore = true;
        if (c == '~' || c == '+' || c == '-') {
            String trimmedLastWord = buf.getLastWord().trim();
            boolean bl = isUnary = trimmedLastWord.length() == 0 || unaryWords.contains(trimmedLastWord);
            if (!isUnary) {
                Iterator iterator = buf.reverseIterator().iterator();
                while (iterator.hasNext()) {
                    char itChar = ((Character)iterator.next()).charValue();
                    if (itChar == ' ' || itChar == '\t') continue;
                    switch (itChar) {
                        case '=': 
                        case '[': 
                        case '{': {
                            changeWhitespacesBefore = false;
                        }
                        case '(': 
                        case ':': {
                            isUnaryWithContents = false;
                        }
                        case '!': 
                        case '%': 
                        case '&': 
                        case '*': 
                        case '+': 
                        case ',': 
                        case '-': 
                        case '/': 
                        case '<': 
                        case '>': 
                        case '^': 
                        case '|': 
                        case '~': {
                            isUnary = true;
                        }
                    }
                    break;
                }
            } else {
                isUnaryWithContents = buf.length() > 0;
            }
        }
        Iterator itChar = buf.reverseIterator().iterator();
        while (itChar.hasNext()) {
            char ch = ((Character)itChar.next()).charValue();
            if (!Character.isWhitespace(ch)) break;
            if (ch != '\r' && ch != '\n') continue;
            changeWhitespacesBefore = false;
            break;
        }
        if (changeWhitespacesBefore) {
            while (buf.length() > 0 && (buf.lastChar() == ' ' || buf.lastChar() == ' ')) {
                buf.deleteLast();
            }
        }
        boolean surroundWithSpaces = std.operatorsWithSpace;
        if (changeWhitespacesBefore && isUnaryWithContents && surroundWithSpaces) {
            buf.append(' ');
        }
        char localC = c;
        char prev = '\u0000';
        boolean backOne = true;
        int initial = i;
        while (PyFormatter.isOperatorPart(localC, prev)) {
            buf.append(localC);
            prev = localC;
            if (++i == cs.length) break;
            localC = cs[i];
            if (localC == '=') {
                buf.append(localC);
                backOne = false;
                break;
            }
            if (c != 58) continue;
            buf.deleteLastChars(i - initial);
            buf.rightTrim();
            buf.append(c);
            if (localC == ' ') {
                buf.append(localC);
            }
            isUnary = true;
            backOne = false;
            i = initial;
            break;
        }
        if (backOne) {
            --i;
        }
        if (!isUnary && surroundWithSpaces) {
            buf.append(' ');
        }
        i = parsingUtils.eatWhitespaces(null, i + 1);
        return i;
    }

    private static boolean isOperatorPart(char c, char prev) {
        switch (c) {
            case '+': 
            case '-': 
            case '~': {
                return prev == '\u0000';
            }
        }
        switch (c) {
            case '!': 
            case '%': 
            case '&': 
            case '*': 
            case '/': 
            case ':': 
            case '<': 
            case '=': 
            case '>': 
            case '^': 
            case '|': 
            case '~': {
                return true;
            }
        }
        return false;
    }

    private static int formatForPar(ParsingUtils parsingUtils, char[] cs, int i, FormatStd std, FastStringBuffer buf, int parensLevel, String delimiter, boolean throwSyntaxError) throws SyntaxErrorException {
        int j;
        int start;
        int c = 32;
        FastStringBuffer locBuf = new FastStringBuffer();
        int end = start = (j = i + 1);
        while (j < cs.length && (c = cs[j]) != 41) {
            ++j;
            if (c == 39 || c == 34) {
                end = j = parsingUtils.eatLiterals(null, j - 1, std.trimMultilineLiterals) + 1;
                continue;
            }
            if (c == 35) {
                end = j = parsingUtils.eatComments(null, j - 1) + 1;
                continue;
            }
            if (c == 40) {
                if (end > start) {
                    locBuf.append(cs, start, end - start);
                    start = end;
                }
                start = j = PyFormatter.formatForPar(parsingUtils, cs, j - 1, std, locBuf, parensLevel + 1, delimiter, throwSyntaxError) + 1;
                continue;
            }
            end = j;
        }
        if (end > start) {
            locBuf.append(cs, start, end - start);
            start = end;
        }
        if (c == 41) {
            FastStringBuffer buf1 = new FastStringBuffer();
            if (locBuf.indexOf('\n') != -1 || locBuf.indexOf('\r') != -1) {
                char c1;
                int k = locBuf.length();
                while (k > 0 && (c1 = locBuf.charAt(k - 1)) != '\n' && c1 != '\r') {
                    buf1.insert(0, c1);
                    --k;
                }
            }
            FastStringBuffer formatStr = PyFormatter.formatStr(PyFormatter.trim(locBuf).toString(), std, parensLevel, delimiter, throwSyntaxError);
            FastStringBuffer formatStrBuf = PyFormatter.trim(formatStr);
            String closing = ")";
            if (buf1.length() > 0 && PySelection.containsOnlyWhitespaces((String)buf1.toString())) {
                formatStrBuf.append(buf1);
            } else if (std.parametersWithSpace) {
                closing = " )";
            }
            if (std.parametersWithSpace) {
                if (formatStrBuf.length() == 0) {
                    buf.append("()");
                } else {
                    buf.append("( ");
                    buf.append(formatStrBuf);
                    buf.append(closing);
                }
            } else {
                buf.append('(');
                buf.append(formatStrBuf);
                buf.append(closing);
            }
            return j;
        }
        if (throwSyntaxError) {
            throw new SyntaxErrorException("No closing ')' found.");
        }
        buf.append('(');
        buf.append(locBuf);
        return j;
    }

    private static FastStringBuffer trim(FastStringBuffer locBuf) {
        while (locBuf.length() > 0 && (locBuf.firstChar() == ' ' || locBuf.firstChar() == '\t')) {
            locBuf.deleteCharAt(0);
        }
        PyFormatter.rtrim(locBuf);
        return locBuf;
    }

    private static FastStringBuffer rtrim(FastStringBuffer locBuf) {
        while (locBuf.length() > 0 && (locBuf.lastChar() == ' ' || locBuf.lastChar() == '\t')) {
            locBuf.deleteLast();
        }
        return locBuf;
    }

    private static int formatForComma(FormatStd std, char[] cs, FastStringBuffer buf, int i, FastStringBuffer formatForCommaTempBuf) {
        formatForCommaTempBuf.clear();
        char c = '\u0000';
        while (i < cs.length - 1 && (c = cs[i + 1]) == ' ') {
            formatForCommaTempBuf.append(c);
            ++i;
        }
        if (c == '#') {
            buf.append(',');
            if (std.spacesBeforeComment == -1) {
                buf.append(formatForCommaTempBuf);
            }
        } else if (std.spaceAfterComma) {
            buf.append(", ");
        } else {
            buf.append(',');
        }
        return i;
    }

    public static void formatSelection(IDocument doc, int[] regionsForSave, IPyFormatStdProvider edit, PySelection ps, FormatStd formatStd) {
        PyFormatter.formatSelection(doc, regionsForSave, edit, ps, formatStd, Integer.MAX_VALUE);
    }

    public static void formatSelection(IDocument doc, int[] regionsForSave, IPyFormatStdProvider edit, PySelection ps, FormatStd formatStd, int manageBlankLinesBeforeLine) {
        Document formatted;
        String formattedAsStr;
        Assert.isTrue((regionsForSave != null ? 1 : 0) != 0);
        switch (formatStd.formatterStyle) {
            case AUTOPEP8: {
                FormatStd formatStdNew = (FormatStd)(edit != null ? edit.getFormatStd() : PyFormatterPreferences.getFormatStd(null));
                try {
                    if (regionsForSave.length > 0) {
                        int firstSelectedLine = regionsForSave[0] + 1;
                        int lastSelectedLine = regionsForSave[regionsForSave.length - 1] + 1;
                        formatStdNew.autopep8Parameters = String.valueOf(formatStdNew.autopep8Parameters) + " --range " + firstSelectedLine + " " + lastSelectedLine;
                    }
                    PyFormatter.formatAll(doc, edit, true, formatStdNew, true, false);
                }
                catch (SyntaxErrorException firstSelectedLine) {
                    // empty catch block
                }
                return;
            }
            case BLACK: {
                try {
                    PyFormatter.formatAll(doc, edit, true, formatStd, true, false);
                    break;
                }
                catch (SyntaxErrorException firstSelectedLine) {
                    // empty catch block
                }
            }
        }
        String delimiter = PySelection.getDelimiter((IDocument)doc);
        try {
            boolean allowChangingBlankLines = false;
            formattedAsStr = PyFormatter.formatStrAutopep8OrPyDev(edit != null ? edit.getPythonNature() : null, formatStd, true, doc, delimiter, allowChangingBlankLines);
            formatted = new Document(formattedAsStr);
        }
        catch (SyntaxErrorException e) {
            return;
        }
        catch (MisconfigurationException e) {
            Log.log((Throwable)e);
            return;
        }
        try {
            int[] regionsReversed;
            int[] nArray = regionsReversed = ArrayUtils.reversedCopy((int[])regionsForSave);
            int n = regionsReversed.length;
            int n2 = 0;
            while (n2 < n) {
                int i = nArray[n2];
                IRegion r = doc.getLineInformation(i);
                int iStart = r.getOffset();
                int iEnd = r.getOffset() + r.getLength();
                String line = PySelection.getLine((IDocument)formatted, (int)i);
                doc.replace(iStart, iEnd - iStart, line);
                ++n2;
            }
            if (formatStd.manageBlankLines) {
                FastStringBuffer buf = new FastStringBuffer(formattedAsStr, 10);
                List computed = PyFormatStdManageBlankLines.computeBlankLinesAmongMethodsAndClasses((FormatStd)formatStd, (FastStringBuffer)buf, (String)delimiter);
                Collections.reverse(computed);
                String delimTwice = String.valueOf(delimiter) + delimiter;
                String delimTimes3 = String.valueOf(delimTwice) + delimiter;
                HashSet<Integer> hashSet = new HashSet<Integer>();
                DocUtils.EmptyLinesComputer emptyLinesComputer = new DocUtils.EmptyLinesComputer(doc);
                int[] nArray2 = regionsForSave;
                int n3 = regionsForSave.length;
                int n4 = 0;
                while (n4 < n3) {
                    int i = nArray2[n4];
                    hashSet.add(i);
                    emptyLinesComputer.addToSetEmptyLinesCloseToLine(hashSet, i);
                    ++n4;
                }
                for (PyFormatStdManageBlankLines.LineOffsetAndInfo lineOffsetAndInfo : computed) {
                    String line;
                    if (!hashSet.contains(lineOffsetAndInfo.infoFromRealLine) || lineOffsetAndInfo.infoFromRealLine > manageBlankLinesBeforeLine) continue;
                    if (lineOffsetAndInfo.delete && (line = PySelection.getLine((IDocument)doc, (int)lineOffsetAndInfo.infoFromRealLine)).trim().length() == 0) {
                        PySelection.deleteLine((IDocument)doc, (int)lineOffsetAndInfo.infoFromRealLine);
                    }
                    if (lineOffsetAndInfo.addBlankLines <= 0) continue;
                    String useDelim = lineOffsetAndInfo.addBlankLines == 1 ? delimiter : (lineOffsetAndInfo.addBlankLines == 2 ? delimTwice : (lineOffsetAndInfo.addBlankLines == 3 ? delimTimes3 : new FastStringBuffer().appendN(delimiter, lineOffsetAndInfo.addBlankLines).toString()));
                    doc.replace(doc.getLineInformation(lineOffsetAndInfo.infoFromRealLine).getOffset(), 0, useDelim);
                }
            }
        }
        catch (BadLocationException | SyntaxErrorException e) {
            Log.log((Throwable)e);
            return;
        }
        if (formatStd.addNewLineAtEndOfFile) {
            try {
                char lastChar;
                int len = doc.getLength();
                if (len > 0 && (lastChar = doc.getChar(len - 1)) != '\r' && lastChar != '\n') {
                    doc.replace(len, 0, PySelection.getDelimiter((IDocument)doc));
                }
            }
            catch (Throwable e) {
                Log.log((Throwable)e);
            }
        }
    }

    public static String formatStrAutopep8OrPyDev(IPythonNature nature, IDocument doc, FormatStd std, String delimiter, boolean throwSyntaxError, boolean allowChangingBlankLines, File workingDir) throws SyntaxErrorException {
        switch (std.formatterStyle) {
            case AUTOPEP8: {
                String parameters = std.autopep8Parameters;
                String formatted = Pep8Runner.runWithPep8BaseScript(doc, parameters, "autopep8.py");
                if (formatted == null) {
                    formatted = doc.get();
                }
                formatted = StringUtils.replaceNewLines((String)formatted, (String)delimiter);
                return formatted;
            }
            case BLACK: {
                String formatted = BlackRunner.formatWithBlack(nature, doc, std, workingDir);
                if (formatted == null) {
                    formatted = doc.get();
                }
                formatted = StringUtils.replaceNewLines((String)formatted, (String)delimiter);
                return formatted;
            }
        }
        FastStringBuffer buf = PyFormatter.formatStr(doc.get(), std, 0, delimiter, throwSyntaxError);
        if (allowChangingBlankLines && std.manageBlankLines) {
            List computed = PyFormatStdManageBlankLines.computeBlankLinesAmongMethodsAndClasses((FormatStd)std, (FastStringBuffer)buf, (String)delimiter);
            return PyFormatStdManageBlankLines.fixBlankLinesAmongMethodsAndClasses((List)computed, (FormatStd)std, (IDocument)doc, (FastStringBuffer)buf, (String)delimiter).toString();
        }
        return buf.toString();
    }

    public static String formatStrAutopep8OrPyDev(IPythonNature nature, FormatStd formatStd, boolean throwSyntaxError, IDocument doc, String delimiter, boolean allowChangingBlankLines) throws SyntaxErrorException {
        IPath location;
        IProject project;
        File workingDir = null;
        if (nature != null && (project = nature.getProject()) != null && (location = project.getLocation()) != null) {
            workingDir = new File(location.toOSString());
        }
        return PyFormatter.formatStrAutopep8OrPyDev(nature, formatStd, throwSyntaxError, doc, delimiter, allowChangingBlankLines, workingDir);
    }

    public static String formatStrAutopep8OrPyDev(IPythonNature nature, FormatStd formatStd, boolean throwSyntaxError, IDocument doc, String delimiter, boolean allowChangingBlankLines, File workingDir) throws SyntaxErrorException {
        String formatted = PyFormatter.formatStrAutopep8OrPyDev(nature, doc, formatStd, delimiter, throwSyntaxError, allowChangingBlankLines, workingDir);
        if (formatStd.addNewLineAtEndOfFile) {
            try {
                char lastChar;
                int len = formatted.length();
                if (len > 0 && (lastChar = formatted.charAt(len - 1)) != '\r' && lastChar != '\n') {
                    formatted = String.valueOf(formatted) + delimiter;
                }
            }
            catch (Throwable e) {
                Log.log((Throwable)e);
            }
        }
        return formatted;
    }

    public static void formatAll(IDocument doc, IPyFormatStdProvider edit, boolean isOpenedFile, FormatStd formatStd, boolean throwSyntaxError, boolean allowChangingLines) throws SyntaxErrorException {
        String formatted;
        String delimiter = PySelection.getDelimiter((IDocument)doc);
        try {
            formatted = PyFormatter.formatStrAutopep8OrPyDev(edit != null ? edit.getPythonNature() : null, formatStd, throwSyntaxError, doc, delimiter, allowChangingLines);
        }
        catch (MisconfigurationException e) {
            Log.log((Throwable)e);
            return;
        }
        String contents = doc.get();
        if (contents.equals(formatted)) {
            return;
        }
        if (!isOpenedFile) {
            doc.set(formatted);
        } else {
            TextSelectionUtils.setOnlyDifferentCode((IDocument)doc, (String)contents, (String)formatted);
        }
    }

    public static void main(String[] args) {
        block15: {
            try {
                int bytesRead;
                if (args.length != 1) {
                    throw new AssertionError((Object)"Expected either -multiple or -single in args.");
                }
                FormatStd formatStd = new FormatStd();
                formatStd.spaceAfterComma = true;
                formatStd.parametersWithSpace = false;
                formatStd.assignWithSpaceInsideParens = false;
                formatStd.operatorsWithSpace = true;
                formatStd.addNewLineAtEndOfFile = true;
                formatStd.trimLines = true;
                formatStd.trimMultilineLiterals = true;
                formatStd.spacesBeforeComment = 2;
                formatStd.spacesInStartComment = 1;
                formatStd.manageBlankLines = true;
                formatStd.blankLinesTopLevel = 2;
                formatStd.blankLinesInner = 1;
                if (args[0].equals("-multiple")) {
                    String line;
                    FastStringBuffer buf = new FastStringBuffer();
                    while ((line = PyFormatter.readLine(System.in, buf)) != null) {
                        int bytesRead2;
                        if (!line.startsWith("Content-Length: ")) {
                            throw new AssertionError((Object)("Unexpected header (expected Content-Length: ) --> " + line));
                        }
                        String emptyLine = PyFormatter.readLine(System.in, buf);
                        if (!emptyLine.isEmpty()) {
                            throw new AssertionError((Object)("expected Content-Length: and empty line afterwards (got: " + line + " instead of empty line)."));
                        }
                        String bytesToRead = line.substring("Content-Length: ".length());
                        int totalBytes = Integer.parseInt(bytesToRead);
                        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(totalBytes);
                        byte[] tempData = new byte[Math.min(totalBytes, 8192)];
                        int remainingBytesToRead = totalBytes;
                        do {
                            bytesRead2 = System.in.read(tempData, 0, Math.min(tempData.length, remainingBytesToRead));
                            byteArrayOutputStream.write(tempData, 0, bytesRead2);
                        } while ((remainingBytesToRead -= bytesRead2) > 0);
                        byteArrayOutputStream.flush();
                        byte[] buffer = byteArrayOutputStream.toByteArray();
                        String encoding = FileUtils.getPythonFileEncoding((byte[])buffer);
                        if (encoding == null) {
                            encoding = "utf-8";
                        }
                        String initialContent = new String(buffer, encoding);
                        Document newDoc = new Document(initialContent);
                        String delimiter = PySelection.getDelimiter((IDocument)newDoc);
                        boolean allowChangingLines = true;
                        String newDocContents = "";
                        try {
                            newDocContents = PyFormatter.formatStrAutopep8OrPyDev(null, formatStd, true, (IDocument)newDoc, delimiter, allowChangingLines);
                        }
                        catch (SyntaxErrorException e) {
                            System.out.write("Content-Length: 0\r\n".getBytes());
                            System.out.write("Result: SyntaxError\r\n\r\n".getBytes());
                            System.out.flush();
                            continue;
                        }
                        System.out.write("Result: Ok\r\n".getBytes());
                        byte[] bytes = newDocContents.getBytes(encoding);
                        System.out.write(("Content-Length: " + bytes.length + "\r\n\r\n").getBytes());
                        System.out.flush();
                        System.out.write(bytes);
                        System.out.flush();
                    }
                    break block15;
                }
                if (!args[0].equals("-single")) break block15;
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                byte[] buffer = new byte[32768];
                while ((bytesRead = System.in.read(buffer)) > 0) {
                    baos.write(buffer, 0, bytesRead);
                }
                byte[] bytes = baos.toByteArray();
                String encoding = FileUtils.getPythonFileEncoding((byte[])bytes);
                if (encoding == null) {
                    encoding = "utf-8";
                }
                String initialContent = new String(bytes, encoding);
                Document newDoc = new Document(initialContent);
                String delimiter = PySelection.getDelimiter((IDocument)newDoc);
                boolean allowChangingLines = true;
                String newDocContents = "";
                try {
                    newDocContents = PyFormatter.formatStrAutopep8OrPyDev(null, formatStd, true, (IDocument)newDoc, delimiter, allowChangingLines);
                }
                catch (SyntaxErrorException e) {
                    System.exit(1);
                }
                System.out.write(newDocContents.getBytes(encoding));
                System.out.flush();
                System.exit(0);
            }
            catch (Exception e) {
                e.printStackTrace();
                System.exit(1);
            }
        }
    }

    private static String readLine(InputStream in, FastStringBuffer buf) throws IOException {
        char c;
        buf.clear();
        while ((c = (char)in.read()) != '\uffffffff') {
            if (c == '\r') {
                c = (char)in.read();
                if (c != '\n') {
                    throw new IOException("Expected line to end with \\r\\n.");
                }
                return buf.toString();
            }
            buf.append(c);
        }
        throw new AssertionError((Object)"Should not get here.");
    }
}

