/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.ast.interpreter_managers;

import java.io.File;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.python.pydev.shared_core.SharedCorePlugin;
import org.python.pydev.shared_core.io.FileUtils;

public class DefaultPathsForInterpreterInfo {
    private final Set<IPath> rootPaths = DefaultPathsForInterpreterInfo.getRootPaths();

    public boolean selectByDefault(String data) {
        return !DefaultPathsForInterpreterInfo.isChildOfRootPath(data, this.rootPaths);
    }

    public boolean exists(String data) {
        return new File(data).exists();
    }

    public static boolean isChildOfRootPath(String data, Set<IPath> rootPaths) {
        IPath path = Path.fromOSString((String)data);
        for (IPath p : rootPaths) {
            if (!FileUtils.isPrefixOf((IPath)p, (IPath)path)) continue;
            return true;
        }
        return false;
    }

    public static HashSet<IPath> getRootPaths() {
        IProject[] projects;
        HashSet<IPath> rootPaths = new HashSet<IPath>();
        if (SharedCorePlugin.inTestMode()) {
            return rootPaths;
        }
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IPath rootLocation = root.getLocation().makeAbsolute();
        rootPaths.add(rootLocation);
        IProject[] iProjectArray = projects = root.getProjects();
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IPath abs;
            IProject iProject = iProjectArray[n2];
            IPath location = iProject.getLocation();
            if (location != null && !FileUtils.isPrefixOf((IPath)rootLocation, (IPath)(abs = location.makeAbsolute()))) {
                rootPaths.add(abs);
            }
            ++n2;
        }
        return rootPaths;
    }
}

