/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.ast.interpreter_managers;

import java.io.File;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.python.pydev.ast.interpreter_managers.AbstractInterpreterManager;
import org.python.pydev.ast.interpreter_managers.InterpreterInfo;
import org.python.pydev.ast.runners.SimpleIronpythonRunner;
import org.python.pydev.shared_core.io.FileUtils;
import org.python.pydev.shared_core.structure.Tuple;

public class IronpythonInterpreterManager
extends AbstractInterpreterManager {
    public IronpythonInterpreterManager(IEclipsePreferences prefs) {
        super(prefs);
    }

    @Override
    protected String getPreferenceName() {
        return "IRONPYTHON_INTERPRETER_PATH";
    }

    @Override
    public String getInterpreterUIName() {
        return "IronPython.";
    }

    @Override
    public Tuple<InterpreterInfo, String> internalCreateInterpreterInfo(String executable, IProgressMonitor monitor, boolean askUser) throws CoreException {
        return IronpythonInterpreterManager.doCreateInterpreterInfo(executable, monitor, askUser);
    }

    @Override
    public String getPreferencesPageId() {
        return "org.python.pydev.ui.pythonpathconf.interpreterPreferencesPageIronpython";
    }

    public static Tuple<InterpreterInfo, String> doCreateInterpreterInfo(String executable, IProgressMonitor monitor, boolean askUser) throws CoreException {
        boolean isJythonExecutable = InterpreterInfo.isJythonExecutable(executable);
        if (isJythonExecutable) {
            throw new RuntimeException("A jar cannot be used in order to get the info for the IronPython interpreter.");
        }
        File script = IronpythonInterpreterManager.getInterpreterInfoPy();
        Tuple<String, String> outTup = new SimpleIronpythonRunner().runAndGetOutputWithInterpreter(executable, FileUtils.getFileAbsolutePath((File)script), null, null, null, monitor, "utf-8");
        InterpreterInfo info = IronpythonInterpreterManager.createInfoFromOutput(monitor, outTup, askUser, executable, false);
        if (info == null) {
            return null;
        }
        info.restoreCompiledLibs(monitor);
        return new Tuple((Object)info, (Object)((String)outTup.o1));
    }

    public int getInterpreterType() {
        return 2;
    }

    public String getManagerRelatedName() {
        return "ironpython";
    }
}

